/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.run;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProgressReporter {
    private static final Logger LOG = Logger.getInstance(ProgressReporter.class);
    private final BlockingQueue<StepContext> myStepQueue;
    private boolean myFinished;

    private synchronized void putStep(@NotNull StepContext stepContext) {
        if (stepContext == null) {
            ProgressReporter.$$$reportNull$$$0(0);
        }
        if (this.myFinished) {
            return;
        }
        try {
            this.myStepQueue.put(stepContext);
        }
        catch (InterruptedException e) {
            LOG.error((Throwable)e);
        }
        this.myFinished = stepContext.isFinished();
    }

    private void runProgressTask(@NotNull Project project) {
        if (project == null) {
            ProgressReporter.$$$reportNull$$$0(1);
        }
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(project, "Attaching native debugger", false){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                try {
                    StepContext stepContext;
                    while (!(stepContext = (StepContext)ProgressReporter.this.myStepQueue.take()).isFinished()) {
                        indicator.setText(stepContext.getName());
                    }
                }
                catch (InterruptedException e) {
                    LOG.error((Throwable)e);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/android/tools/ndk/run/ProgressReporter$1", "run"));
            }
        });
    }

    public ProgressReporter(final @NotNull Project project) {
        if (project == null) {
            ProgressReporter.$$$reportNull$$$0(2);
        }
        this.myStepQueue = new LinkedBlockingDeque<StepContext>();
        this.myFinished = false;
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                ProgressReporter.this.runProgressTask(project);
            }
        });
    }

    public void step(String stepName) {
        this.putStep(new StepContext(stepName, false));
    }

    public void finish() {
        this.putStep(new StepContext(null, true));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stepContext";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/ndk/run/ProgressReporter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "putStep";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "runProgressTask";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class StepContext {
        private final String myName;
        private final boolean myFinished;

        public StepContext(@Nullable String name, boolean finished) {
            this.myName = name;
            this.myFinished = finished;
        }

        @Nullable
        public String getName() {
            return this.myName;
        }

        public boolean isFinished() {
            return this.myFinished;
        }
    }
}

