/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.run.crash;

import com.android.repository.api.LocalPackage;
import com.android.repository.api.ProgressIndicator;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.tools.idea.sdk.progress.StudioLoggerProgressIndicator;
import com.android.tools.ndk.run.lldb.LLDBSdkPkgInstaller;
import com.google.wireless.android.sdk.stats.DeviceInfo;
import com.intellij.errorreport.bean.ErrorBean;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.util.Consumer;
import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.entity.GzipCompressingEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class NativeClientCrashReportingTask
extends Task.Backgroundable {
    private final ErrorBean myBean;
    private final Consumer<String> myCallback;
    private final Consumer<Exception> myErrorCallback;
    private final String mySignature;
    private final DeviceInfo myDeviceInfo;

    public NativeClientCrashReportingTask(@Nullable Project project, @NotNull String title, boolean canBeCancelled, @NotNull ErrorBean bean, @NotNull Consumer<String> callback, @NotNull Consumer<Exception> errorCallback, @Nullable DeviceInfo deviceInfo, @Nullable String signature) {
        if (title == null) {
            NativeClientCrashReportingTask.$$$reportNull$$$0(0);
        }
        if (bean == null) {
            NativeClientCrashReportingTask.$$$reportNull$$$0(1);
        }
        if (callback == null) {
            NativeClientCrashReportingTask.$$$reportNull$$$0(2);
        }
        if (errorCallback == null) {
            NativeClientCrashReportingTask.$$$reportNull$$$0(3);
        }
        super(project, title, canBeCancelled);
        this.myBean = bean;
        this.myCallback = callback;
        this.myErrorCallback = errorCallback;
        this.mySignature = signature;
        this.myDeviceInfo = deviceInfo;
    }

    public void run(@NotNull com.intellij.openapi.progress.ProgressIndicator indicator) {
        if (indicator == null) {
            NativeClientCrashReportingTask.$$$reportNull$$$0(4);
        }
        indicator.setIndeterminate(true);
        try {
            CloseableHttpClient client = HttpClients.createDefault();
            HttpPost post = new HttpPost("https://clients2.google.com/cr/report");
            MultipartEntityBuilder builder = MultipartEntityBuilder.create();
            builder.addTextBody("product", "AndroidStudioNative");
            ApplicationInfoEx application = (ApplicationInfoEx)ApplicationInfo.getInstance();
            StudioLoggerProgressIndicator progress = new StudioLoggerProgressIndicator(((Object)((Object)this)).getClass());
            LocalPackage info = (LocalPackage)AndroidSdks.getInstance().tryToChooseSdkHandler().getSdkManager((ProgressIndicator)progress).getPackages().getLocalPackages().get(LLDBSdkPkgInstaller.COMPATIBLE_PKG_PATH);
            StringBuilder version = new StringBuilder();
            version.append(application.getFullVersion());
            if (info != null) {
                version.append('/');
                version.append(info.getVersion().toString());
            }
            builder.addTextBody("version", version.toString());
            if (this.myBean.getLastAction() != null) {
                builder.addTextBody("last_action", this.myBean.getLastAction());
            }
            if (this.myBean.getDescription() != null) {
                builder.addTextBody("comments", this.myBean.getDescription());
            }
            if (this.myBean.getStackTrace() != null) {
                builder.addTextBody("exception", this.myBean.getStackTrace());
            }
            if (this.mySignature != null) {
                builder.addTextBody("signature", this.mySignature);
            }
            if (this.myDeviceInfo != null) {
                if (this.myDeviceInfo.hasCpuAbi()) {
                    builder.addTextBody("cpu-abi", this.myDeviceInfo.getCpuAbi().name());
                }
                if (this.myDeviceInfo.hasModel()) {
                    builder.addTextBody("model", this.myDeviceInfo.getModel());
                }
                if (this.myDeviceInfo.hasBuildApiLevelFull()) {
                    builder.addTextBody("api-level", this.myDeviceInfo.getBuildApiLevelFull());
                }
                if (this.myDeviceInfo.hasBuildTags()) {
                    builder.addTextBody("build-tags", this.myDeviceInfo.getBuildTags());
                }
                if (this.myDeviceInfo.hasBuildType()) {
                    builder.addTextBody("build-type", this.myDeviceInfo.getBuildType());
                }
                if (this.myDeviceInfo.hasManufacturer()) {
                    builder.addTextBody("manufacturer", this.myDeviceInfo.getManufacturer());
                }
            }
            int file_no = 0;
            for (Attachment attachment : this.myBean.getAttachments()) {
                if (attachment == null || !attachment.isIncluded()) continue;
                String name = "upload_file_minidump";
                if (file_no++ > 0) {
                    name = name + file_no;
                }
                builder.addBinaryBody(name, attachment.getBytes(), ContentType.APPLICATION_OCTET_STREAM, attachment.getName());
            }
            post.setEntity((HttpEntity)new GzipCompressingEntity(builder.build()));
            HttpResponse response = client.execute((HttpUriRequest)post);
            if (response.getStatusLine().getStatusCode() != 200) {
                throw new RuntimeException("Unable to submit error report. Error code: " + response.getStatusLine().getStatusCode());
            }
            this.myCallback.consume((Object)EntityUtils.toString((HttpEntity)response.getEntity()));
        }
        catch (IOException e) {
            this.myErrorCallback.consume((Object)e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bean";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorCallback";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/ndk/run/crash/NativeClientCrashReportingTask";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "run";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

