/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.run.editor;

import com.android.ddmlib.Client;
import com.android.sdklib.AndroidVersion;
import com.android.tools.idea.run.ConsolePrinter;
import com.android.tools.idea.run.editor.AndroidDebuggerConfigurable;
import com.android.tools.idea.run.editor.AndroidJavaDebugger;
import com.android.tools.ndk.run.ProgressReporter;
import com.android.tools.ndk.run.editor.NativeAndroidDebugger;
import com.android.tools.ndk.run.editor.NativeAndroidDebuggerConfigurable;
import com.android.tools.ndk.run.editor.NativeAndroidDebuggerState;
import com.android.tools.ndk.run.hybrid.AndroidJavaDebugProcess;
import com.android.tools.ndk.run.hybrid.AndroidNativeHybridDebugProcess;
import com.android.tools.ndk.run.jdwp.JdwpConnector;
import com.android.tools.ndk.run.lldb.SessionStarter;
import com.google.common.collect.Sets;
import com.intellij.debugger.DebugUIEnvironment;
import com.intellij.debugger.engine.JavaDebugProcess;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.filters.TextConsoleBuilder;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunnerLayoutUi;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.ui.content.Content;
import com.intellij.util.NotNullFunction;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugProcessStarter;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebugSessionListener;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.breakpoints.XBreakpointType;
import com.jetbrains.cidr.execution.RunParameters;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HybridAndroidDebugger
extends NativeAndroidDebugger {
    public static final String ID = "Hybrid";
    private static final Logger LOG = Logger.getInstance(HybridAndroidDebugger.class);

    public HybridAndroidDebugger() {
        super(HybridAndroidDebugger.getAllBreakpointTypes());
    }

    private static Set<Class<? extends XBreakpointType<?, ?>>> getAllBreakpointTypes() {
        HashSet breakpointTypeCls = Sets.newHashSet();
        breakpointTypeCls.addAll(AndroidJavaDebugger.JAVA_BREAKPOINT_TYPES);
        breakpointTypeCls.addAll(NativeAndroidDebugger.NATIVE_BREAKPOINT_TYPES);
        return breakpointTypeCls;
    }

    @Override
    @NotNull
    public String getId() {
        if (ID == null) {
            HybridAndroidDebugger.$$$reportNull$$$0(0);
        }
        return ID;
    }

    @Override
    @NotNull
    public String getDisplayName() {
        if ("Dual" == null) {
            HybridAndroidDebugger.$$$reportNull$$$0(1);
        }
        return "Dual";
    }

    @Override
    @NotNull
    public AndroidDebuggerConfigurable<NativeAndroidDebuggerState> createConfigurable(@NotNull RunConfiguration runConfiguration) {
        if (runConfiguration == null) {
            HybridAndroidDebugger.$$$reportNull$$$0(2);
        }
        NativeAndroidDebuggerConfigurable<NativeAndroidDebuggerState> nativeAndroidDebuggerConfigurable = new NativeAndroidDebuggerConfigurable<NativeAndroidDebuggerState>(runConfiguration.getProject(), false);
        if (nativeAndroidDebuggerConfigurable == null) {
            HybridAndroidDebugger.$$$reportNull$$$0(3);
        }
        return nativeAndroidDebuggerConfigurable;
    }

    @Override
    public boolean supportsJavaAwareNativeDebugging(@NotNull AndroidVersion version) {
        if (version == null) {
            HybridAndroidDebugger.$$$reportNull$$$0(4);
        }
        return false;
    }

    @Override
    protected boolean hasExistingSession(@NotNull Project project, @NotNull Client client) {
        XDebugSession nativeDebugSession;
        if (project == null) {
            HybridAndroidDebugger.$$$reportNull$$$0(5);
        }
        if (client == null) {
            HybridAndroidDebugger.$$$reportNull$$$0(6);
        }
        if ((nativeDebugSession = HybridAndroidDebugger.findNativeDebugSession(project, client)) == null) {
            return false;
        }
        String debugPort = HybridAndroidDebugger.getClientDebugPort((Client)client);
        XDebugSession javaDebugSession = HybridAndroidDebugger.findXDebugSession(project, (NotNullFunction<XDebugProcess, Boolean>)((NotNullFunction)debugProcess -> {
            if (!(debugProcess instanceof AndroidJavaDebugProcess)) {
                return false;
            }
            AndroidJavaDebugProcess javaDebugProcess = (AndroidJavaDebugProcess)((Object)debugProcess);
            return debugPort.equals(javaDebugProcess.getDebuggerSession().getProcess().getConnection().getAddress().trim());
        }));
        if (javaDebugSession == null) {
            HybridAndroidDebugger.detachDebugSessions(nativeDebugSession, null);
            return false;
        }
        boolean result = HybridAndroidDebugger.activateDebugSessionWindow((Project)project, (RunContentDescriptor)nativeDebugSession.getRunContentDescriptor());
        if (!result) {
            HybridAndroidDebugger.detachDebugSessions(nativeDebugSession, javaDebugSession);
        }
        return true;
    }

    private static void detachDebugSessions(@Nullable XDebugSession nativeDebugSession, @Nullable XDebugSession javaDebugSession) {
        if (nativeDebugSession != null) {
            HybridAndroidDebugger.detachXDebugSession(nativeDebugSession);
        }
        if (javaDebugSession != null) {
            HybridAndroidDebugger.detachXDebugSession(javaDebugSession);
        }
    }

    @Override
    @NotNull
    public AndroidNativeHybridDebugProcess newAndroidNativeAppDebugProcess(@NotNull String sessionId, @NotNull RunParameters parameters, final @NotNull XDebugSession session, @NotNull TextConsoleBuilder consoleBuilder, @NotNull ConsolePrinter printer, @NotNull SessionStarter sessionStarter, @NotNull Client client, @Nullable JdwpConnector jdwpConnector, @NotNull ProgressReporter progressReporter, boolean detachOnStop) throws ExecutionException {
        if (sessionId == null) {
            HybridAndroidDebugger.$$$reportNull$$$0(7);
        }
        if (parameters == null) {
            HybridAndroidDebugger.$$$reportNull$$$0(8);
        }
        if (session == null) {
            HybridAndroidDebugger.$$$reportNull$$$0(9);
        }
        if (consoleBuilder == null) {
            HybridAndroidDebugger.$$$reportNull$$$0(10);
        }
        if (printer == null) {
            HybridAndroidDebugger.$$$reportNull$$$0(11);
        }
        if (sessionStarter == null) {
            HybridAndroidDebugger.$$$reportNull$$$0(12);
        }
        if (client == null) {
            HybridAndroidDebugger.$$$reportNull$$$0(13);
        }
        if (progressReporter == null) {
            HybridAndroidDebugger.$$$reportNull$$$0(14);
        }
        if (jdwpConnector == null) {
            throw new IllegalStateException("JDWP connector must not be null for Dual debugger sessions");
        }
        session.addSessionListener((XDebugSessionListener)new FrameContentSwitcher(session));
        final AndroidNativeHybridDebugProcess result = new AndroidNativeHybridDebugProcess(sessionId, parameters, session, consoleBuilder, printer, sessionStarter, client, progressReporter, detachOnStop);
        jdwpConnector.addSessionListener(new JdwpConnector.SessionListener(){

            @Override
            public void sessionCreated(final @NotNull DebuggerSession debuggerSession, @NotNull DebugUIEnvironment debugUIEnv) {
                if (debuggerSession == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (debugUIEnv == null) {
                    1.$$$reportNull$$$0(1);
                }
                try {
                    RunProfile profile = debugUIEnv.getRunProfile();
                    assert (profile != null);
                    XDebugSession javaDebugSession = XDebuggerManager.getInstance((Project)session.getProject()).startSessionAndShowTab(profile.getName() + "-java", debugUIEnv.getReuseContent(), new XDebugProcessStarter(){

                        @NotNull
                        public XDebugProcess start(@NotNull XDebugSession session) {
                            if (session == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            JavaDebugProcess javaDebugProcess = AndroidJavaDebugProcess.create(session, debuggerSession, result);
                            if (javaDebugProcess == null) {
                                1.$$$reportNull$$$0(1);
                            }
                            return javaDebugProcess;
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            RuntimeException runtimeException;
                            Object[] objectArray;
                            Object[] objectArray2;
                            int n2;
                            String string;
                            switch (n) {
                                default: {
                                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                                    break;
                                }
                                case 1: {
                                    string = "@NotNull method %s.%s must not return null";
                                    break;
                                }
                            }
                            switch (n) {
                                default: {
                                    n2 = 3;
                                    break;
                                }
                                case 1: {
                                    n2 = 2;
                                    break;
                                }
                            }
                            Object[] objectArray3 = new Object[n2];
                            switch (n) {
                                default: {
                                    objectArray2 = objectArray3;
                                    objectArray3[0] = "session";
                                    break;
                                }
                                case 1: {
                                    objectArray2 = objectArray3;
                                    objectArray3[0] = "com/android/tools/ndk/run/editor/HybridAndroidDebugger$1$1";
                                    break;
                                }
                            }
                            switch (n) {
                                default: {
                                    objectArray = objectArray2;
                                    objectArray2[1] = "com/android/tools/ndk/run/editor/HybridAndroidDebugger$1$1";
                                    break;
                                }
                                case 1: {
                                    objectArray = objectArray2;
                                    objectArray2[1] = "start";
                                    break;
                                }
                            }
                            switch (n) {
                                default: {
                                    objectArray = objectArray;
                                    objectArray[2] = "start";
                                    break;
                                }
                                case 1: {
                                    break;
                                }
                            }
                            String string2 = String.format(string, objectArray);
                            switch (n) {
                                default: {
                                    runtimeException = new IllegalArgumentException(string2);
                                    break;
                                }
                                case 1: {
                                    runtimeException = new IllegalStateException(string2);
                                    break;
                                }
                            }
                            throw runtimeException;
                        }
                    });
                    javaDebugSession.addSessionListener((XDebugSessionListener)new FrameContentSwitcher(javaDebugSession));
                }
                catch (ExecutionException e) {
                    LOG.error((Throwable)e);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "debuggerSession";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "debugUIEnv";
                        break;
                    }
                }
                objectArray[1] = "com/android/tools/ndk/run/editor/HybridAndroidDebugger$1";
                objectArray[2] = "sessionCreated";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        AndroidNativeHybridDebugProcess androidNativeHybridDebugProcess = result;
        if (androidNativeHybridDebugProcess == null) {
            HybridAndroidDebugger.$$$reportNull$$$0(15);
        }
        return androidNativeHybridDebugProcess;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/ndk/run/editor/HybridAndroidDebugger";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runConfiguration";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "client";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sessionId";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consoleBuilder";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "printer";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sessionStarter";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressReporter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/ndk/run/editor/HybridAndroidDebugger";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createConfigurable";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "newAndroidNativeAppDebugProcess";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createConfigurable";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "supportsJavaAwareNativeDebugging";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "hasExistingSession";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "newAndroidNativeAppDebugProcess";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class FrameContentSwitcher
    implements XDebugSessionListener {
        private final XDebugSession myDebugSession;
        private boolean myFirstRun = true;

        public FrameContentSwitcher(XDebugSession debugSession) {
            this.myDebugSession = debugSession;
        }

        public void sessionPaused() {
            ApplicationManager.getApplication().invokeAndWait(() -> {
                RunContentDescriptor descriptor = this.myDebugSession.getRunContentDescriptor();
                ExecutionManager.getInstance((Project)this.myDebugSession.getProject()).getContentManager().toFrontRunContent(DefaultDebugExecutor.getDebugExecutorInstance(), descriptor);
                if (this.myFirstRun) {
                    RunnerLayoutUi ui = this.myDebugSession.getUI();
                    Content frameContent = ui.findContent("FrameContent");
                    if (frameContent != null) {
                        ui.selectAndFocus(frameContent, true, true);
                    }
                    this.myFirstRun = false;
                }
            }, ModalityState.defaultModalityState());
        }
    }
}

