/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.run.editor;

import com.android.ddmlib.Client;
import com.android.sdklib.AndroidVersion;
import com.android.tools.idea.project.NdkProjectInfo;
import com.android.tools.idea.run.AndroidRunConfiguration;
import com.android.tools.idea.run.ApkProviderUtil;
import com.android.tools.idea.run.ApkProvisionException;
import com.android.tools.idea.run.ConsolePrinter;
import com.android.tools.idea.run.ConsoleProvider;
import com.android.tools.idea.run.ProcessHandlerConsolePrinter;
import com.android.tools.idea.run.editor.AndroidDebuggerConfigurable;
import com.android.tools.idea.run.editor.AndroidDebuggerImplBase;
import com.android.tools.idea.run.editor.AndroidDebuggerState;
import com.android.tools.idea.run.tasks.DebugConnectorTask;
import com.android.tools.ndk.run.AndroidNativeAppDebugProcess;
import com.android.tools.ndk.run.ProgressReporter;
import com.android.tools.ndk.run.attach.AndroidNativeAttachConfiguration;
import com.android.tools.ndk.run.attach.AndroidNativeAttachConfigurationType;
import com.android.tools.ndk.run.editor.NativeAndroidDebuggerConfigurable;
import com.android.tools.ndk.run.editor.NativeAndroidDebuggerState;
import com.android.tools.ndk.run.javaawarecpp.AndroidJavaAwareNativeDebugProcess;
import com.android.tools.ndk.run.jdwp.JdwpConnector;
import com.android.tools.ndk.run.lldb.ConnectLLDBTask;
import com.android.tools.ndk.run.lldb.SessionStarter;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.ProgramRunnerUtil;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.filters.TextConsoleBuilder;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.facet.ProjectFacetManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.NotNullFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.breakpoints.XBreakpointType;
import com.jetbrains.cidr.execution.RunParameters;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerSettings;
import com.jetbrains.cidr.execution.debugger.breakpoints.CidrLineBreakpointType;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NativeAndroidDebugger
extends AndroidDebuggerImplBase<NativeAndroidDebuggerState> {
    public static final String ID = "Native";
    private static final String RUN_CONFIGURATION_NAME_PATTERN = "Android %s Debugger (%d)";
    private static final Logger LOG = Logger.getInstance(NativeAndroidDebugger.class);
    private static final String JAVA_AWARE_NATIVE_DEBUG_OPTION = "-N";
    static final int MIN_JAVA_AWARE_NATIVE_DEBUG_API_LEVEL = 24;
    private static ConsoleProvider ourConsoleProvider = null;
    public static final Set<Class<? extends XBreakpointType<?, ?>>> NATIVE_BREAKPOINT_TYPES = ImmutableSet.of(CidrLineBreakpointType.class);

    public static void setConsoleProvider(@NotNull ConsoleProvider consoleProvider) {
        if (consoleProvider == null) {
            NativeAndroidDebugger.$$$reportNull$$$0(0);
        }
        ourConsoleProvider = consoleProvider;
    }

    public NativeAndroidDebugger() {
        super(NATIVE_BREAKPOINT_TYPES);
    }

    protected NativeAndroidDebugger(Set<Class<? extends XBreakpointType<?, ?>>> breakpointTypeCls) {
        super(breakpointTypeCls);
    }

    @NotNull
    public String getId() {
        if (ID == null) {
            NativeAndroidDebugger.$$$reportNull$$$0(1);
        }
        return ID;
    }

    @NotNull
    public String getDisplayName() {
        String string = this.getId();
        if (string == null) {
            NativeAndroidDebugger.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public NativeAndroidDebuggerState createState() {
        NativeAndroidDebuggerState nativeAndroidDebuggerState = new NativeAndroidDebuggerState();
        if (nativeAndroidDebuggerState == null) {
            NativeAndroidDebugger.$$$reportNull$$$0(3);
        }
        return nativeAndroidDebuggerState;
    }

    @NotNull
    public AndroidDebuggerConfigurable<NativeAndroidDebuggerState> createConfigurable(@NotNull RunConfiguration runConfiguration) {
        if (runConfiguration == null) {
            NativeAndroidDebugger.$$$reportNull$$$0(4);
        }
        NativeAndroidDebuggerConfigurable<NativeAndroidDebuggerState> nativeAndroidDebuggerConfigurable = new NativeAndroidDebuggerConfigurable<NativeAndroidDebuggerState>(runConfiguration.getProject(), runConfiguration instanceof AndroidRunConfiguration);
        if (nativeAndroidDebuggerConfigurable == null) {
            NativeAndroidDebugger.$$$reportNull$$$0(5);
        }
        return nativeAndroidDebuggerConfigurable;
    }

    @NotNull
    public DebugConnectorTask getConnectDebuggerTask(@NotNull ExecutionEnvironment env, @Nullable AndroidVersion version, @NotNull Set<String> applicationIds, @NotNull AndroidFacet facet, @NotNull NativeAndroidDebuggerState state, @NotNull String runConfigTypeId, boolean monitorRemoteProcess) {
        if (env == null) {
            NativeAndroidDebugger.$$$reportNull$$$0(6);
        }
        if (applicationIds == null) {
            NativeAndroidDebugger.$$$reportNull$$$0(7);
        }
        if (facet == null) {
            NativeAndroidDebugger.$$$reportNull$$$0(8);
        }
        if (state == null) {
            NativeAndroidDebugger.$$$reportNull$$$0(9);
        }
        if (runConfigTypeId == null) {
            NativeAndroidDebugger.$$$reportNull$$$0(10);
        }
        ConnectLLDBTask connectLLDBTask = new ConnectLLDBTask(env, applicationIds, facet, state, this, runConfigTypeId);
        if (connectLLDBTask == null) {
            NativeAndroidDebugger.$$$reportNull$$$0(11);
        }
        return connectLLDBTask;
    }

    public boolean supportsProject(@NotNull Project project) {
        if (project == null) {
            NativeAndroidDebugger.$$$reportNull$$$0(12);
        }
        return NdkProjectInfo.get((Project)project).hasNdkModules();
    }

    public void attachToClient(@NotNull Project project, @NotNull Client client) {
        if (project == null) {
            NativeAndroidDebugger.$$$reportNull$$$0(13);
        }
        if (client == null) {
            NativeAndroidDebugger.$$$reportNull$$$0(14);
        }
        String clientDescr = client.getClientData().getClientDescription();
        Module module = null;
        List facets = ProjectFacetManager.getInstance((Project)project).getFacets(AndroidFacet.ID);
        for (AndroidFacet facet : facets) {
            try {
                String packageName = ApkProviderUtil.computePackageName((AndroidFacet)facet);
                if (!clientDescr.startsWith(packageName)) continue;
                module = facet.getModule();
                break;
            }
            catch (ApkProvisionException e) {
                LOG.warn((Throwable)e);
            }
        }
        if (module == null) {
            throw new RuntimeException("Cannot find module by package name");
        }
        if (this.hasExistingSession(project, client)) {
            return;
        }
        DebuggerSession debuggerSession = NativeAndroidDebugger.findJdwpDebuggerSession((Project)project, (String)NativeAndroidDebugger.getClientDebugPort((Client)client));
        if (debuggerSession != null) {
            debuggerSession.getProcess().stop(false);
        }
        RunnerAndConfigurationSettings runSettings = this.createRunnerAndConfigurationSettings(project, module, client);
        ProgramRunnerUtil.executeConfiguration((RunnerAndConfigurationSettings)runSettings, (Executor)DefaultDebugExecutor.getDebugExecutorInstance());
    }

    @NotNull
    protected RunnerAndConfigurationSettings createRunnerAndConfigurationSettings(@NotNull Project project, @NotNull Module module, @NotNull Client client) {
        if (project == null) {
            NativeAndroidDebugger.$$$reportNull$$$0(15);
        }
        if (module == null) {
            NativeAndroidDebugger.$$$reportNull$$$0(16);
        }
        if (client == null) {
            NativeAndroidDebugger.$$$reportNull$$$0(17);
        }
        AndroidNativeAttachConfigurationType attachConfigurationType = AndroidNativeAttachConfigurationType.getInstance();
        ConfigurationFactory factory = attachConfigurationType.getFactory();
        String runConfigurationName = String.format(RUN_CONFIGURATION_NAME_PATTERN, this.getDisplayName(), client.getClientData().getPid());
        RunnerAndConfigurationSettings runSettings = RunManager.getInstance((Project)project).createRunConfiguration(runConfigurationName, factory);
        AndroidNativeAttachConfiguration configuration = (AndroidNativeAttachConfiguration)runSettings.getConfiguration();
        configuration.setClient(client);
        configuration.getAndroidDebuggerContext().setDebuggerType(this.getId());
        ((JavaRunConfigurationModule)configuration.getConfigurationModule()).setModule(module);
        configuration.setConsoleProvider(ourConsoleProvider);
        RunnerAndConfigurationSettings runnerAndConfigurationSettings = runSettings;
        if (runnerAndConfigurationSettings == null) {
            NativeAndroidDebugger.$$$reportNull$$$0(18);
        }
        return runnerAndConfigurationSettings;
    }

    protected static void detachXDebugSession(@NotNull XDebugSession debugSession) {
        RunContentDescriptor descriptor;
        ProcessHandler processHandler;
        if (debugSession == null) {
            NativeAndroidDebugger.$$$reportNull$$$0(19);
        }
        if ((processHandler = (descriptor = debugSession.getRunContentDescriptor()).getProcessHandler()) != null) {
            processHandler.detachProcess();
        }
    }

    protected boolean hasExistingSession(@NotNull Project project, @NotNull Client client) {
        XDebugSession nativeDebugSession;
        if (project == null) {
            NativeAndroidDebugger.$$$reportNull$$$0(20);
        }
        if (client == null) {
            NativeAndroidDebugger.$$$reportNull$$$0(21);
        }
        if ((nativeDebugSession = NativeAndroidDebugger.findNativeDebugSession(project, client)) != null) {
            return NativeAndroidDebugger.activateDebugSessionWindow((Project)project, (RunContentDescriptor)nativeDebugSession.getRunContentDescriptor());
        }
        return false;
    }

    @Nullable
    protected static XDebugSession findNativeDebugSession(@NotNull Project project, @NotNull Client client) {
        if (project == null) {
            NativeAndroidDebugger.$$$reportNull$$$0(22);
        }
        if (client == null) {
            NativeAndroidDebugger.$$$reportNull$$$0(23);
        }
        return NativeAndroidDebugger.findXDebugSession(project, (NotNullFunction<XDebugProcess, Boolean>)((NotNullFunction)debugProcess -> {
            if (client == null) {
                NativeAndroidDebugger.$$$reportNull$$$0(54);
            }
            if (!(debugProcess instanceof AndroidNativeAppDebugProcess)) {
                return false;
            }
            AndroidNativeAppDebugProcess nativeDebugProcess = (AndroidNativeAppDebugProcess)((Object)debugProcess);
            return nativeDebugProcess.getClient().getClientData().getPid() == client.getClientData().getPid();
        }));
    }

    @Nullable
    protected static XDebugSession findXDebugSession(@NotNull Project project, @NotNull NotNullFunction<XDebugProcess, Boolean> debugProcessFilter) {
        if (project == null) {
            NativeAndroidDebugger.$$$reportNull$$$0(24);
        }
        if (debugProcessFilter == null) {
            NativeAndroidDebugger.$$$reportNull$$$0(25);
        }
        for (XDebugSession debugSession : XDebuggerManager.getInstance((Project)project).getDebugSessions()) {
            XDebugProcess debugProcess = debugSession.getDebugProcess();
            if (!((Boolean)debugProcessFilter.fun((Object)debugProcess)).booleanValue()) continue;
            return debugSession;
        }
        return null;
    }

    @NotNull
    public String getAmStartOptions(@NotNull NativeAndroidDebuggerState state, @NotNull Project project, @NotNull AndroidVersion version) {
        if (state == null) {
            NativeAndroidDebugger.$$$reportNull$$$0(26);
        }
        if (project == null) {
            NativeAndroidDebugger.$$$reportNull$$$0(27);
        }
        if (version == null) {
            NativeAndroidDebugger.$$$reportNull$$$0(28);
        }
        String baseOptions = super.getAmStartOptions((AndroidDebuggerState)state, project, version);
        if (state.useJavaAwareDebugger() && this.supportsJavaAwareNativeDebugging(version)) {
            String string = baseOptions + (!baseOptions.isEmpty() ? " " : "") + JAVA_AWARE_NATIVE_DEBUG_OPTION;
            if (string == null) {
                NativeAndroidDebugger.$$$reportNull$$$0(29);
            }
            return string;
        }
        String string = baseOptions;
        if (string == null) {
            NativeAndroidDebugger.$$$reportNull$$$0(30);
        }
        return string;
    }

    @NotNull
    public synchronized Set<XBreakpointType<?, ?>> getSupportedBreakpointTypes(@NotNull Project project, @NotNull AndroidVersion version) {
        if (project == null) {
            NativeAndroidDebugger.$$$reportNull$$$0(31);
        }
        if (version == null) {
            NativeAndroidDebugger.$$$reportNull$$$0(32);
        }
        Set bpTypes = super.getSupportedBreakpointTypes(project, version);
        if (this.supportsJavaAwareNativeDebugging(version)) {
            bpTypes.addAll(AndroidJavaAwareNativeDebugProcess.getJavaBreakpointTypes());
        }
        Set set = bpTypes;
        if (set == null) {
            NativeAndroidDebugger.$$$reportNull$$$0(33);
        }
        return set;
    }

    public boolean supportsJavaAwareNativeDebugging(@NotNull AndroidVersion version) {
        if (version == null) {
            NativeAndroidDebugger.$$$reportNull$$$0(34);
        }
        return version.getFeatureLevel() >= 24;
    }

    @NotNull
    public AndroidNativeAppDebugProcess newAndroidNativeAppDebugProcess(@NotNull String sessionId, @NotNull RunParameters parameters, @NotNull XDebugSession session, @NotNull TextConsoleBuilder consoleBuilder, @NotNull ConsolePrinter printer, @NotNull SessionStarter sessionStarter, @NotNull Client client, @Nullable JdwpConnector jdwpConnector, @NotNull ProgressReporter progressReporter, boolean detachOnStop) throws ExecutionException {
        if (sessionId == null) {
            NativeAndroidDebugger.$$$reportNull$$$0(35);
        }
        if (parameters == null) {
            NativeAndroidDebugger.$$$reportNull$$$0(36);
        }
        if (session == null) {
            NativeAndroidDebugger.$$$reportNull$$$0(37);
        }
        if (consoleBuilder == null) {
            NativeAndroidDebugger.$$$reportNull$$$0(38);
        }
        if (printer == null) {
            NativeAndroidDebugger.$$$reportNull$$$0(39);
        }
        if (sessionStarter == null) {
            NativeAndroidDebugger.$$$reportNull$$$0(40);
        }
        if (client == null) {
            NativeAndroidDebugger.$$$reportNull$$$0(41);
        }
        if (progressReporter == null) {
            NativeAndroidDebugger.$$$reportNull$$$0(42);
        }
        if (client.getClientData().isNativeDebuggable()) {
            AndroidJavaAwareNativeDebugProcess androidJavaAwareNativeDebugProcess = new AndroidJavaAwareNativeDebugProcess(sessionId, parameters, session, consoleBuilder, printer, sessionStarter, jdwpConnector, client, progressReporter, detachOnStop);
            if (androidJavaAwareNativeDebugProcess == null) {
                NativeAndroidDebugger.$$$reportNull$$$0(43);
            }
            return androidJavaAwareNativeDebugProcess;
        }
        AndroidNativeAppDebugProcess androidNativeAppDebugProcess = new AndroidNativeAppDebugProcess(sessionId, parameters, session, consoleBuilder, printer, sessionStarter, jdwpConnector, client, progressReporter, detachOnStop);
        if (androidNativeAppDebugProcess == null) {
            NativeAndroidDebugger.$$$reportNull$$$0(44);
        }
        return androidNativeAppDebugProcess;
    }

    @NotNull
    protected static String prepareSetSettingsCommand(String ... options) {
        if (options == null) {
            NativeAndroidDebugger.$$$reportNull$$$0(45);
        }
        String string = "settings set " + StringUtil.join((String[])options, (String)" ");
        if (string == null) {
            NativeAndroidDebugger.$$$reportNull$$$0(46);
        }
        return string;
    }

    @NotNull
    public List<String> getStartupCommands(@NotNull AndroidFacet facet, @Nullable Client client, @NotNull ProcessHandlerConsolePrinter printer) {
        if (facet == null) {
            NativeAndroidDebugger.$$$reportNull$$$0(47);
        }
        if (printer == null) {
            NativeAndroidDebugger.$$$reportNull$$$0(48);
        }
        Collection javaDirs = facet.getMainSourceProvider().getJavaDirectories();
        boolean enableJIT = client != null && client.getClientData().isNativeDebuggable() && !javaDirs.isEmpty();
        ArrayList cmds = Lists.newArrayList();
        Map<String, String> sourceMap = AndroidNativeAppDebugProcess.getSourceMap(facet);
        if (client != null && client.getClientData().isNativeDebuggable() && !javaDirs.isEmpty()) {
            String firstJavaDir = NativeAndroidDebugger.getFirstAbsolutePath(javaDirs);
            Collections.addAll(cmds, NativeAndroidDebugger.prepareSetSettingsCommand("target.move-to-nearest-code", "false"));
            sourceMap.put("$JAVA_SRC_ROOT", firstJavaDir);
            if (javaDirs.size() > 1) {
                printer.stderr("The project has more than one Java source directories.\nBreakpoints in source files in " + firstJavaDir + " will only be active.");
            }
        }
        if (!sourceMap.isEmpty()) {
            ArrayList<String> arguments = new ArrayList<String>(sourceMap.size() * 2);
            for (Map.Entry<String, String> entry : sourceMap.entrySet()) {
                arguments.add("\"" + entry.getKey() + "\"");
                arguments.add("\"" + entry.getValue() + "\"");
            }
            String argumentsStr = StringUtil.join(arguments, (String)" ");
            LOG.info("Set target.source-map: " + argumentsStr);
            Collections.addAll(cmds, NativeAndroidDebugger.prepareSetSettingsCommand("target.source-map", argumentsStr));
        }
        Collections.addAll(cmds, NativeAndroidDebugger.prepareSetSettingsCommand("auto-confirm", "true"));
        Collections.addAll(cmds, NativeAndroidDebugger.prepareSetSettingsCommand("plugin.symbol-file.dwarf.comp-dir-symlink-paths", "/proc/self/cwd"));
        Collections.addAll(cmds, NativeAndroidDebugger.prepareSetSettingsCommand("plugin.jit-loader.gdb.enable-jit-breakpoint", Boolean.toString(enableJIT)));
        ArrayList arrayList = cmds;
        if (arrayList == null) {
            NativeAndroidDebugger.$$$reportNull$$$0(49);
        }
        return arrayList;
    }

    @NotNull
    public List<String> getPostAttachCommands(@NotNull AndroidFacet facet, @Nullable Client client) {
        if (facet == null) {
            NativeAndroidDebugger.$$$reportNull$$$0(50);
        }
        ArrayList cmds = Lists.newArrayList();
        cmds.add(NativeAndroidDebugger.prepareSetSettingsCommand("target.process.thread.step-avoid-regexp", "''"));
        cmds.add("type format add --format boolean jboolean");
        ArrayList arrayList = cmds;
        if (arrayList == null) {
            NativeAndroidDebugger.$$$reportNull$$$0(51);
        }
        return arrayList;
    }

    @NotNull
    private static String getFirstAbsolutePath(@NotNull Collection<File> dirs) {
        if (dirs == null) {
            NativeAndroidDebugger.$$$reportNull$$$0(52);
        }
        File f = (File)ContainerUtil.getFirstItem(dirs);
        assert (f != null);
        String string = f.getAbsolutePath();
        if (string == null) {
            NativeAndroidDebugger.$$$reportNull$$$0(53);
        }
        return string;
    }

    static {
        CidrDebuggerSettings.getInstance().VALUES_FILTER_ENABLED = false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 11: 
            case 18: 
            case 29: 
            case 30: 
            case 33: 
            case 43: 
            case 44: 
            case 46: 
            case 49: 
            case 51: 
            case 53: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 11: 
            case 18: 
            case 29: 
            case 30: 
            case 33: 
            case 43: 
            case 44: 
            case 46: 
            case 49: 
            case 51: 
            case 53: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consoleProvider";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 11: 
            case 18: 
            case 29: 
            case 30: 
            case 33: 
            case 43: 
            case 44: 
            case 46: 
            case 49: 
            case 51: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/ndk/run/editor/NativeAndroidDebugger";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runConfiguration";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "applicationIds";
                break;
            }
            case 8: 
            case 47: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 9: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runConfigTypeId";
                break;
            }
            case 12: 
            case 13: 
            case 15: 
            case 20: 
            case 22: 
            case 24: 
            case 27: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 14: 
            case 17: 
            case 21: 
            case 23: 
            case 41: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "client";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugSession";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugProcessFilter";
                break;
            }
            case 28: 
            case 32: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sessionId";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consoleBuilder";
                break;
            }
            case 39: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "printer";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sessionStarter";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressReporter";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dirs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/ndk/run/editor/NativeAndroidDebugger";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createState";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createConfigurable";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getConnectDebuggerTask";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "createRunnerAndConfigurationSettings";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getAmStartOptions";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getSupportedBreakpointTypes";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "newAndroidNativeAppDebugProcess";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "prepareSetSettingsCommand";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "getStartupCommands";
                break;
            }
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "getPostAttachCommands";
                break;
            }
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "getFirstAbsolutePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setConsoleProvider";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 11: 
            case 18: 
            case 29: 
            case 30: 
            case 33: 
            case 43: 
            case 44: 
            case 46: 
            case 49: 
            case 51: 
            case 53: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createConfigurable";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getConnectDebuggerTask";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "supportsProject";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "attachToClient";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createRunnerAndConfigurationSettings";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "detachXDebugSession";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "hasExistingSession";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "findNativeDebugSession";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "findXDebugSession";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getAmStartOptions";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getSupportedBreakpointTypes";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "supportsJavaAwareNativeDebugging";
                break;
            }
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "newAndroidNativeAppDebugProcess";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "prepareSetSettingsCommand";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "getStartupCommands";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "getPostAttachCommands";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "getFirstAbsolutePath";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "lambda$findNativeDebugSession$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 11: 
            case 18: 
            case 29: 
            case 30: 
            case 33: 
            case 43: 
            case 44: 
            case 46: 
            case 49: 
            case 51: 
            case 53: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

