/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.run.editor;

import com.android.tools.ndk.run.editor.ChooseSymbolDirectoryPanel;
import com.android.tools.ndk.run.editor.StringListEntryPanel;
import com.intellij.openapi.project.Project;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBTabbedPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;

public class NativeAndroidDebuggerPanel {
    private final Project myProject;
    private JPanel myPanel;
    private ChooseSymbolDirectoryPanel mySymDirsPanel;
    private JTextField myLoggingTargetChannelsField;
    private JBTabbedPane myOptionListsPane;
    private JCheckBox myShowStaticVarsCheckBox;
    private JCheckBox myShowOptimizedWarningCheckBox;
    private StringListEntryPanel myLldbStartupCommandsPanel;
    private StringListEntryPanel myLldbPostAttachCommandsPanel;

    public NativeAndroidDebuggerPanel(@NotNull Project project, boolean enableUseJavaAwareDebugger) {
        if (project == null) {
            NativeAndroidDebuggerPanel.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        this.$$$setupUI$$$();
        this.myLldbStartupCommandsPanel = this.buildOptionListTabPane("LLDB Startup Commands");
        this.myLldbPostAttachCommandsPanel = this.buildOptionListTabPane("LLDB Post Attach Commands");
    }

    public JComponent getComponent() {
        return this.myPanel;
    }

    public boolean showStaticVars() {
        return this.myShowStaticVarsCheckBox.isSelected();
    }

    public void setShowStaticVars(boolean showStaticVars) {
        this.myShowStaticVarsCheckBox.setSelected(showStaticVars);
    }

    public boolean showOptimizedWarning() {
        return this.myShowOptimizedWarningCheckBox.isSelected();
    }

    public void setShowOptimizedWarning(boolean value) {
        this.myShowOptimizedWarningCheckBox.setSelected(value);
    }

    @NotNull
    public ChooseSymbolDirectoryPanel getSymbolDirectoryPanel() {
        ChooseSymbolDirectoryPanel chooseSymbolDirectoryPanel = this.mySymDirsPanel;
        if (chooseSymbolDirectoryPanel == null) {
            NativeAndroidDebuggerPanel.$$$reportNull$$$0(1);
        }
        return chooseSymbolDirectoryPanel;
    }

    @NotNull
    public String getTargetLoggingChannels() {
        String logChannels = this.myLoggingTargetChannelsField.getText().trim();
        String string = logChannels.replaceAll("[^a-z\\-\\s:]", "");
        if (string == null) {
            NativeAndroidDebuggerPanel.$$$reportNull$$$0(2);
        }
        return string;
    }

    public void setTargetLoggingChannels(@NotNull String targetLoggingChannels) {
        if (targetLoggingChannels == null) {
            NativeAndroidDebuggerPanel.$$$reportNull$$$0(3);
        }
        this.myLoggingTargetChannelsField.setText(targetLoggingChannels);
    }

    @NotNull
    public List<String> getUserStartupCommands() {
        List<String> list = this.myLldbStartupCommandsPanel.getEntries();
        if (list == null) {
            NativeAndroidDebuggerPanel.$$$reportNull$$$0(4);
        }
        return list;
    }

    public void setUserStartupCommands(@NotNull List<String> userStartupCommands) {
        if (userStartupCommands == null) {
            NativeAndroidDebuggerPanel.$$$reportNull$$$0(5);
        }
        this.myLldbStartupCommandsPanel.setEntries(userStartupCommands);
    }

    @NotNull
    public List<String> getUserPostAttachCommands() {
        List<String> list = this.myLldbPostAttachCommandsPanel.getEntries();
        if (list == null) {
            NativeAndroidDebuggerPanel.$$$reportNull$$$0(6);
        }
        return list;
    }

    public void setUserPostAttachCommands(@NotNull List<String> userPostAttachCommands) {
        if (userPostAttachCommands == null) {
            NativeAndroidDebuggerPanel.$$$reportNull$$$0(7);
        }
        this.myLldbPostAttachCommandsPanel.setEntries(userPostAttachCommands);
    }

    @NotNull
    private StringListEntryPanel buildOptionListTabPane(String tabName) {
        StringListEntryPanel panel = new StringListEntryPanel();
        this.myOptionListsPane.add(tabName, (Component)panel);
        StringListEntryPanel stringListEntryPanel = panel;
        if (stringListEntryPanel == null) {
            NativeAndroidDebuggerPanel.$$$reportNull$$$0(8);
        }
        return stringListEntryPanel;
    }

    private void createUIComponents() {
        this.mySymDirsPanel = new ChooseSymbolDirectoryPanel(this.myProject);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/ndk/run/editor/NativeAndroidDebuggerPanel";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetLoggingChannels";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "userStartupCommands";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "userPostAttachCommands";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/ndk/run/editor/NativeAndroidDebuggerPanel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getSymbolDirectoryPanel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetLoggingChannels";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getUserStartupCommands";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getUserPostAttachCommands";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "buildOptionListTabPane";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 8: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setTargetLoggingChannels";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setUserStartupCommands";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setUserPostAttachCommands";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JBTabbedPane jBTabbedPane;
        JTextField jTextField;
        JPanel jPanel;
        this.createUIComponents();
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(6, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(2, 2, 4, 1, 0, 2, 1, 6, null, null, null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(4, 0, 1, 2, 1, 1, 3, 3, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel2.add((Component)spacer2, new GridConstraints(0, 0, 1, 3, 0, 2, 1, 6, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel3, new GridConstraints(5, 0, 1, 2, 0, 3, 3, 7, null, null, null));
        jPanel3.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Logging", 0, 0, null, null));
        JBLabel jBLabel = new JBLabel();
        jBLabel.setText("Target channels:");
        jPanel3.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel3.add((Component)spacer3, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myLoggingTargetChannelsField = jTextField = new JTextField();
        jPanel3.add((Component)jTextField, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myOptionListsPane = jBTabbedPane = new JBTabbedPane();
        jPanel.add((Component)jBTabbedPane, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, new Dimension(200, 200), null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jBTabbedPane.addTab("Symbol Directories", null, jPanel4, null);
        ChooseSymbolDirectoryPanel chooseSymbolDirectoryPanel = this.mySymDirsPanel;
        jPanel4.add((Component)chooseSymbolDirectoryPanel, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 2, null, null, null));
        this.myShowStaticVarsCheckBox = jCheckBox2 = new JCheckBox();
        jCheckBox2.setText("Show static/global variables in the Variables Pane");
        jPanel.add((Component)jCheckBox2, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myShowOptimizedWarningCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setText("Warn when debugging optimized code");
        jPanel.add((Component)jCheckBox, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }
}

