/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.run.editor;

import com.android.builder.model.BuildType;
import com.android.builder.model.BuildTypeContainer;
import com.android.ide.common.gradle.model.IdeVariant;
import com.android.tools.idea.gradle.project.facet.gradle.GradleFacet;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.run.ValidationError;
import com.android.tools.idea.run.editor.AndroidDebuggerState;
import com.google.common.collect.Lists;
import com.intellij.execution.Executor;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizer;
import com.intellij.openapi.util.WriteExternalException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NativeAndroidDebuggerState
extends AndroidDebuggerState {
    private static final String SYMBOL_DIRS = "symbol_dirs";
    private static final String SYMBOL_PATH = "symbol_path";
    private static final String STARTUP_COMMANDS = "startup_commands";
    private static final String STARTUP_COMMANDS_ATTR = "startup_commands_attr";
    private static final String POST_ATTACH_COMMANDS = "post_attach_commands";
    private static final String POST_ATTACH_COMMANDS_ATTR = "post_attach_commands_attr";
    private static final String SDK_CHECK_FAIL_WARNING = "SDK check failed.";
    private List<String> mySymbolDirs = Lists.newLinkedList();
    private List<String> myUserStartupCommands = Lists.newLinkedList();
    private List<String> myUserPostAttachCommands = Lists.newLinkedList();
    public boolean USE_JAVA_AWARE_DEBUGGER;
    public boolean SHOW_STATIC_VARS = true;
    public String WORKING_DIR = "";
    public String TARGET_LOGGING_CHANNELS = "lldb process:gdb-remote packets";
    public boolean SHOW_OPTIMIZED_WARNING = true;

    @NotNull
    public List<ValidationError> validate(@NotNull AndroidFacet facet, @Nullable Executor executor) {
        if (facet == null) {
            NativeAndroidDebuggerState.$$$reportNull$$$0(0);
        }
        ArrayList errors = Lists.newArrayList();
        if (executor == null || !(executor instanceof DefaultDebugExecutor)) {
            ArrayList arrayList = errors;
            if (arrayList == null) {
                NativeAndroidDebuggerState.$$$reportNull$$$0(1);
            }
            return arrayList;
        }
        AndroidModuleModel androidModel = AndroidModuleModel.get((AndroidFacet)facet);
        if (androidModel != null && GradleFacet.isAppliedTo((Module)facet.getModule())) {
            IdeVariant selectedVariant = androidModel.getSelectedVariant();
            BuildTypeContainer buildTypeContainer = androidModel.findBuildType(selectedVariant.getBuildType());
            if (buildTypeContainer == null) {
                errors.add(ValidationError.fatal((String)("Build type " + selectedVariant.getBuildType() + " not found")));
                ArrayList arrayList = errors;
                if (arrayList == null) {
                    NativeAndroidDebuggerState.$$$reportNull$$$0(2);
                }
                return arrayList;
            }
            BuildType buildType = buildTypeContainer.getBuildType();
            if (!buildType.isDebuggable()) {
                errors.add(ValidationError.fatal((String)"Build type isn't debuggable"));
            }
        }
        ArrayList arrayList = errors;
        if (arrayList == null) {
            NativeAndroidDebuggerState.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    @NotNull
    public List<String> getSymbolDirs() {
        List<String> list = this.mySymbolDirs;
        if (list == null) {
            NativeAndroidDebuggerState.$$$reportNull$$$0(4);
        }
        return list;
    }

    public void setSymbolDirs(@NotNull List<String> symDirs) {
        if (symDirs == null) {
            NativeAndroidDebuggerState.$$$reportNull$$$0(5);
        }
        this.mySymbolDirs.clear();
        this.mySymbolDirs.addAll(symDirs);
    }

    public void addSymbolDir(@NotNull String symDir) {
        if (symDir == null) {
            NativeAndroidDebuggerState.$$$reportNull$$$0(6);
        }
        if (this.mySymbolDirs.indexOf(symDir) == -1) {
            this.mySymbolDirs.add(symDir);
        }
    }

    public boolean useJavaAwareDebugger() {
        return this.USE_JAVA_AWARE_DEBUGGER;
    }

    public boolean showStaticVars() {
        return this.SHOW_STATIC_VARS;
    }

    public void setShowStaticVars(boolean showStaticVars) {
        this.SHOW_STATIC_VARS = showStaticVars;
    }

    @NotNull
    public String getWorkingDir() {
        String string = this.WORKING_DIR;
        if (string == null) {
            NativeAndroidDebuggerState.$$$reportNull$$$0(7);
        }
        return string;
    }

    public void setWorkingDir(@NotNull String workingDir) {
        if (workingDir == null) {
            NativeAndroidDebuggerState.$$$reportNull$$$0(8);
        }
        this.WORKING_DIR = workingDir;
    }

    @NotNull
    public String getTargetLoggingChannels() {
        String string = this.TARGET_LOGGING_CHANNELS;
        if (string == null) {
            NativeAndroidDebuggerState.$$$reportNull$$$0(9);
        }
        return string;
    }

    public void setTargetLoggingChannels(@NotNull String targetLoggingChannels) {
        if (targetLoggingChannels == null) {
            NativeAndroidDebuggerState.$$$reportNull$$$0(10);
        }
        this.TARGET_LOGGING_CHANNELS = targetLoggingChannels;
    }

    public boolean showOptimizedWarning() {
        return this.SHOW_OPTIMIZED_WARNING;
    }

    public void setShowOptimizedWarning(boolean value) {
        this.SHOW_OPTIMIZED_WARNING = value;
    }

    @NotNull
    public List<String> getUserStartupCommands() {
        List<String> list = this.myUserStartupCommands;
        if (list == null) {
            NativeAndroidDebuggerState.$$$reportNull$$$0(11);
        }
        return list;
    }

    public void setUserStartupCommands(@NotNull Collection<String> userStartupCommands) {
        if (userStartupCommands == null) {
            NativeAndroidDebuggerState.$$$reportNull$$$0(12);
        }
        this.myUserStartupCommands.clear();
        this.myUserStartupCommands.addAll(userStartupCommands);
    }

    @NotNull
    public List<String> getUserPostAttachCommands() {
        List<String> list = this.myUserPostAttachCommands;
        if (list == null) {
            NativeAndroidDebuggerState.$$$reportNull$$$0(13);
        }
        return list;
    }

    public void setUserPostAttachCommands(@NotNull Collection<String> userPostAttachCommands) {
        if (userPostAttachCommands == null) {
            NativeAndroidDebuggerState.$$$reportNull$$$0(14);
        }
        this.myUserPostAttachCommands.clear();
        this.myUserPostAttachCommands.addAll(userPostAttachCommands);
    }

    public void readExternal(Element element) throws InvalidDataException {
        super.readExternal(element);
        this.mySymbolDirs = JDOMExternalizer.loadStringsList((Element)element, (String)SYMBOL_DIRS, (String)SYMBOL_PATH);
        this.myUserStartupCommands = JDOMExternalizer.loadStringsList((Element)element, (String)STARTUP_COMMANDS, (String)STARTUP_COMMANDS_ATTR);
        this.myUserPostAttachCommands = JDOMExternalizer.loadStringsList((Element)element, (String)POST_ATTACH_COMMANDS, (String)POST_ATTACH_COMMANDS_ATTR);
    }

    public void writeExternal(Element element) throws WriteExternalException {
        super.writeExternal(element);
        JDOMExternalizer.saveStringsList((Element)element, (String)SYMBOL_DIRS, (String)SYMBOL_PATH, (String[])this.mySymbolDirs.toArray(new String[0]));
        JDOMExternalizer.saveStringsList((Element)element, (String)STARTUP_COMMANDS, (String)STARTUP_COMMANDS_ATTR, (String[])this.myUserStartupCommands.toArray(new String[0]));
        JDOMExternalizer.saveStringsList((Element)element, (String)POST_ATTACH_COMMANDS, (String)POST_ATTACH_COMMANDS_ATTR, (String[])this.myUserPostAttachCommands.toArray(new String[0]));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 9: 
            case 11: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 9: 
            case 11: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 9: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/ndk/run/editor/NativeAndroidDebuggerState";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symDirs";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symDir";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "workingDir";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetLoggingChannels";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "userStartupCommands";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "userPostAttachCommands";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/ndk/run/editor/NativeAndroidDebuggerState";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "validate";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSymbolDirs";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getWorkingDir";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetLoggingChannels";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getUserStartupCommands";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getUserPostAttachCommands";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "validate";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 9: 
            case 11: 
            case 13: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setSymbolDirs";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addSymbolDir";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setWorkingDir";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setTargetLoggingChannels";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "setUserStartupCommands";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "setUserPostAttachCommands";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 9: 
            case 11: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

