/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.run.editor;

import com.google.common.collect.Lists;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.table.JBTable;
import java.awt.BorderLayout;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NotNull;

class StringListEntryPanel
extends JPanel {
    private final JBTable myOptionsList;
    private StringListTableModel myEntriesModel = new StringListTableModel(Collections.emptyList());

    public StringListEntryPanel() {
        super(new BorderLayout());
        this.myOptionsList = new JBTable((TableModel)this.myEntriesModel);
        this.myOptionsList.setTableHeader(null);
        this.myOptionsList.setShowGrid(false);
        this.myOptionsList.setSelectionMode(0);
        ToolbarDecorator decorator = ToolbarDecorator.createDecorator((JTable)this.myOptionsList).setAddAction(button -> {
            this.myEntriesModel.add("");
            this.myOptionsList.editCellAt(this.myEntriesModel.getLastRowIndex(), 0);
        }).setRemoveAction(button -> {
            if (this.myOptionsList.getSelectedRowCount() > 0) {
                int selectedRow = this.myOptionsList.getSelectedRow();
                this.myOptionsList.removeEditor();
                this.myEntriesModel.removeRow(selectedRow);
                if (selectedRow < this.myEntriesModel.getRowCount()) {
                    this.myOptionsList.changeSelection(selectedRow, 0, false, false);
                } else if (selectedRow > 0) {
                    this.myOptionsList.changeSelection(selectedRow - 1, 0, false, false);
                }
            }
        }).setMoveDownAction(button -> {
            int selectedRow = this.myOptionsList.getSelectedRow();
            if (selectedRow > -1 && selectedRow < this.myEntriesModel.getRowCount() - 1) {
                this.myEntriesModel.moveRow(selectedRow, selectedRow, selectedRow + 1);
                this.myOptionsList.changeSelection(selectedRow + 1, 0, false, false);
            }
        }).setMoveUpAction(button -> {
            int selectedRow = this.myOptionsList.getSelectedRow();
            if (selectedRow > 0) {
                this.myEntriesModel.moveRow(selectedRow, selectedRow, selectedRow - 1);
                this.myOptionsList.changeSelection(selectedRow - 1, 0, false, false);
            }
        });
        this.add(decorator.createPanel());
    }

    @NotNull
    public List<String> getEntries() {
        List<String> list = this.myEntriesModel.getEntries();
        if (list == null) {
            StringListEntryPanel.$$$reportNull$$$0(0);
        }
        return list;
    }

    public void setEntries(@NotNull List<String> entries) {
        if (entries == null) {
            StringListEntryPanel.$$$reportNull$$$0(1);
        }
        this.myEntriesModel = new StringListTableModel(entries);
        this.myOptionsList.setModel((TableModel)this.myEntriesModel);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/ndk/run/editor/StringListEntryPanel";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entries";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getEntries";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/ndk/run/editor/StringListEntryPanel";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setEntries";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class StringListTableModel
    extends DefaultTableModel {
        public StringListTableModel(List<String> entries) {
            if (entries == null) {
                StringListTableModel.$$$reportNull$$$0(0);
            }
            super(0, 1);
            for (String entry : entries) {
                this.add(entry);
            }
        }

        public void add(@NotNull String entry) {
            if (entry == null) {
                StringListTableModel.$$$reportNull$$$0(1);
            }
            this.addRow(new String[]{entry});
        }

        public int getLastRowIndex() {
            return this.getRowCount() - 1;
        }

        @NotNull
        public List<String> getEntries() {
            ArrayList entries = Lists.newArrayListWithCapacity((int)this.getRowCount());
            for (int i = 0; i < this.getRowCount(); ++i) {
                entries.add((String)this.getValueAt(i, 0));
            }
            ArrayList arrayList = entries;
            if (arrayList == null) {
                StringListTableModel.$$$reportNull$$$0(2);
            }
            return arrayList;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "entries";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "entry";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/ndk/run/editor/StringListEntryPanel$StringListTableModel";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/ndk/run/editor/StringListEntryPanel$StringListTableModel";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getEntries";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "add";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

