/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.run.hybrid;

import com.android.tools.ndk.jni.JniNameMangler;
import com.android.tools.ndk.run.hybrid.AndroidNativeHybridDebugProcess;
import com.android.tools.ndk.run.hybrid.MethodCollector;
import com.android.tools.ndk.run.hybrid.StepIntoNativeBreakpointType;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.intellij.debugger.engine.BasicStepMethodFilter;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.JavaDebugProcess;
import com.intellij.debugger.engine.JavaValue;
import com.intellij.debugger.engine.MethodFilter;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiMethod;
import com.intellij.util.Range;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebugSessionListener;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.evaluation.XDebuggerEvaluator;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.frame.XSuspendContext;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.impl.frame.XVariablesView;
import com.intellij.xdebugger.stepping.XSmartStepIntoHandler;
import com.intellij.xdebugger.stepping.XSmartStepIntoVariant;
import com.sun.jdi.Location;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidJavaDebugProcess
extends JavaDebugProcess {
    private static final Logger LOG = Logger.getInstance(AndroidJavaDebugProcess.class);
    private static final String TID_EXPRESSION = "android.os.Process.myTid()";
    private final DebuggerSession myJavaSession;
    private final Project myProject;
    private final AndroidNativeHybridDebugProcess myNativeDebugProcess;
    private final XSmartStepIntoHandler<?> mySmartStepIntoHandler;
    private XSourcePosition myPauseSourcePosition;
    private ListenableFuture<Integer> myCurrentTidFuture;
    private boolean myCanPerformCommands;

    public static JavaDebugProcess create(@NotNull XDebugSession session, @NotNull DebuggerSession javaSession, @NotNull AndroidNativeHybridDebugProcess nativeDebugProcess) {
        if (session == null) {
            AndroidJavaDebugProcess.$$$reportNull$$$0(0);
        }
        if (javaSession == null) {
            AndroidJavaDebugProcess.$$$reportNull$$$0(1);
        }
        if (nativeDebugProcess == null) {
            AndroidJavaDebugProcess.$$$reportNull$$$0(2);
        }
        AndroidJavaDebugProcess res = new AndroidJavaDebugProcess(session, javaSession, nativeDebugProcess);
        javaSession.getProcess().setXDebugProcess((JavaDebugProcess)res);
        nativeDebugProcess.setJavaSession(session);
        return res;
    }

    private AndroidJavaDebugProcess(@NotNull XDebugSession session, @NotNull DebuggerSession javaSession, @NotNull AndroidNativeHybridDebugProcess nativeDebugProcess) {
        if (session == null) {
            AndroidJavaDebugProcess.$$$reportNull$$$0(3);
        }
        if (javaSession == null) {
            AndroidJavaDebugProcess.$$$reportNull$$$0(4);
        }
        if (nativeDebugProcess == null) {
            AndroidJavaDebugProcess.$$$reportNull$$$0(5);
        }
        super(session, javaSession);
        this.mySmartStepIntoHandler = new SmartStepIntoHandlerImpl();
        this.myCanPerformCommands = true;
        this.myJavaSession = javaSession;
        this.myNativeDebugProcess = nativeDebugProcess;
        this.myProject = javaSession.getProject();
        session.addSessionListener(new XDebugSessionListener(){

            public void sessionPaused() {
                AndroidJavaDebugProcess.this.updateSourcePosition();
            }

            public void stackFrameChanged() {
                AndroidJavaDebugProcess.this.updateSourcePosition();
            }
        });
    }

    @NotNull
    private static ListenableFuture<Integer> getCurrentThreadIdFuture(@Nullable XSourcePosition sourcePosition, @NotNull XDebuggerEvaluator evaluator) {
        if (evaluator == null) {
            AndroidJavaDebugProcess.$$$reportNull$$$0(6);
        }
        final SettableFuture futureResult = SettableFuture.create();
        XDebuggerEvaluator.XEvaluationCallback evaluationCallback = new XDebuggerEvaluator.XEvaluationCallback(){

            public void evaluated(@NotNull XValue result) {
                if (result == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (result instanceof JavaValue) {
                    JavaValue jValue = (JavaValue)result;
                    futureResult.set((Object)Integer.parseInt(jValue.getDescriptor().getValue().toString()));
                } else {
                    futureResult.setException((Throwable)new EvaluateException("Unexpected value type: " + result.toString()));
                }
            }

            public void errorOccurred(@NotNull String errorMessage) {
                if (errorMessage == null) {
                    2.$$$reportNull$$$0(1);
                }
                futureResult.setException((Throwable)new EvaluateException("Evaluation failed: " + errorMessage));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "result";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "errorMessage";
                        break;
                    }
                }
                objectArray2[1] = "com/android/tools/ndk/run/hybrid/AndroidJavaDebugProcess$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "evaluated";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "errorOccurred";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        evaluator.evaluate(TID_EXPRESSION, evaluationCallback, sourcePosition);
        SettableFuture settableFuture = futureResult;
        if (settableFuture == null) {
            AndroidJavaDebugProcess.$$$reportNull$$$0(7);
        }
        return settableFuture;
    }

    private void updateSourcePosition() {
        if (this.myCurrentTidFuture != null) {
            this.myCurrentTidFuture.cancel(true);
            this.myCurrentTidFuture = null;
        }
        XStackFrame frame = this.getSession().getCurrentStackFrame();
        XDebuggerEvaluator evaluator = this.getEvaluator();
        if (frame != null && evaluator != null) {
            this.myPauseSourcePosition = frame.getSourcePosition();
            this.myCurrentTidFuture = AndroidJavaDebugProcess.getCurrentThreadIdFuture(this.myPauseSourcePosition, evaluator);
        } else {
            this.myPauseSourcePosition = null;
        }
    }

    private void setupNativeBreakpoints(int tid) {
        LinkedList jniMethodNames = Lists.newLinkedList();
        ApplicationManager.getApplication().runReadAction(() -> jniMethodNames.addAll(this.findNativeMethodsInCurrentSourcePosition()));
        for (String jniMethodName : jniMethodNames) {
            this.myNativeDebugProcess.registerStepIntoNativeBreakpoint(jniMethodName, tid);
        }
    }

    @NotNull
    private List<PsiMethod> findMethodsBySourcePosition(@NotNull XSourcePosition position) {
        if (position == null) {
            AndroidJavaDebugProcess.$$$reportNull$$$0(8);
        }
        MethodCollector methodCollector = new MethodCollector(this.myProject, position);
        List<PsiMethod> list = methodCollector.getMethods();
        if (list == null) {
            AndroidJavaDebugProcess.$$$reportNull$$$0(9);
        }
        return list;
    }

    @NotNull
    private List<String> findNativeMethodsInCurrentSourcePosition() {
        List<PsiMethod> methods = this.findMethodsBySourcePosition(this.myPauseSourcePosition);
        LinkedList jniMethodNames = Lists.newLinkedList();
        for (PsiMethod method : methods) {
            if (!AndroidJavaDebugProcess.isNativeMethod(method)) continue;
            jniMethodNames.add(AndroidJavaDebugProcess.formatJniMethodPattern(method));
        }
        LinkedList linkedList = jniMethodNames;
        if (linkedList == null) {
            AndroidJavaDebugProcess.$$$reportNull$$$0(10);
        }
        return linkedList;
    }

    private static boolean isNativeMethod(@NotNull PsiMethod method) {
        if (method == null) {
            AndroidJavaDebugProcess.$$$reportNull$$$0(11);
        }
        return method.getModifierList().hasExplicitModifier("native");
    }

    @NotNull
    private static String formatJniMethodPattern(@NotNull PsiMethod method) {
        if (method == null) {
            AndroidJavaDebugProcess.$$$reportNull$$$0(12);
        }
        String string = "Java_.*" + JniNameMangler.jniEncodeUnderscore(method.getName(), false) + ".*";
        if (string == null) {
            AndroidJavaDebugProcess.$$$reportNull$$$0(13);
        }
        return string;
    }

    public boolean checkCanPerformCommands() {
        return this.myCanPerformCommands;
    }

    private void initNativeSteppingInto(Runnable callSuperStartStepInto) {
        if (this.myPauseSourcePosition == null || this.myCurrentTidFuture == null) {
            return;
        }
        this.myCanPerformCommands = false;
        this.myCurrentTidFuture.addListener(() -> {
            try {
                int currentTid = (Integer)this.myCurrentTidFuture.get();
                this.setupNativeBreakpoints(currentTid);
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
            finally {
                try {
                    callSuperStartStepInto.run();
                }
                finally {
                    this.myCanPerformCommands = true;
                }
            }
        }, r -> ApplicationManager.getApplication().invokeLater(r));
    }

    private void removeAllStepIntoNativeMethodBreakpoints() {
        this.myNativeDebugProcess.removeAllStepIntoNativeBreakpoints();
    }

    public void startStepInto(@Nullable XSuspendContext context) {
        this.prepareToResume();
        this.initNativeSteppingInto(() -> super.startStepInto(context));
    }

    public void startForceStepInto(@Nullable XSuspendContext context) {
        this.prepareToResume();
        this.initNativeSteppingInto(() -> super.startForceStepInto(context));
    }

    public void startStepOver(@Nullable XSuspendContext context) {
        this.prepareToResume();
        this.removeAllStepIntoNativeMethodBreakpoints();
        super.startStepOver(context);
    }

    public void runToPosition(@NotNull XSourcePosition position, @Nullable XSuspendContext context) {
        if (position == null) {
            AndroidJavaDebugProcess.$$$reportNull$$$0(14);
        }
        this.prepareToResume();
        this.removeAllStepIntoNativeMethodBreakpoints();
        super.runToPosition(position, context);
    }

    public void resume(@Nullable XSuspendContext context) {
        this.prepareToResume();
        this.removeAllStepIntoNativeMethodBreakpoints();
        super.resume(context);
    }

    private void prepareToResume() {
        XVariablesView.InlineVariablesInfo.set((XDebugSession)this.getSession(), null);
    }

    public void stop() {
        super.stop();
        this.myNativeDebugProcess.getSession().stop();
    }

    @Nullable
    public XSmartStepIntoHandler<?> getSmartStepIntoHandler() {
        return this.mySmartStepIntoHandler;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 9: 
            case 10: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 9: 
            case 10: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "javaSession";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nativeDebugProcess";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "evaluator";
                break;
            }
            case 7: 
            case 9: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/ndk/run/hybrid/AndroidJavaDebugProcess";
                break;
            }
            case 8: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/ndk/run/hybrid/AndroidJavaDebugProcess";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentThreadIdFuture";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "findMethodsBySourcePosition";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "findNativeMethodsInCurrentSourcePosition";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "formatJniMethodPattern";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getCurrentThreadIdFuture";
                break;
            }
            case 7: 
            case 9: 
            case 10: 
            case 13: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findMethodsBySourcePosition";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isNativeMethod";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "formatJniMethodPattern";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "runToPosition";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 9: 
            case 10: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public class SmartStepIntoHandlerImpl
    extends XSmartStepIntoHandler<XSmartStepIntoVariantImpl> {
        @NotNull
        public List<XSmartStepIntoVariantImpl> computeSmartStepVariants(@NotNull XSourcePosition position) {
            if (position == null) {
                SmartStepIntoHandlerImpl.$$$reportNull$$$0(0);
            }
            MethodCollector methodCollector = new MethodCollector(AndroidJavaDebugProcess.this.myProject, position);
            List<PsiMethod> methods = methodCollector.getMethods();
            ArrayList variants = Lists.newArrayListWithExpectedSize((int)methods.size());
            Range<Integer> lineRange = methodCollector.getLineRange();
            if (lineRange != null) {
                for (PsiMethod method : methods) {
                    variants.add(new XSmartStepIntoVariantImpl(method, lineRange));
                }
            }
            ArrayList arrayList = variants;
            if (arrayList == null) {
                SmartStepIntoHandlerImpl.$$$reportNull$$$0(1);
            }
            return arrayList;
        }

        public void startStepInto(@NotNull XSmartStepIntoVariantImpl variant) {
            PsiMethod method;
            if (variant == null) {
                SmartStepIntoHandlerImpl.$$$reportNull$$$0(2);
            }
            if (!AndroidJavaDebugProcess.isNativeMethod(method = variant.getMethod())) {
                AndroidJavaDebugProcess.this.myJavaSession.stepInto(true, (MethodFilter)new BasicStepMethodFilter(method, variant.getLineRange()));
                return;
            }
            try {
                XBreakpoint<StepIntoNativeBreakpointType.Properties> bp = AndroidJavaDebugProcess.this.myNativeDebugProcess.registerStepIntoNativeBreakpoint(AndroidJavaDebugProcess.formatJniMethodPattern(method), ((Integer)AndroidJavaDebugProcess.this.myCurrentTidFuture.get()).intValue());
                AndroidJavaDebugProcess.this.myJavaSession.stepInto(true, (MethodFilter)new NativeMethodFilter(bp, variant.getLineRange()));
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        }

        public String getPopupTitle(@NotNull XSourcePosition position) {
            if (position == null) {
                SmartStepIntoHandlerImpl.$$$reportNull$$$0(3);
            }
            return "Method to Step Into";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "position";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/ndk/run/hybrid/AndroidJavaDebugProcess$SmartStepIntoHandlerImpl";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "variant";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/ndk/run/hybrid/AndroidJavaDebugProcess$SmartStepIntoHandlerImpl";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "computeSmartStepVariants";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "computeSmartStepVariants";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "startStepInto";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getPopupTitle";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class XSmartStepIntoVariantImpl
    extends XSmartStepIntoVariant {
        private final PsiMethod myMethod;
        private final Range<Integer> myLineRange;

        public XSmartStepIntoVariantImpl(@NotNull PsiMethod method, @NotNull Range<Integer> lineRange) {
            if (method == null) {
                XSmartStepIntoVariantImpl.$$$reportNull$$$0(0);
            }
            if (lineRange == null) {
                XSmartStepIntoVariantImpl.$$$reportNull$$$0(1);
            }
            this.myMethod = method;
            this.myLineRange = lineRange;
        }

        @Nullable
        public Icon getIcon() {
            return this.myMethod.getIcon(2);
        }

        public String getText() {
            return this.myMethod.getText();
        }

        @NotNull
        public Range<Integer> getLineRange() {
            Range<Integer> range = this.myLineRange;
            if (range == null) {
                XSmartStepIntoVariantImpl.$$$reportNull$$$0(2);
            }
            return range;
        }

        @NotNull
        public PsiMethod getMethod() {
            PsiMethod psiMethod = this.myMethod;
            if (psiMethod == null) {
                XSmartStepIntoVariantImpl.$$$reportNull$$$0(3);
            }
            return psiMethod;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "method";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "lineRange";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/ndk/run/hybrid/AndroidJavaDebugProcess$XSmartStepIntoVariantImpl";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/ndk/run/hybrid/AndroidJavaDebugProcess$XSmartStepIntoVariantImpl";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLineRange";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMethod";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class NativeMethodFilter
    implements MethodFilter {
        private final XBreakpoint<StepIntoNativeBreakpointType.Properties> myBp;
        private final Range<Integer> myLineRange;

        public NativeMethodFilter(@NotNull XBreakpoint<StepIntoNativeBreakpointType.Properties> bp, @NotNull Range<Integer> lineRange) {
            if (bp == null) {
                NativeMethodFilter.$$$reportNull$$$0(0);
            }
            if (lineRange == null) {
                NativeMethodFilter.$$$reportNull$$$0(1);
            }
            this.myBp = bp;
            this.myLineRange = lineRange;
        }

        public boolean locationMatches(@NotNull DebugProcessImpl process, @NotNull Location location) {
            if (process == null) {
                NativeMethodFilter.$$$reportNull$$$0(2);
            }
            if (location == null) {
                NativeMethodFilter.$$$reportNull$$$0(3);
            }
            return ((StepIntoNativeBreakpointType.Properties)this.myBp.getProperties()).isCalled();
        }

        @Nullable
        public Range<Integer> getCallingExpressionLines() {
            return this.myLineRange;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "bp";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "lineRange";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "process";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "location";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/ndk/run/hybrid/AndroidJavaDebugProcess$NativeMethodFilter";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "locationMatches";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

