/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.run.javaawarecpp;

import com.android.ddmlib.Client;
import com.android.tools.idea.run.ConsolePrinter;
import com.android.tools.ndk.run.ProgressReporter;
import com.android.tools.ndk.run.hybrid.AndroidNativeHybridDebugProcessBase;
import com.android.tools.ndk.run.hybrid.MethodCollector;
import com.android.tools.ndk.run.jdwp.JdwpConnector;
import com.android.tools.ndk.run.lldb.SessionStarter;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.debugger.ui.breakpoints.JavaLineBreakpointType;
import com.intellij.execution.filters.TextConsoleBuilder;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiMethod;
import com.intellij.util.concurrency.FutureResult;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XBreakpointHandler;
import com.intellij.xdebugger.breakpoints.XBreakpointProperties;
import com.intellij.xdebugger.breakpoints.XBreakpointType;
import com.intellij.xdebugger.breakpoints.XLineBreakpointType;
import com.intellij.xdebugger.frame.XSuspendContext;
import com.jetbrains.cidr.execution.RunParameters;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.LLFrame;
import com.jetbrains.cidr.execution.debugger.breakpoints.CidrBreakpointHandler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidJavaAwareNativeDebugProcess
extends AndroidNativeHybridDebugProcessBase {
    private static final Logger LOG = Logger.getInstance(AndroidJavaAwareNativeDebugProcess.class);
    private static final XBreakpointType<?, ?> JAVA_LINE_BP_TYPE = (XBreakpointType)XBreakpointType.EXTENSION_POINT_NAME.findExtension(JavaLineBreakpointType.class);
    private static final Set<String> ART_INTERNAL_FUNCTIONS = ImmutableSet.of((Object)"art_quick_to_interpreter_bridge", (Object)"art_quick_generic_jni_trampoline");
    private final CidrBreakpointHandler myJavaLineBreakpointHandler;
    private boolean myLastActionStepIn;

    public AndroidJavaAwareNativeDebugProcess(@NotNull String sessionId, @NotNull RunParameters parameters, @NotNull XDebugSession session, @NotNull TextConsoleBuilder consoleBuilder, @NotNull ConsolePrinter printer, @NotNull SessionStarter sessionStarter, @Nullable JdwpConnector jdwpConnector, @NotNull Client client, @NotNull ProgressReporter progressReporter, boolean detachOnStop) throws com.intellij.execution.ExecutionException {
        if (sessionId == null) {
            AndroidJavaAwareNativeDebugProcess.$$$reportNull$$$0(0);
        }
        if (parameters == null) {
            AndroidJavaAwareNativeDebugProcess.$$$reportNull$$$0(1);
        }
        if (session == null) {
            AndroidJavaAwareNativeDebugProcess.$$$reportNull$$$0(2);
        }
        if (consoleBuilder == null) {
            AndroidJavaAwareNativeDebugProcess.$$$reportNull$$$0(3);
        }
        if (printer == null) {
            AndroidJavaAwareNativeDebugProcess.$$$reportNull$$$0(4);
        }
        if (sessionStarter == null) {
            AndroidJavaAwareNativeDebugProcess.$$$reportNull$$$0(5);
        }
        if (client == null) {
            AndroidJavaAwareNativeDebugProcess.$$$reportNull$$$0(6);
        }
        if (progressReporter == null) {
            AndroidJavaAwareNativeDebugProcess.$$$reportNull$$$0(7);
        }
        super(sessionId, parameters, session, consoleBuilder, printer, sessionStarter, jdwpConnector, client, progressReporter, detachOnStop);
        this.myLastActionStepIn = false;
        this.myJavaLineBreakpointHandler = new CidrBreakpointHandler((CidrDebugProcess)this, AndroidJavaAwareNativeDebugProcess.getJavaLineBreakpointTypeClass());
    }

    private static Class<? extends XLineBreakpointType<XBreakpointProperties>> getJavaLineBreakpointTypeClass() {
        return JAVA_LINE_BP_TYPE.getClass();
    }

    @NotNull
    public static Set<XBreakpointType<?, ?>> getJavaBreakpointTypes() {
        HashSet hashSet = Sets.newHashSet((Object[])new XBreakpointType[]{JAVA_LINE_BP_TYPE});
        if (hashSet == null) {
            AndroidJavaAwareNativeDebugProcess.$$$reportNull$$$0(8);
        }
        return hashSet;
    }

    @Override
    @NotNull
    public XBreakpointHandler<?>[] getBreakpointHandlers() {
        ArrayList<CidrBreakpointHandler> handlerList = new ArrayList<CidrBreakpointHandler>();
        Collections.addAll(handlerList, super.getBreakpointHandlers());
        handlerList.add(this.myJavaLineBreakpointHandler);
        XBreakpointHandler[] xBreakpointHandlerArray = (XBreakpointHandler[])ContainerUtil.toArray(handlerList, (Object[])new XBreakpointHandler[handlerList.size()]);
        if (xBreakpointHandlerArray == null) {
            AndroidJavaAwareNativeDebugProcess.$$$reportNull$$$0(9);
        }
        return xBreakpointHandlerArray;
    }

    public void startPausing() {
        this.startNonStepInAction();
        super.startPausing();
    }

    public void startStepInto(XSuspendContext context) {
        this.myLastActionStepIn = true;
        this.executeConsoleCommand("step -a false");
    }

    public void startForceStepInto(@Nullable XSuspendContext context) {
        this.startStepInto(context);
    }

    public void startStepOver(@Nullable XSuspendContext context) {
        this.startNonStepInAction();
        super.startStepOver(context);
    }

    public void startStepOut(@Nullable XSuspendContext context) {
        this.startNonStepInAction();
        super.startStepOut(context);
    }

    public void runToPosition(@NotNull XSourcePosition position, @Nullable XSuspendContext context) {
        if (position == null) {
            AndroidJavaAwareNativeDebugProcess.$$$reportNull$$$0(10);
        }
        this.startNonStepInAction();
        super.runToPosition(position, context);
    }

    public void resume(@Nullable XSuspendContext context) {
        this.startNonStepInAction();
        super.resume(context);
    }

    @Override
    public void handleInterrupted(@NotNull DebuggerDriver.StopPlace stopPlace) {
        if (stopPlace == null) {
            AndroidJavaAwareNativeDebugProcess.$$$reportNull$$$0(11);
        }
        if (!this.myLastActionStepIn || !this.handleStepIn(stopPlace.thread.getId())) {
            super.handleInterrupted(stopPlace);
        }
    }

    private void startNonStepInAction() {
        this.myLastActionStepIn = false;
        this.removeAllStepIntoNativeBreakpoints();
    }

    private boolean handleStepIn(final long tid) {
        assert (!AndroidJavaAwareNativeDebugProcess.getApp().isDispatchThread());
        final FutureResult framesFuture = new FutureResult();
        this.postCommand(new CidrDebugProcess.DebuggerCommand(){

            public void run(@NotNull DebuggerDriver driver) {
                if (driver == null) {
                    1.$$$reportNull$$$0(0);
                }
                try {
                    framesFuture.set((Object)driver.getFrames((long)tid, (int)0, (int)2).list);
                }
                catch (Throwable t) {
                    framesFuture.setException(t);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "driver", "com/android/tools/ndk/run/javaawarecpp/AndroidJavaAwareNativeDebugProcess$1", "run"));
            }
        });
        List frames = null;
        try {
            frames = (List)framesFuture.get();
        }
        catch (InterruptedException | ExecutionException e) {
            LOG.warn(e.getMessage());
        }
        if (frames == null) {
            return false;
        }
        if (frames.size() < 2) {
            return false;
        }
        LLFrame frame = (LLFrame)frames.get(0);
        LLFrame callerFrame = (LLFrame)frames.get(1);
        if (callerFrame.getFile() == null || !callerFrame.getFile().endsWith(".java")) {
            return false;
        }
        HashSet methods = Sets.newHashSet();
        if (!this.getPossiblyCalledMethods(callerFrame, methods)) {
            return false;
        }
        if (ART_INTERNAL_FUNCTIONS.contains(frame.getFunction()) || methods.contains(frame.getFunction())) {
            if (this.setStepInBreakpointsAndResume(methods, tid)) {
                return true;
            }
            return this.checkedStepOut();
        }
        if (frame.getFile() == null || frame.getFile().isEmpty()) {
            return this.checkedStepOut();
        }
        return false;
    }

    private boolean getPossiblyCalledMethods(@NotNull LLFrame frame, @NotNull Set<String> methodNames) {
        if (frame == null) {
            AndroidJavaAwareNativeDebugProcess.$$$reportNull$$$0(12);
        }
        if (methodNames == null) {
            AndroidJavaAwareNativeDebugProcess.$$$reportNull$$$0(13);
        }
        if (frame.getFile() == null) {
            return false;
        }
        VirtualFile vFile = LocalFileSystem.getInstance().findFileByPath(frame.getFile());
        XSourcePosition pos = XDebuggerUtil.getInstance().createPosition(vFile, frame.getLine());
        if (pos == null) {
            return false;
        }
        LinkedList methods = Lists.newLinkedList();
        AndroidJavaAwareNativeDebugProcess.getApp().runReadAction(() -> {
            MethodCollector collector = new MethodCollector(this.getProject(), pos);
            methods.addAll(collector.getMethods());
        });
        if (methods.isEmpty()) {
            return false;
        }
        for (PsiMethod method : methods) {
            methodNames.add(method.getName());
        }
        return true;
    }

    private boolean setStepInBreakpointsAndResume(@NotNull Set<String> methodNames, long tid) {
        if (methodNames == null) {
            AndroidJavaAwareNativeDebugProcess.$$$reportNull$$$0(14);
        }
        for (String method : methodNames) {
            this.registerStepIntoNativeBreakpoint(method, tid);
        }
        final FutureResult retFuture = new FutureResult();
        this.postCommand(new CidrDebugProcess.DebuggerCommand(){

            public void run(@NotNull DebuggerDriver driver) {
                if (driver == null) {
                    2.$$$reportNull$$$0(0);
                }
                try {
                    retFuture.set((Object)driver.resume());
                }
                catch (Throwable t) {
                    retFuture.setException(t);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "driver", "com/android/tools/ndk/run/javaawarecpp/AndroidJavaAwareNativeDebugProcess$2", "run"));
            }
        });
        try {
            return (Boolean)retFuture.get();
        }
        catch (InterruptedException | ExecutionException e) {
            LOG.warn(e.getMessage());
            return false;
        }
    }

    private boolean checkedStepOut() {
        final FutureResult res = new FutureResult();
        this.postCommand(new CidrDebugProcess.DebuggerCommand(){

            public void run(@NotNull DebuggerDriver driver) {
                if (driver == null) {
                    3.$$$reportNull$$$0(0);
                }
                try {
                    driver.stepOut();
                    res.set((Object)true);
                }
                catch (Throwable t) {
                    res.setException(t);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "driver", "com/android/tools/ndk/run/javaawarecpp/AndroidJavaAwareNativeDebugProcess$3", "run"));
            }
        });
        try {
            return (Boolean)res.get();
        }
        catch (InterruptedException | ExecutionException e) {
            LOG.warn(e.getMessage());
            return false;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sessionId";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consoleBuilder";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "printer";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sessionStarter";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "client";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressReporter";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/ndk/run/javaawarecpp/AndroidJavaAwareNativeDebugProcess";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stopPlace";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frame";
                break;
            }
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/ndk/run/javaawarecpp/AndroidJavaAwareNativeDebugProcess";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getJavaBreakpointTypes";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getBreakpointHandlers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 8: 
            case 9: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "runToPosition";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "handleInterrupted";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getPossiblyCalledMethods";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "setStepInBreakpointsAndResume";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

