/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.run.jdwp;

import com.android.tools.ndk.run.jdwp.CodeInjection;
import com.intellij.execution.ExecutionException;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.concurrency.FutureResult;
import com.intellij.util.concurrency.Semaphore;
import org.jetbrains.annotations.NotNull;

class CodeInjectionImpl
implements CodeInjection {
    private final String myCodeFragment;
    private final FutureResult<Void> myResultFuture;
    private final Semaphore myResumeSemaphore;

    public FutureResult<Void> getResultFuture() {
        return this.myResultFuture;
    }

    CodeInjectionImpl(@NotNull String codeFragment) {
        if (codeFragment == null) {
            CodeInjectionImpl.$$$reportNull$$$0(0);
        }
        this.myResultFuture = new FutureResult();
        this.myResumeSemaphore = new Semaphore();
        this.myResumeSemaphore.down();
        this.myCodeFragment = codeFragment;
    }

    @NotNull
    String getCodeFragment() {
        String string = this.myCodeFragment;
        if (string == null) {
            CodeInjectionImpl.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public void waitForInjection() throws ExecutionException {
        try {
            this.myResultFuture.get();
        }
        catch (Exception e) {
            ProcessCanceledException canceledException = (ProcessCanceledException)ExceptionUtil.findCause((Throwable)e, ProcessCanceledException.class);
            if (canceledException != null) {
                throw canceledException;
            }
            throw new ExecutionException("Code injection has failed", (Throwable)e);
        }
    }

    @Override
    public void resume() {
        this.myResumeSemaphore.up();
    }

    @Override
    public void cancel() {
        this.myResultFuture.setException((Throwable)new ProcessCanceledException());
    }

    public void waitForResume() {
        this.myResumeSemaphore.waitFor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "codeFragment";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/ndk/run/jdwp/CodeInjectionImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/ndk/run/jdwp/CodeInjectionImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getCodeFragment";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

