/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.run.lldb;

import com.android.tools.ndk.run.AndroidNativeAppDebugProcess;
import com.android.tools.ndk.run.lldb.AndroidDisasmView;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.impl.FileDocumentManagerImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.xdebugger.breakpoints.XBreakpointProperties;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.intellij.xdebugger.breakpoints.XLineBreakpointType;
import com.jetbrains.cidr.execution.debugger.disasm.CidrDisasmRegion;
import com.jetbrains.cidr.execution.debugger.memory.Address;
import com.jetbrains.cidr.execution.debugger.memory.AddressSpace;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddressBreakpointType
extends XLineBreakpointType<Properties> {
    private static final Logger LOG = Logger.getInstance(AddressBreakpointType.class);
    public static final String TYPE_ID = "com.android.tools.ndk.run.lldb.AddressBreakpointType";

    public AddressBreakpointType() {
        super(TYPE_ID, "Address breakpoints");
    }

    public boolean canPutAt(@NotNull VirtualFile file, int line, @NotNull Project project) {
        Document doc;
        if (file == null) {
            AddressBreakpointType.$$$reportNull$$$0(0);
        }
        if (project == null) {
            AddressBreakpointType.$$$reportNull$$$0(1);
        }
        if ((doc = (Document)file.getUserData(FileDocumentManagerImpl.HARD_REF_TO_DOCUMENT_KEY)) == null) {
            return false;
        }
        AddressSpace addressSpace = (AddressSpace)doc.getUserData(AndroidDisasmView.ADDRESS_SPACE_KEY);
        if (addressSpace == null) {
            return false;
        }
        String lineContent = doc.getText(new TextRange(doc.getLineStartOffset(line), doc.getLineEndOffset(line)));
        int exclamationIndex = lineContent.lastIndexOf(33);
        if (exclamationIndex == -1) {
            return false;
        }
        String addressString = lineContent.substring(exclamationIndex + 2);
        if (!addressString.startsWith("0x")) {
            return false;
        }
        try {
            Address expectedAddress = Address.parseHexString((String)addressString);
            if (((CidrDisasmRegion)addressSpace.get(expectedAddress)).getLineNumberInDocument(expectedAddress) != line) {
                LOG.warn("Suspicious invalid line for address breakpoint : '" + lineContent + "' with expected address " + expectedAddress);
                return false;
            }
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    @Nullable
    public Properties createBreakpointProperties(@NotNull VirtualFile file, int line) {
        Document doc;
        if (file == null) {
            AddressBreakpointType.$$$reportNull$$$0(2);
        }
        if ((doc = (Document)file.getUserData(FileDocumentManagerImpl.HARD_REF_TO_DOCUMENT_KEY)) == null) {
            throw new IllegalStateException("Unexpected null document");
        }
        String lineContent = doc.getText(new TextRange(doc.getLineStartOffset(line), doc.getLineEndOffset(line)));
        String addressString = lineContent.substring(lineContent.lastIndexOf(33) + 2);
        return new Properties(Address.parseHexString((String)addressString));
    }

    public String getDisplayText(XLineBreakpoint<Properties> breakpoint) {
        Properties props = (Properties)breakpoint.getProperties();
        if (props == null) {
            return null;
        }
        return ((Properties)breakpoint.getProperties()).getAddress().toString();
    }

    public String getShortText(XLineBreakpoint<Properties> breakpoint) {
        return this.getDisplayText(breakpoint);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/ndk/run/lldb/AddressBreakpointType";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "canPutAt";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "createBreakpointProperties";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class Properties
    extends XBreakpointProperties<Properties> {
        private long myAddress;
        private AndroidNativeAppDebugProcess myProcess;

        Properties() {
        }

        Properties(@NotNull Address address) {
            if (address == null) {
                Properties.$$$reportNull$$$0(0);
            }
            this.myAddress = address.getUnsignedLongValue();
        }

        public Address getAddress() {
            return Address.fromUnsignedLong((long)this.myAddress);
        }

        public AndroidNativeAppDebugProcess getProcess() {
            return this.myProcess;
        }

        public void setProcess(AndroidNativeAppDebugProcess process) {
            this.myProcess = process;
        }

        @Nullable
        public Properties getState() {
            return new Properties();
        }

        public void loadState(@NotNull Properties state) {
            if (state == null) {
                Properties.$$$reportNull$$$0(1);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "address";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "state";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/ndk/run/lldb/AddressBreakpointType$Properties";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "loadState";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

