/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.run.lldb;

import com.android.tools.ndk.run.lldb.LocatableLightVfs;
import com.intellij.execution.ExecutionException;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.command.undo.UndoConstants;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileEditor.impl.EditorHistoryManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.ui.GuiUtils;
import com.intellij.util.DocumentUtil;
import com.intellij.xdebugger.XDebugSessionListener;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.impl.XSourcePositionImpl;
import com.jetbrains.cidr.execution.CidrDebuggerBundle;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerLog;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerCommandException;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.disasm.CidrDisasmRegion;
import com.jetbrains.cidr.execution.debugger.memory.Address;
import com.jetbrains.cidr.execution.debugger.memory.AddressRange;
import com.jetbrains.cidr.execution.debugger.memory.AddressSpace;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class AndroidDisasmView
implements AddressSpace.Listener<CidrDisasmRegion> {
    public static final Key<AddressSpace<CidrDisasmRegion>> ADDRESS_SPACE_KEY = Key.create((String)"android.ndk.debugger.disasm.address_space");
    @NotNull
    private final CidrDebugProcess myProcess;
    @NotNull
    private final LocatableLightVfs.LocatableLightVirtualFile myVirtualFile;
    @NotNull
    private final Document myDocument;
    @NotNull
    private final AddressSpace<CidrDisasmRegion> myAddressSpace;

    public static AndroidDisasmView create(@NotNull CidrDebugProcess process) {
        LocatableLightVfs.LocatableLightVirtualFile virtualFile;
        if (process == null) {
            AndroidDisasmView.$$$reportNull$$$0(0);
        }
        if ((virtualFile = LocatableLightVfs.create(CidrDebuggerBundle.message((String)"debug.disasm.view.name", (Object[])new Object[]{process.getSession().getSessionName()}))) == null) {
            return null;
        }
        return new AndroidDisasmView(process, virtualFile);
    }

    private AndroidDisasmView(@NotNull CidrDebugProcess process, @NotNull LocatableLightVfs.LocatableLightVirtualFile virtualFile) {
        if (process == null) {
            AndroidDisasmView.$$$reportNull$$$0(1);
        }
        if (virtualFile == null) {
            AndroidDisasmView.$$$reportNull$$$0(2);
        }
        this.myProcess = process;
        this.myVirtualFile = virtualFile;
        this.myVirtualFile.setWritable(false);
        this.myVirtualFile.putUserData(Iconable.ICON_FLAG_IGNORE_MASK, 2);
        this.myDocument = (Document)ReadAction.compute(() -> {
            Document document = FileDocumentManager.getInstance().getDocument((VirtualFile)this.myVirtualFile);
            CidrDebuggerLog.LOG.assertTrue(document != null, (Object)"null Document returned for newly created LightVirtualFile");
            return document;
        });
        this.myDocument.putUserData(UndoConstants.DONT_RECORD_UNDO, (Object)Boolean.TRUE);
        this.myProcess.getSession().addSessionListener(new XDebugSessionListener(){

            public void sessionStopped() {
                GuiUtils.invokeLaterIfNeeded(() -> {
                    Project project = AndroidDisasmView.this.myProcess.getProject();
                    if (!project.isDisposed()) {
                        FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)project);
                        fileEditorManager.closeFile((VirtualFile)AndroidDisasmView.this.myVirtualFile);
                        AndroidDisasmView.this.myVirtualFile.delete(this);
                        EditorHistoryManager.getInstance((Project)AndroidDisasmView.this.myProcess.getProject()).removeFile((VirtualFile)AndroidDisasmView.this.myVirtualFile);
                    }
                }, (ModalityState)ModalityState.defaultModalityState());
            }
        });
        this.myAddressSpace = new AddressSpace(CidrDisasmRegion::new);
        this.myAddressSpace.addListener((AddressSpace.Listener)this);
        this.myDocument.putUserData(ADDRESS_SPACE_KEY, this.myAddressSpace);
        this.postWriteAction(() -> ((CidrDisasmRegion)this.myAddressSpace.get(Address.NULL)).addToDocument(this.myDocument, 0));
    }

    private void requestDisassemblingForMissingRanges(@NotNull Address address) {
        if (address == null) {
            AndroidDisasmView.$$$reportNull$$$0(3);
        }
        this.postWriteAction(() -> {
            if (address == null) {
                AndroidDisasmView.$$$reportNull$$$0(12);
            }
            List ranges = this.myAddressSpace.preallocate(address);
            for (final AddressRange range : ranges) {
                this.myProcess.postCommand(new CidrDebugProcess.DebuggerCommand(){

                    public void run(@NotNull DebuggerDriver driver) throws ExecutionException {
                        if (driver == null) {
                            2.$$$reportNull$$$0(0);
                        }
                        try {
                            List result = driver.disassemble(range);
                            CidrDisasmRegion region = new CidrDisasmRegion(range, result);
                            AndroidDisasmView.this.postWriteAction(() -> AndroidDisasmView.this.myAddressSpace.save((AddressSpace.Region)region));
                        }
                        catch (DebuggerCommandException e) {
                            CidrDebuggerLog.LOG.warn((Throwable)e);
                            AndroidDisasmView.this.postWriteAction(() -> AndroidDisasmView.this.myAddressSpace.unallocate(range));
                        }
                    }

                    public void rejected(@NotNull String reason) {
                        if (reason == null) {
                            2.$$$reportNull$$$0(1);
                        }
                        CidrDebuggerLog.LOG.warn(reason);
                        AndroidDisasmView.this.postWriteAction(() -> AndroidDisasmView.this.myAddressSpace.unallocate(range));
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2;
                        Object[] objectArray3 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "driver";
                                break;
                            }
                            case 1: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "reason";
                                break;
                            }
                        }
                        objectArray2[1] = "com/android/tools/ndk/run/lldb/AndroidDisasmView$2";
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[2] = "run";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[2] = "rejected";
                                break;
                            }
                        }
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                });
            }
        });
    }

    public XSourcePosition disassemble(final @NotNull Address address) {
        if (address == null) {
            AndroidDisasmView.$$$reportNull$$$0(4);
        }
        return new XSourcePosition(){
            private boolean myRequested;

            private void requestDisassemblingIfNeeded() {
                if (!this.myRequested) {
                    AndroidDisasmView.this.requestDisassemblingForMissingRanges(address);
                    this.myRequested = true;
                }
            }

            public int getLine() {
                this.requestDisassemblingIfNeeded();
                return (Integer)ReadAction.compute(() -> {
                    if (address == null) {
                        3.$$$reportNull$$$0(4);
                    }
                    return ((CidrDisasmRegion)AndroidDisasmView.this.myAddressSpace.get(address)).getLineNumberInDocument(address);
                });
            }

            public int getOffset() {
                this.requestDisassemblingIfNeeded();
                return (Integer)ReadAction.compute(() -> {
                    if (address == null) {
                        3.$$$reportNull$$$0(3);
                    }
                    return ((CidrDisasmRegion)AndroidDisasmView.this.myAddressSpace.get(address)).getOffsetInDocument(address);
                });
            }

            @NotNull
            public VirtualFile getFile() {
                LocatableLightVfs.LocatableLightVirtualFile locatableLightVirtualFile = AndroidDisasmView.this.myVirtualFile;
                if (locatableLightVirtualFile == null) {
                    3.$$$reportNull$$$0(0);
                }
                return locatableLightVirtualFile;
            }

            @NotNull
            public Navigatable createNavigatable(@NotNull Project project) {
                if (project == null) {
                    3.$$$reportNull$$$0(1);
                }
                OpenFileDescriptor openFileDescriptor = XSourcePositionImpl.doCreateOpenFileDescriptor((Project)project, (XSourcePosition)this);
                if (openFileDescriptor == null) {
                    3.$$$reportNull$$$0(2);
                }
                return openFileDescriptor;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                    case 1: 
                    case 3: 
                    case 4: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 1: 
                    case 3: 
                    case 4: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/android/tools/ndk/run/lldb/AndroidDisasmView$3";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                    case 3: 
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "address";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getFile";
                        break;
                    }
                    case 1: 
                    case 3: 
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/android/tools/ndk/run/lldb/AndroidDisasmView$3";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createNavigatable";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "createNavigatable";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "lambda$getOffset$1";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray;
                        objectArray[2] = "lambda$getLine$0";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                    case 1: 
                    case 3: 
                    case 4: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    public void regionSplit(@NotNull CidrDisasmRegion oldRegion, @NotNull List<? extends CidrDisasmRegion> newRegions) {
        if (oldRegion == null) {
            AndroidDisasmView.$$$reportNull$$$0(5);
        }
        if (newRegions == null) {
            AndroidDisasmView.$$$reportNull$$$0(6);
        }
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        oldRegion.replaceWith(newRegions);
    }

    @NotNull
    private Runnable withDocumentWritable(@NotNull Runnable action) {
        if (action == null) {
            AndroidDisasmView.$$$reportNull$$$0(7);
        }
        Runnable runnable = () -> {
            if (action == null) {
                AndroidDisasmView.$$$reportNull$$$0(11);
            }
            boolean wasWritable = this.myDocument.isWritable();
            this.myDocument.setReadOnly(false);
            try {
                action.run();
                this.myDocument.setReadOnly(!wasWritable);
            }
            catch (Throwable throwable) {
                this.myDocument.setReadOnly(!wasWritable);
                throw throwable;
            }
        };
        if (runnable == null) {
            AndroidDisasmView.$$$reportNull$$$0(8);
        }
        return runnable;
    }

    private void postWriteAction(@NotNull Runnable action) {
        if (action == null) {
            AndroidDisasmView.$$$reportNull$$$0(9);
        }
        GuiUtils.invokeLaterIfNeeded(() -> {
            if (action == null) {
                AndroidDisasmView.$$$reportNull$$$0(10);
            }
            DocumentUtil.writeInRunUndoTransparentAction((Runnable)this.withDocumentWritable(action));
        }, (ModalityState)ModalityState.defaultModalityState());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "process";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 3: 
            case 4: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "address";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldRegion";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newRegions";
                break;
            }
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/ndk/run/lldb/AndroidDisasmView";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/ndk/run/lldb/AndroidDisasmView";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "withDocumentWritable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "requestDisassemblingForMissingRanges";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "disassemble";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "regionSplit";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "withDocumentWritable";
                break;
            }
            case 8: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "postWriteAction";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "lambda$postWriteAction$4";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "lambda$withDocumentWritable$3";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "lambda$requestDisassemblingForMissingRanges$2";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

