/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.run.lldb;

import com.android.ddmlib.IDevice;
import com.android.sdklib.devices.Abi;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.run.ConsolePrinter;
import com.android.tools.ndk.DeviceHelper;
import com.android.tools.ndk.ModulePathManager;
import com.android.tools.ndk.run.AndroidNativeAppDebugProcess;
import com.android.tools.ndk.run.crash.AndroidLLDBBreakpadIntegration;
import com.android.tools.ndk.run.editor.NativeAndroidDebuggerState;
import com.android.tools.ndk.run.lldb.AndroidLLDBDriverConfiguration;
import com.android.tools.ndk.run.lldb.LLDBUsageTracker;
import com.android.tools.ndk.run.lldb.SessionStarter;
import com.android.tools.ndk.run.lldb.renderers.formatters.libstdcpp.LibStdCppTypeNameFormatters;
import com.google.common.base.Stopwatch;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.protobuf.GeneratedMessage;
import com.google.wireless.android.sdk.stats.LldbPercentileEstimator;
import com.intellij.execution.ExecutionException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Consumer;
import com.intellij.util.ThrowableRunnable;
import com.jetbrains.cidr.execution.Installer;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerCommandException;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.LLBreakpoint;
import com.jetbrains.cidr.execution.debugger.backend.LLDBDriverConfiguration;
import com.jetbrains.cidr.execution.debugger.backend.LLFrame;
import com.jetbrains.cidr.execution.debugger.backend.LLInstruction;
import com.jetbrains.cidr.execution.debugger.backend.LLSymbolicBreakpoint;
import com.jetbrains.cidr.execution.debugger.backend.LLValue;
import com.jetbrains.cidr.execution.debugger.backend.LLWatchpoint;
import com.jetbrains.cidr.execution.debugger.backend.lldb.LLDBDriver;
import com.jetbrains.cidr.execution.debugger.backend.lldb.LLDBDriverException;
import com.jetbrains.cidr.execution.debugger.backend.lldb.ProtobufMessageFactory;
import com.jetbrains.cidr.execution.debugger.backend.lldb.auto_generated.Protocol;
import com.jetbrains.cidr.execution.debugger.memory.Address;
import com.jetbrains.cidr.execution.debugger.memory.AddressRange;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidLLDBDriver
extends LLDBDriver {
    private static final String PLATFORM_NAME = "remote-android";
    private static final String ENV_VAR_PREFIX = "ANDROIDSTUDIO_LLDB_EXTRA_CMD_";
    private static final String[] STARTUP_SCRIPTS = new String[]{ModulePathManager.getRepoLLDBStlPrintersBinFile("load_script").getPath()};
    private static final int CONNECT_PLATFORM_NUM_ATTEMPTS = 10;
    private static final int CONNECT_PLATFORM_TIMEOUT_MSECS = 500;
    private final Collection<File> mySymDirs;
    private final SessionStarter mySessionStarter;
    private String myPlatformConnectURL;
    @NotNull
    private final List<String> myStartupCommands;
    @NotNull
    private final List<String> myPostAttachCommands;
    private boolean myCrashed;
    private final boolean myDeviceSupportsWatchpoints;
    private static final Set<String> WATCHPOINT_WHITELISTED_MODELS = Sets.newHashSet((Object[])new String[]{"Nexus 9"});
    private static final Set<Abi> WATCHPOINT_WHITELISTED_ABIS = ImmutableSet.of((Object)Abi.X86, (Object)Abi.X86_64);
    private boolean myReportedWatchpointsUsage;
    private Stopwatch attachStopwatch;
    private static final Logger LOG = Logger.getInstance(AndroidLLDBDriver.class);

    public AndroidLLDBDriver(@NotNull DebuggerDriver.Handler handler, @NotNull AndroidFacet facet, @NotNull NativeAndroidDebuggerState debuggerState, @NotNull AndroidLLDBDriverConfiguration configuration, @NotNull ConsolePrinter printer) throws ExecutionException {
        if (handler == null) {
            AndroidLLDBDriver.$$$reportNull$$$0(0);
        }
        if (facet == null) {
            AndroidLLDBDriver.$$$reportNull$$$0(1);
        }
        if (debuggerState == null) {
            AndroidLLDBDriver.$$$reportNull$$$0(2);
        }
        if (configuration == null) {
            AndroidLLDBDriver.$$$reportNull$$$0(3);
        }
        if (printer == null) {
            AndroidLLDBDriver.$$$reportNull$$$0(4);
        }
        super(handler, (LLDBDriverConfiguration)configuration);
        this.myCrashed = false;
        this.myReportedWatchpointsUsage = false;
        this.attachStopwatch = Stopwatch.createStarted();
        AndroidLLDBBreakpadIntegration.monitorForCrashes(this);
        IDevice device = configuration.getDevice();
        this.mySessionStarter = configuration.getSessionStarter();
        this.myStartupCommands = configuration.getStartupCommands();
        this.myPostAttachCommands = configuration.getPostAttachCommands();
        this.mySymDirs = AndroidNativeAppDebugProcess.getSymbolsDir(facet, debuggerState, configuration.getClientABIs());
        if (this.mySymDirs.isEmpty()) {
            LOG.warn("No symbol directories found");
            printer.stderr("Attention! No symbol directories found - please check your native debug configuration");
        }
        this.myDeviceSupportsWatchpoints = AndroidLLDBDriver.deviceSupportsWatchpoints(device);
    }

    private static boolean deviceSupportsWatchpoints(@NotNull IDevice device) {
        String model;
        if (device == null) {
            AndroidLLDBDriver.$$$reportNull$$$0(5);
        }
        if (WATCHPOINT_WHITELISTED_MODELS.contains(model = device.getProperty("ro.product.model"))) {
            return true;
        }
        for (String abiStr : device.getAbis()) {
            Abi abi = Abi.getEnum((String)abiStr);
            if (abi == null || !WATCHPOINT_WHITELISTED_ABIS.contains(abi)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    private static String getWatchpointWhitelist() {
        String string = String.format("%s based devices/emulators, %s", WATCHPOINT_WHITELISTED_ABIS, WATCHPOINT_WHITELISTED_MODELS);
        if (string == null) {
            AndroidLLDBDriver.$$$reportNull$$$0(6);
        }
        return string;
    }

    public void commonLoad() throws ExecutionException {
        LOG.info("Loading driver");
        LOG.debug("Load startup scripts");
        this.executeConsoleCommand("settings set target.process.thread.step-out-avoid-nodebug false");
        this.loadStartupScripts();
        this.loadJObjectPrettyPrinterScripts();
        LOG.debug("run console commands from environment");
        this.runEnvCommands();
        this.runStartupCommands();
        LOG.debug("connectPlatform");
        int attempts = 0;
        while (true) {
            ++attempts;
            try {
                this.connectPlatform();
                break;
            }
            catch (LLDBDriverException e) {
                if (attempts >= 10) {
                    LOG.warn("Giving up making LLDB connection after 10 attempts");
                    throw e;
                }
                LOG.warn("Failed to connect platform (attempt " + attempts + " of " + 10 + ") - retrying.  Error was: " + e.getMessage());
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e2) {
                    Thread.currentThread().interrupt();
                    throw new ExecutionException("Interrupted");
                }
            }
        }
    }

    private void setSymbols() throws ExecutionException {
        if (!this.mySymDirs.isEmpty()) {
            ArrayList searchPaths = Lists.newArrayListWithExpectedSize((int)this.mySymDirs.size());
            for (File symDir : this.mySymDirs) {
                searchPaths.add("\"" + symDir.getAbsolutePath() + "\"");
            }
            String searchPathsStr = StringUtil.join((Collection)searchPaths, (String)" ");
            LOG.info("Append target.exec-search-paths: " + searchPathsStr);
            this.executeConsoleCommand("settings append target.exec-search-paths " + searchPathsStr);
        }
    }

    protected void sendCreateTargetRequest(@NotNull Protocol.CompositeRequest createTargetRequest) throws ExecutionException {
        if (createTargetRequest == null) {
            AndroidLLDBDriver.$$$reportNull$$$0(7);
        }
        if (!createTargetRequest.getCreateTarget().getExePath().isEmpty()) {
            throw new IllegalStateException("Creating a target based on an executable path is not supported on Android");
        }
        super.sendCreateTargetRequest(createTargetRequest);
    }

    @NotNull
    public DebuggerDriver.Inferior loadForLaunch(@NotNull Installer installer, @Nullable String architectureId) throws ExecutionException {
        if (installer == null) {
            AndroidLLDBDriver.$$$reportNull$$$0(8);
        }
        throw new IllegalStateException("loadForLaunch is not supported on Android");
    }

    @NotNull
    public DebuggerDriver.Inferior loadForAttach(int pid, final @NotNull ThrowableRunnable<ExecutionException> preAttach, final @NotNull ThrowableRunnable<ExecutionException> postAttach) throws ExecutionException {
        if (preAttach == null) {
            AndroidLLDBDriver.$$$reportNull$$$0(9);
        }
        if (postAttach == null) {
            AndroidLLDBDriver.$$$reportNull$$$0(10);
        }
        this.commonLoad();
        final DebuggerDriver.Inferior delegate = super.loadForAttach(pid);
        this.setSymbols();
        DebuggerDriver.Inferior inferior = new DebuggerDriver.Inferior(0){

            protected long startImpl() throws ExecutionException {
                preAttach.run();
                long ret = delegate.start();
                AndroidLLDBDriver.this.runPostAttachCommands();
                postAttach.run();
                return ret;
            }

            protected void detachImpl() throws ExecutionException {
                delegate.detach();
            }

            protected boolean destroyImpl() throws ExecutionException {
                return delegate.destroy();
            }
        };
        if (inferior == null) {
            AndroidLLDBDriver.$$$reportNull$$$0(11);
        }
        return inferior;
    }

    public void setValuesFilteringEnabled(boolean enabled) throws ExecutionException {
        super.setValuesFilteringEnabled(true);
    }

    private void runCommands(@NotNull String name, @NotNull List<String> commands) throws ExecutionException {
        if (name == null) {
            AndroidLLDBDriver.$$$reportNull$$$0(12);
        }
        if (commands == null) {
            AndroidLLDBDriver.$$$reportNull$$$0(13);
        }
        for (String cmd : commands) {
            String trimmed_cmd = cmd.trim();
            if (trimmed_cmd.isEmpty()) continue;
            LOG.info(String.format("%s command: \"%s\"", name, trimmed_cmd));
            this.executeConsoleCommand(trimmed_cmd);
        }
    }

    private void runStartupCommands() throws ExecutionException {
        this.runCommands("Startup", this.myStartupCommands);
    }

    private void runPostAttachCommands() throws ExecutionException {
        this.runCommands("Post attach", this.myPostAttachCommands);
    }

    public boolean supportsWatchpoints() {
        return true;
    }

    private void runEnvCommands() throws ExecutionException {
        String envCommand;
        int i = 0;
        while ((envCommand = System.getenv(ENV_VAR_PREFIX + i)) != null) {
            LOG.info("Environment command: " + envCommand);
            this.executeConsoleCommand(envCommand);
            ++i;
        }
    }

    private void loadStartupScripts() throws ExecutionException {
        for (String script : STARTUP_SCRIPTS) {
            LOG.info("Loading startup script: " + script);
            this.executeConsoleCommand("command source \"" + script + "\"");
        }
    }

    private void loadJObjectPrettyPrinterScripts() throws ExecutionException {
        int deviceApiLevel = this.mySessionStarter.getDevice().getVersion().getApiLevel();
        String isDalvik = DeviceHelper.RuntimeVersion.DALVIK.equals((Object)DeviceHelper.getRuntime(this.mySessionStarter.getDevice())) ? "True" : "False";
        File scriptPath = new File(ModulePathManager.getRepoLLDBPrettyPrinterScriptsFolder(), "jstring_reader.py");
        LOG.info("Loading startup script: " + scriptPath);
        this.executeConsoleCommand("command script import \"" + scriptPath + "\"");
        this.executeConsoleCommand(String.format("script jstring_reader.register(%d, %s)", deviceApiLevel, isDalvik));
    }

    private void connectPlatform() throws ExecutionException {
        if (this.myPlatformConnectURL == null) {
            this.myPlatformConnectURL = this.mySessionStarter.startServer();
        }
        LOG.info("Connecting to LLDB server: " + this.myPlatformConnectURL);
        LLDBDriver.ThrowIfNotValid responseHandler = new LLDBDriver.ThrowIfNotValid("Couldn't connect platform");
        Protocol.CompositeRequest connectPlatformReq = ProtobufMessageFactory.connectPlatform((String)PLATFORM_NAME, (String)this.myPlatformConnectURL);
        this.getProtobufClient().sendMessageAndWaitForReply((GeneratedMessage)connectPlatformReq, Protocol.ConnectPlatform_Res.class, (Consumer)responseHandler);
        responseHandler.throwIfNeeded();
    }

    public boolean isCrashed() {
        return this.myCrashed;
    }

    public void setCrashed() {
        this.myCrashed = true;
    }

    @NotNull
    public LLWatchpoint addWatchpoint(long threadId, int frameNumber, LLValue value, String expr, LLWatchpoint.Lifetime lifetime, LLWatchpoint.AccessType accessType) throws ExecutionException, DebuggerCommandException {
        if (!this.myDeviceSupportsWatchpoints) {
            throw new DebuggerCommandException("You are debugging on a device that is not known to support watchpoints - supported devices include " + AndroidLLDBDriver.getWatchpointWhitelist());
        }
        if (!this.myReportedWatchpointsUsage) {
            this.myReportedWatchpointsUsage = true;
            LLDBUsageTracker.sessionUsedWatchpoints();
        }
        LLWatchpoint lLWatchpoint = super.addWatchpoint(threadId, frameNumber, value, expr, lifetime, accessType);
        if (lLWatchpoint == null) {
            AndroidLLDBDriver.$$$reportNull$$$0(14);
        }
        return lLWatchpoint;
    }

    protected void handleExited(int code) {
        super.handleExited(code);
        LLDBUsageTracker.frontendExited(code);
    }

    protected void handleAttached(int pid) {
        if (this.attachStopwatch.isRunning()) {
            this.attachStopwatch.stop();
            LLDBUsageTracker.storeLldbActionTime(LldbPercentileEstimator.Metric.ATTACH_TIME_MICROS, this.attachStopwatch.elapsed(TimeUnit.MICROSECONDS));
        }
        super.handleAttached(pid);
    }

    @NotNull
    public List<LLBreakpoint> addBreakpoint(String path, int line, @Nullable String condition) throws ExecutionException {
        Stopwatch s = Stopwatch.createStarted();
        List ret = super.addBreakpoint(path, line, condition);
        LLDBUsageTracker.storeLldbActionTime(LldbPercentileEstimator.Metric.ADD_BREAKPOINT_TIME_MICROS, s.elapsed(TimeUnit.MICROSECONDS));
        List list = ret;
        if (list == null) {
            AndroidLLDBDriver.$$$reportNull$$$0(15);
        }
        return list;
    }

    @Nullable
    public LLSymbolicBreakpoint addSymbolicBreakpoint(@NotNull DebuggerDriver.SymbolicBreakpoint symBreakpoint) throws ExecutionException, DebuggerCommandException {
        if (symBreakpoint == null) {
            AndroidLLDBDriver.$$$reportNull$$$0(16);
        }
        Stopwatch s = Stopwatch.createStarted();
        LLSymbolicBreakpoint ret = super.addSymbolicBreakpoint(symBreakpoint);
        LLDBUsageTracker.storeLldbActionTime(LldbPercentileEstimator.Metric.ADD_SYMBOLIC_BREAKPOINT_TIME_MICROS, s.elapsed(TimeUnit.MICROSECONDS));
        return ret;
    }

    @NotNull
    public DebuggerDriver.ResultList<LLFrame> getFrames(long threadId, int from, int count, boolean untilFirstLineWithCode) throws ExecutionException, DebuggerCommandException {
        Stopwatch s = Stopwatch.createStarted();
        DebuggerDriver.ResultList ret = super.getFrames(threadId, from, count, untilFirstLineWithCode);
        LLDBUsageTracker.storeLldbActionTime(LldbPercentileEstimator.Metric.GET_FRAMES_TIME_MICROS, s.elapsed(TimeUnit.MICROSECONDS));
        DebuggerDriver.ResultList resultList = ret;
        if (resultList == null) {
            AndroidLLDBDriver.$$$reportNull$$$0(17);
        }
        return resultList;
    }

    @NotNull
    public List<LLValue> getVariables(long threadId, int frameIndex) throws ExecutionException {
        Stopwatch s = Stopwatch.createStarted();
        List ret = super.getVariables(threadId, frameIndex);
        LLDBUsageTracker.storeLldbActionTime(LldbPercentileEstimator.Metric.GET_VARIABLES_TIME_MICROS, s.elapsed(TimeUnit.MICROSECONDS));
        List list = ret;
        if (list == null) {
            AndroidLLDBDriver.$$$reportNull$$$0(18);
        }
        return list;
    }

    @NotNull
    public DebuggerDriver.ResultList<LLValue> getVariableChildren(LLValue value, int from, int count) throws ExecutionException, DebuggerCommandException {
        Stopwatch s = Stopwatch.createStarted();
        DebuggerDriver.ResultList ret = super.getVariableChildren(value, from, count);
        LLDBUsageTracker.storeLldbActionTime(LldbPercentileEstimator.Metric.GET_VARIABLE_CHILDREN_RANGE_TIME_MICROS, s.elapsed(TimeUnit.MICROSECONDS));
        DebuggerDriver.ResultList resultList = ret;
        if (resultList == null) {
            AndroidLLDBDriver.$$$reportNull$$$0(19);
        }
        return resultList;
    }

    public void stepOver(@Nullable Boolean stepByInstruction) throws ExecutionException {
        Stopwatch s = Stopwatch.createStarted();
        super.stepOver(stepByInstruction);
        LLDBUsageTracker.storeLldbActionTime(LldbPercentileEstimator.Metric.STEP_RESUME_RESPONSE_TIME_MICROS, s.elapsed(TimeUnit.MICROSECONDS));
    }

    public void stepInto(boolean forceStepIntoFramesWithNoDebugInfo, @Nullable Boolean stepByInstruction) throws ExecutionException {
        Stopwatch s = Stopwatch.createStarted();
        super.stepInto(forceStepIntoFramesWithNoDebugInfo, stepByInstruction);
        LLDBUsageTracker.storeLldbActionTime(LldbPercentileEstimator.Metric.STEP_RESUME_RESPONSE_TIME_MICROS, s.elapsed(TimeUnit.MICROSECONDS));
    }

    public void stepOut() throws ExecutionException {
        Stopwatch s = Stopwatch.createStarted();
        super.stepOut();
        LLDBUsageTracker.storeLldbActionTime(LldbPercentileEstimator.Metric.STEP_RESUME_RESPONSE_TIME_MICROS, s.elapsed(TimeUnit.MICROSECONDS));
    }

    public boolean resume() throws ExecutionException {
        Stopwatch s = Stopwatch.createStarted();
        boolean ret = super.resume();
        LLDBUsageTracker.storeLldbActionTime(LldbPercentileEstimator.Metric.STEP_RESUME_RESPONSE_TIME_MICROS, s.elapsed(TimeUnit.MICROSECONDS));
        return ret;
    }

    public Pair<String, Boolean> executeConsoleCommandWithOutput(long threadId, int frameIndex, String command) throws ExecutionException {
        Protocol.CompositeRequest request = ProtobufMessageFactory.handleConsoleCommand((long)threadId, (int)frameIndex, (String)command);
        Ref result = Ref.create();
        this.getProtobufClient().sendMessageAndWaitForReply((GeneratedMessage)request, Protocol.HandleConsoleCommand_Res.class, res -> {
            if (res.hasOut()) {
                result.set((Object)Pair.create((Object)res.getOut(), (Object)true));
            }
            if (res.hasErr()) {
                result.set((Object)Pair.create((Object)res.getErr(), (Object)false));
            }
        });
        return (Pair)result.get();
    }

    public boolean supportsDisasm() {
        return (Boolean)StudioFlags.LLDB_ASSEMBLY_DEBUGGING.get();
    }

    @NotNull
    public List<LLInstruction> disassemble(@NotNull AddressRange range) throws ExecutionException, DebuggerCommandException {
        String command;
        Pair<String, Boolean> output;
        if (range == null) {
            AndroidLLDBDriver.$$$reportNull$$$0(20);
        }
        if (!((Boolean)(output = this.executeConsoleCommandWithOutput(-1L, -1, command = "disassemble --start-address " + range.getStart().toString() + " --end-address " + range.getEndInclusive())).getSecond()).booleanValue()) {
            throw new DebuggerCommandException("failed to disassemble range " + range + " : " + (String)output.getFirst());
        }
        List<LLInstruction> list = AndroidLLDBDriver.parseLldbDisassembleOutput((String)output.getFirst());
        if (list == null) {
            AndroidLLDBDriver.$$$reportNull$$$0(21);
        }
        return list;
    }

    public static List<LLInstruction> parseLldbDisassembleOutput(String raw) {
        ArrayList<LLInstruction> res = new ArrayList<LLInstruction>();
        Pattern linePattern = Pattern.compile("^\\s*(0x[a-fA-F0-9]+)\\s*<\\+([0-9]+)>:\\s*([^;]*)");
        String currentFunction = null;
        for (String line : raw.split("\n")) {
            int functionOffset;
            Address addr;
            int groupCount;
            if (line.isEmpty()) continue;
            if (line.startsWith("->")) {
                line = line.substring(2);
            } else if (line.charAt(0) != ' ') {
                currentFunction = line.substring(0, line.length() - 1);
                continue;
            }
            Matcher matcher = linePattern.matcher(line);
            if (!matcher.lookingAt() || (groupCount = matcher.groupCount()) != 3) continue;
            try {
                addr = Address.parseHexString((String)matcher.group(1));
            }
            catch (NumberFormatException e) {
                LOG.warn("Could not determine address for disassembled instruction", (Throwable)e);
                continue;
            }
            try {
                functionOffset = Integer.parseInt(matcher.group(2));
            }
            catch (NumberFormatException e) {
                LOG.warn("Could not determine function offset for disassembled instruction", (Throwable)e);
                functionOffset = -1;
            }
            res.add(new LLInstruction(addr, matcher.group(3), currentFunction, functionOffset));
        }
        return res;
    }

    static {
        LibStdCppTypeNameFormatters.register();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 11: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 21: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 11: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 21: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debuggerState";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "printer";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "device";
                break;
            }
            case 6: 
            case 11: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/ndk/run/lldb/AndroidLLDBDriver";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "createTargetRequest";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "installer";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "preAttach";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "postAttach";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commands";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symBreakpoint";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/ndk/run/lldb/AndroidLLDBDriver";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getWatchpointWhitelist";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "loadForAttach";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "addWatchpoint";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "addBreakpoint";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getFrames";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariables";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariableChildren";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "disassemble";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "deviceSupportsWatchpoints";
                break;
            }
            case 6: 
            case 11: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 21: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "sendCreateTargetRequest";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "loadForLaunch";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "loadForAttach";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "runCommands";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "addSymbolicBreakpoint";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "disassemble";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 11: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 21: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

