/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.run.lldb;

import com.android.ddmlib.IDevice;
import com.android.sdklib.devices.Abi;
import com.android.tools.idea.gradle.project.GradleProjectInfo;
import com.android.tools.idea.run.ConsolePrinter;
import com.android.tools.ndk.GradleWorkspace;
import com.android.tools.ndk.ModulePathManager;
import com.android.tools.ndk.NdkHelper;
import com.android.tools.ndk.run.crash.AndroidLLDBBreakpadIntegration;
import com.android.tools.ndk.run.editor.NativeAndroidDebuggerState;
import com.android.tools.ndk.run.lldb.AndroidLLDBDriver;
import com.android.tools.ndk.run.lldb.SessionStarter;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerPathManager;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.LLDBDriverConfiguration;
import com.jetbrains.cidr.execution.debugger.backend.lldb.LLDBDriver;
import java.io.File;
import java.util.List;
import java.util.Map;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;

public class AndroidLLDBDriverConfiguration
extends LLDBDriverConfiguration {
    @NotNull
    private final NativeAndroidDebuggerState myDebuggerState;
    @NotNull
    private final IDevice myDevice;
    @NotNull
    private final List<Abi> myClientABIs;
    @NotNull
    private final SessionStarter mySessionStarter;
    @NotNull
    private final List<String> myStartupCommands;
    @NotNull
    private final List<String> myPostAttachCommands;
    @NotNull
    private final File myFrameworkFile;
    private static final Logger LOG = Logger.getInstance(AndroidLLDBDriverConfiguration.class);
    private final AndroidFacet myFacet;
    private final ConsolePrinter myPrinter;

    public AndroidLLDBDriverConfiguration(@NotNull AndroidFacet facet, @NotNull NativeAndroidDebuggerState debuggerState, @NotNull ConsolePrinter consolePrinter, @NotNull IDevice device, @NotNull List<Abi> clientABIs, @NotNull SessionStarter sessionStarter, @NotNull List<String> startupCommands, @NotNull List<String> postAttachCommands) {
        if (facet == null) {
            AndroidLLDBDriverConfiguration.$$$reportNull$$$0(0);
        }
        if (debuggerState == null) {
            AndroidLLDBDriverConfiguration.$$$reportNull$$$0(1);
        }
        if (consolePrinter == null) {
            AndroidLLDBDriverConfiguration.$$$reportNull$$$0(2);
        }
        if (device == null) {
            AndroidLLDBDriverConfiguration.$$$reportNull$$$0(3);
        }
        if (clientABIs == null) {
            AndroidLLDBDriverConfiguration.$$$reportNull$$$0(4);
        }
        if (sessionStarter == null) {
            AndroidLLDBDriverConfiguration.$$$reportNull$$$0(5);
        }
        if (startupCommands == null) {
            AndroidLLDBDriverConfiguration.$$$reportNull$$$0(6);
        }
        if (postAttachCommands == null) {
            AndroidLLDBDriverConfiguration.$$$reportNull$$$0(7);
        }
        this.myFacet = facet;
        this.myDebuggerState = debuggerState;
        this.myPrinter = consolePrinter;
        this.myDevice = device;
        this.myClientABIs = clientABIs;
        this.mySessionStarter = sessionStarter;
        this.myStartupCommands = startupCommands;
        this.myPostAttachCommands = postAttachCommands;
        this.myFrameworkFile = this.findFrameworkFile();
        LOG.info("LLDB framework file: " + this.myFrameworkFile.getAbsolutePath());
    }

    @NotNull
    public AndroidFacet getFacet() {
        AndroidFacet androidFacet = this.myFacet;
        if (androidFacet == null) {
            AndroidLLDBDriverConfiguration.$$$reportNull$$$0(8);
        }
        return androidFacet;
    }

    @NotNull
    public IDevice getDevice() {
        IDevice iDevice = this.myDevice;
        if (iDevice == null) {
            AndroidLLDBDriverConfiguration.$$$reportNull$$$0(9);
        }
        return iDevice;
    }

    @NotNull
    public List<Abi> getClientABIs() {
        List<Abi> list = this.myClientABIs;
        if (list == null) {
            AndroidLLDBDriverConfiguration.$$$reportNull$$$0(10);
        }
        return list;
    }

    @NotNull
    public SessionStarter getSessionStarter() {
        SessionStarter sessionStarter = this.mySessionStarter;
        if (sessionStarter == null) {
            AndroidLLDBDriverConfiguration.$$$reportNull$$$0(11);
        }
        return sessionStarter;
    }

    @NotNull
    public List<String> getStartupCommands() {
        List<String> list = this.myStartupCommands;
        if (list == null) {
            AndroidLLDBDriverConfiguration.$$$reportNull$$$0(12);
        }
        return list;
    }

    @NotNull
    public List<String> getPostAttachCommands() {
        List<String> list = this.myPostAttachCommands;
        if (list == null) {
            AndroidLLDBDriverConfiguration.$$$reportNull$$$0(13);
        }
        return list;
    }

    @NotNull
    public DebuggerDriver createDriver(@NotNull DebuggerDriver.Handler handler) throws ExecutionException {
        if (handler == null) {
            AndroidLLDBDriverConfiguration.$$$reportNull$$$0(14);
        }
        AndroidLLDBDriver androidLLDBDriver = new AndroidLLDBDriver(handler, this.myFacet, this.myDebuggerState, this, this.myPrinter);
        if (androidLLDBDriver == null) {
            AndroidLLDBDriverConfiguration.$$$reportNull$$$0(15);
        }
        return androidLLDBDriver;
    }

    @NotNull
    private static File getLLDBHostFile(@NotNull String relativePath) {
        if (relativePath == null) {
            AndroidLLDBDriverConfiguration.$$$reportNull$$$0(16);
        }
        File file = ModulePathManager.getLldbHostFile(relativePath);
        if (file == null) {
            AndroidLLDBDriverConfiguration.$$$reportNull$$$0(17);
        }
        return file;
    }

    @NotNull
    protected File getLLDBBinFile(@NotNull String relativePath) {
        if (relativePath == null) {
            AndroidLLDBDriverConfiguration.$$$reportNull$$$0(18);
        }
        File file = AndroidLLDBDriverConfiguration.getLLDBHostFile(new File("bin", relativePath).getPath());
        if (file == null) {
            AndroidLLDBDriverConfiguration.$$$reportNull$$$0(19);
        }
        return file;
    }

    @NotNull
    private static File getLLDBLibDir() {
        File file = AndroidLLDBDriverConfiguration.getLLDBHostFile(new File("lib").getPath());
        if (file == null) {
            AndroidLLDBDriverConfiguration.$$$reportNull$$$0(20);
        }
        return file;
    }

    @NotNull
    private File findFrameworkFile() {
        if (SystemInfo.isWindows) {
            File file = this.getLLDBBinFile("liblldb.dll");
            if (file == null) {
                AndroidLLDBDriverConfiguration.$$$reportNull$$$0(21);
            }
            return file;
        }
        File[] libFiles = AndroidLLDBDriverConfiguration.getLLDBLibDir().listFiles(pathname -> pathname.getName().startsWith("liblldb."));
        if (libFiles == null || libFiles.length != 1) {
            throw new RuntimeException("Found broken LLDB configuration");
        }
        File file = libFiles[0];
        if (file == null) {
            AndroidLLDBDriverConfiguration.$$$reportNull$$$0(22);
        }
        return file;
    }

    @NotNull
    protected File getLLDBFrameworkFile() {
        File file = this.myFrameworkFile;
        if (file == null) {
            AndroidLLDBDriverConfiguration.$$$reportNull$$$0(23);
        }
        return file;
    }

    protected void configureDriverCommandLine(@NotNull GeneralCommandLine result) {
        File libStdCxxPrinterPath;
        File ndkPath;
        Project project;
        String workingDir;
        if (result == null) {
            AndroidLLDBDriverConfiguration.$$$reportNull$$$0(24);
        }
        if (!(workingDir = this.myDebuggerState.getWorkingDir()).isEmpty()) {
            result.withWorkDirectory(workingDir);
        }
        if (!GradleProjectInfo.getInstance((Project)(project = this.myFacet.getModule().getProject())).isBuildWithGradle()) {
            return;
        }
        Map environment = result.getEnvironment();
        File galaPath = ModulePathManager.getRepoLLDBStlPrintersFolder();
        if (galaPath.exists()) {
            environment.put("AS_GALA_PATH", galaPath.getAbsolutePath());
        }
        if ((ndkPath = GradleWorkspace.getInstance(project).getNdkPath()) != null && (libStdCxxPrinterPath = NdkHelper.getLibStdCxxPrintersPath(ndkPath, "4.9")).exists()) {
            environment.put("AS_LIBSTDCXX_PRINTER_PATH", libStdCxxPrinterPath.getAbsolutePath());
        }
    }

    @NotNull
    public GeneralCommandLine createDriverCommandLine(@NotNull DebuggerDriver driver) throws ExecutionException {
        File lldbFrameworkFile;
        if (driver == null) {
            AndroidLLDBDriverConfiguration.$$$reportNull$$$0(25);
        }
        if (!(lldbFrameworkFile = this.getLLDBFrameworkFile()).exists()) {
            throw new ExecutionException(lldbFrameworkFile + " not found");
        }
        File frontendExecutable = this.getLLDBBinFile(SystemInfo.isWindows ? "LLDBFrontend.exe" : "LLDBFrontend");
        if (!frontendExecutable.exists()) {
            throw new ExecutionException(frontendExecutable.getAbsolutePath() + " not found");
        }
        GeneralCommandLine result = new GeneralCommandLine();
        result.setExePath(frontendExecutable.getAbsolutePath());
        result.addParameter(String.valueOf(((LLDBDriver)driver).getPort()));
        AndroidLLDBDriverConfiguration.setupCommonParameters((GeneralCommandLine)result);
        Map env = result.getEnvironment();
        if (SystemInfo.isLinux) {
            env.put("LD_LIBRARY_PATH", AndroidLLDBDriverConfiguration.getLLDBLibDir().getAbsolutePath());
        } else if (SystemInfo.isMac) {
            env.put("DYLD_FRAMEWORK_PATH", lldbFrameworkFile.getParent());
            File pythonBinDir = CidrDebuggerPathManager.getOSXSystemPythonBinDir();
            if (pythonBinDir != null) {
                env.put("PATH", pythonBinDir.getAbsolutePath());
            }
        }
        if (!SystemInfo.isMac) {
            env.put("PYTHONHOME", ModulePathManager.getLldbPythonHome().getAbsolutePath());
            String lldbPythonLibs = ModulePathManager.getLldbHostFile("lib/python").getAbsolutePath();
            Map<String, String> parentEnv = System.getenv();
            String parentPythonPath = parentEnv.get("PYTHONPATH");
            if (parentPythonPath != null) {
                env.put("PYTHONPATH", parentPythonPath + File.pathSeparator + lldbPythonLibs);
            } else {
                env.put("PYTHONPATH", lldbPythonLibs);
            }
            env.put("PYTHONDONTWRITEBYTECODE", "1");
        }
        AndroidLLDBBreakpadIntegration.setUpRunEnvironment(env);
        this.configureDriverCommandLine(result);
        GeneralCommandLine generalCommandLine = result;
        if (generalCommandLine == null) {
            AndroidLLDBDriverConfiguration.$$$reportNull$$$0(26);
        }
        return generalCommandLine;
    }

    public boolean isStaticVarsLoadingEnabled() {
        return this.myDebuggerState.showStaticVars();
    }

    public boolean isOptimizedWarningEnabled() {
        return this.myDebuggerState.showOptimizedWarning();
    }

    public void disableOptimizedWarning() {
        this.myDebuggerState.setShowOptimizedWarning(false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 26: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 26: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debuggerState";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consolePrinter";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "device";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clientABIs";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sessionStarter";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startupCommands";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "postAttachCommands";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/ndk/run/lldb/AndroidLLDBDriverConfiguration";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativePath";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "driver";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/ndk/run/lldb/AndroidLLDBDriverConfiguration";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getFacet";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getDevice";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getClientABIs";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getSessionStarter";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getStartupCommands";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getPostAttachCommands";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "createDriver";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getLLDBHostFile";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getLLDBBinFile";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getLLDBLibDir";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "findFrameworkFile";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getLLDBFrameworkFile";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "createDriverCommandLine";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 26: {
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createDriver";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getLLDBHostFile";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getLLDBBinFile";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "configureDriverCommandLine";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "createDriverCommandLine";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 26: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

