/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.run.lldb;

import com.android.builder.model.NativeArtifact;
import com.android.builder.model.NativeToolchain;
import com.android.ddmlib.Client;
import com.android.ddmlib.CollectingOutputReceiver;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.SyncService;
import com.android.repository.api.LocalPackage;
import com.android.repository.api.ProgressIndicator;
import com.android.sdklib.devices.Abi;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.tools.analytics.CommonMetricsData;
import com.android.tools.idea.fd.InstantRunUtils;
import com.android.tools.idea.gradle.project.model.NdkModuleModel;
import com.android.tools.idea.run.AndroidProcessText;
import com.android.tools.idea.run.AndroidSessionInfo;
import com.android.tools.idea.run.ConsolePrinter;
import com.android.tools.idea.run.LaunchInfo;
import com.android.tools.idea.run.ProcessHandlerConsolePrinter;
import com.android.tools.idea.run.editor.AndroidDebugger;
import com.android.tools.idea.run.tasks.ConnectDebuggerTask;
import com.android.tools.idea.run.util.LaunchStatus;
import com.android.tools.idea.run.util.ProcessHandlerLaunchStatus;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.tools.idea.sdk.progress.StudioLoggerProgressIndicator;
import com.android.tools.ndk.ModulePathManager;
import com.android.tools.ndk.NdkHelper;
import com.android.tools.ndk.run.AndroidNativeAppDebugProcess;
import com.android.tools.ndk.run.ClientShellHelper;
import com.android.tools.ndk.run.ProgressReporter;
import com.android.tools.ndk.run.editor.AutoAndroidDebuggerState;
import com.android.tools.ndk.run.editor.HybridAndroidDebugger;
import com.android.tools.ndk.run.editor.NativeAndroidDebugger;
import com.android.tools.ndk.run.editor.NativeAndroidDebuggerState;
import com.android.tools.ndk.run.jdwp.JdwpConnector;
import com.android.tools.ndk.run.lldb.AndroidLLDBDriverConfiguration;
import com.android.tools.ndk.run.lldb.InjectorSessionStarterImpl;
import com.android.tools.ndk.run.lldb.LLDBUsageTracker;
import com.android.tools.ndk.run.lldb.RunAsSessionStarterImpl;
import com.android.tools.ndk.run.lldb.SessionStarter;
import com.android.tools.ndk.run.lldb.ShellSessionStarterImpl;
import com.google.common.base.Charsets;
import com.google.common.collect.Lists;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.ProductDetails;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.CommandLineState;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessTerminatedListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionEnvironmentBuilder;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebugSessionListener;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.jetbrains.cidr.execution.CidrCommandLineState;
import com.jetbrains.cidr.execution.CidrRunner;
import com.jetbrains.cidr.execution.Installer;
import com.jetbrains.cidr.execution.RunParameters;
import com.jetbrains.cidr.execution.TrivialInstaller;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriverConfiguration;
import com.jetbrains.cidr.execution.testing.CidrLauncher;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.android.dom.manifest.Application;
import org.jetbrains.android.dom.manifest.Manifest;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConnectLLDBTask
extends ConnectDebuggerTask {
    private static final Logger LOG = Logger.getInstance(ConnectLLDBTask.class);
    private final String mySessionId;
    @NotNull
    private final ExecutionEnvironment myEnv;
    @NotNull
    protected final AndroidFacet myFacet;
    @NotNull
    protected final NativeAndroidDebuggerState myDebuggerState;
    @NotNull
    private final String myRunConfigTypeId;
    @NotNull
    protected final NativeAndroidDebugger myNativeDebugger;
    protected ProgressReporter myProgressReporter;
    public static final NotificationGroup NOTIFICATION_GROUP = NotificationGroup.toolWindowGroup((String)"Native Debugger", (String)ToolWindowId.DEBUG);

    public ConnectLLDBTask(@NotNull ExecutionEnvironment env, @NotNull Set<String> applicationIds, @NotNull AndroidFacet facet, @NotNull NativeAndroidDebuggerState state, @NotNull NativeAndroidDebugger debugger, @NotNull String runConfigTypeId) {
        if (env == null) {
            ConnectLLDBTask.$$$reportNull$$$0(0);
        }
        if (applicationIds == null) {
            ConnectLLDBTask.$$$reportNull$$$0(1);
        }
        if (facet == null) {
            ConnectLLDBTask.$$$reportNull$$$0(2);
        }
        if (state == null) {
            ConnectLLDBTask.$$$reportNull$$$0(3);
        }
        if (debugger == null) {
            ConnectLLDBTask.$$$reportNull$$$0(4);
        }
        if (runConfigTypeId == null) {
            ConnectLLDBTask.$$$reportNull$$$0(5);
        }
        super(applicationIds, (AndroidDebugger)debugger, facet.getModule().getProject(), true);
        this.myEnv = env;
        this.myFacet = facet;
        this.myDebuggerState = state;
        this.myRunConfigTypeId = runConfigTypeId;
        this.myNativeDebugger = debugger;
        this.mySessionId = UUID.randomUUID().toString();
    }

    public boolean isReadyForDebugging(@NotNull Client client, @NotNull ConsolePrinter printer) {
        if (client == null) {
            ConnectLLDBTask.$$$reportNull$$$0(6);
        }
        if (printer == null) {
            ConnectLLDBTask.$$$reportNull$$$0(7);
        }
        return super.isReadyForDebugging(client, printer) && client.isDdmAware();
    }

    protected boolean isDetachOnStop() {
        return false;
    }

    protected boolean needsJdwpConnector(@NotNull SessionStarterType starterType) {
        if (starterType == null) {
            ConnectLLDBTask.$$$reportNull$$$0(8);
        }
        return true;
    }

    SessionStarterType decideStarterImplementation(Client client) throws ExecutionException {
        boolean restrictedPtraceScope;
        if (Boolean.getBoolean("lldb.session-starter.runas")) {
            return SessionStarterType.RUN_AS_SHELL;
        }
        int ptraceScope = ConnectLLDBTask.getPtraceScope(client.getDevice());
        boolean bl = restrictedPtraceScope = ptraceScope > 0;
        if (restrictedPtraceScope) {
            LOG.warn(String.format("YAMA is on - ptrace_scope set to %d.  Using injector to start debug session", ptraceScope));
            return SessionStarterType.INJECTOR_YAMA;
        }
        if (Boolean.getBoolean("lldb.session-starter.jdwp")) {
            LOG.warn("Using injector to start debug session due to system property");
            return SessionStarterType.INJECTOR;
        }
        if (ConnectLLDBTask.isRootedDevice(client.getDevice())) {
            LOG.warn("Rooted device, using shell to start debug session");
            return SessionStarterType.ROOT_SHELL;
        }
        if (ConnectLLDBTask.isRunAsOK(client)) {
            LOG.warn("Using run-as to start debug session");
            return SessionStarterType.RUN_AS_SHELL;
        }
        LOG.warn("Non-rooted device, run-as not working, resorting to injector to start debug session");
        return SessionStarterType.INJECTOR;
    }

    private void appendDualDebuggerMessage(@NotNull StringBuilder message) {
        if (message == null) {
            ConnectLLDBTask.$$$reportNull$$$0(9);
        }
        if (this.myNativeDebugger instanceof HybridAndroidDebugger) {
            if (this.myDebuggerState instanceof AutoAndroidDebuggerState) {
                message.append("Auto debugger mode selected the Dual debugger.");
            } else {
                message.append("You are using the Dual debugger.");
            }
        }
        message.append("You can continue to debug Java code by using the Java debugger. See <https://developer.android.com/studio/debug/index.html#debug-types> for more details.");
    }

    private static boolean hasBrokenNdkABI(@NotNull Client client) {
        if (client == null) {
            ConnectLLDBTask.$$$reportNull$$$0(10);
        }
        for (Abi abi : ConnectLLDBTask.getClientABIs(client)) {
            if (abi.toString() != "x86") continue;
            return true;
        }
        return false;
    }

    private void maybeShowBrokenNdkMessage(@NotNull Client client) {
        if (client == null) {
            ConnectLLDBTask.$$$reportNull$$$0(11);
        }
        if (!ConnectLLDBTask.hasBrokenNdkABI(client)) {
            return;
        }
        NdkModuleModel ndkModuleModel = NdkModuleModel.get((Module)this.myFacet.getModule());
        if (ndkModuleModel == null) {
            return;
        }
        Collection artifacts = ndkModuleModel.getSelectedVariant().getArtifacts();
        if (artifacts.isEmpty()) {
            return;
        }
        NativeToolchain toolchain = ndkModuleModel.findToolchain(((NativeArtifact)artifacts.iterator().next()).getToolChain());
        if (toolchain == null) {
            return;
        }
        File cc = toolchain.getCCompilerExecutable();
        if (cc == null) {
            return;
        }
        if (!cc.getName().contains("clang")) {
            return;
        }
        AndroidSdkHandler sdkHandler = AndroidSdks.getInstance().tryToChooseSdkHandler();
        LocalPackage ndk = sdkHandler.getLocalPackage("ndk-bundle", (ProgressIndicator)new StudioLoggerProgressIndicator(ConnectLLDBTask.class));
        if (ndk == null) {
            return;
        }
        if (!cc.getAbsolutePath().startsWith(ndk.getLocation().getAbsolutePath())) {
            return;
        }
        if (ndk.getVersion().getMajor() > 16) {
            return;
        }
        NOTIFICATION_GROUP.createNotification("While debugging with an x86 device, the version of Clang included in NDK r16 and lower has a known issue that prevents function argument values from displaying correctly. To avoid this issue, either use an x86_64 device, or update the NDK to r17 or higher.", NotificationType.WARNING).notify(this.myProject);
    }

    private void maybeShowMustExpandNativeLibsMessage() {
        Manifest manifest = this.myFacet.getManifest();
        if (manifest == null) {
            return;
        }
        Application app = manifest.getApplication();
        if (app == null || app.getXmlTag() == null) {
            return;
        }
        if ("false".equalsIgnoreCase(app.getXmlTag().getAttributeValue("extractNativeLibs", "http://schemas.android.com/apk/res/android"))) {
            NOTIFICATION_GROUP.createNotification("Android Studio cannot debug native libraries that are not extracted from the APK. When debugging your app, set extractNativeLibs=\"true\" in your app's manifest.", NotificationType.WARNING).notify(this.myProject);
        }
    }

    @Nullable
    public ProcessHandler launchDebugger(@NotNull LaunchInfo currentLaunchInfo, @NotNull Client client, @NotNull ProcessHandlerLaunchStatus launchStatus, @NotNull ProcessHandlerConsolePrinter printer) {
        if (currentLaunchInfo == null) {
            ConnectLLDBTask.$$$reportNull$$$0(12);
        }
        if (client == null) {
            ConnectLLDBTask.$$$reportNull$$$0(13);
        }
        if (launchStatus == null) {
            ConnectLLDBTask.$$$reportNull$$$0(14);
        }
        if (printer == null) {
            ConnectLLDBTask.$$$reportNull$$$0(15);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (CommonMetricsData.getOsArchitecture().equals((Object)ProductDetails.CpuArchitecture.X86) || Boolean.getBoolean("lldb.fail_arch_check")) {
            StringBuilder message = new StringBuilder("Native debugging is not supported on 32-bit architectures.\n");
            this.appendDualDebuggerMessage(message);
            NOTIFICATION_GROUP.createNotification(message.toString(), NotificationType.ERROR).notify(this.myProject);
            launchStatus.terminateLaunch(message.toString());
            ConnectLLDBTask.forceStopActivity(client);
            return null;
        }
        this.maybeShowBrokenNdkMessage(client);
        this.maybeShowMustExpandNativeLibsMessage();
        this.myProgressReporter = new ProgressReporter(this.myEnv.getProject());
        String prettyConfigName = this.getPrettyConfigurationName(client);
        IDevice device = client.getDevice();
        String deviceModel = device.getProperty("ro.product.model");
        String deviceAPILevel = device.getProperty("ro.build.version.sdk");
        String deviceCodename = device.getProperty("ro.build.version.codename");
        String deviceManufacturer = device.getProperty("ro.product.manufacturer");
        LOG.info(String.format("Launching %s native debug session on device: manufacturer=%s, model=%s, API=%s, codename=%s, ABIs=%s", prettyConfigName, deviceManufacturer, deviceModel, deviceAPILevel, deviceCodename, device.getAbis().toString()));
        try {
            SessionStarterType sessionStarterType = this.decideStarterImplementation(client);
            LLDBUsageTracker.sessionStarted(device, this.getDebuggerType(), this.mySessionId, this.debuggerTypeChosenByAuto(), sessionStarterType);
            return this.launchCidrDebugger(currentLaunchInfo, client, sessionStarterType, launchStatus, printer);
        }
        catch (Throwable e) {
            this.onLaunchFailure((LaunchStatus)launchStatus, client, "Error while starting native debug session: " + e.toString(), e);
            return null;
        }
    }

    @NotNull
    private static File createPtraceScopeTempFile() throws IOException {
        File file = File.createTempFile("ptrace_scope", Long.toString(System.currentTimeMillis()));
        file.deleteOnExit();
        File file2 = file;
        if (file2 == null) {
            ConnectLLDBTask.$$$reportNull$$$0(16);
        }
        return file2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int getPtraceScope(@NotNull IDevice device) {
        if (device == null) {
            ConnectLLDBTask.$$$reportNull$$$0(17);
        }
        SyncService syncService = null;
        File localPtraceScopeFile = null;
        try {
            syncService = device.getSyncService();
            if (syncService == null) {
                throw new ExecutionException("Failed to get SyncService");
            }
            SyncService.FileStat ptraceScopeStat = syncService.statFile("/proc/sys/kernel/yama/ptrace_scope");
            if (ptraceScopeStat == null || ptraceScopeStat.getMode() == 0) {
                int n = 0;
                return n;
            }
            localPtraceScopeFile = ConnectLLDBTask.createPtraceScopeTempFile();
            device.pullFile("/proc/sys/kernel/yama/ptrace_scope", localPtraceScopeFile.getPath());
            int n = Integer.parseInt(com.google.common.io.Files.toString((File)localPtraceScopeFile, (Charset)Charsets.UTF_8).trim());
            return n;
        }
        catch (Exception e) {
            LOG.warn((Throwable)e);
        }
        finally {
            if (localPtraceScopeFile != null) {
                try {
                    Files.delete(localPtraceScopeFile.toPath());
                }
                catch (IOException e) {
                    LOG.warn((Throwable)e);
                }
            }
            if (syncService != null) {
                syncService.close();
            }
        }
        return -1;
    }

    @NotNull
    private SessionStarter newSessionStarter(@Nullable JdwpConnector jdwpConnector, @NotNull Client client, @NotNull List<Abi> clientABIs, @NotNull SessionStarterType type, @NotNull ProcessHandlerLaunchStatus launchStatus, @NotNull ConsolePrinter printer) throws ExecutionException {
        if (client == null) {
            ConnectLLDBTask.$$$reportNull$$$0(18);
        }
        if (clientABIs == null) {
            ConnectLLDBTask.$$$reportNull$$$0(19);
        }
        if (type == null) {
            ConnectLLDBTask.$$$reportNull$$$0(20);
        }
        if (launchStatus == null) {
            ConnectLLDBTask.$$$reportNull$$$0(21);
        }
        if (printer == null) {
            ConnectLLDBTask.$$$reportNull$$$0(22);
        }
        AndroidNativeAppDebugProcess.verifyNativeModel(this.myFacet, clientABIs, printer);
        File lldbServer = ModulePathManager.findLLDBServer(this.myFacet, this.myDebuggerState, clientABIs);
        if (lldbServer == null) {
            LOG.error("LLDB server not found");
            throw new IllegalStateException(String.format("LLDB server for architecture '%s' not found", clientABIs.get(0)));
        }
        LOG.info(String.format("Found LLDB server: \"%s\"", lldbServer.getAbsolutePath()));
        File startServerScript = ModulePathManager.getLldbAndroidFile("start_lldb_server.sh");
        switch (type) {
            case INJECTOR: 
            case INJECTOR_YAMA: {
                if (jdwpConnector == null) {
                    throw new IllegalStateException("JDWP Connector must not be null when injector session starter is required");
                }
                SessionStarter sessionStarter = this.newInjectorSessionStarter(jdwpConnector, client, type == SessionStarterType.INJECTOR_YAMA, lldbServer, startServerScript, launchStatus, printer);
                if (sessionStarter == null) {
                    ConnectLLDBTask.$$$reportNull$$$0(23);
                }
                return sessionStarter;
            }
            case ROOT_SHELL: {
                SessionStarter sessionStarter = this.newShellSessionStarter(jdwpConnector, client, lldbServer, startServerScript, launchStatus, printer);
                if (sessionStarter == null) {
                    ConnectLLDBTask.$$$reportNull$$$0(24);
                }
                return sessionStarter;
            }
            case RUN_AS_SHELL: {
                SessionStarter sessionStarter = this.newRunAsSessionStarter(jdwpConnector, client, lldbServer, startServerScript, launchStatus, printer);
                if (sessionStarter == null) {
                    ConnectLLDBTask.$$$reportNull$$$0(25);
                }
                return sessionStarter;
            }
        }
        throw new IllegalStateException("SessionStarterType was not recognized");
    }

    private static void resumeVMOnSessionStarted(@NotNull SessionStarter sessionStarter, @Nullable JdwpConnector jdwpConnector) {
        if (sessionStarter == null) {
            ConnectLLDBTask.$$$reportNull$$$0(26);
        }
        if (jdwpConnector == null) {
            return;
        }
        sessionStarter.addEventListener(jdwpConnector::Connect);
    }

    @NotNull
    private SessionStarter newShellSessionStarter(@Nullable JdwpConnector jdwpConnector, @NotNull Client client, @NotNull File serverPath, @NotNull File startScriptPath, @NotNull ProcessHandlerLaunchStatus launchStatus, @NotNull ConsolePrinter printer) throws ExecutionException {
        if (client == null) {
            ConnectLLDBTask.$$$reportNull$$$0(27);
        }
        if (serverPath == null) {
            ConnectLLDBTask.$$$reportNull$$$0(28);
        }
        if (startScriptPath == null) {
            ConnectLLDBTask.$$$reportNull$$$0(29);
        }
        if (launchStatus == null) {
            ConnectLLDBTask.$$$reportNull$$$0(30);
        }
        if (printer == null) {
            ConnectLLDBTask.$$$reportNull$$$0(31);
        }
        ShellSessionStarterImpl sessionStarter = new ShellSessionStarterImpl(client, serverPath, startScriptPath, this.myDebuggerState, this.myProgressReporter, launchStatus, printer);
        ConnectLLDBTask.resumeVMOnSessionStarted(sessionStarter, jdwpConnector);
        ShellSessionStarterImpl shellSessionStarterImpl = sessionStarter;
        if (shellSessionStarterImpl == null) {
            ConnectLLDBTask.$$$reportNull$$$0(32);
        }
        return shellSessionStarterImpl;
    }

    @NotNull
    private SessionStarter newRunAsSessionStarter(@Nullable JdwpConnector jdwpConnector, @NotNull Client client, @NotNull File serverPath, @NotNull File startScriptPath, @NotNull ProcessHandlerLaunchStatus launchStatus, @NotNull ConsolePrinter printer) throws ExecutionException {
        if (client == null) {
            ConnectLLDBTask.$$$reportNull$$$0(33);
        }
        if (serverPath == null) {
            ConnectLLDBTask.$$$reportNull$$$0(34);
        }
        if (startScriptPath == null) {
            ConnectLLDBTask.$$$reportNull$$$0(35);
        }
        if (launchStatus == null) {
            ConnectLLDBTask.$$$reportNull$$$0(36);
        }
        if (printer == null) {
            ConnectLLDBTask.$$$reportNull$$$0(37);
        }
        RunAsSessionStarterImpl sessionStarter = new RunAsSessionStarterImpl(client, serverPath, startScriptPath, this.myDebuggerState, this.myProgressReporter, launchStatus, printer);
        ConnectLLDBTask.resumeVMOnSessionStarted(sessionStarter, jdwpConnector);
        RunAsSessionStarterImpl runAsSessionStarterImpl = sessionStarter;
        if (runAsSessionStarterImpl == null) {
            ConnectLLDBTask.$$$reportNull$$$0(38);
        }
        return runAsSessionStarterImpl;
    }

    @NotNull
    private SessionStarter newInjectorSessionStarter(@NotNull JdwpConnector jdwpConnector, @NotNull Client client, boolean restrictedPtraceScope, @NotNull File serverPath, @NotNull File startScriptPath, @NotNull ProcessHandlerLaunchStatus launchStatus, @NotNull ConsolePrinter printer) throws ExecutionException {
        if (jdwpConnector == null) {
            ConnectLLDBTask.$$$reportNull$$$0(39);
        }
        if (client == null) {
            ConnectLLDBTask.$$$reportNull$$$0(40);
        }
        if (serverPath == null) {
            ConnectLLDBTask.$$$reportNull$$$0(41);
        }
        if (startScriptPath == null) {
            ConnectLLDBTask.$$$reportNull$$$0(42);
        }
        if (launchStatus == null) {
            ConnectLLDBTask.$$$reportNull$$$0(43);
        }
        if (printer == null) {
            ConnectLLDBTask.$$$reportNull$$$0(44);
        }
        InjectorSessionStarterImpl injectorSessionStarterImpl = new InjectorSessionStarterImpl(jdwpConnector, client, restrictedPtraceScope, serverPath, startScriptPath, this.myDebuggerState, this.myProgressReporter, launchStatus, printer);
        if (injectorSessionStarterImpl == null) {
            ConnectLLDBTask.$$$reportNull$$$0(45);
        }
        return injectorSessionStarterImpl;
    }

    private static boolean isRunAsOK(@NotNull Client client) throws ExecutionException {
        if (client == null) {
            ConnectLLDBTask.$$$reportNull$$$0(46);
        }
        try {
            ClientShellHelper shellHelper = new ClientShellHelper(client);
            IDevice device = client.getDevice();
            String deviceModel = device.getProperty("ro.product.model");
            if (deviceModel == null) {
                return false;
            }
            CollectingOutputReceiver receiver = new CollectingOutputReceiver();
            client.getDevice().executeShellCommand(shellHelper.getRunAsCommand(String.format("getprop %s", "ro.product.model")), (IShellOutputReceiver)receiver);
            String output = receiver.getOutput().trim();
            if (!output.contains(deviceModel)) {
                LOG.warn("run-as for the selected device appears to be broken, output was : " + output);
                return false;
            }
            return true;
        }
        catch (Exception e) {
            throw new ExecutionException((Throwable)e);
        }
    }

    protected static boolean isRootedDevice(@NotNull IDevice device) throws ExecutionException {
        if (device == null) {
            ConnectLLDBTask.$$$reportNull$$$0(47);
        }
        try {
            return device.isRoot();
        }
        catch (Exception e) {
            throw new ExecutionException((Throwable)e);
        }
    }

    private static int getClientAddressByteSize(@NotNull Client client) {
        String abi;
        if (client == null) {
            ConnectLLDBTask.$$$reportNull$$$0(48);
        }
        if ((abi = client.getClientData().getAbi()) != null && abi.startsWith("64-bit")) {
            return 8;
        }
        return 4;
    }

    @NotNull
    private static List<Abi> getClientABIs(@NotNull Client client) {
        int clientAddrByteSize;
        if (client == null) {
            ConnectLLDBTask.$$$reportNull$$$0(49);
        }
        if ((clientAddrByteSize = ConnectLLDBTask.getClientAddressByteSize(client)) <= 0) {
            LOG.warn("Failed to get client address byte size from ABI: " + client.getClientData().getAbi());
        }
        LinkedList abis = Lists.newLinkedList();
        IDevice device = client.getDevice();
        for (String abiStr : device.getAbis()) {
            Abi abi = Abi.getEnum((String)abiStr);
            if (abi == null) {
                LOG.warn("Failed to get abi by name: " + abiStr);
                continue;
            }
            if (clientAddrByteSize > 0) {
                if (abi.getAddressSizeInBytes() != clientAddrByteSize) continue;
                abis.add(abi);
                continue;
            }
            abis.add(abi);
        }
        LOG.info("ABIs supported by app: " + ((Object)abis).toString());
        LinkedList linkedList = abis;
        if (linkedList == null) {
            ConnectLLDBTask.$$$reportNull$$$0(50);
        }
        return linkedList;
    }

    @NotNull
    private RunParameters newRunParameters(@NotNull Client client, @NotNull List<Abi> clientABIs, @NotNull SessionStarter sessionStarter, @NotNull ProcessHandlerConsolePrinter printer) {
        if (client == null) {
            ConnectLLDBTask.$$$reportNull$$$0(51);
        }
        if (clientABIs == null) {
            ConnectLLDBTask.$$$reportNull$$$0(52);
        }
        if (sessionStarter == null) {
            ConnectLLDBTask.$$$reportNull$$$0(53);
        }
        if (printer == null) {
            ConnectLLDBTask.$$$reportNull$$$0(54);
        }
        final IDevice device = client.getDevice();
        final AndroidLLDBDriverConfiguration configuration = new AndroidLLDBDriverConfiguration(this.myFacet, this.myDebuggerState, (ConsolePrinter)printer, device, clientABIs, sessionStarter, this.getStartupCommands(client, printer), this.getPostAttachCommands(client));
        RunParameters runParameters = new RunParameters(){

            @NotNull
            public Installer getInstaller() {
                TrivialInstaller trivialInstaller = new TrivialInstaller(new GeneralCommandLine(new String[]{""}));
                if (trivialInstaller == null) {
                    1.$$$reportNull$$$0(0);
                }
                return trivialInstaller;
            }

            @NotNull
            public DebuggerDriverConfiguration getDebuggerDriverConfiguration() {
                AndroidLLDBDriverConfiguration androidLLDBDriverConfiguration = configuration;
                if (androidLLDBDriverConfiguration == null) {
                    1.$$$reportNull$$$0(1);
                }
                return androidLLDBDriverConfiguration;
            }

            @NotNull
            public String getArchitectureId() {
                String string = NdkHelper.getArchitectureId(NdkHelper.getAbi(device));
                if (string == null) {
                    1.$$$reportNull$$$0(2);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/android/tools/ndk/run/lldb/ConnectLLDBTask$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getInstaller";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getDebuggerDriverConfiguration";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getArchitectureId";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
        if (runParameters == null) {
            ConnectLLDBTask.$$$reportNull$$$0(55);
        }
        return runParameters;
    }

    @NotNull
    protected JdwpConnector newJdwpConnector(@NotNull LaunchInfo currentLaunchInfo, @NotNull Client client, @NotNull XDebugSession session) {
        if (currentLaunchInfo == null) {
            ConnectLLDBTask.$$$reportNull$$$0(56);
        }
        if (client == null) {
            ConnectLLDBTask.$$$reportNull$$$0(57);
        }
        if (session == null) {
            ConnectLLDBTask.$$$reportNull$$$0(58);
        }
        JdwpConnector jdwpConnector = new JdwpConnector(currentLaunchInfo, this.myFacet, client, session, true);
        if (jdwpConnector == null) {
            ConnectLLDBTask.$$$reportNull$$$0(59);
        }
        return jdwpConnector;
    }

    private ProcessHandler launchCidrDebugger(final @NotNull LaunchInfo currentLaunchInfo, final @NotNull Client client, final @NotNull SessionStarterType sessionStarterType, final @NotNull ProcessHandlerLaunchStatus launchStatus, final @NotNull ProcessHandlerConsolePrinter printer) throws ExecutionException {
        AndroidSessionInfo newInfo;
        if (currentLaunchInfo == null) {
            ConnectLLDBTask.$$$reportNull$$$0(60);
        }
        if (client == null) {
            ConnectLLDBTask.$$$reportNull$$$0(61);
        }
        if (sessionStarterType == null) {
            ConnectLLDBTask.$$$reportNull$$$0(62);
        }
        if (launchStatus == null) {
            ConnectLLDBTask.$$$reportNull$$$0(63);
        }
        if (printer == null) {
            ConnectLLDBTask.$$$reportNull$$$0(64);
        }
        CidrRunner cidrRunner = new CidrRunner(){

            @NotNull
            public String getRunnerId() {
                if ("AndroidNativeDebugRunner2" == null) {
                    2.$$$reportNull$$$0(0);
                }
                return "AndroidNativeDebugRunner2";
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/ndk/run/lldb/ConnectLLDBTask$2", "getRunnerId"));
            }
        };
        ExecutionEnvironment env = new ExecutionEnvironmentBuilder(this.myEnv).executor(this.myEnv.getExecutor()).runner((ProgramRunner)cidrRunner).contentToReuse(this.myEnv.getContentToReuse()).build();
        CidrCommandLineState cidrState = new CidrCommandLineState(env, new CidrLauncher(){

            public ProcessHandler createProcess(@NotNull CommandLineState state) {
                if (state == null) {
                    3.$$$reportNull$$$0(0);
                }
                throw new RuntimeException("start process not implemented");
            }

            @NotNull
            public CidrDebugProcess createDebugProcess(@NotNull CommandLineState state, @NotNull XDebugSession session) throws ExecutionException {
                SessionStarter sessionStarter;
                if (state == null) {
                    3.$$$reportNull$$$0(1);
                }
                if (session == null) {
                    3.$$$reportNull$$$0(2);
                }
                List clientABIs = ConnectLLDBTask.getClientABIs(client);
                JdwpConnector jdwpConnector = null;
                if (!ConnectLLDBTask.this.needsJdwpConnector(sessionStarterType)) {
                    LOG.info("Not creating JDWP connector.  Connect task is : " + ((Object)((Object)ConnectLLDBTask.this)).getClass().getName() + ". Session starter type is : " + (Object)((Object)sessionStarterType) + ". Debugger id is : " + ConnectLLDBTask.this.myNativeDebugger.getId());
                } else {
                    jdwpConnector = ConnectLLDBTask.this.newJdwpConnector(currentLaunchInfo, client, session);
                }
                try {
                    sessionStarter = ConnectLLDBTask.this.newSessionStarter(jdwpConnector, client, clientABIs, sessionStarterType, launchStatus, (ConsolePrinter)printer);
                }
                catch (Exception e) {
                    throw new ExecutionException((Throwable)e);
                }
                RunParameters runParameters = ConnectLLDBTask.this.newRunParameters(client, clientABIs, sessionStarter, printer);
                AndroidNativeAppDebugProcess result = ConnectLLDBTask.this.myNativeDebugger.newAndroidNativeAppDebugProcess(ConnectLLDBTask.this.mySessionId, runParameters, session, state.getConsoleBuilder(), (ConsolePrinter)printer, sessionStarter, client, jdwpConnector, ConnectLLDBTask.this.myProgressReporter, ConnectLLDBTask.this.isDetachOnStop());
                ProcessTerminatedListener.attach((ProcessHandler)result.getProcessHandler(), (Project)ConnectLLDBTask.this.myEnv.getProject());
                AndroidNativeAppDebugProcess androidNativeAppDebugProcess = result;
                if (androidNativeAppDebugProcess == null) {
                    3.$$$reportNull$$$0(3);
                }
                return androidNativeAppDebugProcess;
            }

            @NotNull
            protected Project getProject() {
                Project project = ConnectLLDBTask.this.myEnv.getProject();
                if (project == null) {
                    3.$$$reportNull$$$0(4);
                }
                return project;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 3: 
                    case 4: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 3: 
                    case 4: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "state";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "session";
                        break;
                    }
                    case 3: 
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/android/tools/ndk/run/lldb/ConnectLLDBTask$3";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/android/tools/ndk/run/lldb/ConnectLLDBTask$3";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createDebugProcess";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getProject";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "createProcess";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "createDebugProcess";
                        break;
                    }
                    case 3: 
                    case 4: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 3: 
                    case 4: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        });
        printer.stdout("Now Launching Native Debug Session");
        this.myProgressReporter.step("Launching debug session");
        XDebugSessionImpl xDebugSession = (XDebugSessionImpl)cidrRunner.startDebugSession(cidrState, env, false, new XDebugSessionListener[0]);
        ProcessHandler oldProcessHandler = launchStatus.getProcessHandler();
        ProcessHandler newProcessHandler = xDebugSession.getRunContentDescriptor().getProcessHandler();
        if (newProcessHandler == null) {
            throw new ExecutionException("Cannot start debugging - null process handler.");
        }
        AndroidSessionInfo oldInfo = (AndroidSessionInfo)oldProcessHandler.getUserData(AndroidSessionInfo.KEY);
        if (oldInfo != null) {
            newInfo = new AndroidSessionInfo(newProcessHandler, oldInfo.getDescriptor(), oldInfo.getRunConfigurationId(), oldInfo.getExecutorId(), oldInfo.getExecutorActionName(), oldInfo.isInstantRun());
        } else {
            RunProfile runProfile = env.getRunProfile();
            int uniqueId = runProfile instanceof RunConfigurationBase ? ((RunConfigurationBase)runProfile).getUniqueID() : -1;
            newInfo = new AndroidSessionInfo(newProcessHandler, xDebugSession.getRunContentDescriptor(), uniqueId, env.getExecutor().getId(), env.getExecutor().getActionName(), InstantRunUtils.isInstantRunEnabled((ExecutionEnvironment)env));
        }
        newProcessHandler.putUserData(AndroidSessionInfo.KEY, (Object)newInfo);
        launchStatus.setProcessHandler(newProcessHandler);
        printer.setProcessHandler(newProcessHandler);
        oldProcessHandler.detachProcess();
        AndroidProcessText oldText = AndroidProcessText.get((ProcessHandler)oldProcessHandler);
        if (oldText != null) {
            oldText.printTo(newProcessHandler);
        }
        xDebugSession.showSessionTab();
        return newProcessHandler;
    }

    @NotNull
    private String getPrettyConfigurationName(@NotNull Client client) {
        if (client == null) {
            ConnectLLDBTask.$$$reportNull$$$0(65);
        }
        LinkedList items = Lists.newLinkedList();
        items.add(this.myRunConfigTypeId);
        items.add(this.myDebugger.getId());
        if (client.getClientData().isNativeDebuggable()) {
            items.add("java_aware_cpp");
        }
        String string = StringUtil.join((Collection)items, (String)":");
        if (string == null) {
            ConnectLLDBTask.$$$reportNull$$$0(66);
        }
        return string;
    }

    private void onLaunchFailure(@NotNull LaunchStatus launchStatus, @NotNull Client client, @NotNull String message, @NotNull Throwable e) {
        if (launchStatus == null) {
            ConnectLLDBTask.$$$reportNull$$$0(67);
        }
        if (client == null) {
            ConnectLLDBTask.$$$reportNull$$$0(68);
        }
        if (message == null) {
            ConnectLLDBTask.$$$reportNull$$$0(69);
        }
        if (e == null) {
            ConnectLLDBTask.$$$reportNull$$$0(70);
        }
        launchStatus.terminateLaunch(message);
        LOG.warn(message, e);
        LLDBUsageTracker.sessionFailed(e, this.mySessionId, 0L, 1L);
        this.myProgressReporter.finish();
        ConnectLLDBTask.forceStopActivity(client);
    }

    private static void forceStopActivity(@NotNull Client client) {
        if (client == null) {
            ConnectLLDBTask.$$$reportNull$$$0(71);
        }
        String packageName = client.getClientData().getClientDescription();
        try {
            IDevice device = client.getDevice();
            CollectingOutputReceiver receiver = new CollectingOutputReceiver();
            device.executeShellCommand("am force-stop " + packageName, (IShellOutputReceiver)receiver);
        }
        catch (Exception e) {
            LOG.info("Failed to force-stop activity " + packageName, (Throwable)e);
        }
    }

    @NotNull
    private List<String> getStartupCommands(@NotNull Client client, @NotNull ProcessHandlerConsolePrinter printer) {
        if (client == null) {
            ConnectLLDBTask.$$$reportNull$$$0(72);
        }
        if (printer == null) {
            ConnectLLDBTask.$$$reportNull$$$0(73);
        }
        List<String> list = Stream.concat(this.myNativeDebugger.getStartupCommands(this.myFacet, client, printer).stream(), this.myDebuggerState.getUserStartupCommands().stream()).collect(Collectors.toList());
        if (list == null) {
            ConnectLLDBTask.$$$reportNull$$$0(74);
        }
        return list;
    }

    @NotNull
    private List<String> getPostAttachCommands(@NotNull Client client) {
        if (client == null) {
            ConnectLLDBTask.$$$reportNull$$$0(75);
        }
        List<String> list = Stream.concat(this.myNativeDebugger.getPostAttachCommands(this.myFacet, client).stream(), this.myDebuggerState.getUserPostAttachCommands().stream()).collect(Collectors.toList());
        if (list == null) {
            ConnectLLDBTask.$$$reportNull$$$0(76);
        }
        return list;
    }

    private boolean debuggerTypeChosenByAuto() {
        return this.myDebuggerState instanceof AutoAndroidDebuggerState;
    }

    private AndroidStudioEvent.DebuggerType getDebuggerType() {
        if (this.myDebugger instanceof HybridAndroidDebugger) {
            return AndroidStudioEvent.DebuggerType.HYBRID;
        }
        if (this.myDebugger instanceof NativeAndroidDebugger) {
            return AndroidStudioEvent.DebuggerType.NATIVE;
        }
        return AndroidStudioEvent.DebuggerType.UNKNOWN_DEBUGGER_TYPE;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 16: 
            case 23: 
            case 24: 
            case 25: 
            case 32: 
            case 38: 
            case 45: 
            case 50: 
            case 55: 
            case 59: 
            case 66: 
            case 74: 
            case 76: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 16: 
            case 23: 
            case 24: 
            case 25: 
            case 32: 
            case 38: 
            case 45: 
            case 50: 
            case 55: 
            case 59: 
            case 66: 
            case 74: 
            case 76: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "applicationIds";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugger";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runConfigTypeId";
                break;
            }
            case 6: 
            case 10: 
            case 11: 
            case 13: 
            case 18: 
            case 27: 
            case 33: 
            case 40: 
            case 46: 
            case 48: 
            case 49: 
            case 51: 
            case 57: 
            case 61: 
            case 65: 
            case 68: 
            case 71: 
            case 72: 
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "client";
                break;
            }
            case 7: 
            case 15: 
            case 22: 
            case 31: 
            case 37: 
            case 44: 
            case 54: 
            case 64: 
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "printer";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "starterType";
                break;
            }
            case 9: 
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 12: 
            case 56: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentLaunchInfo";
                break;
            }
            case 14: 
            case 21: 
            case 30: 
            case 36: 
            case 43: 
            case 63: 
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "launchStatus";
                break;
            }
            case 16: 
            case 23: 
            case 24: 
            case 25: 
            case 32: 
            case 38: 
            case 45: 
            case 50: 
            case 55: 
            case 59: 
            case 66: 
            case 74: 
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/ndk/run/lldb/ConnectLLDBTask";
                break;
            }
            case 17: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "device";
                break;
            }
            case 19: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clientABIs";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 26: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sessionStarter";
                break;
            }
            case 28: 
            case 34: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serverPath";
                break;
            }
            case 29: 
            case 35: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startScriptPath";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jdwpConnector";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sessionStarterType";
                break;
            }
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/ndk/run/lldb/ConnectLLDBTask";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "createPtraceScopeTempFile";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "newSessionStarter";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "newShellSessionStarter";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "newRunAsSessionStarter";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "newInjectorSessionStarter";
                break;
            }
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "getClientABIs";
                break;
            }
            case 55: {
                objectArray = objectArray2;
                objectArray2[1] = "newRunParameters";
                break;
            }
            case 59: {
                objectArray = objectArray2;
                objectArray2[1] = "newJdwpConnector";
                break;
            }
            case 66: {
                objectArray = objectArray2;
                objectArray2[1] = "getPrettyConfigurationName";
                break;
            }
            case 74: {
                objectArray = objectArray2;
                objectArray2[1] = "getStartupCommands";
                break;
            }
            case 76: {
                objectArray = objectArray2;
                objectArray2[1] = "getPostAttachCommands";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isReadyForDebugging";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "needsJdwpConnector";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "appendDualDebuggerMessage";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "hasBrokenNdkABI";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "maybeShowBrokenNdkMessage";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "launchDebugger";
                break;
            }
            case 16: 
            case 23: 
            case 24: 
            case 25: 
            case 32: 
            case 38: 
            case 45: 
            case 50: 
            case 55: 
            case 59: 
            case 66: 
            case 74: 
            case 76: {
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getPtraceScope";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "newSessionStarter";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "resumeVMOnSessionStarted";
                break;
            }
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "newShellSessionStarter";
                break;
            }
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "newRunAsSessionStarter";
                break;
            }
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "newInjectorSessionStarter";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "isRunAsOK";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "isRootedDevice";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "getClientAddressByteSize";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "getClientABIs";
                break;
            }
            case 51: 
            case 52: 
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "newRunParameters";
                break;
            }
            case 56: 
            case 57: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "newJdwpConnector";
                break;
            }
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "launchCidrDebugger";
                break;
            }
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "getPrettyConfigurationName";
                break;
            }
            case 67: 
            case 68: 
            case 69: 
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "onLaunchFailure";
                break;
            }
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "forceStopActivity";
                break;
            }
            case 72: 
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "getStartupCommands";
                break;
            }
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "getPostAttachCommands";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 16: 
            case 23: 
            case 24: 
            case 25: 
            case 32: 
            case 38: 
            case 45: 
            case 50: 
            case 55: 
            case 59: 
            case 66: 
            case 74: 
            case 76: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum SessionStarterType {
        ROOT_SHELL,
        RUN_AS_SHELL,
        INJECTOR,
        INJECTOR_YAMA;

    }
}

