/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.run.lldb;

import com.android.ddmlib.Client;
import com.android.tools.idea.run.ConsolePrinter;
import com.android.tools.idea.run.util.ProcessHandlerLaunchStatus;
import com.android.tools.ndk.run.ProgressReporter;
import com.android.tools.ndk.run.editor.NativeAndroidDebuggerState;
import com.android.tools.ndk.run.jdwp.CodeInjection;
import com.android.tools.ndk.run.jdwp.JdwpConnector;
import com.android.tools.ndk.run.lldb.SessionStarter;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import org.jetbrains.annotations.NotNull;

public class InjectorSessionStarterImpl
extends SessionStarter {
    private static final Logger LOG = Logger.getInstance(InjectorSessionStarterImpl.class);
    private static final long PR_SET_PTRACER = 1499557217L;
    private final JdwpConnector myJdwpConnector;
    private CodeInjection myCodeInjection;
    private final boolean myRestrictedPtraceScope;
    private final int myPid;

    public InjectorSessionStarterImpl(@NotNull JdwpConnector jdwpConnector, @NotNull Client client, boolean restrictedPtraceScope, @NotNull File localServerFile, @NotNull File localStartScriptFile, @NotNull NativeAndroidDebuggerState debuggerState, @NotNull ProgressReporter progressReporter, @NotNull ProcessHandlerLaunchStatus launchStatus, @NotNull ConsolePrinter printer) throws ExecutionException {
        if (jdwpConnector == null) {
            InjectorSessionStarterImpl.$$$reportNull$$$0(0);
        }
        if (client == null) {
            InjectorSessionStarterImpl.$$$reportNull$$$0(1);
        }
        if (localServerFile == null) {
            InjectorSessionStarterImpl.$$$reportNull$$$0(2);
        }
        if (localStartScriptFile == null) {
            InjectorSessionStarterImpl.$$$reportNull$$$0(3);
        }
        if (debuggerState == null) {
            InjectorSessionStarterImpl.$$$reportNull$$$0(4);
        }
        if (progressReporter == null) {
            InjectorSessionStarterImpl.$$$reportNull$$$0(5);
        }
        if (launchStatus == null) {
            InjectorSessionStarterImpl.$$$reportNull$$$0(6);
        }
        if (printer == null) {
            InjectorSessionStarterImpl.$$$reportNull$$$0(7);
        }
        super(client, localServerFile, localStartScriptFile, debuggerState, progressReporter, launchStatus, printer);
        this.myJdwpConnector = jdwpConnector;
        this.myRestrictedPtraceScope = restrictedPtraceScope;
        this.myPid = client.getClientData().getPid();
    }

    @Override
    public void pushFilesToDevice() throws ExecutionException {
        super.pushFilesToDevice();
        String lldbServerTempPath = this.myServerTempFile.getFilePath();
        String lldbServerAppPath = this.getTargetBinFilePath(this.myLocalServerFile.getName());
        String startLldbServerTempPath = this.myStartScriptTempFile.getFilePath();
        String startLldbServerAppPath = this.getStartScriptTargetPath();
        StringBuilder codeFragment = new StringBuilder().append("java.io.File lldbBinDir = new java.io.File(\"").append(this.getTargetBinDirectory()).append("\");\n").append("lldbBinDir.mkdirs();\n").append("java.io.File serverFile = new java.io.File(\"").append(lldbServerAppPath).append("\");\n");
        if (this.myServerTempFile.getLastModified() > 0L) {
            codeFragment.append("if (!(serverFile.exists() && serverFile.lastModified()>=").append(this.myServerTempFile.getLastModified()).append("L))");
        }
        codeFragment.append("{\n").append("  java.lang.ProcessBuilder pb1 = new java.lang.ProcessBuilder(\"sh\", \"-c\",\"cat ").append(lldbServerTempPath).append(">").append(lldbServerAppPath).append(" && chmod 700 ").append(lldbServerAppPath).append(";\");\n").append("  pb1.directory(lldbBinDir).start().waitFor();\n").append("}\n").append("java.io.File startScriptFile = new java.io.File(\"").append(startLldbServerAppPath).append("\");\n");
        if (this.myStartScriptTempFile.getLastModified() > 0L) {
            codeFragment.append("if (!(startScriptFile.exists() && startScriptFile.lastModified()>=").append(this.myStartScriptTempFile.getLastModified()).append("L))");
        }
        codeFragment.append("{\n").append("  java.lang.ProcessBuilder pb2 = new java.lang.ProcessBuilder(\"sh\", \"-c\",\"cat ").append(startLldbServerTempPath).append(">").append(startLldbServerAppPath).append(" && chmod 700 ").append(startLldbServerAppPath).append(";\");\n").append("  pb2.directory(lldbBinDir).start().waitFor();\n").append("}\n").append("java.lang.ProcessBuilder pb3 = new java.lang.ProcessBuilder(\"sh\", \"-c\",\"").append(StringUtil.escapeQuotes((String)this.getStartCommandLine())).append("\");\n").append("pb3.directory(lldbBinDir).start();\n");
        if (this.myRestrictedPtraceScope) {
            codeFragment.append(String.format("android.system.Os.prctl(%d, %dL, 0, 0, 0);\n", 1499557217L, this.myPid));
        }
        this.myCodeInjection = this.myJdwpConnector.injectCodeFragment(codeFragment.toString());
    }

    @Override
    protected void internalStartServer() throws ExecutionException {
        LOG.info("Starting LLDB server using code injection");
        this.myPrinter.stdout("Starting LLDB server using code injection");
        this.myJdwpConnector.Connect();
        ProcessHandler processHandler = this.myLaunchStatus.getProcessHandler();
        ProcessAdapter processListener = new ProcessAdapter(){

            public void processTerminated(@NotNull ProcessEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                super.processTerminated(event);
                InjectorSessionStarterImpl.this.myCodeInjection.cancel();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/android/tools/ndk/run/lldb/InjectorSessionStarterImpl$1", "processTerminated"));
            }
        };
        try {
            processHandler.addProcessListener((ProcessListener)processListener);
            this.myCodeInjection.waitForInjection();
        }
        finally {
            processHandler.removeProcessListener((ProcessListener)processListener);
        }
    }

    @Override
    public void sessionStarted() throws ExecutionException {
        this.myCodeInjection.resume();
        super.sessionStarted();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "jdwpConnector";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "client";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "localServerFile";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "localStartScriptFile";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[0] = "debuggerState";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[0] = "progressReporter";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[0] = "launchStatus";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[0] = "printer";
                break;
            }
        }
        objectArray[1] = "com/android/tools/ndk/run/lldb/InjectorSessionStarterImpl";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

