/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.run.lldb;

import com.android.ddmlib.IDevice;
import com.android.tools.analytics.Percentiles;
import com.android.tools.analytics.UsageTracker;
import com.android.tools.idea.diagnostics.crash.StudioExceptionReport;
import com.android.tools.idea.stats.AndroidStudioUsageTracker;
import com.android.tools.ndk.run.AndroidNativeDeviceException;
import com.android.tools.ndk.run.lldb.ConnectLLDBTask;
import com.android.tools.ndk.run.lldb.LLDBSdkPkgInstaller;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.LLDBFrontendDetails;
import com.google.wireless.android.sdk.stats.LldbPercentileEstimator;
import com.google.wireless.android.sdk.stats.LldbPerformanceStats;
import com.google.wireless.android.sdk.stats.LldbSessionEndDetails;
import com.google.wireless.android.sdk.stats.LldbSessionStartDetails;
import com.intellij.concurrency.JobScheduler;
import com.intellij.ide.AppLifecycleListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.jetbrains.cidr.execution.debugger.backend.lldb.LLDBDriverException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LLDBUsageTracker {
    private static final Object TIMINGS_LOCK = new Object();
    private static final double[] ESTIMATION_TARGETS = new double[]{0.5, 0.9, 0.99};
    private static final int NUM_RAW_SAMPLES = 80;
    private static final int INTERVAL_MINUTES = 60;
    private static final int INITIAL_DELAY_MINUTES = 60;
    private static HashMap<LldbPercentileEstimator.Metric, Percentiles> ourEstimators = new HashMap();
    private static final ImmutableSet<Class<? extends Throwable>> THROWABLE_CLASSES_TO_TRACK_MESSAGES;

    @NotNull
    private static String getExceptionDescription(@Nullable Throwable e) {
        if (e == null) {
            if ("" == null) {
                LLDBUsageTracker.$$$reportNull$$$0(0);
            }
            return "";
        }
        Throwable cause = StudioExceptionReport.getRootCause((Throwable)e);
        if (THROWABLE_CLASSES_TO_TRACK_MESSAGES.contains(cause.getClass())) {
            String string = Strings.nullToEmpty((String)cause.getMessage());
            if (string == null) {
                LLDBUsageTracker.$$$reportNull$$$0(1);
            }
            return string;
        }
        String string = StudioExceptionReport.getDescription((Throwable)e);
        if (string == null) {
            LLDBUsageTracker.$$$reportNull$$$0(2);
        }
        return string;
    }

    private static void log(AndroidStudioEvent.Builder studioEventBuilder) {
        UsageTracker.getInstance().log(studioEventBuilder);
    }

    private static AndroidStudioEvent.Builder newBuilder(AndroidStudioEvent.EventKind eventKind) {
        return AndroidStudioEvent.newBuilder().setCategory(AndroidStudioEvent.EventCategory.LLDB).setKind(eventKind);
    }

    @NotNull
    private static LldbSessionStartDetails.StarterType convertStarterType(ConnectLLDBTask.SessionStarterType type) {
        switch (type) {
            case INJECTOR: 
            case INJECTOR_YAMA: {
                LldbSessionStartDetails.StarterType starterType = LldbSessionStartDetails.StarterType.INJECTOR_STARTER_TYPE;
                if (starterType == null) {
                    LLDBUsageTracker.$$$reportNull$$$0(3);
                }
                return starterType;
            }
            case ROOT_SHELL: {
                LldbSessionStartDetails.StarterType starterType = LldbSessionStartDetails.StarterType.ROOT_SHELL_STARTER_TYPE;
                if (starterType == null) {
                    LLDBUsageTracker.$$$reportNull$$$0(4);
                }
                return starterType;
            }
            case RUN_AS_SHELL: {
                LldbSessionStartDetails.StarterType starterType = LldbSessionStartDetails.StarterType.RUN_AS_SHELL_STARTER_TYPE;
                if (starterType == null) {
                    LLDBUsageTracker.$$$reportNull$$$0(5);
                }
                return starterType;
            }
        }
        throw new IllegalArgumentException("Could not convert unknown starter type : " + (Object)((Object)type));
    }

    public static void sessionStarted(@NotNull IDevice device, AndroidStudioEvent.DebuggerType debuggerType, String sessionId, boolean chosenByAuto, ConnectLLDBTask.SessionStarterType starterType) {
        if (device == null) {
            LLDBUsageTracker.$$$reportNull$$$0(6);
        }
        LLDBUsageTracker.log(LLDBUsageTracker.newBuilder(AndroidStudioEvent.EventKind.LLDB_SESSION_STARTED).setLldbSessionStartDetails(LldbSessionStartDetails.newBuilder().setAutoDebugger(chosenByAuto).setStarterType(LLDBUsageTracker.convertStarterType(starterType)).setDebugSessionId(sessionId).setDebuggerType(debuggerType).setDeviceInfo(AndroidStudioUsageTracker.deviceToDeviceInfo((IDevice)device)).setLldbVersion(LLDBSdkPkgInstaller.PINNED_REVISION.toString())));
    }

    /*
     * WARNING - void declaration
     */
    public static void sessionStopped(@NotNull String sessionId, long stops, long l) {
        void errors;
        if (sessionId == null) {
            LLDBUsageTracker.$$$reportNull$$$0(7);
        }
        LLDBUsageTracker.log(LLDBUsageTracker.newBuilder(AndroidStudioEvent.EventKind.LLDB_SESSION_ENDED).setLldbSessionEndDetails(LldbSessionEndDetails.newBuilder().setDebugSessionId(sessionId).setStops(stops).setErrors((long)errors)));
    }

    /*
     * WARNING - void declaration
     */
    public static void sessionFailed(@NotNull Throwable e, @NotNull String sessionId, long stops, long l) {
        void errors;
        if (e == null) {
            LLDBUsageTracker.$$$reportNull$$$0(8);
        }
        if (sessionId == null) {
            LLDBUsageTracker.$$$reportNull$$$0(9);
        }
        LLDBUsageTracker.sessionFailed(LLDBUsageTracker.getExceptionDescription(e), sessionId, stops, (long)errors);
    }

    /*
     * WARNING - void declaration
     */
    public static void sessionFailed(@NotNull String error, @NotNull String sessionId, long stops, long l) {
        void errors;
        if (error == null) {
            LLDBUsageTracker.$$$reportNull$$$0(10);
        }
        if (sessionId == null) {
            LLDBUsageTracker.$$$reportNull$$$0(11);
        }
        LLDBUsageTracker.log(LLDBUsageTracker.newBuilder(AndroidStudioEvent.EventKind.LLDB_SESSION_ENDED).setLldbSessionEndDetails(LldbSessionEndDetails.newBuilder().setDebugSessionId(sessionId).setStops(stops).setErrors((long)errors).setFailureMessage(error)));
    }

    public static void installStarted() {
        LLDBUsageTracker.log(LLDBUsageTracker.newBuilder(AndroidStudioEvent.EventKind.LLDB_INSTALL_STARTED));
    }

    public static void installFailed(@Nullable Throwable e) {
        LLDBUsageTracker.log(LLDBUsageTracker.newBuilder(AndroidStudioEvent.EventKind.LLDB_INSTALL_FAILED).setLldbSessionFailureMessage(LLDBUsageTracker.getExceptionDescription(e)));
    }

    public static void sessionUsedWatchpoints() {
        LLDBUsageTracker.log(LLDBUsageTracker.newBuilder(AndroidStudioEvent.EventKind.LLDB_SESSION_USED_WATCHPOINTS));
    }

    public static void frontendExited(int exitCode) {
        LLDBUsageTracker.log(LLDBUsageTracker.newBuilder(AndroidStudioEvent.EventKind.LLDB_FRONTEND_EXITED).setLldbFrontendDetails(LLDBFrontendDetails.newBuilder().setExitCode(exitCode)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void logAndResetPerformanceStats() {
        HashMap<LldbPercentileEstimator.Metric, Percentiles> estimators;
        HashMap newEstimators = new HashMap();
        Object object = TIMINGS_LOCK;
        synchronized (object) {
            estimators = ourEstimators;
            ourEstimators = newEstimators;
        }
        if (estimators != null) {
            LLDBUsageTracker.logPerformanceStats(estimators);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void storeLldbActionTime(LldbPercentileEstimator.Metric m, double sample) {
        Object object = TIMINGS_LOCK;
        synchronized (object) {
            Percentiles p = ourEstimators.get(m);
            if (p == null) {
                p = new Percentiles(ESTIMATION_TARGETS, 80);
                ourEstimators.put(m, p);
            }
            p.addSample(sample);
        }
    }

    private static void logPerformanceStats(@NotNull Map<LldbPercentileEstimator.Metric, Percentiles> estimators) {
        if (estimators == null) {
            LLDBUsageTracker.$$$reportNull$$$0(12);
        }
        if (estimators.isEmpty()) {
            return;
        }
        AndroidStudioEvent.Builder builder = AndroidStudioEvent.newBuilder();
        builder.setCategory(AndroidStudioEvent.EventCategory.LLDB).setKind(AndroidStudioEvent.EventKind.LLDB_PERFORMANCE_STATS);
        LldbPerformanceStats.Builder stats = builder.getLldbPerformanceStatsBuilder();
        for (Map.Entry<LldbPercentileEstimator.Metric, Percentiles> e : estimators.entrySet()) {
            stats.addEstimatorBuilder().setMetric(e.getKey()).setEstimator(e.getValue().export());
        }
        LLDBUsageTracker.log(builder);
    }

    static {
        Application application = ApplicationManager.getApplication();
        application.getMessageBus().connect((Disposable)application).subscribe(AppLifecycleListener.TOPIC, (Object)new AppLifecycleListener(){

            public void appClosing() {
                LLDBUsageTracker.logAndResetPerformanceStats();
            }
        });
        JobScheduler.getScheduler().scheduleWithFixedDelay(LLDBUsageTracker::logAndResetPerformanceStats, 60L, 60L, TimeUnit.MINUTES);
        THROWABLE_CLASSES_TO_TRACK_MESSAGES = ImmutableSet.of(AndroidNativeDeviceException.class, LLDBDriverException.class);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/ndk/run/lldb/LLDBUsageTracker";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "device";
                break;
            }
            case 7: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sessionId";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "error";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "estimators";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getExceptionDescription";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "convertStarterType";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/ndk/run/lldb/LLDBUsageTracker";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "sessionStarted";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "sessionStopped";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "sessionFailed";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "logPerformanceStats";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

