/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.run.lldb;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.vfs.DeprecatedVirtualFileSystem;
import com.intellij.openapi.vfs.NonPhysicalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.testFramework.LightVirtualFile;
import com.jetbrains.cidr.execution.debugger.disasm.DisasmFileType;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LocatableLightVfs
extends DeprecatedVirtualFileSystem
implements NonPhysicalFileSystem {
    private static final Logger LOG = Logger.getInstance(LocatableLightVfs.class);
    private final Map<String, LocatableLightVirtualFile> myFileMap = new HashMap<String, LocatableLightVirtualFile>();
    private static final String PROTOCOL = "locatable_light";

    public static LocatableLightVfs getInstance() {
        return (LocatableLightVfs)VirtualFileManager.getInstance().getFileSystem(PROTOCOL);
    }

    @NotNull
    public String getProtocol() {
        if (PROTOCOL == null) {
            LocatableLightVfs.$$$reportNull$$$0(0);
        }
        return PROTOCOL;
    }

    @Nullable
    public static LocatableLightVirtualFile create(@NotNull String name) {
        if (name == null) {
            LocatableLightVfs.$$$reportNull$$$0(1);
        }
        return LocatableLightVfs.getInstance().createFile(name);
    }

    @Nullable
    private synchronized LocatableLightVirtualFile createFile(@NotNull String name) {
        if (name == null) {
            LocatableLightVfs.$$$reportNull$$$0(2);
        }
        if (name.isEmpty()) {
            LOG.warn("Attempt to create a file with empty name");
            return null;
        }
        String keyName = '/' + name;
        if (this.myFileMap.containsKey(keyName)) {
            for (int counter = 2; counter < 1000; ++counter) {
                String dedupKeyName = keyName + " (" + counter + ')';
                if (this.myFileMap.containsKey(dedupKeyName)) continue;
                LocatableLightVirtualFile res = new LocatableLightVirtualFile(name + " (" + counter + ')');
                this.myFileMap.put(dedupKeyName, res);
                return res;
            }
            LOG.warn("Giving up creating locatable light virtual file with name \"" + name + '\"');
            return null;
        }
        LocatableLightVirtualFile res = new LocatableLightVirtualFile(name);
        this.myFileMap.put(keyName, res);
        return res;
    }

    @Nullable
    public synchronized VirtualFile findFileByPath(@NotNull String path) {
        if (path == null) {
            LocatableLightVfs.$$$reportNull$$$0(3);
        }
        return (VirtualFile)this.myFileMap.get(path);
    }

    public synchronized void deleteFile(Object requestor, @NotNull VirtualFile file) {
        if (file == null) {
            LocatableLightVfs.$$$reportNull$$$0(4);
        }
        this.myFileMap.remove(file.getPath());
    }

    public void refresh(boolean asynchronous) {
    }

    @Nullable
    public VirtualFile refreshAndFindFileByPath(@NotNull String path) {
        if (path == null) {
            LocatableLightVfs.$$$reportNull$$$0(5);
        }
        return this.findFileByPath(path);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/ndk/run/lldb/LocatableLightVfs";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getProtocol";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/ndk/run/lldb/LocatableLightVfs";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createFile";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findFileByPath";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "deleteFile";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "refreshAndFindFileByPath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class LocatableLightVirtualFile
    extends LightVirtualFile {
        private LocatableLightVirtualFile(String name) {
            super(name, (FileType)DisasmFileType.INSTANCE, (CharSequence)"");
        }

        @NotNull
        public LocatableLightVfs getFileSystem() {
            LocatableLightVfs locatableLightVfs = LocatableLightVfs.getInstance();
            if (locatableLightVfs == null) {
                LocatableLightVirtualFile.$$$reportNull$$$0(0);
            }
            return locatableLightVfs;
        }

        public void delete(Object requestor) {
            LocatableLightVfs.getInstance().deleteFile(requestor, (VirtualFile)this);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/ndk/run/lldb/LocatableLightVfs$LocatableLightVirtualFile", "getFileSystem"));
        }
    }
}

