/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.run.lldb;

import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.Client;
import com.android.ddmlib.CollectingOutputReceiver;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.ShellCommandUnresponsiveException;
import com.android.ddmlib.SyncException;
import com.android.ddmlib.SyncService;
import com.android.ddmlib.TimeoutException;
import com.android.tools.idea.run.ConsolePrinter;
import com.android.tools.idea.run.util.ProcessHandlerLaunchStatus;
import com.android.tools.ndk.run.ProgressReporter;
import com.android.tools.ndk.run.editor.NativeAndroidDebuggerState;
import com.google.common.collect.Lists;
import com.intellij.execution.ExecutionException;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public abstract class SessionStarter {
    private static final Logger LOG = Logger.getInstance(SessionStarter.class);
    protected final IDevice myDevice;
    private final NativeAndroidDebuggerState myDebuggerState;
    private final String myPlatformSocketName;
    private final ProgressReporter myProgressReporter;
    protected final ProcessHandlerLaunchStatus myLaunchStatus;
    protected final ConsolePrinter myPrinter;
    protected final File myLocalServerFile;
    private final File myLocalStartScriptFile;
    private final String myTargetDataDir;
    private final String myTargetSocketDir;
    protected FileStat myServerTempFile;
    protected FileStat myStartScriptTempFile;
    private final List<EventListener> myEventListeners;
    private boolean mySessionStarted;

    protected SessionStarter(@NotNull IDevice device, @NotNull String targetDataDir, @NotNull String targetSocketDir, @NotNull File localServerFile, @NotNull File localStartScriptFile, @NotNull NativeAndroidDebuggerState debuggerState, @NotNull ProgressReporter progressReporter, @NotNull ProcessHandlerLaunchStatus launchStatus, @NotNull ConsolePrinter printer) throws ExecutionException {
        if (device == null) {
            SessionStarter.$$$reportNull$$$0(0);
        }
        if (targetDataDir == null) {
            SessionStarter.$$$reportNull$$$0(1);
        }
        if (targetSocketDir == null) {
            SessionStarter.$$$reportNull$$$0(2);
        }
        if (localServerFile == null) {
            SessionStarter.$$$reportNull$$$0(3);
        }
        if (localStartScriptFile == null) {
            SessionStarter.$$$reportNull$$$0(4);
        }
        if (debuggerState == null) {
            SessionStarter.$$$reportNull$$$0(5);
        }
        if (progressReporter == null) {
            SessionStarter.$$$reportNull$$$0(6);
        }
        if (launchStatus == null) {
            SessionStarter.$$$reportNull$$$0(7);
        }
        if (printer == null) {
            SessionStarter.$$$reportNull$$$0(8);
        }
        this.myEventListeners = Lists.newLinkedList();
        this.mySessionStarted = false;
        this.myDevice = device;
        this.myDebuggerState = debuggerState;
        this.myPlatformSocketName = String.format("platform-%d.sock", System.currentTimeMillis());
        this.myProgressReporter = progressReporter;
        this.myLaunchStatus = launchStatus;
        this.myPrinter = printer;
        this.myLocalServerFile = localServerFile;
        this.myLocalStartScriptFile = localStartScriptFile;
        this.myTargetDataDir = targetDataDir;
        this.myTargetSocketDir = targetSocketDir;
    }

    protected SessionStarter(@NotNull Client client, @NotNull File localServerFile, @NotNull File localStartScriptFile, @NotNull NativeAndroidDebuggerState debuggerState, @NotNull ProgressReporter progressReporter, @NotNull ProcessHandlerLaunchStatus launchStatus, @NotNull ConsolePrinter printer) throws ExecutionException {
        if (client == null) {
            SessionStarter.$$$reportNull$$$0(9);
        }
        if (localServerFile == null) {
            SessionStarter.$$$reportNull$$$0(10);
        }
        if (localStartScriptFile == null) {
            SessionStarter.$$$reportNull$$$0(11);
        }
        if (debuggerState == null) {
            SessionStarter.$$$reportNull$$$0(12);
        }
        if (progressReporter == null) {
            SessionStarter.$$$reportNull$$$0(13);
        }
        if (launchStatus == null) {
            SessionStarter.$$$reportNull$$$0(14);
        }
        if (printer == null) {
            SessionStarter.$$$reportNull$$$0(15);
        }
        this(client.getDevice(), client.getClientData().getDataDir(), SessionStarter.getHelpfullyNamedSocketDirectory(client), localServerFile, localStartScriptFile, debuggerState, progressReporter, launchStatus, printer);
    }

    public void pushFilesToDevice() throws ExecutionException {
        LOG.info("Pushing files to device");
        this.myProgressReporter.step("Pushing files to device");
        try (SyncService syncService = null;){
            syncService = this.myDevice.getSyncService();
            if (syncService == null) {
                throw new ExecutionException("Failed to get SyncService");
            }
            this.myServerTempFile = this.pushDebuggerFile(syncService, this.myLocalServerFile);
            this.myStartScriptTempFile = this.pushDebuggerFile(syncService, this.myLocalStartScriptFile);
        }
    }

    @NotNull
    public List<Attachment> getLogFilesFromDevice() {
        String[] files = new String[]{"gdb-server.log", "platform.log"};
        ArrayList<Attachment> result = new ArrayList<Attachment>(files.length);
        for (String targetFile : files) {
            String contents;
            String targetPath = this.getTargetLogFilePath(targetFile);
            try {
                CollectingOutputReceiver receiver = new CollectingOutputReceiver();
                this.myDevice.executeShellCommand("cat '" + targetPath + "'", (IShellOutputReceiver)receiver, 30L, TimeUnit.SECONDS);
                contents = receiver.getOutput();
            }
            catch (Exception e) {
                contents = e.toString();
            }
            result.add(new Attachment(targetPath, contents));
        }
        ArrayList<Attachment> arrayList = result;
        if (arrayList == null) {
            SessionStarter.$$$reportNull$$$0(16);
        }
        return arrayList;
    }

    public String startServer() throws ExecutionException {
        this.myProgressReporter.step("Starting LLDB server");
        this.internalStartServer();
        return this.getConnectUrl();
    }

    protected abstract void internalStartServer() throws ExecutionException;

    @NotNull
    protected String getStartCommandLine() {
        String string = String.format("%s %s %s %s %s \"%s\"", this.getStartScriptTargetPath(), this.getTargetRootDirectory(), "unix-abstract", this.myTargetSocketDir, this.myPlatformSocketName, this.myDebuggerState.getTargetLoggingChannels());
        if (string == null) {
            SessionStarter.$$$reportNull$$$0(17);
        }
        return string;
    }

    @NotNull
    private String getConnectUrl() {
        String string = String.format("%s-connect://[%s]%s/%s", "unix-abstract", this.myDevice.getSerialNumber(), this.myTargetSocketDir, this.myPlatformSocketName);
        if (string == null) {
            SessionStarter.$$$reportNull$$$0(18);
        }
        return string;
    }

    @NotNull
    protected String getTargetRootDirectory() {
        String string = SessionStarter.joinPaths(this.myTargetDataDir, "lldb");
        if (string == null) {
            SessionStarter.$$$reportNull$$$0(19);
        }
        return string;
    }

    @NotNull
    protected String getTargetBinDirectory() {
        String string = SessionStarter.joinPaths(this.getTargetRootDirectory(), "bin");
        if (string == null) {
            SessionStarter.$$$reportNull$$$0(20);
        }
        return string;
    }

    @NotNull
    private String getTargetLogFilePath(@NotNull String file) {
        if (file == null) {
            SessionStarter.$$$reportNull$$$0(21);
        }
        String string = SessionStarter.joinPaths(this.getTargetRootDirectory(), "log", file);
        if (string == null) {
            SessionStarter.$$$reportNull$$$0(22);
        }
        return string;
    }

    @NotNull
    protected String getTargetBinFilePath(@NotNull String filePath) {
        if (filePath == null) {
            SessionStarter.$$$reportNull$$$0(23);
        }
        String string = SessionStarter.joinPaths(this.getTargetBinDirectory(), filePath);
        if (string == null) {
            SessionStarter.$$$reportNull$$$0(24);
        }
        return string;
    }

    @NotNull
    protected String getStartScriptTargetPath() {
        String string = this.getTargetBinFilePath("start_lldb_server.sh");
        if (string == null) {
            SessionStarter.$$$reportNull$$$0(25);
        }
        return string;
    }

    @NotNull
    protected static String joinPaths(String ... paths) {
        if (paths == null) {
            SessionStarter.$$$reportNull$$$0(26);
        }
        String string = StringUtil.join((String[])paths, (String)"/");
        if (string == null) {
            SessionStarter.$$$reportNull$$$0(27);
        }
        return string;
    }

    @NotNull
    private FileStat pushDebuggerFile(@NotNull SyncService syncService, @NotNull File localFile) throws IOException, AdbCommandRejectedException, TimeoutException, SyncException, ShellCommandUnresponsiveException {
        if (syncService == null) {
            SessionStarter.$$$reportNull$$$0(28);
        }
        if (localFile == null) {
            SessionStarter.$$$reportNull$$$0(29);
        }
        String fileName = localFile.getName();
        String tmpDestFile = SessionStarter.joinPaths("/data/local/tmp", fileName);
        Date localFileLmt = new Date(localFile.lastModified() / 1000L * 1000L);
        SyncService.FileStat destFileStat = syncService.statFile(tmpDestFile);
        if (destFileStat == null || destFileStat.getMode() == 0 || !localFileLmt.equals(destFileStat.getLastModified()) || localFile.length() != (long)destFileStat.getSize()) {
            LOG.info("Pushing to the device: " + localFile + " => " + tmpDestFile);
            this.myDevice.pushFile(localFile.getAbsolutePath(), tmpDestFile);
        } else {
            LOG.info("Remote file " + tmpDestFile + " is up-to-date.");
        }
        FileStat fileStat = new FileStat(tmpDestFile, destFileStat == null ? 0L : destFileStat.getLastModified().getTime());
        if (fileStat == null) {
            SessionStarter.$$$reportNull$$$0(30);
        }
        return fileStat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sessionStarted() throws ExecutionException {
        List<EventListener> list = this.myEventListeners;
        synchronized (list) {
            assert (!this.mySessionStarted);
            this.mySessionStarted = true;
            for (EventListener eventListener : this.myEventListeners) {
                eventListener.sessionStarted();
            }
            this.myEventListeners.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEventListener(@NotNull EventListener eventListener) {
        if (eventListener == null) {
            SessionStarter.$$$reportNull$$$0(31);
        }
        List<EventListener> list = this.myEventListeners;
        synchronized (list) {
            assert (!this.mySessionStarted);
            this.myEventListeners.add(eventListener);
        }
    }

    @NotNull
    public IDevice getDevice() {
        IDevice iDevice = this.myDevice;
        if (iDevice == null) {
            SessionStarter.$$$reportNull$$$0(32);
        }
        return iDevice;
    }

    @NotNull
    private static String getHelpfullyNamedSocketDirectory(@NotNull Client client) {
        String dir;
        if (client == null) {
            SessionStarter.$$$reportNull$$$0(33);
        }
        if ((dir = client.getClientData().getPackageName() + "-" + client.getClientData().getUserId()).length() >= 70) {
            dir = dir.substring(dir.length() - 70);
        }
        String string = "/" + dir;
        if (string == null) {
            SessionStarter.$$$reportNull$$$0(34);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 24: 
            case 25: 
            case 27: 
            case 30: 
            case 32: 
            case 34: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 24: 
            case 25: 
            case 27: 
            case 30: 
            case 32: 
            case 34: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "device";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetDataDir";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetSocketDir";
                break;
            }
            case 3: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localServerFile";
                break;
            }
            case 4: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localStartScriptFile";
                break;
            }
            case 5: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debuggerState";
                break;
            }
            case 6: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressReporter";
                break;
            }
            case 7: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "launchStatus";
                break;
            }
            case 8: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "printer";
                break;
            }
            case 9: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "client";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 24: 
            case 25: 
            case 27: 
            case 30: 
            case 32: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/ndk/run/lldb/SessionStarter";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paths";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "syncService";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localFile";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "eventListener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/ndk/run/lldb/SessionStarter";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogFilesFromDevice";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getStartCommandLine";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getConnectUrl";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetRootDirectory";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetBinDirectory";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetLogFilePath";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetBinFilePath";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getStartScriptTargetPath";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "joinPaths";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "pushDebuggerFile";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getDevice";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getHelpfullyNamedSocketDirectory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 24: 
            case 25: 
            case 27: 
            case 30: 
            case 32: 
            case 34: {
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getTargetLogFilePath";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getTargetBinFilePath";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "joinPaths";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "pushDebuggerFile";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "addEventListener";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getHelpfullyNamedSocketDirectory";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 24: 
            case 25: 
            case 27: 
            case 30: 
            case 32: 
            case 34: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface EventListener {
        public void sessionStarted() throws ExecutionException;
    }

    protected static class FileStat {
        private final String myFilePath;
        private final long myLastModified;

        public FileStat(@NotNull String filePath, long lastModified) {
            if (filePath == null) {
                FileStat.$$$reportNull$$$0(0);
            }
            this.myFilePath = filePath;
            this.myLastModified = lastModified;
        }

        @NotNull
        public String getFilePath() {
            String string = this.myFilePath;
            if (string == null) {
                FileStat.$$$reportNull$$$0(1);
            }
            return string;
        }

        public long getLastModified() {
            return this.myLastModified;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "filePath";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/ndk/run/lldb/SessionStarter$FileStat";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/ndk/run/lldb/SessionStarter$FileStat";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFilePath";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

