/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.run.lldb;

import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.Client;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.ShellCommandUnresponsiveException;
import com.android.ddmlib.SyncException;
import com.android.ddmlib.TimeoutException;
import com.android.tools.idea.run.ConsolePrinter;
import com.android.tools.idea.run.ErrorMatchingReceiver;
import com.android.tools.idea.run.tasks.ShellCommandLauncher;
import com.android.tools.idea.run.util.LaunchStatus;
import com.android.tools.idea.run.util.ProcessHandlerLaunchStatus;
import com.android.tools.ndk.run.AndroidNativeDeviceException;
import com.android.tools.ndk.run.ProgressReporter;
import com.android.tools.ndk.run.editor.NativeAndroidDebuggerState;
import com.android.tools.ndk.run.lldb.SessionStarter;
import com.intellij.execution.ExecutionException;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ConcurrencyUtil;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public class ShellSessionStarterImpl
extends SessionStarter {
    private static final Logger LOG = Logger.getInstance(ShellSessionStarterImpl.class);

    public ShellSessionStarterImpl(@NotNull Client client, @NotNull File localServerFile, @NotNull File localStartScriptFile, @NotNull NativeAndroidDebuggerState debuggerState, @NotNull ProgressReporter progressReporter, @NotNull ProcessHandlerLaunchStatus launchStatus, @NotNull ConsolePrinter printer) throws ExecutionException {
        if (client == null) {
            ShellSessionStarterImpl.$$$reportNull$$$0(0);
        }
        if (localServerFile == null) {
            ShellSessionStarterImpl.$$$reportNull$$$0(1);
        }
        if (localStartScriptFile == null) {
            ShellSessionStarterImpl.$$$reportNull$$$0(2);
        }
        if (debuggerState == null) {
            ShellSessionStarterImpl.$$$reportNull$$$0(3);
        }
        if (progressReporter == null) {
            ShellSessionStarterImpl.$$$reportNull$$$0(4);
        }
        if (launchStatus == null) {
            ShellSessionStarterImpl.$$$reportNull$$$0(5);
        }
        if (printer == null) {
            ShellSessionStarterImpl.$$$reportNull$$$0(6);
        }
        super(client, localServerFile, localStartScriptFile, debuggerState, progressReporter, launchStatus, printer);
    }

    public ShellSessionStarterImpl(@NotNull IDevice device, @NotNull File localServerFile, @NotNull File localStartScriptFile, @NotNull NativeAndroidDebuggerState debuggerState, @NotNull ProgressReporter progressReporter, @NotNull ProcessHandlerLaunchStatus launchStatus, @NotNull ConsolePrinter printer) throws ExecutionException {
        if (device == null) {
            ShellSessionStarterImpl.$$$reportNull$$$0(7);
        }
        if (localServerFile == null) {
            ShellSessionStarterImpl.$$$reportNull$$$0(8);
        }
        if (localStartScriptFile == null) {
            ShellSessionStarterImpl.$$$reportNull$$$0(9);
        }
        if (debuggerState == null) {
            ShellSessionStarterImpl.$$$reportNull$$$0(10);
        }
        if (progressReporter == null) {
            ShellSessionStarterImpl.$$$reportNull$$$0(11);
        }
        if (launchStatus == null) {
            ShellSessionStarterImpl.$$$reportNull$$$0(12);
        }
        if (printer == null) {
            ShellSessionStarterImpl.$$$reportNull$$$0(13);
        }
        super(device, "/data/local/tmp", "/data/local/tmp", localServerFile, localStartScriptFile, debuggerState, progressReporter, launchStatus, printer);
    }

    @Override
    public void internalStartServer() throws ExecutionException {
        try {
            String mkdirOutput = this.executeCommand(this.getClientCommand(String.format("sh -c 'mkdir %s; mkdir %s'", this.getTargetRootDirectory(), this.getTargetBinDirectory())), 5L, TimeUnit.SECONDS);
            if (!mkdirOutput.isEmpty()) {
                LOG.warn(mkdirOutput);
            }
            this.copyFileToTargetBinDirectory(this.myServerTempFile.getFilePath());
            this.copyFileToTargetBinDirectory(this.myStartScriptTempFile.getFilePath());
            String startCmd = this.getStartCommandLine();
            LOG.info("Starting LLDB server : " + startCmd);
            this.myPrinter.stdout("Starting LLDB server: " + startCmd);
            ApplicationManager.getApplication().executeOnPooledThread(() -> ConcurrencyUtil.runUnderThreadName((String)"lldb-server executor", () -> {
                try {
                    String output = this.executeCommand(this.getClientCommand(startCmd), 0L, TimeUnit.DAYS);
                    LOG.info("LLDB server has exited: " + output);
                }
                catch (Exception e) {
                    LOG.warn("LLDB server has failed: ", (Throwable)e);
                }
            }));
        }
        catch (Exception e) {
            throw new ExecutionException((Throwable)e);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected String executeCommand(@NotNull String command, long maxTimeToOutputResponse, TimeUnit timeUnit) throws TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, IOException, AndroidNativeDeviceException {
        void maxTimeUnits;
        if (command == null) {
            ShellSessionStarterImpl.$$$reportNull$$$0(14);
        }
        ErrorMatchingReceiver receiver = new ErrorMatchingReceiver((LaunchStatus)this.myLaunchStatus);
        this.myDevice.executeShellCommand(command, (IShellOutputReceiver)receiver, maxTimeToOutputResponse, (TimeUnit)maxTimeUnits);
        String string = receiver.getOutput().toString();
        if (string == null) {
            ShellSessionStarterImpl.$$$reportNull$$$0(15);
        }
        return string;
    }

    @NotNull
    protected String getClientCommand(@NotNull String command) {
        if (command == null) {
            ShellSessionStarterImpl.$$$reportNull$$$0(16);
        }
        String string = command;
        if (string == null) {
            ShellSessionStarterImpl.$$$reportNull$$$0(17);
        }
        return string;
    }

    private void copyFileToTargetBinDirectory(@NotNull String tmpDeviceFile) throws IOException, AdbCommandRejectedException, TimeoutException, SyncException, ShellCommandUnresponsiveException {
        if (tmpDeviceFile == null) {
            ShellSessionStarterImpl.$$$reportNull$$$0(18);
        }
        String fileName = new File(tmpDeviceFile).getName();
        String destFile = ShellSessionStarterImpl.joinPaths(this.getTargetBinDirectory(), fileName);
        String copyChmodCommand = "cat " + tmpDeviceFile + " | " + this.getClientCommand(String.format("sh -c 'cat > %s && chmod 700 %s'", destFile, destFile));
        LOG.info("Copying to app folder: " + tmpDeviceFile + " => " + destFile);
        LOG.info("Command: " + copyChmodCommand);
        if (!ShellCommandLauncher.execute((String)copyChmodCommand, (IDevice)this.myDevice, (LaunchStatus)this.myLaunchStatus, (ConsolePrinter)this.myPrinter, (long)60L, (TimeUnit)TimeUnit.SECONDS)) {
            throw new IOException("Command failed: " + copyChmodCommand);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 15: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 15: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "client";
                break;
            }
            case 1: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localServerFile";
                break;
            }
            case 2: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localStartScriptFile";
                break;
            }
            case 3: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debuggerState";
                break;
            }
            case 4: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressReporter";
                break;
            }
            case 5: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "launchStatus";
                break;
            }
            case 6: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "printer";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "device";
                break;
            }
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/ndk/run/lldb/ShellSessionStarterImpl";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tmpDeviceFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/ndk/run/lldb/ShellSessionStarterImpl";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "executeCommand";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getClientCommand";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "executeCommand";
                break;
            }
            case 15: 
            case 17: {
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getClientCommand";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "copyFileToTargetBinDirectory";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 15: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

