/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.run.lldb.renderers;

import com.android.tools.ndk.run.lldb.renderers.ConstTypeNameFormatter;
import com.android.utils.Pair;
import com.intellij.openapi.diagnostic.Logger;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeNameFormatterCategory {
    private static final HashMap<String, TypeNameFormatterCategory> myTypeNameFormatterCategories = new HashMap();
    private final String myName;
    private final HashMap<String, PatternFormatterPair> myTypeNameFormatterMap;
    private static final Logger LOG = Logger.getInstance(TypeNameFormatterCategory.class);

    @NotNull
    public static TypeNameFormatterCategory createTypeNameFormatterCategory(@NotNull String name) {
        TypeNameFormatterCategory category;
        if (name == null) {
            TypeNameFormatterCategory.$$$reportNull$$$0(0);
        }
        if ((category = myTypeNameFormatterCategories.get(name)) != null) {
            TypeNameFormatterCategory typeNameFormatterCategory = category;
            if (typeNameFormatterCategory == null) {
                TypeNameFormatterCategory.$$$reportNull$$$0(1);
            }
            return typeNameFormatterCategory;
        }
        category = new TypeNameFormatterCategory(name);
        myTypeNameFormatterCategories.put(name, category);
        TypeNameFormatterCategory typeNameFormatterCategory = category;
        if (typeNameFormatterCategory == null) {
            TypeNameFormatterCategory.$$$reportNull$$$0(2);
        }
        return typeNameFormatterCategory;
    }

    @Nullable
    public static TypeNameFormatter lookupTypeNameFormatter(@NotNull String rawTypeName) {
        if (rawTypeName == null) {
            TypeNameFormatterCategory.$$$reportNull$$$0(3);
        }
        for (Map.Entry<String, TypeNameFormatterCategory> entry : myTypeNameFormatterCategories.entrySet()) {
            TypeNameFormatter formatter = entry.getValue().getTypeNameFormatter(rawTypeName);
            if (formatter == null) continue;
            return formatter;
        }
        return null;
    }

    public TypeNameFormatterCategory(@NotNull String name) {
        if (name == null) {
            TypeNameFormatterCategory.$$$reportNull$$$0(4);
        }
        this.myName = name;
        this.myTypeNameFormatterMap = new HashMap();
    }

    public void registerTypeNameFormatter(@NotNull String name, @NotNull Pattern pattern, @NotNull TypeNameFormatter formatter) {
        if (name == null) {
            TypeNameFormatterCategory.$$$reportNull$$$0(5);
        }
        if (pattern == null) {
            TypeNameFormatterCategory.$$$reportNull$$$0(6);
        }
        if (formatter == null) {
            TypeNameFormatterCategory.$$$reportNull$$$0(7);
        }
        if (this.myTypeNameFormatterMap.get(name) != null) {
            LOG.warn(String.format("Overwriting the type-name-formatter with name %s.", name));
        }
        this.myTypeNameFormatterMap.put(name, new PatternFormatterPair(pattern, formatter));
    }

    @Nullable
    private TypeNameFormatter getTypeNameFormatter(@NotNull String rawTypeName) {
        if (rawTypeName == null) {
            TypeNameFormatterCategory.$$$reportNull$$$0(8);
        }
        Pair<String, Boolean> nonConstTypeNamePair = ConstTypeNameFormatter.getNonConstTypeName(rawTypeName);
        for (Map.Entry<String, PatternFormatterPair> mapEntry : this.myTypeNameFormatterMap.entrySet()) {
            PatternFormatterPair pair = mapEntry.getValue();
            Matcher matcher = pair.pattern.matcher((CharSequence)nonConstTypeNamePair.getFirst());
            if (!matcher.find()) continue;
            if (((Boolean)nonConstTypeNamePair.getSecond()).booleanValue()) {
                return new ConstTypeNameFormatter(pair.formatter);
            }
            return pair.formatter;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/ndk/run/lldb/renderers/TypeNameFormatterCategory";
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rawTypeName";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "formatter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/ndk/run/lldb/renderers/TypeNameFormatterCategory";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createTypeNameFormatterCategory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createTypeNameFormatterCategory";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "lookupTypeNameFormatter";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "registerTypeNameFormatter";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getTypeNameFormatter";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class PatternFormatterPair {
        public final Pattern pattern;
        public final TypeNameFormatter formatter;

        public PatternFormatterPair(Pattern p, TypeNameFormatter f) {
            this.pattern = p;
            this.formatter = f;
        }
    }

    public static interface TypeNameFormatter {
        public String format(String var1);
    }
}

