/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.run.lldb.renderers.formatters.libstdcpp;

import com.android.tools.ndk.run.lldb.renderers.TemplateParamsParser;
import com.android.tools.ndk.run.lldb.renderers.TypeNameFormatterCategory;
import java.util.ArrayList;
import java.util.HashMap;
import org.jetbrains.annotations.NotNull;

public class StringTypeNameFormatter
implements TypeNameFormatterCategory.TypeNameFormatter {
    private static final HashMap<String, String> myCharTypeToStringTypeMap = new HashMap();

    @Override
    public String format(@NotNull String input) {
        ArrayList<String> templateParams;
        if (input == null) {
            StringTypeNameFormatter.$$$reportNull$$$0(0);
        }
        if ((templateParams = TemplateParamsParser.getTemplateParams(input)) == null || templateParams.isEmpty()) {
            return input;
        }
        String charType = templateParams.get(0);
        if (templateParams.size() > 1 && !templateParams.get(1).contentEquals("std::char_traits<" + charType + ">")) {
            return input;
        }
        if (templateParams.size() > 2 && !templateParams.get(2).contentEquals("std::allocator<" + charType + ">")) {
            return input;
        }
        if (templateParams.size() > 3) {
            return input;
        }
        String output = myCharTypeToStringTypeMap.get(charType);
        if (output != null) {
            return output;
        }
        return input;
    }

    static {
        myCharTypeToStringTypeMap.put("char", "std::string");
        myCharTypeToStringTypeMap.put("wchar_t", "std::wstring");
        myCharTypeToStringTypeMap.put("char16_t", "std::u16string");
        myCharTypeToStringTypeMap.put("char32_t", "std::u32string");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "input", "com/android/tools/ndk/run/lldb/renderers/formatters/libstdcpp/StringTypeNameFormatter", "format"));
    }
}

