/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.run.lldb.renderers.formatters.libstdcpp;

import com.android.tools.ndk.run.lldb.renderers.TemplateParamsParser;
import com.android.tools.ndk.run.lldb.renderers.TypeNameFormatterCategory;
import java.util.ArrayList;

public class UnorderedSetTypeNameFormatter
implements TypeNameFormatterCategory.TypeNameFormatter {
    private final String myContainerName;

    private static boolean isDefaultHashFunction(String elementType, String hashFunction) {
        String defaultHashFunction = String.format("std::hash<%s%s>", elementType, TemplateParamsParser.spaceBetweenAngleBracket(elementType));
        return hashFunction.contentEquals(defaultHashFunction);
    }

    private static boolean isDefaultPredicateFunction(String elementType, String predicateFunction) {
        String defaultPredicateFunction = String.format("std::equal_to<%s%s>", elementType, TemplateParamsParser.spaceBetweenAngleBracket(elementType));
        return predicateFunction.contentEquals(defaultPredicateFunction);
    }

    private static boolean isDefaultAllocatorType(String elementType, String allocatorType) {
        String dataTypeAngleBracketSpace = TemplateParamsParser.spaceBetweenAngleBracket(elementType);
        String defaultAllocatorType = String.format("std::allocator<%s%s>", elementType, dataTypeAngleBracketSpace);
        return allocatorType.contentEquals(defaultAllocatorType);
    }

    public UnorderedSetTypeNameFormatter(String containerName) {
        this.myContainerName = containerName;
    }

    @Override
    public String format(String typeName) {
        int numParams;
        ArrayList<String> templateParams = TemplateParamsParser.getTemplateParams(typeName);
        int n = numParams = templateParams == null ? 0 : templateParams.size();
        if (numParams < 2 || numParams > 4) {
            return typeName;
        }
        String elementType = templateParams.get(0);
        if (numParams >= 2 && !UnorderedSetTypeNameFormatter.isDefaultHashFunction(elementType, templateParams.get(1))) {
            return typeName;
        }
        if (numParams >= 3 && !UnorderedSetTypeNameFormatter.isDefaultPredicateFunction(elementType, templateParams.get(2))) {
            return typeName;
        }
        if (numParams == 4 && !UnorderedSetTypeNameFormatter.isDefaultAllocatorType(elementType, templateParams.get(3))) {
            return typeName;
        }
        TypeNameFormatterCategory.TypeNameFormatter elementTypeFormatter = TypeNameFormatterCategory.lookupTypeNameFormatter(elementType);
        String formattedElementType = elementTypeFormatter != null ? elementTypeFormatter.format(elementType) : elementType;
        return String.format("%s<%s%s>", this.myContainerName, formattedElementType, TemplateParamsParser.spaceBetweenAngleBracket(formattedElementType));
    }
}

