/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.android.jps;

import com.intellij.util.PathUtil;
import java.io.File;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.android.model.base.AndroidExtensionsDataProvider;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.ModuleBuildTarget;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.kotlin.jps.build.KotlinJpsCompilerArgumentsProvider;
import org.w3c.dom.Document;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u001e\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u001e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\b0\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/android/jps/KotlinAndroidJpsPlugin;", "Lorg/jetbrains/kotlin/jps/build/KotlinJpsCompilerArgumentsProvider;", "()V", "getAndroidManifest", "Ljava/io/File;", "module", "Lorg/jetbrains/jps/model/module/JpsModule;", "getAndroidResPath", "", "getClasspath", "", "moduleBuildTarget", "Lorg/jetbrains/jps/incremental/ModuleBuildTarget;", "context", "Lorg/jetbrains/jps/incremental/CompileContext;", "getExtraArguments", "hasAndroidJpsPlugin", "", "isAndroidModuleWithoutGradle", "Companion", "android-extensions-jps"})
public final class KotlinAndroidJpsPlugin
implements KotlinJpsCompilerArgumentsProvider {
    private static final String ANDROID_JPS_UTIL_CLASS_FQNAME = "org.jetbrains.jps.android.AndroidJpsUtil";
    private static final String JAR_FILE_NAME = "android-extensions-compiler.jar";
    private static final String ANDROID_COMPILER_PLUGIN_ID = "org.jetbrains.kotlin.android";
    private static final String VARIANT_OPTION_NAME = "variant";
    private static final String PACKAGE_OPTION_NAME = "package";
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public List<String> getExtraArguments(@NotNull ModuleBuildTarget moduleBuildTarget, @NotNull CompileContext context) {
        String string;
        JpsModule module;
        block6: {
            block5: {
                Intrinsics.checkParameterIsNotNull((Object)moduleBuildTarget, (String)"moduleBuildTarget");
                Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
                module = moduleBuildTarget.getModule();
                if (!this.hasAndroidJpsPlugin()) break block5;
                JpsModule jpsModule = module;
                Intrinsics.checkExpressionValueIsNotNull((Object)jpsModule, (String)"module");
                if (this.isAndroidModuleWithoutGradle(jpsModule)) break block6;
            }
            return CollectionsKt.emptyList();
        }
        String pluginId = ANDROID_COMPILER_PLUGIN_ID;
        String resPath = this.getAndroidResPath(module);
        File file = this.getAndroidManifest(module);
        if (file != null) {
            File file2;
            File it = file2 = file;
            string = KotlinAndroidJpsPlugin.Companion.getApplicationPackageFromManifest(it);
        } else {
            string = null;
        }
        String applicationId = string;
        return resPath != null && applicationId != null ? CollectionsKt.listOf((Object[])new String[]{KotlinAndroidJpsPlugin.Companion.getPluginOptionString(pluginId, VARIANT_OPTION_NAME, "main;" + resPath), KotlinAndroidJpsPlugin.Companion.getPluginOptionString(pluginId, PACKAGE_OPTION_NAME, applicationId)}) : CollectionsKt.emptyList();
    }

    private final boolean isAndroidModuleWithoutGradle(JpsModule module) {
        AndroidExtensionsDataProvider androidExtensionsDataProvider = AndroidExtensionsDataProvider.Companion.getExtension(module);
        if (androidExtensionsDataProvider == null) {
            return false;
        }
        AndroidExtensionsDataProvider androidFacet = androidExtensionsDataProvider;
        return !androidFacet.isGradleProject();
    }

    private final boolean hasAndroidJpsPlugin() {
        try {
            Class.forName(ANDROID_JPS_UTIL_CLASS_FQNAME);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    @Override
    @NotNull
    public List<String> getClasspath(@NotNull ModuleBuildTarget moduleBuildTarget, @NotNull CompileContext context) {
        List list;
        block8: {
            block7: {
                Intrinsics.checkParameterIsNotNull((Object)moduleBuildTarget, (String)"moduleBuildTarget");
                Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
                JpsModule module = moduleBuildTarget.getModule();
                if (!this.hasAndroidJpsPlugin()) break block7;
                JpsModule jpsModule = module;
                Intrinsics.checkExpressionValueIsNotNull((Object)jpsModule, (String)"module");
                if (this.isAndroidModuleWithoutGradle(jpsModule)) break block8;
            }
            return CollectionsKt.emptyList();
        }
        JpsModule jpsModule = moduleBuildTarget.getModule();
        Intrinsics.checkExpressionValueIsNotNull((Object)jpsModule, (String)"moduleBuildTarget.module");
        File manifestFile = this.getAndroidManifest(jpsModule);
        if (manifestFile != null) {
            File compilerPluginJar;
            File file;
            File jpsPluginJar = new File(PathUtil.getJarPathForClass(this.getClass()));
            File file2 = jpsPluginJar.getParentFile();
            if (Intrinsics.areEqual((Object)(file2 != null ? file2.getName() : null), (Object)"libs") && Intrinsics.areEqual((Object)((file = jpsPluginJar.getParentFile()) != null && (file = file.getParentFile()) != null ? file.getName() : null), (Object)"build")) {
                compilerPluginJar = new File("dist/kotlinc/lib/android-extensions-compiler.jar");
            } else {
                File file3 = jpsPluginJar.getParentFile();
                Intrinsics.checkExpressionValueIsNotNull((Object)file3, (String)"jpsPluginJar.parentFile");
                File libDirectory = file3.getParentFile();
                compilerPluginJar = new File(libDirectory, JAR_FILE_NAME);
            }
            list = CollectionsKt.listOf((Object)compilerPluginJar.getAbsolutePath());
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    private final String getAndroidResPath(JpsModule module) {
        Object object = AndroidExtensionsDataProvider.Companion.getExtension(module);
        return object != null && (object = object.getResourceDirForCompilationPath()) != null ? ((File)object).getAbsolutePath() : null;
    }

    private final File getAndroidManifest(JpsModule module) {
        AndroidExtensionsDataProvider androidExtensionsDataProvider = AndroidExtensionsDataProvider.Companion.getExtension(module);
        return androidExtensionsDataProvider != null ? androidExtensionsDataProvider.getManifestFileForCompilationPath() : null;
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\t\u001a\u0004\u0018\u00010\u00042\u0006\u0010\n\u001a\u00020\u000bH\u0002J \u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0004H\u0002J\f\u0010\u0010\u001a\u00020\u0011*\u00020\u000bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/android/jps/KotlinAndroidJpsPlugin$Companion;", "", "()V", "ANDROID_COMPILER_PLUGIN_ID", "", "ANDROID_JPS_UTIL_CLASS_FQNAME", "JAR_FILE_NAME", "PACKAGE_OPTION_NAME", "VARIANT_OPTION_NAME", "getApplicationPackageFromManifest", "manifestFile", "Ljava/io/File;", "getPluginOptionString", "pluginId", "key", "value", "parseXml", "Lorg/w3c/dom/Document;", "android-extensions-jps"})
    public static final class Companion {
        private final String getApplicationPackageFromManifest(File manifestFile) {
            String string;
            try {
                string = this.parseXml(manifestFile).getDocumentElement().getAttribute(KotlinAndroidJpsPlugin.PACKAGE_OPTION_NAME);
            }
            catch (Exception e) {
                string = null;
            }
            return string;
        }

        private final Document parseXml(@NotNull File $receiver) {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse($receiver);
            Intrinsics.checkExpressionValueIsNotNull((Object)document, (String)"builder.parse(this)");
            return document;
        }

        private final String getPluginOptionString(String pluginId, String key, String value) {
            return "plugin:" + pluginId + ':' + key + '=' + value;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

