/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.jps.build;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.UserDataHolder;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.ModuleChunk;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.builders.BuildTargetIndex;
import org.jetbrains.jps.builders.DirtyFilesHolder;
import org.jetbrains.jps.builders.FileProcessor;
import org.jetbrains.jps.builders.impl.DirtyFilesHolderBase;
import org.jetbrains.jps.builders.java.JavaBuilderUtil;
import org.jetbrains.jps.builders.java.JavaSourceRootDescriptor;
import org.jetbrains.jps.builders.storage.BuildDataPaths;
import org.jetbrains.jps.cmdline.ProjectDescriptor;
import org.jetbrains.jps.incremental.BuilderCategory;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.FSOperations;
import org.jetbrains.jps.incremental.ModuleBuildTarget;
import org.jetbrains.jps.incremental.ModuleLevelBuilder;
import org.jetbrains.jps.incremental.StopBuildException;
import org.jetbrains.jps.incremental.Utils;
import org.jetbrains.jps.incremental.java.JavaBuilder;
import org.jetbrains.jps.incremental.storage.BuildDataManager;
import org.jetbrains.jps.model.JpsProject;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.jps.model.module.JpsModuleSourceRoot;
import org.jetbrains.kotlin.build.GeneratedFile;
import org.jetbrains.kotlin.cli.common.arguments.CommonCompilerArguments;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.common.messages.MessageCollectorUtil;
import org.jetbrains.kotlin.compilerRunner.JpsCompilerEnvironment;
import org.jetbrains.kotlin.compilerRunner.JpsKotlinCompilerRunner;
import org.jetbrains.kotlin.compilerRunner.OutputItemsCollector;
import org.jetbrains.kotlin.compilerRunner.OutputItemsCollectorImpl;
import org.jetbrains.kotlin.compilerRunner.ProgressReporterImpl;
import org.jetbrains.kotlin.compilerRunner.SimpleOutputItem;
import org.jetbrains.kotlin.compilerRunner.SimpleOutputItemKt;
import org.jetbrains.kotlin.config.IncrementalCompilation;
import org.jetbrains.kotlin.config.Services;
import org.jetbrains.kotlin.daemon.common.DaemonParamsKt;
import org.jetbrains.kotlin.incremental.CacheVersion;
import org.jetbrains.kotlin.incremental.ChangesCollector;
import org.jetbrains.kotlin.incremental.ExpectActualTrackerImpl;
import org.jetbrains.kotlin.incremental.LookupStorage;
import org.jetbrains.kotlin.incremental.LookupTrackerImpl;
import org.jetbrains.kotlin.incremental.components.ExpectActualTracker;
import org.jetbrains.kotlin.incremental.components.LookupTracker;
import org.jetbrains.kotlin.jps.build.BuildLogger;
import org.jetbrains.kotlin.jps.build.FSOperationsHelper;
import org.jetbrains.kotlin.jps.build.HasKotlinMarker;
import org.jetbrains.kotlin.jps.build.JpsUtilKt;
import org.jetbrains.kotlin.jps.build.KotlinBuilder;
import org.jetbrains.kotlin.jps.build.KotlinBuilder$WhenMappings;
import org.jetbrains.kotlin.jps.build.KotlinBuilderKt;
import org.jetbrains.kotlin.jps.build.KotlinDirtySourceFilesHolder;
import org.jetbrains.kotlin.jps.build.KotlinJpsCompilerArgumentsProvider;
import org.jetbrains.kotlin.jps.build.MessageCollectorAdapter;
import org.jetbrains.kotlin.jps.build.RebuildAfterCacheVersionChangeMarker;
import org.jetbrains.kotlin.jps.build.TeamcityStatisticsLogger;
import org.jetbrains.kotlin.jps.build.TestingContext;
import org.jetbrains.kotlin.jps.build.TestingContextKt;
import org.jetbrains.kotlin.jps.incremental.CacheVersionProvider;
import org.jetbrains.kotlin.jps.incremental.JpsIncrementalCache;
import org.jetbrains.kotlin.jps.incremental.JpsIncrementalCacheKt;
import org.jetbrains.kotlin.jps.incremental.JpsLookupStorageKt;
import org.jetbrains.kotlin.jps.platforms.KotlinBuildTargets;
import org.jetbrains.kotlin.jps.platforms.KotlinJvmModuleBuildTarget;
import org.jetbrains.kotlin.jps.platforms.KotlinModuleBuildTarget;
import org.jetbrains.kotlin.jps.platforms.TargetPlatformKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.preloading.ClassCondition;
import org.jetbrains.kotlin.utils.KotlinPaths;
import org.jetbrains.kotlin.utils.KotlinPathsFromHomeDir;
import org.jetbrains.kotlin.utils.PathUtil;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u00c6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u0000 L2\u00020\u0001:\u0001LB\u0005\u00a2\u0006\u0002\u0010\u0002JD\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J4\u0010\u0015\u001a\u00020\u00162\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u00182\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u00120\u001a2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0012\u0010\u001e\u001a\u00020\u00062\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016J\u0010\u0010\u001f\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rH\u0016J&\u0010 \u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0018\u0010!\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0018\u0010\"\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\n\u0010#\u001a\u0004\u0018\u00010$H\u0002JJ\u0010%\u001a\u0004\u0018\u00010&2\n\u0010'\u001a\u0006\u0012\u0002\b\u00030(2\u0012\u0010)\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020+0*2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u00100\u001a\u000201H\u0002JD\u00102\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\n\u00103\u001a\u0006\u0012\u0002\b\u00030(2\u0006\u0010\f\u001a\u00020\r2\u0006\u00104\u001a\u0002052\u0006\u00100\u001a\u0002012\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002JZ\u00106\u001a\u0004\u0018\u0001072\u0006\u0010\u0017\u001a\u00020\u00182\n\u00103\u001a\u0006\u0012\u0002\b\u00030(2\u0006\u00108\u001a\u0002092\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0019\u001a\u0002052\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010:\u001a\u00020&2\u0012\u0010)\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020+0*H\u0002J\u0018\u0010;\u001a\u0012\u0012\u0004\u0012\u00020=0<j\b\u0012\u0004\u0012\u00020=`>H\u0016J2\u0010?\u001a\u0014\u0012\u0004\u0012\u00020\u0012\u0012\n\u0012\b\u0012\u0004\u0012\u00020A0@0*2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010B\u001a\u00020CH\u0002J\b\u0010D\u001a\u00020=H\u0016J(\u0010E\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u000205H\u0002J \u0010F\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010G\u001a\u00020=H\u0002J*\u0010H\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u001d2\u0018\u0010I\u001a\u0014\u0012\u0004\u0012\u00020\u0012\u0012\n\u0012\b\u0012\u0004\u0012\u00020A0@0*H\u0002J \u0010J\u001a\u00020\u00062\u0006\u0010,\u001a\u00020-2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u000205H\u0002J\u0012\u0010K\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011*\u00020\rH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006M"}, d2={"Lorg/jetbrains/kotlin/jps/build/KotlinBuilder;", "Lorg/jetbrains/jps/incremental/ModuleLevelBuilder;", "()V", "statisticsLogger", "Lorg/jetbrains/kotlin/jps/build/TeamcityStatisticsLogger;", "applyActionsOnCacheVersionChange", "", "actions", "", "Lorg/jetbrains/kotlin/incremental/CacheVersion$Action;", "cacheVersionsProvider", "Lorg/jetbrains/kotlin/jps/incremental/CacheVersionProvider;", "context", "Lorg/jetbrains/jps/incremental/CompileContext;", "dataManager", "Lorg/jetbrains/jps/incremental/storage/BuildDataManager;", "targets", "", "Lorg/jetbrains/jps/incremental/ModuleBuildTarget;", "fsOperations", "Lorg/jetbrains/kotlin/jps/build/FSOperationsHelper;", "build", "Lorg/jetbrains/jps/incremental/ModuleLevelBuilder$ExitCode;", "chunk", "Lorg/jetbrains/jps/ModuleChunk;", "dirtyFilesHolder", "Lorg/jetbrains/jps/builders/DirtyFilesHolder;", "Lorg/jetbrains/jps/builders/java/JavaSourceRootDescriptor;", "outputConsumer", "Lorg/jetbrains/jps/incremental/ModuleLevelBuilder$OutputConsumer;", "buildFinished", "buildStarted", "checkCachesVersions", "chunkBuildFinished", "chunkBuildStarted", "computeKotlinPathsForJpsPlugin", "Lorg/jetbrains/kotlin/utils/KotlinPaths;", "createCompileEnvironment", "Lorg/jetbrains/kotlin/compilerRunner/JpsCompilerEnvironment;", "kotlinModuleBuilderTarget", "Lorg/jetbrains/kotlin/jps/platforms/KotlinModuleBuildTarget;", "incrementalCaches", "", "Lorg/jetbrains/kotlin/jps/incremental/JpsIncrementalCache;", "lookupTracker", "Lorg/jetbrains/kotlin/incremental/components/LookupTracker;", "exceptActualTracer", "Lorg/jetbrains/kotlin/incremental/components/ExpectActualTracker;", "messageCollector", "Lorg/jetbrains/kotlin/jps/build/MessageCollectorAdapter;", "doBuild", "representativeTarget", "kotlinDirtyFilesHolder", "Lorg/jetbrains/kotlin/jps/build/KotlinDirtySourceFilesHolder;", "doCompileModuleChunk", "Lorg/jetbrains/kotlin/compilerRunner/OutputItemsCollector;", "commonArguments", "Lorg/jetbrains/kotlin/cli/common/arguments/CommonCompilerArguments;", "environment", "getCompilableFileExtensions", "Ljava/util/ArrayList;", "", "Lkotlin/collections/ArrayList;", "getGeneratedFiles", "", "Lorg/jetbrains/kotlin/build/GeneratedFile;", "outputItemCollector", "Lorg/jetbrains/kotlin/compilerRunner/OutputItemsCollectorImpl;", "getPresentableName", "markAdditionalFilesForInitialRound", "markAllKotlinForRebuild", "reason", "registerOutputItems", "outputItems", "updateLookupStorage", "allTargets", "Companion", "jps-plugin"})
public final class KotlinBuilder
extends ModuleLevelBuilder {
    private final TeamcityStatisticsLogger statisticsLogger = new TeamcityStatisticsLogger();
    @NotNull
    public static final String KOTLIN_BUILDER_NAME = "Kotlin Builder";
    @NotNull
    private static final Logger LOG;
    @NotNull
    public static final String SKIP_CACHE_VERSION_CHECK_PROPERTY = "kotlin.jps.skip.cache.version.check";
    @NotNull
    public static final String JPS_KOTLIN_HOME_PROPERTY = "jps.kotlin.home";
    public static final Companion Companion;

    @NotNull
    public String getPresentableName() {
        return KOTLIN_BUILDER_NAME;
    }

    @NotNull
    public ArrayList<String> getCompilableFileExtensions() {
        return CollectionsKt.arrayListOf((Object[])new String[]{"kt", "kts"});
    }

    public void buildStarted(@NotNull CompileContext context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        LOG.debug("==========================================");
        LOG.info("is Kotlin incremental compilation enabled for JVM: " + IncrementalCompilation.isEnabledForJvm());
        LOG.info("is Kotlin incremental compilation enabled for JS: " + IncrementalCompilation.isEnabledForJs());
        if (IncrementalCompilation.isEnabledForJs()) {
            MessageCollectorAdapter messageCollector = new MessageCollectorAdapter(context, null);
            MessageCollector.DefaultImpls.report$default(messageCollector, CompilerMessageSeverity.INFO, "Using experimental incremental compilation for Kotlin/JS", null, 4, null);
        }
        LOG.info("is Kotlin compiler daemon enabled: " + DaemonParamsKt.isDaemonEnabled());
        String historyLabel = context.getBuilderParameter("history label");
        if (historyLabel != null) {
            LOG.info("Label in local history: " + historyLabel);
        }
    }

    public void buildFinished(@Nullable CompileContext context) {
        this.statisticsLogger.reportTotal();
    }

    public void chunkBuildStarted(@NotNull CompileContext context, @NotNull ModuleChunk chunk) {
        block13: {
            boolean bl;
            BuildDataManager dataManager;
            Set targets;
            BuildLogger buildLogger;
            block12: {
                Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
                Intrinsics.checkParameterIsNotNull((Object)chunk, (String)"chunk");
                super.chunkBuildStarted(context, chunk);
                if (JpsUtilKt.isDummy(chunk, context)) {
                    return;
                }
                TestingContext testingContext = TestingContextKt.getTestingContext(context);
                BuildLogger buildLogger2 = buildLogger = testingContext != null ? testingContext.getBuildLogger() : null;
                if (buildLogger2 != null) {
                    buildLogger2.buildStarted(context, chunk);
                }
                if (JavaBuilderUtil.isForcedRecompilationAllJavaModules((CompileContext)context)) {
                    return;
                }
                targets = chunk.getTargets();
                BuildDataManager buildDataManager = dataManager = context.getProjectDescriptor().dataManager;
                Intrinsics.checkExpressionValueIsNotNull((Object)buildDataManager, (String)"dataManager");
                HasKotlinMarker hasKotlin = new HasKotlinMarker(buildDataManager);
                Set set = targets;
                Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"targets");
                Iterable $receiver$iv = set;
                if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $receiver$iv) {
                        ModuleBuildTarget it;
                        ModuleBuildTarget moduleBuildTarget = it = (ModuleBuildTarget)element$iv;
                        Intrinsics.checkExpressionValueIsNotNull((Object)moduleBuildTarget, (String)"it");
                        if (!Intrinsics.areEqual((Object)hasKotlin.get(moduleBuildTarget), (Object)true)) continue;
                        bl = false;
                        break block12;
                    }
                    bl = true;
                }
            }
            if (bl) {
                return;
            }
            KotlinDirtySourceFilesHolder roundDirtyFiles2 = new KotlinDirtySourceFilesHolder(chunk, context, (DirtyFilesHolder<JavaSourceRootDescriptor, ModuleBuildTarget>)((DirtyFilesHolder)new DirtyFilesHolderBase<JavaSourceRootDescriptor, ModuleBuildTarget>(context, chunk, context){
                final /* synthetic */ CompileContext $context;
                final /* synthetic */ ModuleChunk $chunk;

                public void processDirtyFiles(@NotNull FileProcessor<JavaSourceRootDescriptor, ModuleBuildTarget> processor) {
                    Intrinsics.checkParameterIsNotNull(processor, (String)"processor");
                    FSOperations.processFilesToRecompile((CompileContext)this.$context, (ModuleChunk)this.$chunk, processor);
                }
                {
                    this.$context = $captured_local_variable$0;
                    this.$chunk = $captured_local_variable$1;
                    super($super_call_param$2);
                }
            }));
            Logger logger = LOG;
            Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"LOG");
            FSOperationsHelper fsOperations = new FSOperationsHelper(context, chunk, roundDirtyFiles2, logger);
            ModuleBuildTarget jpsRepresentativeTarget = chunk.representativeTarget();
            KotlinBuildTargets kotlinBuildTargets = TargetPlatformKt.getKotlinBuildTargets(context);
            ModuleBuildTarget moduleBuildTarget = jpsRepresentativeTarget;
            Intrinsics.checkExpressionValueIsNotNull((Object)moduleBuildTarget, (String)"jpsRepresentativeTarget");
            KotlinModuleBuildTarget<?> representativeTarget = kotlinBuildTargets.get(moduleBuildTarget);
            if (representativeTarget == null) {
                LOG.warn("Unable to find Kotlin build target for JPS target " + jpsRepresentativeTarget.getPresentableName());
            }
            if (System.getProperty(SKIP_CACHE_VERSION_CHECK_PROPERTY) == null && representativeTarget != null) {
                BuildDataPaths buildDataPaths = dataManager.getDataPaths();
                Intrinsics.checkExpressionValueIsNotNull((Object)buildDataPaths, (String)"dataManager.dataPaths");
                CacheVersionProvider cacheVersionsProvider = new CacheVersionProvider(buildDataPaths, representativeTarget.isIncrementalCompilationEnabled());
                Set<CacheVersion.Action> actions = this.checkCachesVersions(context, cacheVersionsProvider, chunk);
                this.applyActionsOnCacheVersionChange(actions, cacheVersionsProvider, context, dataManager, targets, fsOperations);
                if (actions.contains((Object)CacheVersion.Action.REBUILD_ALL_KOTLIN)) {
                    return;
                }
            }
            try {
                JpsLookupStorageKt.withLookupStorage(dataManager, chunkBuildStarted.2.INSTANCE);
            }
            catch (Exception e) {
                LOG.info((Throwable)e);
                this.markAllKotlinForRebuild(context, fsOperations, "Lookup storage is corrupted");
                return;
            }
            this.markAdditionalFilesForInitialRound(chunk, context, fsOperations, roundDirtyFiles2);
            BuildLogger buildLogger3 = buildLogger;
            if (buildLogger3 == null) break block13;
            buildLogger3.afterBuildStarted(context, chunk);
        }
    }

    private final void markAdditionalFilesForInitialRound(ModuleChunk chunk, CompileContext context, FSOperationsHelper fsOperations, KotlinDirtySourceFilesHolder dirtyFilesHolder) {
        KotlinBuildTargets kotlinBuildTargets = TargetPlatformKt.getKotlinBuildTargets(context);
        ModuleBuildTarget moduleBuildTarget = chunk.representativeTarget();
        Intrinsics.checkExpressionValueIsNotNull((Object)moduleBuildTarget, (String)"chunk.representativeTarget()");
        KotlinModuleBuildTarget<?> kotlinModuleBuildTarget = kotlinBuildTargets.get(moduleBuildTarget);
        if (kotlinModuleBuildTarget == null) {
            return;
        }
        KotlinModuleBuildTarget<?> representativeTarget = kotlinModuleBuildTarget;
        Map incrementalCaches = KotlinBuilderKt.access$getIncrementalCaches(chunk, context);
        MessageCollectorAdapter messageCollector = new MessageCollectorAdapter(context, representativeTarget);
        JpsCompilerEnvironment jpsCompilerEnvironment = this.createCompileEnvironment(representativeTarget, incrementalCaches, LookupTracker.DO_NOTHING.INSTANCE, ExpectActualTracker.DoNothing.INSTANCE, chunk, messageCollector);
        if (jpsCompilerEnvironment == null) {
            return;
        }
        JpsCompilerEnvironment environment = jpsCompilerEnvironment;
        HashSet<String> removedClasses = new HashSet<String>();
        for (ModuleBuildTarget target : chunk.getTargets()) {
            JpsIncrementalCache cache;
            if ((JpsIncrementalCache)incrementalCaches.get(target) == null) {
                continue;
            }
            ModuleBuildTarget moduleBuildTarget2 = target;
            Intrinsics.checkExpressionValueIsNotNull((Object)moduleBuildTarget2, (String)"target");
            Set<File> dirtyFiles = dirtyFilesHolder.getDirtyFiles(moduleBuildTarget2);
            Collection<File> removedFiles = dirtyFilesHolder.getRemovedFiles(target);
            Set<String> existingClasses = new JpsKotlinCompilerRunner().classesFqNamesByFiles(environment, dirtyFiles);
            Collection<FqName> previousClasses = cache.classesFqNamesBySources(SetsKt.plus(dirtyFiles, (Iterable)removedFiles));
            for (FqName jvmClassName : previousClasses) {
                String fqName2 = jvmClassName.asString();
                if (existingClasses.contains(fqName2)) continue;
                removedClasses.add(fqName2);
            }
        }
        ChangesCollector changesCollector = new ChangesCollector();
        Iterable $receiver$iv = removedClasses;
        for (Object element$iv : $receiver$iv) {
            String it = (String)element$iv;
            changesCollector.collectSignature(new FqName(it), true);
        }
        Iterable iterable = incrementalCaches.values();
        BuildDataManager buildDataManager = context.getProjectDescriptor().dataManager;
        Intrinsics.checkExpressionValueIsNotNull((Object)buildDataManager, (String)"context.projectDescriptor.dataManager");
        Set affectedByRemovedClasses = KotlinBuilderKt.access$getDirtyFiles(changesCollector, iterable, buildDataManager);
        fsOperations.markFilesForCurrentRound$jps_plugin(affectedByRemovedClasses);
    }

    /*
     * WARNING - void declaration
     */
    private final Set<CacheVersion.Action> checkCachesVersions(CompileContext context, CacheVersionProvider cacheVersionsProvider, ModuleChunk chunk) {
        void $receiver$iv$iv;
        Iterable<CacheVersion> allVersions;
        Iterable<CacheVersion> $receiver$iv;
        Set targets = chunk.getTargets();
        BuildDataManager dataManager = context.getProjectDescriptor().dataManager;
        Set set = targets;
        Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"targets");
        Iterable<CacheVersion> iterable = $receiver$iv = (allVersions = cacheVersionsProvider.allVersions(set));
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            CacheVersion cacheVersion = (CacheVersion)item$iv$iv;
            Collection collection = destination$iv$iv;
            CacheVersion.Action action = it.checkVersion();
            collection.add(action);
        }
        Set actions = CollectionsKt.toMutableSet((Iterable)((List)destination$iv$iv));
        KotlinBuildTargets kotlinBuildTargets = TargetPlatformKt.getKotlinBuildTargets(context);
        ModuleBuildTarget moduleBuildTarget = chunk.representativeTarget();
        Intrinsics.checkExpressionValueIsNotNull((Object)moduleBuildTarget, (String)"chunk.representativeTarget()");
        KotlinModuleBuildTarget<?> kotlinModuleBuildTarget = kotlinBuildTargets.get(moduleBuildTarget);
        if (kotlinModuleBuildTarget == null) {
            Intrinsics.throwNpe();
        }
        KotlinModuleBuildTarget<?> kotlinModuleBuilderTarget = kotlinModuleBuildTarget;
        BuildDataManager buildDataManager = dataManager;
        Intrinsics.checkExpressionValueIsNotNull((Object)buildDataManager, (String)"dataManager");
        kotlinModuleBuilderTarget.checkCachesVersions(chunk, buildDataManager, actions);
        return actions;
    }

    public void chunkBuildFinished(@NotNull CompileContext context, @NotNull ModuleChunk chunk) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)chunk, (String)"chunk");
        super.chunkBuildFinished(context, chunk);
        if (JpsUtilKt.isDummy(chunk, context)) {
            return;
        }
        LOG.debug("------------------------------------------");
    }

    @NotNull
    public ModuleLevelBuilder.ExitCode build(@NotNull CompileContext context, @NotNull ModuleChunk chunk, @NotNull DirtyFilesHolder<JavaSourceRootDescriptor, ModuleBuildTarget> dirtyFilesHolder, @NotNull ModuleLevelBuilder.OutputConsumer outputConsumer) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)chunk, (String)"chunk");
        Intrinsics.checkParameterIsNotNull(dirtyFilesHolder, (String)"dirtyFilesHolder");
        Intrinsics.checkParameterIsNotNull((Object)outputConsumer, (String)"outputConsumer");
        if (JpsUtilKt.isDummy(chunk, context)) {
            return ModuleLevelBuilder.ExitCode.NOTHING_DONE;
        }
        KotlinBuildTargets kotlinBuildTargets = TargetPlatformKt.getKotlinBuildTargets(context);
        ModuleBuildTarget moduleBuildTarget = chunk.representativeTarget();
        Intrinsics.checkExpressionValueIsNotNull((Object)moduleBuildTarget, (String)"chunk.representativeTarget()");
        KotlinModuleBuildTarget<?> kotlinModuleBuildTarget = kotlinBuildTargets.get(moduleBuildTarget);
        if (kotlinModuleBuildTarget == null) {
            return ModuleLevelBuilder.ExitCode.OK;
        }
        KotlinModuleBuildTarget<?> kotlinTarget = kotlinModuleBuildTarget;
        MessageCollectorAdapter messageCollector = new MessageCollectorAdapter(context, kotlinTarget);
        KotlinDirtySourceFilesHolder kotlinDirtyFilesHolder = new KotlinDirtySourceFilesHolder(chunk, context, dirtyFilesHolder);
        Logger logger = LOG;
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"LOG");
        FSOperationsHelper fsOperations = new FSOperationsHelper(context, chunk, kotlinDirtyFilesHolder, logger);
        try {
            ModuleLevelBuilder.ExitCode proposedExitCode = this.doBuild(chunk, kotlinTarget, context, kotlinDirtyFilesHolder, messageCollector, outputConsumer, fsOperations);
            ModuleLevelBuilder.ExitCode actualExitCode = proposedExitCode == ModuleLevelBuilder.ExitCode.OK && fsOperations.getHasMarkedDirty$jps_plugin() ? ModuleLevelBuilder.ExitCode.ADDITIONAL_PASS_REQUIRED : proposedExitCode;
            LOG.debug("Build result: " + actualExitCode);
            Object object = TestingContextKt.getTestingContext(context);
            if (object != null && (object = ((TestingContext)object).getBuildLogger()) != null) {
                object.buildFinished(actualExitCode);
            }
            return actualExitCode;
        }
        catch (StopBuildException e) {
            LOG.info("Caught exception: " + (Object)((Object)e));
            throw (Throwable)e;
        }
        catch (Throwable e) {
            LOG.info("Caught exception: " + e);
            MessageCollectorUtil.reportException(messageCollector, e);
            return ModuleLevelBuilder.ExitCode.ABORT;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final ModuleLevelBuilder.ExitCode doBuild(ModuleChunk chunk, KotlinModuleBuildTarget<?> representativeTarget, CompileContext context, KotlinDirtySourceFilesHolder kotlinDirtyFilesHolder, MessageCollectorAdapter messageCollector, ModuleLevelBuilder.OutputConsumer outputConsumer, FSOperationsHelper fsOperations) {
        block35: {
            block34: {
                if (representativeTarget instanceof KotlinJvmModuleBuildTarget && !((Boolean)JavaBuilder.IS_ENABLED.get((UserDataHolder)context, (Object)true)).booleanValue()) {
                    MessageCollector.DefaultImpls.report$default(messageCollector, CompilerMessageSeverity.INFO, "Kotlin JPS plugin is disabled", null, 4, null);
                    return ModuleLevelBuilder.ExitCode.NOTHING_DONE;
                }
                projectDescriptor = context.getProjectDescriptor();
                dataManager = projectDescriptor.dataManager;
                targets = chunk.getTargets();
                v0 = dataManager;
                Intrinsics.checkExpressionValueIsNotNull((Object)v0, (String)"dataManager");
                hasKotlin = new HasKotlinMarker(v0);
                rebuildAfterCacheVersionChanged = new RebuildAfterCacheVersionChangeMarker(dataManager);
                if (JavaBuilderUtil.isForcedRecompilationAllJavaModules((CompileContext)context)) ** GOTO lbl-1000
                v1 = targets;
                Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"targets");
                $receiver$iv = v1;
                if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                    v2 = false;
                } else {
                    for (Iterable element$iv : $receiver$iv) {
                        v3 = it = (ModuleBuildTarget)element$iv /* !! */ ;
                        Intrinsics.checkExpressionValueIsNotNull((Object)v3, (String)"it");
                        if (!Intrinsics.areEqual((Object)rebuildAfterCacheVersionChanged.get(v3), (Object)true)) continue;
                        v2 = true;
                        break block34;
                    }
                    v2 = false;
                }
            }
            if (v2) lbl-1000:
            // 2 sources

            {
                v4 = true;
            } else {
                v4 = isChunkRebuilding = false;
            }
            if (kotlinDirtyFilesHolder.getHasDirtyOrRemovedFiles()) {
                if (!isChunkRebuilding && !representativeTarget.isIncrementalCompilationEnabled()) {
                    v5 = targets;
                    Intrinsics.checkExpressionValueIsNotNull((Object)v5, (String)"targets");
                    $receiver$iv = v5;
                    for (Iterable element$iv : $receiver$iv) {
                        v6 = it = (ModuleBuildTarget)element$iv /* !! */ ;
                        Intrinsics.checkExpressionValueIsNotNull((Object)v6, (String)"it");
                        rebuildAfterCacheVersionChanged.set(v6, true);
                    }
                    return ModuleLevelBuilder.ExitCode.CHUNK_REBUILD_REQUIRED;
                }
            } else {
                if (isChunkRebuilding) {
                    v7 = targets;
                    Intrinsics.checkExpressionValueIsNotNull((Object)v7, (String)"targets");
                    $receiver$iv = v7;
                    for (Iterable element$iv : $receiver$iv) {
                        v8 = it = (ModuleBuildTarget)element$iv /* !! */ ;
                        Intrinsics.checkExpressionValueIsNotNull((Object)v8, (String)"it");
                        hasKotlin.set(v8, false);
                    }
                }
                v9 = targets;
                Intrinsics.checkExpressionValueIsNotNull((Object)v9, (String)"targets");
                $receiver$iv = v9;
                for (Iterable element$iv : $receiver$iv) {
                    v10 = it = (ModuleBuildTarget)element$iv /* !! */ ;
                    Intrinsics.checkExpressionValueIsNotNull((Object)v10, (String)"it");
                    rebuildAfterCacheVersionChanged.clean(v10);
                }
                return ModuleLevelBuilder.ExitCode.NOTHING_DONE;
            }
            v11 = targets;
            Intrinsics.checkExpressionValueIsNotNull((Object)v11, (String)"targets");
            element$iv /* !! */  = $receiver$iv = (Iterable)v11;
            destination$iv$iv = new ArrayList<E>();
            for (T element$iv$iv : $receiver$iv$iv) {
                v12 = it = (ModuleBuildTarget)element$iv$iv;
                Intrinsics.checkExpressionValueIsNotNull((Object)v12, (String)"it");
                if (!(v12.getOutputDir() == null)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            targetsWithoutOutputDir = (List)destination$iv$iv;
            $receiver$iv = targetsWithoutOutputDir;
            if ($receiver$iv.isEmpty() == false) {
                MessageCollector.DefaultImpls.report$default(messageCollector, CompilerMessageSeverity.ERROR, "Output directory not specified for " + CollectionsKt.joinToString$default((Iterable)targetsWithoutOutputDir, null, null, null, (int)0, null, null, (int)63, null), null, 4, null);
                return ModuleLevelBuilder.ExitCode.ABORT;
            }
            v13 = projectDescriptor;
            Intrinsics.checkExpressionValueIsNotNull((Object)v13, (String)"projectDescriptor");
            v14 = project = v13.getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)v14, (String)"project");
            lookupTracker = KotlinBuilderKt.access$getLookupTracker(v14, representativeTarget);
            exceptActualTracer = new ExpectActualTrackerImpl();
            incrementalCaches = KotlinBuilderKt.access$getIncrementalCaches(chunk, context);
            v15 = this.createCompileEnvironment(representativeTarget, incrementalCaches, lookupTracker, exceptActualTracer, chunk, messageCollector);
            if (v15 == null) {
                return ModuleLevelBuilder.ExitCode.ABORT;
            }
            environment = v15;
            $receiver = $i$a$1$filter = representativeTarget.compilerArgumentsForChunk(chunk);
            $receiver.setReportOutputFiles(true);
            $receiver.setVersion(true);
            commonArguments = $i$a$1$filter;
            v16 = KotlinBuilder.LOG;
            Intrinsics.checkExpressionValueIsNotNull((Object)v16, (String)"LOG");
            if (v16.isDebugEnabled()) {
                KotlinBuilder.LOG.debug("Compiling files: " + kotlinDirtyFilesHolder.getAllDirtyFiles());
            }
            start = System.nanoTime();
            outputItemCollector = this.doCompileModuleChunk(chunk, representativeTarget, commonArguments, context, kotlinDirtyFilesHolder, fsOperations, environment, incrementalCaches);
            this.statisticsLogger.registerStatistic(chunk, System.nanoTime() - start);
            if (outputItemCollector == null) {
                return ModuleLevelBuilder.ExitCode.NOTHING_DONE;
            }
            v17 = compilationErrors = (Boolean)Utils.ERRORS_DETECTED_KEY.get((UserDataHolder)context, (Object)false);
            Intrinsics.checkExpressionValueIsNotNull((Object)v17, (String)"compilationErrors");
            if (v17.booleanValue()) {
                KotlinBuilder.LOG.info("Compiled with errors");
                return ModuleLevelBuilder.ExitCode.ABORT;
            }
            KotlinBuilder.LOG.info("Compiled successfully");
            generatedFiles = this.getGeneratedFiles(context, chunk, environment.getOutputItemsCollector());
            this.registerOutputItems(outputConsumer, generatedFiles);
            representativeTarget.saveVersions(context, chunk, commonArguments);
            $receiver$iv = targets;
            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                v18 = false;
            } else {
                var27_28 = $receiver$iv.iterator();
                while (var27_28.hasNext()) {
                    element$iv /* !! */  = var27_28.next();
                    it = (ModuleBuildTarget)element$iv /* !! */ ;
                    v19 = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)v19, (String)"it");
                    if (!(hasKotlin.get(v19) == null)) continue;
                    v18 = true;
                    break block35;
                }
                v18 = false;
            }
        }
        if (v18) {
            fsOperations.markChunk(false, true, kotlinDirtyFilesHolder.getAllDirtyFiles());
        }
        var27_28 = targets.iterator();
        while (var27_28.hasNext()) {
            v20 = target = (ModuleBuildTarget)var27_28.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)v20, (String)"target");
            hasKotlin.set(v20, true);
            rebuildAfterCacheVersionChanged.clean(target);
        }
        v21 = chunk.getTargets();
        Intrinsics.checkExpressionValueIsNotNull((Object)v21, (String)"chunk.targets");
        $receiver$iv = v21;
        var27_28 = $receiver$iv.iterator();
        while (var27_28.hasNext()) {
            element$iv /* !! */  = var27_28.next();
            it = (ModuleBuildTarget)element$iv /* !! */ ;
            v22 = TargetPlatformKt.getKotlinBuildTargets(context);
            v23 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)v23, (String)"it");
            v24 = v22.get(v23);
            if (v24 != null) {
                v24.doAfterBuild();
                v25 = Unit.INSTANCE;
                continue;
            }
            v25 = null;
        }
        representativeTarget.updateChunkMappings(chunk, kotlinDirtyFilesHolder, generatedFiles, incrementalCaches);
        if (!representativeTarget.isIncrementalCompilationEnabled()) {
            return ModuleLevelBuilder.ExitCode.OK;
        }
        context.checkCanceled();
        $receiver$iv = environment;
        try {
            progress = $receiver$iv.getProgressReporter();
            progress.progress("performing incremental compilation analysis");
            changesCollector = new ChangesCollector();
            it = generatedFiles;
            var30_31 = it.entrySet().iterator();
            while (var30_31.hasNext()) {
                var32_33 = var31_32 = var30_31.next();
                target = (ModuleBuildTarget)var32_33.getKey();
                var32_33 = var31_32;
                files = (List)var32_33.getValue();
                if (TargetPlatformKt.getKotlinBuildTargets(context).get(target) == null) {
                    Intrinsics.throwNpe();
                }
                v26 = incrementalCaches.get(target);
                if (v26 == null) {
                    Intrinsics.throwNpe();
                }
                kotlinModuleBuilderTarget.updateCaches((JpsIncrementalCache)v26, files, changesCollector, environment);
            }
            this.updateLookupStorage(lookupTracker, dataManager, kotlinDirtyFilesHolder);
            if (!isChunkRebuilding) {
                KotlinBuilderKt.access$processChangesUsingLookups(changesCollector, kotlinDirtyFilesHolder.getAllDirtyFiles(), dataManager, fsOperations, incrementalCaches.values());
            }
            var35_35 = Unit.INSTANCE;
        }
        finally {
            $receiver$iv.getProgressReporter().clearProgress();
        }
        return ModuleLevelBuilder.ExitCode.OK;
    }

    private final void applyActionsOnCacheVersionChange(Set<? extends CacheVersion.Action> actions, CacheVersionProvider cacheVersionsProvider, CompileContext context, BuildDataManager dataManager, Set<ModuleBuildTarget> targets, FSOperationsHelper fsOperations) {
        HasKotlinMarker hasKotlin = new HasKotlinMarker(dataManager);
        List sortedActions = CollectionsKt.sorted((Iterable)actions);
        Object object = TestingContextKt.getTestingContext(context);
        if (object != null && (object = ((TestingContext)object).getBuildLogger()) != null) {
            object.actionsOnCacheVersionChanged(sortedActions);
        }
        block6: for (CacheVersion.Action status : sortedActions) {
            boolean bl;
            switch (KotlinBuilder$WhenMappings.$EnumSwitchMapping$0[status.ordinal()]) {
                case 1: {
                    this.markAllKotlinForRebuild(context, fsOperations, "Kotlin global lookup map format changed");
                    return;
                }
                case 2: {
                    LOG.info("Clearing caches for " + CollectionsKt.joinToString$default((Iterable)targets, null, null, null, (int)0, null, (Function1)applyActionsOnCacheVersionChange.1.INSTANCE, (int)31, null));
                    RebuildAfterCacheVersionChangeMarker rebuildAfterCacheVersionChanged = new RebuildAfterCacheVersionChangeMarker(dataManager);
                    KotlinBuildTargets kotlinBuildTargets = TargetPlatformKt.getKotlinBuildTargets(context);
                    for (ModuleBuildTarget target : targets) {
                        JpsIncrementalCache jpsIncrementalCache = JpsIncrementalCacheKt.getKotlinCache(dataManager, kotlinBuildTargets.get(target));
                        if (jpsIncrementalCache != null) {
                            jpsIncrementalCache.clean();
                        }
                        hasKotlin.clean(target);
                        rebuildAfterCacheVersionChanged.set(target, true);
                    }
                    FSOperationsHelper.markChunk$default(fsOperations, false, true, null, 4, null);
                    return;
                }
                case 3: {
                    LOG.info("Clearing caches for all targets");
                    KotlinBuildTargets kotlinBuildTargets = TargetPlatformKt.getKotlinBuildTargets(context);
                    for (ModuleBuildTarget target : this.allTargets(context)) {
                        JpsIncrementalCache jpsIncrementalCache = JpsIncrementalCacheKt.getKotlinCache(dataManager, kotlinBuildTargets.get(target));
                        if (jpsIncrementalCache == null) continue;
                        jpsIncrementalCache.clean();
                    }
                    continue block6;
                }
                case 4: {
                    LOG.info("Clearing lookup cache");
                    Logger logger = LOG;
                    Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"LOG");
                    JpsLookupStorageKt.cleanLookupStorage(dataManager, logger);
                    cacheVersionsProvider.dataContainerVersion().clean();
                    continue block6;
                }
            }
            boolean bl2 = bl = status == CacheVersion.Action.DO_NOTHING;
            if (!_Assertions.ENABLED || bl) continue;
            String string = "Unknown version status " + (Object)((Object)status);
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Set<ModuleBuildTarget> allTargets(@NotNull CompileContext $receiver) {
        void var3_3;
        void $receiver$iv;
        ProjectDescriptor projectDescriptor = $receiver.getProjectDescriptor();
        Intrinsics.checkExpressionValueIsNotNull((Object)projectDescriptor, (String)"projectDescriptor");
        BuildTargetIndex buildTargetIndex = projectDescriptor.getBuildTargetIndex();
        Intrinsics.checkExpressionValueIsNotNull((Object)buildTargetIndex, (String)"projectDescriptor.buildTargetIndex");
        List list = buildTargetIndex.getAllTargets();
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"projectDescriptor.buildTargetIndex.allTargets");
        Iterable iterable = list;
        Collection destination$iv = new HashSet();
        for (Object element$iv : $receiver$iv) {
            if (!(element$iv instanceof ModuleBuildTarget)) continue;
            destination$iv.add(element$iv);
        }
        return (Set)var3_3;
    }

    /*
     * WARNING - void declaration
     */
    private final void markAllKotlinForRebuild(CompileContext context, FSOperationsHelper fsOperations, String reason) {
        BuildDataManager dataManager;
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        JpsProject project;
        LOG.info("Rebuilding all Kotlin: " + reason);
        ProjectDescriptor projectDescriptor = context.getProjectDescriptor();
        Intrinsics.checkExpressionValueIsNotNull((Object)projectDescriptor, (String)"context.projectDescriptor");
        JpsProject jpsProject = project = projectDescriptor.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)jpsProject, (String)"project");
        List list = jpsProject.getModules();
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"project.modules");
        Iterable iterable = $receiver$iv = (Iterable)list;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            JpsModule it;
            JpsModule jpsModule = it = (JpsModule)element$iv$iv;
            Intrinsics.checkExpressionValueIsNotNull((Object)jpsModule, (String)"it");
            Iterable list$iv$iv = jpsModule.getSourceRoots();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List sourceRoots = (List)destination$iv$iv;
        BuildDataManager buildDataManager = dataManager = context.getProjectDescriptor().dataManager;
        Intrinsics.checkExpressionValueIsNotNull((Object)buildDataManager, (String)"dataManager");
        RebuildAfterCacheVersionChangeMarker rebuildAfterCacheVersionChanged = new RebuildAfterCacheVersionChangeMarker(buildDataManager);
        Iterator<Object> iterator2 = sourceRoots.iterator();
        while (iterator2.hasNext()) {
            JpsModuleSourceRoot sourceRoot;
            JpsModuleSourceRoot jpsModuleSourceRoot = sourceRoot = (JpsModuleSourceRoot)iterator2.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)jpsModuleSourceRoot, (String)"sourceRoot");
            File file = jpsModuleSourceRoot.getFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"sourceRoot.file");
            Sequence ktFiles2 = SequencesKt.filter((Sequence)((Sequence)FilesKt.walk$default((File)file, null, (int)1, null)), (Function1)markAllKotlinForRebuild.ktFiles.1.INSTANCE);
            fsOperations.markFiles(SequencesKt.toList((Sequence)ktFiles2));
        }
        KotlinBuildTargets kotlinBuildTargets = TargetPlatformKt.getKotlinBuildTargets(context);
        for (ModuleBuildTarget target : this.allTargets(context)) {
            JpsIncrementalCache jpsIncrementalCache = JpsIncrementalCacheKt.getKotlinCache(dataManager, kotlinBuildTargets.get(target));
            if (jpsIncrementalCache != null) {
                jpsIncrementalCache.clean();
            }
            rebuildAfterCacheVersionChanged.set(target, true);
        }
        Logger logger = LOG;
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"LOG");
        JpsLookupStorageKt.cleanLookupStorage(dataManager, logger);
    }

    private final OutputItemsCollector doCompileModuleChunk(ModuleChunk chunk, KotlinModuleBuildTarget<?> representativeTarget, CommonCompilerArguments commonArguments, CompileContext context, KotlinDirtySourceFilesHolder dirtyFilesHolder, FSOperationsHelper fsOperations, JpsCompilerEnvironment environment, Map<ModuleBuildTarget, ? extends JpsIncrementalCache> incrementalCaches) {
        boolean isDoneSomething;
        doCompileModuleChunk.1 concatenate$ = doCompileModuleChunk.1.INSTANCE;
        for (KotlinJpsCompilerArgumentsProvider argumentProvider : ServiceLoader.load(KotlinJpsCompilerArgumentsProvider.class)) {
            ModuleBuildTarget jpsModuleBuildTarget = representativeTarget.getJpsModuleBuildTarget();
            commonArguments.setPluginOptions(concatenate$.invoke(commonArguments.getPluginOptions(), argumentProvider.getExtraArguments(jpsModuleBuildTarget, context)));
            commonArguments.setPluginClasspaths(concatenate$.invoke(commonArguments.getPluginClasspaths(), argumentProvider.getClasspath(jpsModuleBuildTarget, context)));
            LOG.debug("Plugin loaded: " + argumentProvider.getClass().getSimpleName());
        }
        if (representativeTarget.isIncrementalCompilationEnabled()) {
            for (ModuleBuildTarget target : chunk.getTargets()) {
                JpsIncrementalCache cache = incrementalCaches.get(target);
                KotlinDirtySourceFilesHolder.TargetFiles targetDirtyFiles2 = dirtyFilesHolder.getByTarget().get(target);
                if (cache == null || targetDirtyFiles2 == null) continue;
                Collection<File> complementaryFiles = cache.clearComplementaryFilesMapping(SetsKt.plus(targetDirtyFiles2.getDirty(), (Iterable)targetDirtyFiles2.getRemoved()));
                ModuleBuildTarget moduleBuildTarget = target;
                Intrinsics.checkExpressionValueIsNotNull((Object)moduleBuildTarget, (String)"target");
                fsOperations.markFilesForCurrentRound(moduleBuildTarget, (Iterable<? extends File>)complementaryFiles);
                cache.markDirty(SetsKt.plus(targetDirtyFiles2.getDirty(), (Iterable)targetDirtyFiles2.getRemoved()));
            }
        }
        return (isDoneSomething = representativeTarget.compileModuleChunk(chunk, commonArguments, dirtyFilesHolder, environment)) ? (OutputItemsCollector)environment.getOutputItemsCollector() : null;
    }

    private final JpsCompilerEnvironment createCompileEnvironment(KotlinModuleBuildTarget<?> kotlinModuleBuilderTarget, Map<ModuleBuildTarget, ? extends JpsIncrementalCache> incrementalCaches, LookupTracker lookupTracker, ExpectActualTracker exceptActualTracer, ModuleChunk chunk, MessageCollectorAdapter messageCollector) {
        Services.Builder builder;
        Services.Builder $receiver = builder = new Services.Builder();
        kotlinModuleBuilderTarget.makeServices($receiver, incrementalCaches, lookupTracker, exceptActualTracer);
        Services compilerServices = $receiver.build();
        KotlinPaths paths = this.computeKotlinPathsForJpsPlugin();
        if (paths == null || !paths.getHomePath().exists()) {
            MessageCollector.DefaultImpls.report$default(messageCollector, CompilerMessageSeverity.ERROR, "Cannot find kotlinc home. Make sure the plugin is properly installed, or specify jps.kotlin.home system property", null, 4, null);
            return null;
        }
        return new JpsCompilerEnvironment(paths, compilerServices, Companion.getClassesToLoadByParent(), messageCollector, new OutputItemsCollectorImpl(), new ProgressReporterImpl(kotlinModuleBuilderTarget.getContext(), chunk));
    }

    private final KotlinPaths computeKotlinPathsForJpsPlugin() {
        File jar;
        if (StringsKt.equals((String)System.getProperty("kotlin.jps.tests"), (String)"true", (boolean)true)) {
            return PathUtil.getKotlinPathsForDistDirectory();
        }
        String jpsKotlinHome = System.getProperty(JPS_KOTLIN_HOME_PROPERTY);
        if (jpsKotlinHome != null) {
            return new KotlinPathsFromHomeDir(new File(jpsKotlinHome));
        }
        File file = PathUtil.INSTANCE.getPathUtilJar();
        File p1 = file;
        File file2 = jar = p1.exists() ? file : null;
        if (Intrinsics.areEqual((Object)(file2 != null ? file2.getName() : null), (Object)"kotlin-jps-plugin.jar")) {
            File file3 = jar.getParentFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)file3, (String)"jar.parentFile");
            File file4 = file3.getParentFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)file4, (String)"jar.parentFile.parentFile");
            File pluginHome = file4.getParentFile();
            return new KotlinPathsFromHomeDir(new File(pluginHome, "kotlinc"));
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<ModuleBuildTarget, List<GeneratedFile>> getGeneratedFiles(CompileContext context, ModuleChunk chunk, OutputItemsCollectorImpl outputItemCollector) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        HashMap sourceToTarget = new HashMap();
        if (chunk.getTargets().size() > 1) {
            for (ModuleBuildTarget target : chunk.getTargets()) {
                KotlinBuildTargets kotlinBuildTargets = TargetPlatformKt.getKotlinBuildTargets(context);
                ModuleBuildTarget moduleBuildTarget = target;
                Intrinsics.checkExpressionValueIsNotNull((Object)moduleBuildTarget, (String)"target");
                KotlinModuleBuildTarget<?> kotlinModuleBuildTarget = kotlinBuildTargets.get(moduleBuildTarget);
                if (kotlinModuleBuildTarget != null && (kotlinModuleBuildTarget = kotlinModuleBuildTarget.getSourceFiles()) != null) {
                    $receiver$iv = (Iterable)((Object)kotlinModuleBuildTarget);
                    for (Object element$iv : $receiver$iv) {
                        File it = (File)element$iv;
                        Map map2 = sourceToTarget;
                        ModuleBuildTarget moduleBuildTarget2 = target;
                        map2.put(it, moduleBuildTarget2);
                    }
                }
            }
        }
        ModuleBuildTarget representativeTarget = chunk.representativeTarget();
        Function1<SimpleOutputItem, ModuleBuildTarget> target$ = new Function1<SimpleOutputItem, ModuleBuildTarget>(sourceToTarget, chunk, representativeTarget){
            final /* synthetic */ HashMap $sourceToTarget;
            final /* synthetic */ ModuleChunk $chunk;
            final /* synthetic */ ModuleBuildTarget $representativeTarget;

            /*
             * WARNING - void declaration
             */
            public final ModuleBuildTarget invoke(@NotNull SimpleOutputItem $receiver) {
                File file;
                File file2;
                File it;
                Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                File file3 = (File)CollectionsKt.firstOrNull((Iterable)$receiver.getSourceFiles());
                if (file3 == null || (file3 = (ModuleBuildTarget)this.$sourceToTarget.get(it = (file2 = file3))) == null) {
                    Object object;
                    block6: {
                        void var3_3;
                        Set set = this.$chunk.getTargets();
                        Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"chunk.targets");
                        Iterable $receiver$iv = set;
                        Object single$iv = null;
                        boolean found$iv = false;
                        for (T element$iv : $receiver$iv) {
                            boolean bl;
                            ModuleBuildTarget it2;
                            ModuleBuildTarget moduleBuildTarget = it2 = (ModuleBuildTarget)element$iv;
                            Intrinsics.checkExpressionValueIsNotNull((Object)moduleBuildTarget, (String)"it");
                            if (moduleBuildTarget.getOutputDir() != null) {
                                File file4;
                                File it3 = file4;
                                File file5 = $receiver.getOutputFile();
                                File file6 = it3;
                                Intrinsics.checkExpressionValueIsNotNull((Object)file6, (String)"it");
                                bl = FilesKt.startsWith((File)file5, (File)file6);
                            } else {
                                bl = false;
                            }
                            if (!bl) continue;
                            if (found$iv) {
                                object = null;
                                break block6;
                            }
                            single$iv = element$iv;
                            found$iv = true;
                        }
                        object = !found$iv ? null : var3_3;
                    }
                    file3 = file = (ModuleBuildTarget)object;
                }
                if (file3 == null) {
                    file = this.$representativeTarget;
                }
                return file;
            }
            {
                this.$sourceToTarget = hashMap;
                this.$chunk = moduleChunk;
                this.$representativeTarget = moduleBuildTarget;
                super(1);
            }
        };
        List<SimpleOutputItem> list = outputItemCollector.getOutputs();
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"outputItemCollector.outputs");
        $receiver$iv = list;
        Iterable iterable = $receiver$iv;
        Map destination$iv$iv = new LinkedHashMap();
        Iterator iterator2 = $receiver$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Object object;
            Map $receiver$iv$iv$iv = destination$iv$iv;
            Object element$iv$iv = iterator2.next();
            SimpleOutputItem p1 = (SimpleOutputItem)element$iv$iv;
            ModuleBuildTarget key$iv$iv = target$.invoke(p1);
            Object value$iv$iv$iv = $receiver$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                ArrayList answer$iv$iv$iv = new ArrayList();
                $receiver$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            p1 = (SimpleOutputItem)element$iv$iv;
            List list2 = list$iv$iv;
            GeneratedFile generatedFile = SimpleOutputItemKt.toGeneratedFile(p1);
            list2.add(generatedFile);
        }
        return destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final void registerOutputItems(ModuleLevelBuilder.OutputConsumer outputConsumer, Map<ModuleBuildTarget, ? extends List<? extends GeneratedFile>> outputItems) {
        Map<ModuleBuildTarget, ? extends List<? extends GeneratedFile>> map2 = outputItems;
        Iterator<Map.Entry<ModuleBuildTarget, ? extends List<? extends GeneratedFile>>> iterator2 = map2.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<ModuleBuildTarget, ? extends List<? extends GeneratedFile>> entry;
            Map.Entry<ModuleBuildTarget, ? extends List<? extends GeneratedFile>> entry2 = entry = iterator2.next();
            ModuleBuildTarget target = entry2.getKey();
            Map.Entry<ModuleBuildTarget, ? extends List<? extends GeneratedFile>> entry3 = entry;
            List<? extends GeneratedFile> outputs = entry3.getValue();
            for (GeneratedFile generatedFile : outputs) {
                Collection<String> collection;
                void $receiver$iv$iv;
                void $receiver$iv;
                Iterable iterable = generatedFile.getSourceFiles();
                File file = generatedFile.getOutputFile();
                BuildTarget buildTarget = (BuildTarget)target;
                ModuleLevelBuilder.OutputConsumer outputConsumer2 = outputConsumer;
                void var10_13 = $receiver$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                for (Object item$iv$iv : $receiver$iv$iv) {
                    void it;
                    File file2 = (File)item$iv$iv;
                    collection = destination$iv$iv;
                    String string = it.getPath();
                    collection.add(string);
                }
                collection = (List)destination$iv$iv;
                outputConsumer2.registerOutputFile(buildTarget, file, (Collection)collection);
            }
        }
    }

    private final void updateLookupStorage(LookupTracker lookupTracker, BuildDataManager dataManager, KotlinDirtySourceFilesHolder dirtyFilesHolder) {
        if (!(lookupTracker instanceof LookupTrackerImpl)) {
            throw (Throwable)((Object)new AssertionError((Object)("Lookup tracker is expected to be LookupTrackerImpl, got " + lookupTracker.getClass())));
        }
        JpsLookupStorageKt.withLookupStorage(dataManager, (Function1)new Function1<LookupStorage, Unit>(dirtyFilesHolder, lookupTracker){
            final /* synthetic */ KotlinDirtySourceFilesHolder $dirtyFilesHolder;
            final /* synthetic */ LookupTracker $lookupTracker;

            public final void invoke(@NotNull LookupStorage lookupStorage) {
                Intrinsics.checkParameterIsNotNull((Object)lookupStorage, (String)"lookupStorage");
                lookupStorage.removeLookupsFrom((Sequence<? extends File>)SequencesKt.plus((Sequence)CollectionsKt.asSequence((Iterable)this.$dirtyFilesHolder.getAllDirtyFiles()), (Sequence)CollectionsKt.asSequence((Iterable)this.$dirtyFilesHolder.getAllRemovedFilesFiles())));
                Set set = ((LookupTrackerImpl)this.$lookupTracker).getLookups().entrySet();
                Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"lookupTracker.lookups.entrySet()");
                Set set2 = ((LookupTrackerImpl)this.$lookupTracker).getPathInterner().getValues();
                Intrinsics.checkExpressionValueIsNotNull((Object)set2, (String)"lookupTracker.pathInterner.values");
                lookupStorage.addAll(set, set2);
            }
            {
                this.$dirtyFilesHolder = kotlinDirtySourceFilesHolder;
                this.$lookupTracker = lookupTracker;
                super(1);
            }
        });
    }

    public KotlinBuilder() {
        super(BuilderCategory.SOURCE_PROCESSOR);
    }

    static {
        Companion = new Companion(null);
        LOG = Logger.getInstance((String)"#org.jetbrains.kotlin.jps.build.KotlinBuilder");
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/jps/build/KotlinBuilder$Companion;", "", "()V", "JPS_KOTLIN_HOME_PROPERTY", "", "KOTLIN_BUILDER_NAME", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "SKIP_CACHE_VERSION_CHECK_PROPERTY", "classesToLoadByParent", "Lorg/jetbrains/kotlin/preloading/ClassCondition;", "getClassesToLoadByParent", "()Lorg/jetbrains/kotlin/preloading/ClassCondition;", "jps-plugin"})
    public static final class Companion {
        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        @NotNull
        public final ClassCondition getClassesToLoadByParent() {
            return classesToLoadByParent.1.INSTANCE;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

