/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.jps.build;

import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.ModuleChunk;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.builders.impl.BuildTargetChunk;
import org.jetbrains.jps.cmdline.ProjectDescriptor;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.ModuleBuildTarget;
import org.jetbrains.jps.incremental.storage.BuildDataManager;
import org.jetbrains.jps.model.JpsProject;
import org.jetbrains.jps.model.java.JpsJavaClasspathKind;
import org.jetbrains.jps.model.java.JpsJavaDependenciesEnumerator;
import org.jetbrains.jps.model.java.JpsJavaExtensionService;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.kotlin.incremental.AbstractIncrementalCache;
import org.jetbrains.kotlin.incremental.BuildUtilKt;
import org.jetbrains.kotlin.incremental.ChangesCollector;
import org.jetbrains.kotlin.incremental.DirtyData;
import org.jetbrains.kotlin.incremental.IncrementalCacheCommon;
import org.jetbrains.kotlin.incremental.LookupStorage;
import org.jetbrains.kotlin.incremental.LookupSymbol;
import org.jetbrains.kotlin.incremental.LookupTrackerImpl;
import org.jetbrains.kotlin.incremental.components.LookupTracker;
import org.jetbrains.kotlin.jps.build.FSOperationsHelper;
import org.jetbrains.kotlin.jps.build.JpsICReporter;
import org.jetbrains.kotlin.jps.build.KotlinBuilderKt;
import org.jetbrains.kotlin.jps.build.TestingContext;
import org.jetbrains.kotlin.jps.build.TestingContextKt;
import org.jetbrains.kotlin.jps.incremental.JpsIncrementalCache;
import org.jetbrains.kotlin.jps.incremental.JpsIncrementalCacheKt;
import org.jetbrains.kotlin.jps.incremental.JpsLookupStorageKt;
import org.jetbrains.kotlin.jps.platforms.KotlinBuildTargets;
import org.jetbrains.kotlin.jps.platforms.KotlinModuleBuildTarget;
import org.jetbrains.kotlin.jps.platforms.TargetPlatformKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.utils.CollectionsKt;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=2, d1={"\u0000l\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u001e\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\"\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u00012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u00012\u0006\u0010\t\u001a\u00020\n\u001a$\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\nH\u0002\u001a\u001c\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\n\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u0015H\u0002\u001a(\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u0001*\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002\u001a8\u0010\u001e\u001a\u00020\u001f*\u00020\u00182\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00170\u00012\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\"2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\r0\u001aH\u0002\u00a8\u0006#"}, d2={"getDependenciesRecursively", "", "Lorg/jetbrains/jps/model/module/JpsModule;", "module", "kind", "Lorg/jetbrains/jps/model/java/JpsJavaClasspathKind;", "getDependentTargets", "Lorg/jetbrains/jps/incremental/ModuleBuildTarget;", "compilingChunkTargets", "context", "Lorg/jetbrains/jps/incremental/CompileContext;", "getIncrementalCaches", "", "Lorg/jetbrains/kotlin/jps/incremental/JpsIncrementalCache;", "chunk", "Lorg/jetbrains/jps/ModuleChunk;", "getLookupTracker", "Lorg/jetbrains/kotlin/incremental/components/LookupTracker;", "project", "Lorg/jetbrains/jps/model/JpsProject;", "representativeTarget", "Lorg/jetbrains/kotlin/jps/platforms/KotlinModuleBuildTarget;", "getDirtyFiles", "Ljava/io/File;", "Lorg/jetbrains/kotlin/incremental/ChangesCollector;", "caches", "", "Lorg/jetbrains/kotlin/incremental/IncrementalCacheCommon;", "dataManager", "Lorg/jetbrains/jps/incremental/storage/BuildDataManager;", "processChangesUsingLookups", "", "compiledFiles", "fsOperations", "Lorg/jetbrains/kotlin/jps/build/FSOperationsHelper;", "jps-plugin"})
public final class KotlinBuilderKt {
    /*
     * WARNING - void declaration
     */
    private static final void processChangesUsingLookups(@NotNull ChangesCollector $receiver, Set<? extends File> compiledFiles, BuildDataManager dataManager, FSOperationsHelper fsOperations, Iterable<? extends JpsIncrementalCache> caches) {
        void $receiver$iv$iv;
        Iterable<? extends JpsIncrementalCache> $receiver$iv;
        Iterable<? extends JpsIncrementalCache> iterable = $receiver$iv = caches;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            JpsIncrementalCache it = (JpsIncrementalCache)element$iv$iv;
            Iterable<AbstractIncrementalCache<?>> list$iv$iv = it.getThisWithDependentCaches();
            kotlin.collections.CollectionsKt.addAll((Collection)destination$iv$iv, list$iv$iv);
        }
        List allCaches = (List)destination$iv$iv;
        JpsICReporter reporter = new JpsICReporter();
        reporter.report((Function0<String>)((Function0)processChangesUsingLookups.1.INSTANCE));
        Set<File> dirtyFiles = KotlinBuilderKt.getDirtyFiles($receiver, allCaches, dataManager);
        Iterable iterable2 = dirtyFiles;
        FSOperationsHelper fSOperationsHelper = fsOperations;
        Iterable iterable3 = iterable2;
        fSOperationsHelper.markInChunkOrDependents(iterable3, compiledFiles);
        reporter.report((Function0<String>)((Function0)processChangesUsingLookups.2.INSTANCE));
    }

    /*
     * WARNING - void declaration
     */
    private static final Set<File> getDirtyFiles(@NotNull ChangesCollector $receiver, Iterable<? extends IncrementalCacheCommon> caches, BuildDataManager dataManager) {
        void dirtyLookupSymbols;
        JpsICReporter reporter = new JpsICReporter();
        DirtyData dirtyData = BuildUtilKt.getDirtyData($receiver, caches, reporter);
        Collection<LookupSymbol> collection = dirtyData.component1();
        Collection<FqName> dirtyClassFqNames = dirtyData.component2();
        Set dirtyFilesFromLookups2 = (Set)JpsLookupStorageKt.withLookupStorage(dataManager, (Function1)new Function1<LookupStorage, Set<? extends File>>((Collection)dirtyLookupSymbols, reporter){
            final /* synthetic */ Collection $dirtyLookupSymbols;
            final /* synthetic */ JpsICReporter $reporter;

            @NotNull
            public final Set<File> invoke(@NotNull LookupStorage it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return BuildUtilKt.mapLookupSymbolsToFiles$default(it, this.$dirtyLookupSymbols, this.$reporter, null, 8, null);
            }
            {
                this.$dirtyLookupSymbols = collection;
                this.$reporter = jpsICReporter;
                super(1);
            }
        });
        return SetsKt.plus((Set)dirtyFilesFromLookups2, (Iterable)BuildUtilKt.mapClassesFqNamesToFiles$default(caches, dirtyClassFqNames, reporter, null, 8, null));
    }

    private static final LookupTracker getLookupTracker(JpsProject project, KotlinModuleBuildTarget<?> representativeTarget) {
        Object testLookupTracker;
        Object object = TestingContextKt.getTestingContext(project);
        if (object == null || (object = ((TestingContext)object).getLookupTracker()) == null) {
            object = testLookupTracker = (LookupTracker)LookupTracker.DO_NOTHING.INSTANCE;
        }
        if (representativeTarget.isIncrementalCompilationEnabled()) {
            return new LookupTrackerImpl((LookupTracker)testLookupTracker);
        }
        return testLookupTracker;
    }

    /*
     * WARNING - void declaration
     */
    private static final Map<ModuleBuildTarget, JpsIncrementalCache> getIncrementalCaches(ModuleChunk chunk, CompileContext context) {
        void $receiver$iv$iv;
        BuildDataManager dataManager = context.getProjectDescriptor().dataManager;
        KotlinBuildTargets kotlinBuildTargets = TargetPlatformKt.getKotlinBuildTargets(context);
        Set set = chunk.getTargets();
        Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"chunk.targets");
        Map<ModuleBuildTarget, JpsIncrementalCache> chunkCaches2 = CollectionsKt.keysToMapExceptNulls(set, (Function1)new Function1<ModuleBuildTarget, JpsIncrementalCache>(dataManager, kotlinBuildTargets){
            final /* synthetic */ BuildDataManager $dataManager;
            final /* synthetic */ KotlinBuildTargets $kotlinBuildTargets;

            @Nullable
            public final JpsIncrementalCache invoke(ModuleBuildTarget it) {
                BuildDataManager buildDataManager = this.$dataManager;
                Intrinsics.checkExpressionValueIsNotNull((Object)buildDataManager, (String)"dataManager");
                ModuleBuildTarget moduleBuildTarget = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)moduleBuildTarget, (String)"it");
                return JpsIncrementalCacheKt.getKotlinCache(buildDataManager, this.$kotlinBuildTargets.get(moduleBuildTarget));
            }
            {
                this.$dataManager = buildDataManager;
                this.$kotlinBuildTargets = kotlinBuildTargets;
                super(1);
            }
        });
        Set<ModuleBuildTarget> dependentTargets = KotlinBuilderKt.getDependentTargets(chunkCaches2.keySet(), context);
        Iterable $receiver$iv = dependentTargets;
        Iterable iterable = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        void $receiver$iv$iv$iv = $receiver$iv$iv;
        Iterator iterator2 = $receiver$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            JpsIncrementalCache jpsIncrementalCache;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            ModuleBuildTarget it = (ModuleBuildTarget)element$iv$iv;
            BuildDataManager buildDataManager = dataManager;
            Intrinsics.checkExpressionValueIsNotNull((Object)buildDataManager, (String)"dataManager");
            if (JpsIncrementalCacheKt.getKotlinCache(buildDataManager, kotlinBuildTargets.get(it)) == null) continue;
            JpsIncrementalCache it$iv$iv = jpsIncrementalCache;
            destination$iv$iv.add(it$iv$iv);
        }
        List dependentCaches = (List)destination$iv$iv;
        for (JpsIncrementalCache chunkCache : chunkCaches2.values()) {
            for (JpsIncrementalCache dependentCache : dependentCaches) {
                chunkCache.addJpsDependentCache(dependentCache);
            }
        }
        return chunkCaches2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Set<ModuleBuildTarget> getDependentTargets(@NotNull Set<ModuleBuildTarget> compilingChunkTargets, @NotNull CompileContext context) {
        Iterator iterator2;
        boolean bl;
        Set compilingChunkModules;
        Object object;
        HashSet hashSet;
        block11: {
            ModuleBuildTarget it;
            void destination$iv;
            void $receiver$iv;
            Intrinsics.checkParameterIsNotNull(compilingChunkTargets, (String)"compilingChunkTargets");
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            if (compilingChunkTargets.isEmpty()) {
                return SetsKt.emptySet();
            }
            Iterable iterable = compilingChunkTargets;
            Collection collection = new LinkedHashSet();
            for (Object item$iv : $receiver$iv) {
                ModuleBuildTarget moduleBuildTarget = (ModuleBuildTarget)item$iv;
                hashSet = destination$iv;
                object = it.getModule();
                hashSet.add(object);
            }
            compilingChunkModules = (Set)destination$iv;
            Iterable $receiver$iv2 = compilingChunkTargets;
            if ($receiver$iv2 instanceof Collection && ((Collection)$receiver$iv2).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $receiver$iv2) {
                    it = (ModuleBuildTarget)element$iv;
                    if (!it.isTests()) continue;
                    bl = true;
                    break block11;
                }
                bl = false;
            }
        }
        boolean compilingChunkIsTests = bl;
        JpsJavaClasspathKind classpathKind = JpsJavaClasspathKind.compile((boolean)compilingChunkIsTests);
        Function1 dependsOnCompilingChunk$ = new Function1<BuildTarget<?>, Boolean>(compilingChunkIsTests, classpathKind, compilingChunkModules){
            final /* synthetic */ boolean $compilingChunkIsTests;
            final /* synthetic */ JpsJavaClasspathKind $classpathKind;
            final /* synthetic */ Set $compilingChunkModules;

            public final boolean invoke(@NotNull BuildTarget<?> target) {
                Intrinsics.checkParameterIsNotNull(target, (String)"target");
                if (!(target instanceof ModuleBuildTarget) || this.$compilingChunkIsTests && !((ModuleBuildTarget)target).isTests()) {
                    return false;
                }
                JpsModule jpsModule = ((ModuleBuildTarget)target).getModule();
                Intrinsics.checkExpressionValueIsNotNull((Object)jpsModule, (String)"target.module");
                JpsJavaClasspathKind jpsJavaClasspathKind = this.$classpathKind;
                Intrinsics.checkExpressionValueIsNotNull((Object)jpsJavaClasspathKind, (String)"classpathKind");
                Set dependencies = KotlinBuilderKt.access$getDependenciesRecursively(jpsModule, jpsJavaClasspathKind);
                return ContainerUtil.intersects((Collection)dependencies, (Collection)this.$compilingChunkModules);
            }
            {
                this.$compilingChunkIsTests = bl;
                this.$classpathKind = jpsJavaClasspathKind;
                this.$compilingChunkModules = set;
                super(1);
            }
        };
        HashSet dependentTargets = new HashSet();
        ProjectDescriptor projectDescriptor = context.getProjectDescriptor();
        Intrinsics.checkExpressionValueIsNotNull((Object)projectDescriptor, (String)"context.projectDescriptor");
        Iterator sortedChunks = projectDescriptor.getBuildTargetIndex().getSortedTargetChunks(context).iterator();
        while (sortedChunks.hasNext()) {
            Object e = sortedChunks.next();
            Intrinsics.checkExpressionValueIsNotNull(e, (String)"sortedChunks.next()");
            if (!Intrinsics.areEqual((Object)((BuildTargetChunk)e).getTargets(), compilingChunkTargets)) continue;
            break;
        }
        Iterator iterator3 = iterator2 = sortedChunks;
        while (iterator3.hasNext()) {
            void $receiver$iv$iv;
            boolean bl2;
            Iterable $receiver$iv;
            BuildTargetChunk followingChunk;
            block12: {
                BuildTargetChunk buildTargetChunk = followingChunk = (BuildTargetChunk)iterator3.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)buildTargetChunk, (String)"followingChunk");
                Set set = buildTargetChunk.getTargets();
                Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"followingChunk.targets");
                $receiver$iv = set;
                if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                    bl2 = true;
                } else {
                    for (Object element$iv : $receiver$iv) {
                        BuildTarget p1 = (BuildTarget)element$iv;
                        if (!dependsOnCompilingChunk$.invoke(p1)) continue;
                        bl2 = false;
                        break block12;
                    }
                    bl2 = true;
                }
            }
            if (bl2) continue;
            Set set = followingChunk.getTargets();
            Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"followingChunk.targets");
            $receiver$iv = set;
            hashSet = dependentTargets;
            Iterable iterable = $receiver$iv;
            Collection destination$iv$iv = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                if (!(element$iv$iv instanceof ModuleBuildTarget)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            object = (List)destination$iv$iv;
            hashSet.addAll((Collection)object);
        }
        return dependentTargets;
    }

    private static final Set<JpsModule> getDependenciesRecursively(JpsModule module, JpsJavaClasspathKind kind) {
        JpsJavaDependenciesEnumerator jpsJavaDependenciesEnumerator = JpsJavaExtensionService.dependencies((JpsModule)module).includedIn(kind).recursivelyExportedOnly();
        Intrinsics.checkExpressionValueIsNotNull((Object)jpsJavaDependenciesEnumerator, (String)"JpsJavaExtensionService.\u2026recursivelyExportedOnly()");
        Set set = jpsJavaDependenciesEnumerator.getModules();
        Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"JpsJavaExtensionService.\u2026elyExportedOnly().modules");
        return set;
    }

    @NotNull
    public static final /* synthetic */ Map access$getIncrementalCaches(@NotNull ModuleChunk chunk, @NotNull CompileContext context) {
        return KotlinBuilderKt.getIncrementalCaches(chunk, context);
    }

    @NotNull
    public static final /* synthetic */ Set access$getDirtyFiles(@NotNull ChangesCollector $receiver, @NotNull Iterable caches, @NotNull BuildDataManager dataManager) {
        return KotlinBuilderKt.getDirtyFiles($receiver, caches, dataManager);
    }

    @NotNull
    public static final /* synthetic */ LookupTracker access$getLookupTracker(@NotNull JpsProject project, @NotNull KotlinModuleBuildTarget representativeTarget) {
        return KotlinBuilderKt.getLookupTracker(project, representativeTarget);
    }

    public static final /* synthetic */ void access$processChangesUsingLookups(@NotNull ChangesCollector $receiver, @NotNull Set compiledFiles, @NotNull BuildDataManager dataManager, @NotNull FSOperationsHelper fsOperations, @NotNull Iterable caches) {
        KotlinBuilderKt.processChangesUsingLookups($receiver, compiledFiles, dataManager, fsOperations, caches);
    }

    @NotNull
    public static final /* synthetic */ Set access$getDependenciesRecursively(@NotNull JpsModule module, @NotNull JpsJavaClasspathKind kind) {
        return KotlinBuilderKt.getDependenciesRecursively(module, kind);
    }
}

