/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.jps.build;

import com.intellij.util.Consumer;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.builders.AdditionalRootsProviderService;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.builders.BuildTargetType;
import org.jetbrains.jps.builders.java.JavaModuleBuildTargetType;
import org.jetbrains.jps.builders.java.JavaSourceRootDescriptor;
import org.jetbrains.jps.builders.storage.BuildDataPaths;
import org.jetbrains.jps.incremental.ModuleBuildTarget;
import org.jetbrains.jps.model.JpsElement;
import org.jetbrains.jps.model.java.JavaSourceRootProperties;
import org.jetbrains.jps.model.java.JpsJavaDependenciesEnumerator;
import org.jetbrains.jps.model.java.JpsJavaExtensionService;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.jps.model.module.JpsModuleSourceRoot;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;
import org.jetbrains.jps.model.module.JpsTypedModuleSourceRoot;
import org.jetbrains.kotlin.config.KotlinSourceRootType;
import org.jetbrains.kotlin.jps.build.KotlinCommonModuleSourceRoot;
import org.jetbrains.kotlin.jps.build.KotlinSourceRootProviderKt;
import org.jetbrains.kotlin.jps.model.ModuleSettingsKt;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J&\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J&\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00020\r2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/jps/build/KotlinSourceRootProvider;", "Lorg/jetbrains/jps/builders/AdditionalRootsProviderService;", "Lorg/jetbrains/jps/builders/java/JavaSourceRootDescriptor;", "()V", "addCommonModuleSourceRoots", "", "result", "", "commonModule", "Lorg/jetbrains/jps/model/module/JpsModule;", "target", "Lorg/jetbrains/jps/incremental/ModuleBuildTarget;", "getAdditionalRoots", "", "Lorg/jetbrains/jps/builders/BuildTarget;", "dataPaths", "Lorg/jetbrains/jps/builders/storage/BuildDataPaths;", "jps-plugin"})
public final class KotlinSourceRootProvider
extends AdditionalRootsProviderService<JavaSourceRootDescriptor> {
    @NotNull
    public List<JavaSourceRootDescriptor> getAdditionalRoots(@NotNull BuildTarget<JavaSourceRootDescriptor> target, @Nullable BuildDataPaths dataPaths) {
        Intrinsics.checkParameterIsNotNull(target, (String)"target");
        BuildTarget<JavaSourceRootDescriptor> buildTarget = target;
        if (!(buildTarget instanceof ModuleBuildTarget)) {
            buildTarget = null;
        }
        ModuleBuildTarget moduleBuildTarget = (ModuleBuildTarget)buildTarget;
        if (moduleBuildTarget == null) {
            return CollectionsKt.emptyList();
        }
        ModuleBuildTarget moduleBuildTarget2 = moduleBuildTarget;
        JpsModule module = moduleBuildTarget2.getModule();
        List result = new ArrayList();
        KotlinSourceRootType kotlinSourceRootType = ((ModuleBuildTarget)target).isTests() ? (KotlinSourceRootType)KotlinSourceRootType.TestSource.INSTANCE : (KotlinSourceRootType)KotlinSourceRootType.Source.INSTANCE;
        Iterable iterable = module.getSourceRoots((JpsModuleSourceRootType)kotlinSourceRootType);
        Intrinsics.checkExpressionValueIsNotNull((Object)iterable, (String)"module.getSourceRoots(kotlinSourceRootType)");
        Iterable $receiver$iv = iterable;
        for (Object element$iv : $receiver$iv) {
            Set set;
            JpsTypedModuleSourceRoot it;
            JpsTypedModuleSourceRoot jpsTypedModuleSourceRoot = it = (JpsTypedModuleSourceRoot)element$iv;
            Intrinsics.checkExpressionValueIsNotNull((Object)jpsTypedModuleSourceRoot, (String)"it");
            File file = jpsTypedModuleSourceRoot.getFile();
            ModuleBuildTarget moduleBuildTarget3 = (ModuleBuildTarget)target;
            JpsElement jpsElement = it.getProperties();
            Intrinsics.checkExpressionValueIsNotNull((Object)jpsElement, (String)"it.properties");
            String string = ((JavaSourceRootProperties)jpsElement).getPackagePrefix();
            boolean bl = false;
            boolean bl2 = false;
            ModuleBuildTarget moduleBuildTarget4 = moduleBuildTarget3;
            File file2 = file;
            List list = result;
            Set set2 = set = SetsKt.emptySet();
            String string2 = string;
            boolean bl3 = bl;
            boolean bl4 = bl2;
            ModuleBuildTarget moduleBuildTarget5 = moduleBuildTarget4;
            File file3 = file2;
            list.add(new JavaSourceRootDescriptor(file3, moduleBuildTarget5, bl4, bl3, string2, set2));
        }
        JpsModule jpsModule = module;
        Intrinsics.checkExpressionValueIsNotNull((Object)jpsModule, (String)"module");
        $receiver$iv = ModuleSettingsKt.getExpectedByModules(jpsModule);
        for (Object element$iv : $receiver$iv) {
            JpsModule commonModule = (JpsModule)element$iv;
            this.addCommonModuleSourceRoots(result, commonModule, (ModuleBuildTarget)target);
        }
        return result;
    }

    private final void addCommonModuleSourceRoots(List<JavaSourceRootDescriptor> result, JpsModule commonModule, ModuleBuildTarget target) {
        JpsJavaDependenciesEnumerator jpsJavaDependenciesEnumerator;
        Iterator iterator2 = commonModule.getSourceRoots().iterator();
        while (iterator2.hasNext()) {
            File file;
            Set set;
            JpsModuleSourceRoot commonSourceRoot;
            JpsModuleSourceRoot jpsModuleSourceRoot = commonSourceRoot = (JpsModuleSourceRoot)iterator2.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)jpsModuleSourceRoot, (String)"commonSourceRoot");
            JpsModuleSourceRootType jpsModuleSourceRootType = jpsModuleSourceRoot.getRootType();
            Intrinsics.checkExpressionValueIsNotNull((Object)jpsModuleSourceRootType, (String)"commonSourceRoot.rootType");
            Boolean isCommonTestsRootType = KotlinSourceRootProviderKt.access$isTestsRootType$p(jpsModuleSourceRootType);
            if (isCommonTestsRootType == null || !Intrinsics.areEqual((Object)target.isTests(), (Object)isCommonTestsRootType)) continue;
            JpsElement jpsElement = commonSourceRoot.getProperties();
            if (!(jpsElement instanceof JavaSourceRootProperties)) {
                jpsElement = null;
            }
            JavaSourceRootProperties javaSourceRootProperties = (JavaSourceRootProperties)jpsElement;
            Intrinsics.checkExpressionValueIsNotNull((Object)commonSourceRoot.getFile(), (String)"commonSourceRoot.file");
            JavaSourceRootProperties javaSourceRootProperties2 = javaSourceRootProperties;
            boolean bl = javaSourceRootProperties2 != null ? javaSourceRootProperties2.isForGeneratedSources() : false;
            Object object = javaSourceRootProperties;
            if (object == null || (object = object.getPackagePrefix()) == null) {
                object = "";
            }
            Object object2 = object;
            boolean bl2 = false;
            boolean bl3 = bl;
            ModuleBuildTarget moduleBuildTarget = target;
            List<JavaSourceRootDescriptor> list = result;
            Set set2 = set = SetsKt.emptySet();
            Object object3 = object2;
            boolean bl4 = bl2;
            boolean bl5 = bl3;
            ModuleBuildTarget moduleBuildTarget2 = moduleBuildTarget;
            File file2 = file;
            list.add(new KotlinCommonModuleSourceRoot(file2, moduleBuildTarget2, bl5, bl4, (String)object3, set2));
        }
        JpsJavaDependenciesEnumerator it = jpsJavaDependenciesEnumerator = JpsJavaExtensionService.dependencies((JpsModule)commonModule);
        if (!target.isTests()) {
            it.productionOnly();
        }
        jpsJavaDependenciesEnumerator.processModules((Consumer)new Consumer<JpsModule>(this, result, target){
            final /* synthetic */ KotlinSourceRootProvider this$0;
            final /* synthetic */ List $result;
            final /* synthetic */ ModuleBuildTarget $target;

            public final void consume(JpsModule it) {
                JpsModule jpsModule = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)jpsModule, (String)"it");
                BuildTargetType buildTargetType = this.$target.getTargetType();
                if (buildTargetType == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.jps.builders.java.JavaModuleBuildTargetType");
                }
                KotlinSourceRootProvider.access$addCommonModuleSourceRoots(this.this$0, this.$result, jpsModule, new ModuleBuildTarget(it, (JavaModuleBuildTargetType)buildTargetType));
            }
            {
                this.this$0 = kotlinSourceRootProvider;
                this.$result = list;
                this.$target = moduleBuildTarget;
            }
        });
    }

    public KotlinSourceRootProvider() {
        super((Collection)JavaModuleBuildTargetType.ALL_TYPES);
    }

    public static final /* synthetic */ void access$addCommonModuleSourceRoots(KotlinSourceRootProvider $this, @NotNull List result, @NotNull JpsModule commonModule, @NotNull ModuleBuildTarget target) {
        $this.addCommonModuleSourceRoots(result, commonModule, target);
    }
}

