/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.jps.platforms;

import java.io.File;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.builders.ModuleBasedBuildTargetType;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.ModuleBuildTarget;
import org.jetbrains.jps.model.java.JpsJavaDependenciesEnumerator;
import org.jetbrains.jps.model.library.JpsLibrary;
import org.jetbrains.jps.model.library.JpsLibraryRoot;
import org.jetbrains.jps.model.library.JpsOrderRootType;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.jps.util.JpsPathUtil;
import org.jetbrains.kotlin.config.TargetPlatformKind;
import org.jetbrains.kotlin.jps.model.ModuleSettingsKt;
import org.jetbrains.kotlin.jps.platforms.KotlinCommonModuleBuildTarget;
import org.jetbrains.kotlin.jps.platforms.KotlinJsModuleBuildTarget;
import org.jetbrains.kotlin.jps.platforms.KotlinJvmModuleBuildTarget;
import org.jetbrains.kotlin.jps.platforms.KotlinModuleBuildTarget;
import org.jetbrains.kotlin.utils.LibraryUtils;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000f2\u0006\u0010\u0010\u001a\u00020\u0007H\u0002J\u0017\u0010\u0011\u001a\b\u0012\u0002\b\u0003\u0018\u00010\b2\u0006\u0010\u0010\u001a\u00020\u0007H\u0086\u0002J\u001e\u0010\u0011\u001a\b\u0012\u0002\b\u0003\u0018\u00010\b2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0007H\u0087\u0002\u00a2\u0006\u0002\b\u0012J\u0010\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0007H\u0002R\u001e\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00020\u0007\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/jps/platforms/KotlinBuildTargets;", "", "compileContext", "Lorg/jetbrains/jps/incremental/CompileContext;", "(Lorg/jetbrains/jps/incremental/CompileContext;)V", "byJpsModuleBuildTarget", "Ljava/util/concurrent/ConcurrentHashMap;", "Lorg/jetbrains/jps/incremental/ModuleBuildTarget;", "Lorg/jetbrains/kotlin/jps/platforms/KotlinModuleBuildTarget;", "getCompileContext", "()Lorg/jetbrains/jps/incremental/CompileContext;", "isKotlinJsStdlibJar", "", "", "detectTargetPlatform", "Lorg/jetbrains/kotlin/config/TargetPlatformKind;", "target", "get", "getNullable", "hasJsStdLib", "jps-plugin"})
public final class KotlinBuildTargets {
    private final ConcurrentHashMap<ModuleBuildTarget, KotlinModuleBuildTarget<?>> byJpsModuleBuildTarget;
    private final ConcurrentHashMap<String, Boolean> isKotlinJsStdlibJar;
    @NotNull
    private final CompileContext compileContext;

    @JvmName(name="getNullable")
    @Nullable
    public final KotlinModuleBuildTarget<?> getNullable(@Nullable ModuleBuildTarget target) {
        if (target == null) {
            return null;
        }
        return this.get(target);
    }

    @Nullable
    public final KotlinModuleBuildTarget<?> get(@NotNull ModuleBuildTarget target) {
        Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
        if (!(target.getTargetType() instanceof ModuleBasedBuildTargetType)) {
            return null;
        }
        return this.byJpsModuleBuildTarget.computeIfAbsent(target, new Function<ModuleBuildTarget, KotlinModuleBuildTarget<?>>(this, target){
            final /* synthetic */ KotlinBuildTargets this$0;
            final /* synthetic */ ModuleBuildTarget $target;

            @NotNull
            public final KotlinModuleBuildTarget<?> apply(@NotNull ModuleBuildTarget it) {
                KotlinModuleBuildTarget kotlinModuleBuildTarget;
                TargetPlatformKind targetPlatformKind;
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                JpsModule jpsModule = this.$target.getModule();
                Intrinsics.checkExpressionValueIsNotNull((Object)jpsModule, (String)"target.module");
                TargetPlatformKind targetPlatformKind2 = ModuleSettingsKt.getTargetPlatform(jpsModule);
                if (targetPlatformKind2 == null) {
                    targetPlatformKind2 = targetPlatformKind = KotlinBuildTargets.access$detectTargetPlatform(this.this$0, this.$target);
                }
                if (targetPlatformKind instanceof TargetPlatformKind.Common) {
                    kotlinModuleBuildTarget = new KotlinCommonModuleBuildTarget(this.this$0.getCompileContext(), this.$target);
                } else if (targetPlatformKind instanceof TargetPlatformKind.JavaScript) {
                    kotlinModuleBuildTarget = new KotlinJsModuleBuildTarget(this.this$0.getCompileContext(), this.$target);
                } else if (targetPlatformKind instanceof TargetPlatformKind.Jvm) {
                    kotlinModuleBuildTarget = new KotlinJvmModuleBuildTarget(this.this$0.getCompileContext(), this.$target);
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                return kotlinModuleBuildTarget;
            }
            {
                this.this$0 = kotlinBuildTargets;
                this.$target = moduleBuildTarget;
            }
        });
    }

    private final TargetPlatformKind<?> detectTargetPlatform(ModuleBuildTarget target) {
        if (this.hasJsStdLib(target)) {
            return TargetPlatformKind.JavaScript.INSTANCE;
        }
        return TargetPlatformKind.Companion.getDEFAULT_PLATFORM();
    }

    private final boolean hasJsStdLib(ModuleBuildTarget target) {
        JpsJavaDependenciesEnumerator jpsJavaDependenciesEnumerator = new KotlinJvmModuleBuildTarget(this.compileContext, target).getAllDependencies();
        Intrinsics.checkExpressionValueIsNotNull((Object)jpsJavaDependenciesEnumerator, (String)"KotlinJvmModuleBuildTarg\u2026, target).allDependencies");
        Set set = jpsJavaDependenciesEnumerator.getLibraries();
        Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"KotlinJvmModuleBuildTarg\u2026allDependencies.libraries");
        Iterable $receiver$iv = set;
        for (Object element$iv : $receiver$iv) {
            JpsLibrary library = (JpsLibrary)element$iv;
            Iterator iterator2 = library.getRoots(JpsOrderRootType.COMPILED).iterator();
            while (iterator2.hasNext()) {
                Boolean isKotlinJsLib2;
                JpsLibraryRoot root;
                JpsLibraryRoot jpsLibraryRoot = root = (JpsLibraryRoot)iterator2.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)jpsLibraryRoot, (String)"root");
                String url = jpsLibraryRoot.getUrl();
                Boolean bl = isKotlinJsLib2 = this.isKotlinJsStdlibJar.computeIfAbsent(url, new Function<String, Boolean>(url){
                    final /* synthetic */ String $url;

                    public final boolean apply(@NotNull String it) {
                        Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                        File file = JpsPathUtil.urlToFile((String)this.$url);
                        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"JpsPathUtil.urlToFile(url)");
                        return LibraryUtils.isKotlinJavascriptStdLibrary(file);
                    }
                    {
                        this.$url = string;
                    }
                });
                Intrinsics.checkExpressionValueIsNotNull((Object)bl, (String)"isKotlinJsLib");
                if (!bl.booleanValue()) continue;
                return true;
            }
        }
        return false;
    }

    @NotNull
    public final CompileContext getCompileContext() {
        return this.compileContext;
    }

    public KotlinBuildTargets(@NotNull CompileContext compileContext) {
        Intrinsics.checkParameterIsNotNull((Object)compileContext, (String)"compileContext");
        this.compileContext = compileContext;
        this.byJpsModuleBuildTarget = new ConcurrentHashMap();
        this.isKotlinJsStdlibJar = new ConcurrentHashMap();
    }

    @NotNull
    public static final /* synthetic */ TargetPlatformKind access$detectTargetPlatform(KotlinBuildTargets $this, @NotNull ModuleBuildTarget target) {
        return $this.detectTargetPlatform(target);
    }
}

