/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github;

import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ui.SelectFilesDialog;
import com.intellij.openapi.vcs.ui.CommitMessage;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcsUtil.VcsFileUtil;
import git4idea.DialogManager;
import git4idea.GitLocalBranch;
import git4idea.GitUtil;
import git4idea.actions.BasicAction;
import git4idea.actions.GitInit;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitLineHandler;
import git4idea.commands.GitLineHandlerListener;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import git4idea.util.GitFileUtils;
import icons.GithubIcons;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.GithubApiUtil;
import org.jetbrains.plugins.github.api.GithubFullPath;
import org.jetbrains.plugins.github.api.data.GithubRepo;
import org.jetbrains.plugins.github.api.data.GithubRepoDetailed;
import org.jetbrains.plugins.github.api.data.GithubUserDetailed;
import org.jetbrains.plugins.github.exceptions.GithubStatusCodeException;
import org.jetbrains.plugins.github.ui.GithubShareDialog;
import org.jetbrains.plugins.github.util.GithubAuthDataHolder;
import org.jetbrains.plugins.github.util.GithubNotifications;
import org.jetbrains.plugins.github.util.GithubUrlUtil;
import org.jetbrains.plugins.github.util.GithubUtil;

public class GithubShareAction
extends DumbAwareAction {
    private static final Logger LOG = GithubUtil.LOG;

    public GithubShareAction() {
        super("Share Project on GitHub", "Easily share project on GitHub", GithubIcons.Github_icon);
    }

    public void update(AnActionEvent e) {
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        if (project == null || project.isDefault()) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        e.getPresentation().setEnabledAndVisible(true);
    }

    public void actionPerformed(AnActionEvent e) {
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        VirtualFile file = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        if (project == null || project.isDisposed() || !GithubUtil.testGitExecutable(project)) {
            return;
        }
        GithubShareAction.shareProjectOnGithub(project, file);
    }

    public static void shareProjectOnGithub(final @NotNull Project project, @Nullable VirtualFile file) {
        GithubInfo githubInfo;
        if (project == null) {
            GithubShareAction.$$$reportNull$$$0(0);
        }
        BasicAction.saveAll();
        GitRepository gitRepository = GithubUtil.getGitRepository(project, file);
        final boolean gitDetected = gitRepository != null;
        final VirtualFile root = gitDetected ? gitRepository.getRoot() : project.getBaseDir();
        final GithubAuthDataHolder authHolder = GithubAuthDataHolder.createFromSettings();
        Set existingRemotes = Collections.emptySet();
        if (gitDetected) {
            String githubRemote = GithubUtil.findGithubRemoteUrl(gitRepository);
            if (githubRemote != null && !GithubShareAction.checkExistingRemote(project, authHolder, githubRemote)) {
                return;
            }
            existingRemotes = ContainerUtil.map2Set((Collection)gitRepository.getRemotes(), GitRemote::getName);
        }
        if ((githubInfo = GithubShareAction.loadGithubInfoWithModal(authHolder, project)) == null) {
            return;
        }
        GithubShareDialog shareDialog = new GithubShareDialog(project, githubInfo.getRepositoryNames(), existingRemotes, githubInfo.getUser().canCreatePrivateRepo());
        DialogManager.show((DialogWrapper)shareDialog);
        if (!shareDialog.isOK()) {
            return;
        }
        final boolean isPrivate = shareDialog.isPrivate();
        final String name = shareDialog.getRepositoryName();
        final String description = shareDialog.getDescription();
        final String remoteName = shareDialog.getRemoteName();
        new Task.Backgroundable(project, "Sharing Project on GitHub..."){

            public void run(@NotNull ProgressIndicator indicator) {
                GitRepositoryManager repositoryManager;
                GitRepository repository;
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                LOG.info("Creating GitHub repository");
                indicator.setText("Creating GitHub repository...");
                String url = GithubShareAction.createGithubRepository(project, authHolder, indicator, name, description, isPrivate);
                if (url == null) {
                    return;
                }
                LOG.info("Successfully created GitHub repository");
                LOG.info("Binding local project with GitHub");
                if (!gitDetected) {
                    LOG.info("No git detected, creating empty git repo");
                    indicator.setText("Creating empty git repo...");
                    if (!GithubShareAction.createEmptyGitRepository(project, root)) {
                        return;
                    }
                }
                if ((repository = (GitRepository)(repositoryManager = GitUtil.getRepositoryManager((Project)project)).getRepositoryForRoot(root)) == null) {
                    GithubNotifications.showError(project, "Failed to create GitHub Repository", "Can't find Git repository");
                    return;
                }
                String remoteUrl = GithubUrlUtil.getCloneUrl(githubInfo.getUser().getLogin(), name);
                LOG.info("Adding GitHub as a remote host");
                indicator.setText("Adding GitHub as a remote host...");
                if (!GithubUtil.addGithubRemote(project, repository, remoteName, remoteUrl)) {
                    return;
                }
                if (!GithubShareAction.performFirstCommitIfRequired(project, root, repository, indicator, name, url)) {
                    return;
                }
                LOG.info("Pushing to github master");
                indicator.setText("Pushing to github master...");
                if (!GithubShareAction.pushCurrentBranch(project, repository, remoteName, remoteUrl, name, url)) {
                    return;
                }
                GithubNotifications.showInfoURL(project, "Successfully shared project on GitHub", name, url);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/plugins/github/GithubShareAction$1", "run"));
            }
        }.queue();
    }

    private static boolean checkExistingRemote(@NotNull Project project, @NotNull GithubAuthDataHolder authHolder, @NotNull String remote) {
        GithubFullPath path;
        if (project == null) {
            GithubShareAction.$$$reportNull$$$0(1);
        }
        if (authHolder == null) {
            GithubShareAction.$$$reportNull$$$0(2);
        }
        if (remote == null) {
            GithubShareAction.$$$reportNull$$$0(3);
        }
        if ((path = GithubUrlUtil.getUserAndRepositoryFromRemoteUrl(remote)) == null) {
            return GithubNotifications.showYesNoDialog(project, "Project Is Already on GitHub", "Can't connect to repository from configured remote. You could want to check .git config.\nDo you want to proceed anyway?");
        }
        try {
            GithubRepo repo = (GithubRepo)GithubUtil.computeValueInModalIO(project, "Access to GitHub", indicator -> {
                if (project == null) {
                    GithubShareAction.$$$reportNull$$$0(33);
                }
                if (authHolder == null) {
                    GithubShareAction.$$$reportNull$$$0(34);
                }
                return (GithubRepoDetailed)GithubUtil.runTask(project, authHolder, indicator, connection -> GithubApiUtil.getDetailedRepoInfo(connection, path.getUser(), path.getRepository()));
            });
            int result = Messages.showDialog((Project)project, (String)("Successfully connected to " + repo.getHtmlUrl() + ".\nDo you want to proceed anyway?"), (String)"Project Is Already on GitHub", (String[])new String[]{"Continue", "Open in Browser", Messages.CANCEL_BUTTON}, (int)2, (Icon)Messages.getQuestionIcon());
            if (result == 0) {
                return true;
            }
            if (result == 1) {
                BrowserUtil.browse((String)repo.getHtmlUrl());
            }
            return false;
        }
        catch (GithubStatusCodeException e) {
            if (e.getStatusCode() == 404) {
                return GithubNotifications.showYesNoDialog(project, "Project Is Already on GitHub", "Can't connect to repository from configured remote. You could want to check .git config.\nDo you want to proceed anyway?");
            }
            GithubNotifications.showErrorDialog(project, "Failed to Connect to GitHub", (Exception)e);
            return false;
        }
        catch (IOException e) {
            GithubNotifications.showErrorDialog(project, "Failed to Connect to GitHub", (Exception)e);
            return false;
        }
    }

    @Nullable
    private static GithubInfo loadGithubInfoWithModal(@NotNull GithubAuthDataHolder authHolder, @NotNull Project project) {
        if (authHolder == null) {
            GithubShareAction.$$$reportNull$$$0(4);
        }
        if (project == null) {
            GithubShareAction.$$$reportNull$$$0(5);
        }
        try {
            return (GithubInfo)GithubUtil.computeValueInModalIO(project, "Access to GitHub", indicator -> {
                if (project == null) {
                    GithubShareAction.$$$reportNull$$$0(31);
                }
                if (authHolder == null) {
                    GithubShareAction.$$$reportNull$$$0(32);
                }
                return (GithubInfo)GithubUtil.runTask(project, authHolder, indicator, connection -> {
                    GithubUserDetailed userInfo = GithubApiUtil.getCurrentUser(connection);
                    HashSet<String> names = new HashSet<String>();
                    for (GithubRepo info : GithubApiUtil.getUserRepos(connection)) {
                        names.add(info.getName());
                    }
                    return new GithubInfo(userInfo, names);
                });
            });
        }
        catch (IOException e) {
            GithubNotifications.showErrorDialog(project, "Failed to Connect to GitHub", (Exception)e);
            return null;
        }
    }

    @Nullable
    private static String createGithubRepository(@NotNull Project project, @NotNull GithubAuthDataHolder authHolder, @NotNull ProgressIndicator indicator, @NotNull String name, @NotNull String description, boolean isPrivate) {
        if (project == null) {
            GithubShareAction.$$$reportNull$$$0(6);
        }
        if (authHolder == null) {
            GithubShareAction.$$$reportNull$$$0(7);
        }
        if (indicator == null) {
            GithubShareAction.$$$reportNull$$$0(8);
        }
        if (name == null) {
            GithubShareAction.$$$reportNull$$$0(9);
        }
        if (description == null) {
            GithubShareAction.$$$reportNull$$$0(10);
        }
        try {
            return ((GithubRepo)GithubUtil.runTask(project, authHolder, indicator, connection -> {
                if (name == null) {
                    GithubShareAction.$$$reportNull$$$0(29);
                }
                if (description == null) {
                    GithubShareAction.$$$reportNull$$$0(30);
                }
                return GithubApiUtil.createRepo(connection, name, description, isPrivate);
            })).getHtmlUrl();
        }
        catch (IOException e) {
            GithubNotifications.showError(project, "Failed to create GitHub Repository", e);
            return null;
        }
    }

    private static boolean createEmptyGitRepository(@NotNull Project project, @NotNull VirtualFile root) {
        GitCommandResult result;
        if (project == null) {
            GithubShareAction.$$$reportNull$$$0(11);
        }
        if (root == null) {
            GithubShareAction.$$$reportNull$$$0(12);
        }
        if (!(result = Git.getInstance().init(project, root, new GitLineHandlerListener[0])).success()) {
            VcsNotifier.getInstance((Project)project).notifyError(GitBundle.getString((String)"initializing.title"), result.getErrorOutputAsHtmlString());
            LOG.info("Failed to create empty git repo: " + result.getErrorOutputAsJoinedString());
            return false;
        }
        GitInit.refreshAndConfigureVcsMappings((Project)project, (VirtualFile)root, (String)root.getPath());
        return true;
    }

    private static boolean performFirstCommitIfRequired(@NotNull Project project, @NotNull VirtualFile root, @NotNull GitRepository repository, @NotNull ProgressIndicator indicator, @NotNull String name, @NotNull String url) {
        if (project == null) {
            GithubShareAction.$$$reportNull$$$0(13);
        }
        if (root == null) {
            GithubShareAction.$$$reportNull$$$0(14);
        }
        if (repository == null) {
            GithubShareAction.$$$reportNull$$$0(15);
        }
        if (indicator == null) {
            GithubShareAction.$$$reportNull$$$0(16);
        }
        if (name == null) {
            GithubShareAction.$$$reportNull$$$0(17);
        }
        if (url == null) {
            GithubShareAction.$$$reportNull$$$0(18);
        }
        if (!repository.isFresh()) {
            return true;
        }
        LOG.info("Trying to commit");
        try {
            LOG.info("Adding files for commit");
            indicator.setText("Adding files to git...");
            List trackedFiles = ChangeListManager.getInstance((Project)project).getAffectedFiles();
            Collection<VirtualFile> untrackedFiles = GithubShareAction.filterOutIgnored(project, repository.getUntrackedFilesHolder().retrieveUntrackedFiles());
            trackedFiles.removeAll(untrackedFiles);
            ArrayList<VirtualFile> allFiles = new ArrayList<VirtualFile>();
            allFiles.addAll(trackedFiles);
            allFiles.addAll(untrackedFiles);
            Ref dialogRef = new Ref();
            ApplicationManager.getApplication().invokeAndWait(() -> {
                if (project == null) {
                    GithubShareAction.$$$reportNull$$$0(28);
                }
                GithubUntrackedFilesDialog dialog = new GithubUntrackedFilesDialog(project, allFiles);
                if (!trackedFiles.isEmpty()) {
                    dialog.setSelectedFiles(trackedFiles);
                }
                DialogManager.show((DialogWrapper)dialog);
                dialogRef.set((Object)dialog);
            }, indicator.getModalityState());
            GithubUntrackedFilesDialog dialog = (GithubUntrackedFilesDialog)((Object)dialogRef.get());
            Collection files2commit = dialog.getSelectedFiles();
            if (!dialog.isOK() || files2commit.isEmpty()) {
                GithubNotifications.showInfoURL(project, "Successfully created empty repository on GitHub", name, url);
                return false;
            }
            Collection files2add = ContainerUtil.intersection(untrackedFiles, (Collection)files2commit);
            Collection files2rm = ContainerUtil.subtract((Collection)trackedFiles, (Collection)files2commit);
            HashSet modified = new HashSet(trackedFiles);
            modified.addAll(files2commit);
            GitFileUtils.addFiles((Project)project, (VirtualFile)root, (Collection)files2add);
            GitFileUtils.deleteFilesFromCache((Project)project, (VirtualFile)root, (Collection)files2rm);
            LOG.info("Performing commit");
            indicator.setText("Performing commit...");
            GitLineHandler handler = new GitLineHandler(project, root, GitCommand.COMMIT);
            handler.setStdoutSuppressed(false);
            handler.addParameters(new String[]{"-m", dialog.getCommitMessage()});
            handler.endOptions();
            Git.getInstance().runCommand(handler).getOutputOrThrow(new int[0]);
            VcsFileUtil.markFilesDirty((Project)project, modified);
        }
        catch (VcsException e) {
            LOG.warn((Throwable)e);
            GithubNotifications.showErrorURL(project, "Can't finish GitHub sharing process", "Successfully created project ", "'" + name + "'", " on GitHub, but initial commit failed:<br/>" + GithubUtil.getErrorTextFromException((Exception)((Object)e)), url);
            return false;
        }
        LOG.info("Successfully created initial commit");
        return true;
    }

    @NotNull
    private static Collection<VirtualFile> filterOutIgnored(@NotNull Project project, @NotNull Collection<VirtualFile> files) {
        if (project == null) {
            GithubShareAction.$$$reportNull$$$0(19);
        }
        if (files == null) {
            GithubShareAction.$$$reportNull$$$0(20);
        }
        ChangeListManager changeListManager = ChangeListManager.getInstance((Project)project);
        ProjectLevelVcsManager vcsManager = ProjectLevelVcsManager.getInstance((Project)project);
        List list = ContainerUtil.filter(files, file -> !changeListManager.isIgnoredFile(file) && !vcsManager.isIgnored(file));
        if (list == null) {
            GithubShareAction.$$$reportNull$$$0(21);
        }
        return list;
    }

    private static boolean pushCurrentBranch(@NotNull Project project, @NotNull GitRepository repository, @NotNull String remoteName, @NotNull String remoteUrl, @NotNull String name, @NotNull String url) {
        if (project == null) {
            GithubShareAction.$$$reportNull$$$0(22);
        }
        if (repository == null) {
            GithubShareAction.$$$reportNull$$$0(23);
        }
        if (remoteName == null) {
            GithubShareAction.$$$reportNull$$$0(24);
        }
        if (remoteUrl == null) {
            GithubShareAction.$$$reportNull$$$0(25);
        }
        if (name == null) {
            GithubShareAction.$$$reportNull$$$0(26);
        }
        if (url == null) {
            GithubShareAction.$$$reportNull$$$0(27);
        }
        Git git = (Git)ServiceManager.getService(Git.class);
        GitLocalBranch currentBranch = repository.getCurrentBranch();
        if (currentBranch == null) {
            GithubNotifications.showErrorURL(project, "Can't finish GitHub sharing process", "Successfully created project ", "'" + name + "'", " on GitHub, but initial push failed: no current branch", url);
            return false;
        }
        GitCommandResult result = git.push(repository, remoteName, remoteUrl, currentBranch.getName(), true, new GitLineHandlerListener[0]);
        if (!result.success()) {
            GithubNotifications.showErrorURL(project, "Can't finish GitHub sharing process", "Successfully created project ", "'" + name + "'", " on GitHub, but initial push failed:<br/>" + result.getErrorOutputAsHtmlString(), url);
            return false;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 21: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 21: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 32: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "authHolder";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remote";
                break;
            }
            case 8: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 9: 
            case 17: 
            case 26: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 10: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 15: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
            case 18: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/github/GithubShareAction";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteName";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteUrl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/github/GithubShareAction";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "filterOutIgnored";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "shareProjectOnGithub";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "checkExistingRemote";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "loadGithubInfoWithModal";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createGithubRepository";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createEmptyGitRepository";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "performFirstCommitIfRequired";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "filterOutIgnored";
                break;
            }
            case 21: {
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "pushCurrentBranch";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "lambda$performFirstCommitIfRequired$5";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "lambda$createGithubRepository$4";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "lambda$loadGithubInfoWithModal$3";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "lambda$checkExistingRemote$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 21: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class GithubInfo {
        @NotNull
        private final GithubUserDetailed myUser;
        @NotNull
        private final HashSet<String> myRepositoryNames;

        GithubInfo(@NotNull GithubUserDetailed user, @NotNull HashSet<String> repositoryNames) {
            if (user == null) {
                GithubInfo.$$$reportNull$$$0(0);
            }
            if (repositoryNames == null) {
                GithubInfo.$$$reportNull$$$0(1);
            }
            this.myUser = user;
            this.myRepositoryNames = repositoryNames;
        }

        @NotNull
        public GithubUserDetailed getUser() {
            GithubUserDetailed githubUserDetailed = this.myUser;
            if (githubUserDetailed == null) {
                GithubInfo.$$$reportNull$$$0(2);
            }
            return githubUserDetailed;
        }

        @NotNull
        public HashSet<String> getRepositoryNames() {
            HashSet<String> hashSet = this.myRepositoryNames;
            if (hashSet == null) {
                GithubInfo.$$$reportNull$$$0(3);
            }
            return hashSet;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "user";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "repositoryNames";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/github/GithubShareAction$GithubInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/github/GithubShareAction$GithubInfo";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUser";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRepositoryNames";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class GithubUntrackedFilesDialog
    extends SelectFilesDialog
    implements DataProvider {
        @NotNull
        private final Project myProject;
        private CommitMessage myCommitMessagePanel;

        public GithubUntrackedFilesDialog(@NotNull Project project, @NotNull List<VirtualFile> untrackedFiles) {
            if (project == null) {
                GithubUntrackedFilesDialog.$$$reportNull$$$0(0);
            }
            if (untrackedFiles == null) {
                GithubUntrackedFilesDialog.$$$reportNull$$$0(1);
            }
            super(project, untrackedFiles, null, null, true, false, false);
            this.myProject = project;
            this.setTitle("Add Files For Initial Commit");
            this.init();
        }

        protected JComponent createNorthPanel() {
            return null;
        }

        protected JComponent createCenterPanel() {
            JComponent tree = super.createCenterPanel();
            this.myCommitMessagePanel = new CommitMessage(this.myProject);
            this.myCommitMessagePanel.setCommitMessage("Initial commit");
            Splitter splitter = new Splitter(true);
            splitter.setHonorComponentsMinimumSize(true);
            splitter.setFirstComponent(tree);
            splitter.setSecondComponent((JComponent)this.myCommitMessagePanel);
            splitter.setProportion(0.7f);
            return splitter;
        }

        @NotNull
        public String getCommitMessage() {
            String string = this.myCommitMessagePanel.getComment();
            if (string == null) {
                GithubUntrackedFilesDialog.$$$reportNull$$$0(2);
            }
            return string;
        }

        @Nullable
        public Object getData(@NonNls String dataId) {
            if (VcsDataKeys.COMMIT_MESSAGE_CONTROL.is(dataId)) {
                return this.myCommitMessagePanel;
            }
            return null;
        }

        protected String getDimensionServiceKey() {
            return "Github.UntrackedFilesDialog";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "untrackedFiles";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/github/GithubShareAction$GithubUntrackedFilesDialog";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/github/GithubShareAction$GithubUntrackedFilesDialog";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCommitMessage";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

