/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.extensions;

import com.intellij.dvcs.hosting.RepositoryListLoader;
import com.intellij.dvcs.hosting.RepositoryListLoadingException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.text.StringUtil;
import git4idea.DialogManager;
import git4idea.remote.GitRepositoryHostingService;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.github.api.GithubApiUtil;
import org.jetbrains.plugins.github.api.data.GithubRepo;
import org.jetbrains.plugins.github.ui.GithubLoginDialog;
import org.jetbrains.plugins.github.util.AuthLevel;
import org.jetbrains.plugins.github.util.GithubAuthData;
import org.jetbrains.plugins.github.util.GithubAuthDataHolder;
import org.jetbrains.plugins.github.util.GithubSettings;
import org.jetbrains.plugins.github.util.GithubUrlUtil;
import org.jetbrains.plugins.github.util.GithubUtil;

public class GithubRepositoryHostingService
extends GitRepositoryHostingService {
    @NotNull
    public String getServiceDisplayName() {
        if ("GitHub" == null) {
            GithubRepositoryHostingService.$$$reportNull$$$0(0);
        }
        return "GitHub";
    }

    @NotNull
    public RepositoryListLoader getRepositoryListLoader(final @NotNull Project project) {
        if (project == null) {
            GithubRepositoryHostingService.$$$reportNull$$$0(1);
        }
        RepositoryListLoader repositoryListLoader = new RepositoryListLoader(){
            @NotNull
            private final GithubAuthDataHolder myAuthDataHolder = GithubAuthDataHolder.createFromSettings();

            public boolean isEnabled() {
                GithubAuthData authData = this.myAuthDataHolder.getAuthData();
                if (authData.getAuthType().equals((Object)GithubAuthData.AuthType.BASIC)) {
                    GithubAuthData.BasicAuth basicAuth = authData.getBasicAuth();
                    if (basicAuth == null) {
                        return false;
                    }
                    return StringUtil.isNotEmpty((String)basicAuth.getPassword());
                }
                if (authData.getAuthType().equals((Object)GithubAuthData.AuthType.TOKEN)) {
                    GithubAuthData.TokenAuth tokenAuth = authData.getTokenAuth();
                    if (tokenAuth == null) {
                        return false;
                    }
                    return StringUtil.isNotEmpty((String)tokenAuth.getToken());
                }
                return false;
            }

            public boolean enable() {
                GithubAuthData currentAuthData = this.myAuthDataHolder.getAuthData();
                this.myAuthDataHolder.runTransaction(currentAuthData, () -> {
                    if (project == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    GithubLoginDialog dialog = new GithubLoginDialog(project, currentAuthData, AuthLevel.LOGGED);
                    DialogManager.show((DialogWrapper)dialog);
                    if (dialog.isOK()) {
                        GithubAuthData authData = dialog.getAuthData();
                        GithubSettings.getInstance().setAuthData(authData, dialog.isSavePasswordSelected());
                        return authData;
                    }
                    return currentAuthData;
                });
                return this.isEnabled();
            }

            @NotNull
            public List<String> getAvailableRepositories(@NotNull ProgressIndicator progressIndicator) throws RepositoryListLoadingException {
                List<String> list;
                if (progressIndicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                try {
                    list = ((List)GithubUtil.runTask(project, this.myAuthDataHolder, progressIndicator, connection -> GithubApiUtil.getAvailableRepos(connection))).stream().sorted(Comparator.comparing(GithubRepo::getUserName).thenComparing(GithubRepo::getName)).map(repo -> GithubUrlUtil.getCloneUrl(GithubUrlUtil.getGitHostWithoutProtocol(this.myAuthDataHolder.getAuthData().getHost()), repo.getUserName(), repo.getName())).collect(Collectors.toList());
                }
                catch (Exception e) {
                    throw new RepositoryListLoadingException("Error connecting to Github", (Throwable)e);
                }
                if (list == null) {
                    1.$$$reportNull$$$0(1);
                }
                return list;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "progressIndicator";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "org/jetbrains/plugins/github/extensions/GithubRepositoryHostingService$1";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "org/jetbrains/plugins/github/extensions/GithubRepositoryHostingService$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getAvailableRepositories";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getAvailableRepositories";
                        break;
                    }
                    case 1: {
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "lambda$enable$0";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        if (repositoryListLoader == null) {
            GithubRepositoryHostingService.$$$reportNull$$$0(2);
        }
        return repositoryListLoader;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/github/extensions/GithubRepositoryHostingService";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getServiceDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/github/extensions/GithubRepositoryHostingService";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getRepositoryListLoader";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getRepositoryListLoader";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

