/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.ui;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.ui.components.JBBox;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.JBTextField;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UI;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JTextArea;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GithubCreateGistDialog
extends DialogWrapper {
    @Nullable
    private final JBTextField myFileNameField;
    @NotNull
    private final JTextArea myDescriptionField;
    @NotNull
    private final JBCheckBox mySecretCheckBox;
    @NotNull
    private final JBCheckBox myOpenInBrowserCheckBox;

    public GithubCreateGistDialog(@NotNull Project project, @Nullable String fileName, boolean secret, boolean openInBrowser) {
        if (project == null) {
            GithubCreateGistDialog.$$$reportNull$$$0(0);
        }
        super(project, true);
        this.myFileNameField = fileName != null ? new JBTextField(fileName) : null;
        this.myDescriptionField = new JTextArea();
        this.mySecretCheckBox = new JBCheckBox("Secret", secret);
        this.myOpenInBrowserCheckBox = new JBCheckBox("Open in browser", openInBrowser);
        this.setTitle("Create Gist");
        this.init();
    }

    protected JComponent createCenterPanel() {
        JBBox checkBoxes = JBBox.createHorizontalBox();
        checkBoxes.add((Component)this.mySecretCheckBox);
        checkBoxes.add(Box.createRigidArea((Dimension)JBUI.size((int)10, (int)0)));
        checkBoxes.add((Component)this.myOpenInBrowserCheckBox);
        JBScrollPane descriptionPane = new JBScrollPane((Component)this.myDescriptionField);
        descriptionPane.setMinimumSize((Dimension)new JBDimension(150, 50));
        descriptionPane.setPreferredSize((Dimension)new JBDimension(150, 50));
        descriptionPane.setBorder(BorderFactory.createEtchedBorder());
        BorderLayoutPanel panel = JBUI.Panels.simplePanel((int)10, (int)4).addToCenter((Component)JBUI.Panels.simplePanel((int)10, (int)4).addToCenter((Component)descriptionPane).addToTop((Component)new JBLabel("Description:"))).addToBottom((Component)checkBoxes);
        if (this.myFileNameField != null) {
            panel.addToTop((Component)UI.PanelFactory.panel((JComponent)this.myFileNameField).withLabel("Filename:").createPanel());
        }
        return panel;
    }

    protected String getHelpId() {
        return "github.create.gist.dialog";
    }

    protected String getDimensionServiceKey() {
        return "Github.CreateGistDialog";
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myDescriptionField;
    }

    @Nullable
    public String getFileName() {
        return this.myFileNameField != null ? this.myFileNameField.getText() : null;
    }

    @NotNull
    public String getDescription() {
        String string = this.myDescriptionField.getText();
        if (string == null) {
            GithubCreateGistDialog.$$$reportNull$$$0(1);
        }
        return string;
    }

    public boolean isSecret() {
        return this.mySecretCheckBox.isSelected();
    }

    public boolean isOpenInBrowser() {
        return this.myOpenInBrowserCheckBox.isSelected();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/github/ui/GithubCreateGistDialog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/github/ui/GithubCreateGistDialog";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

