/*
 * Decompiled with CFR 0.152.
 */
package com.google.services.creators;

import com.android.tools.idea.structure.services.DeveloperServiceCreator;
import com.android.tools.idea.structure.services.DeveloperServiceCreators;
import com.android.tools.idea.structure.services.ServiceBundle;
import com.google.api.client.repackaged.com.google.common.base.Strings;
import com.intellij.openapi.diagnostic.Logger;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.JAXBException;
import org.jetbrains.annotations.NotNull;

public abstract class FileServiceCreators
implements DeveloperServiceCreators {
    @NotNull
    private static final String ENABLE_ALTERNATE_RESOURCE_LOCATION_FLAG = "com.google.services.resource_location";

    protected abstract DeveloperServiceCreator getServiceCreator(String var1, List<String> var2);

    protected abstract String getResourceConfigFileName();

    @NotNull
    public final Collection<? extends DeveloperServiceCreator> getCreators() {
        Collection<DeveloperServiceCreator> collection;
        try {
            collection = this.loadCreators();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (collection == null) {
            FileServiceCreators.$$$reportNull$$$0(0);
        }
        return collection;
    }

    protected URL getResource(String resourceName) {
        String alternateResourceParameter = System.getProperty(ENABLE_ALTERNATE_RESOURCE_LOCATION_FLAG);
        if (!Strings.isNullOrEmpty((String)alternateResourceParameter)) {
            File altResourceDir = new File(alternateResourceParameter);
            if (altResourceDir.exists() && altResourceDir.isDirectory()) {
                File altResourceFile = new File(altResourceDir, resourceName);
                if (altResourceFile.exists() && altResourceFile.isFile()) {
                    try {
                        return altResourceFile.toURI().toURL();
                    }
                    catch (MalformedURLException malformedURLException) {
                    }
                } else {
                    FileServiceCreators.getLog().warn("Alt resource loading flag was set, but '" + altResourceFile.getAbsolutePath() + "' wasn't found so failing back to standard logic");
                }
            } else {
                FileServiceCreators.getLog().warn("Alt resource loading flag was set to '" + altResourceDir + "', but that doesn't appear to be a valid directory");
            }
        }
        return this.getClass().getResource(resourceName);
    }

    private static Logger getLog() {
        return Logger.getInstance(FileServiceCreators.class);
    }

    private Collection<DeveloperServiceCreator> loadCreators() throws FileNotFoundException {
        String fileName = this.getResourceConfigFileName();
        URL resource = this.getResource(fileName);
        if (resource == null) {
            throw new FileNotFoundException(String.format("Could not find service file %1$s", fileName));
        }
        InputStream inputStream = null;
        InputStreamReader inputStreamReader = null;
        try {
            inputStream = resource.openStream();
            inputStreamReader = new InputStreamReader(inputStream);
            ServiceBundle servicebundle = ServiceBundle.parse((Reader)inputStreamReader);
            List<DeveloperServiceCreator> list = this.generateCreators(servicebundle);
            return list;
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to parse " + fileName + " to read services configuration.", e);
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (inputStreamReader != null) {
                    inputStreamReader.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    private List<DeveloperServiceCreator> generateCreators(@NotNull ServiceBundle serviceBundle) {
        if (serviceBundle == null) {
            FileServiceCreators.$$$reportNull$$$0(1);
        }
        ArrayList<DeveloperServiceCreator> creators = new ArrayList<DeveloperServiceCreator>();
        for (ServiceBundle.Service service : serviceBundle.getServices()) {
            creators.add(this.getServiceCreator(service.getResourceRoot(), service.getResources()));
        }
        return creators;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/google/services/creators/FileServiceCreators";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serviceBundle";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getCreators";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/google/services/creators/FileServiceCreators";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "generateCreators";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

