/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.peephole;

import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.editor.CodeAttributeEditor;
import proguard.classfile.instruction.BranchInstruction;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.InstructionFactory;
import proguard.classfile.instruction.visitor.InstructionVisitor;
import proguard.classfile.util.SimplifiedVisitor;

public class GotoGotoReplacer
extends SimplifiedVisitor
implements InstructionVisitor {
    private final CodeAttributeEditor codeAttributeEditor;
    private final InstructionVisitor extraInstructionVisitor;

    public GotoGotoReplacer(CodeAttributeEditor codeAttributeEditor) {
        this(codeAttributeEditor, null);
    }

    public GotoGotoReplacer(CodeAttributeEditor codeAttributeEditor, InstructionVisitor extraInstructionVisitor) {
        this.codeAttributeEditor = codeAttributeEditor;
        this.extraInstructionVisitor = extraInstructionVisitor;
    }

    public void visitAnyInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, Instruction instruction) {
    }

    public void visitBranchInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, BranchInstruction branchInstruction) {
        byte opcode = branchInstruction.opcode;
        if (opcode == -89 || opcode == -56) {
            int branchOffset = branchInstruction.branchOffset;
            int targetOffset = offset + branchOffset;
            if (branchOffset != 0 && branchOffset != branchInstruction.length(offset) && !this.codeAttributeEditor.isModified(offset) && !this.codeAttributeEditor.isModified(targetOffset)) {
                Instruction targetInstruction = InstructionFactory.create(codeAttribute.code, targetOffset);
                if (targetInstruction.opcode == -89) {
                    int targetBranchOffset = ((BranchInstruction)targetInstruction).branchOffset;
                    BranchInstruction newBranchInstruction = new BranchInstruction(opcode, branchOffset + targetBranchOffset);
                    this.codeAttributeEditor.replaceInstruction(offset, newBranchInstruction);
                    if (this.extraInstructionVisitor != null) {
                        this.extraInstructionVisitor.visitBranchInstruction(clazz, method, codeAttribute, offset, branchInstruction);
                    }
                }
            }
        }
    }
}

