/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal;

import com.android.build.gradle.internal.dependency.VariantDependencies;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.builder.dependency.DependencyContainer;
import com.android.builder.model.AndroidLibrary;
import com.android.builder.model.JavaLibrary;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.tasks.diagnostics.internal.TextReportRenderer;
import org.gradle.internal.graph.GraphRenderer;
import org.gradle.internal.logging.text.StyledTextOutput;
import org.gradle.util.GUtil;

public class AndroidAsciiReportRenderer
extends TextReportRenderer {
    private boolean hasConfigs;
    private boolean hasCyclicDependencies;
    private GraphRenderer renderer;

    public void startProject(Project project) {
        super.startProject(project);
        this.hasConfigs = false;
        this.hasCyclicDependencies = false;
    }

    public void completeProject(Project project) {
        if (!this.hasConfigs) {
            this.getTextOutput().withStyle(StyledTextOutput.Style.Info).println((Object)"No dependencies");
        }
        super.completeProject(project);
    }

    public void startVariant(final BaseVariantData variantData) {
        if (this.hasConfigs) {
            this.getTextOutput().println();
        }
        this.hasConfigs = true;
        this.renderer = new GraphRenderer(this.getTextOutput());
        this.renderer.visit((Action)new Action<StyledTextOutput>(){

            public void execute(StyledTextOutput styledTextOutput) {
                AndroidAsciiReportRenderer.this.getTextOutput().withStyle(StyledTextOutput.Style.Identifier).text((Object)variantData.getVariantConfiguration().getFullName());
                AndroidAsciiReportRenderer.this.getTextOutput().withStyle(StyledTextOutput.Style.Description).text((Object)"");
            }
        }, true);
    }

    private String getDescription(Configuration configuration) {
        return GUtil.isTrue((Object)configuration.getDescription()) ? " - " + configuration.getDescription() : "";
    }

    public void completeConfiguration(BaseVariantData variantData) {
    }

    public void render(BaseVariantData variantData) throws IOException {
        VariantDependencies variantDependency = variantData.getVariantDependency();
        DependencyContainer compileDependencies = variantDependency.getCompileDependencies();
        DependencyContainer packageDependencies = variantDependency.getPackageDependencies();
        ImmutableList libraries = compileDependencies.getAndroidDependencies();
        ImmutableList localDeps = compileDependencies.getLocalDependencies();
        ArrayList localJars = Lists.newArrayListWithCapacity((int)localDeps.size());
        for (JavaLibrary javaLibrary : localDeps) {
            localJars.add(javaLibrary.getJarFile());
        }
        this.renderNow((List<AndroidLibrary>)libraries, localJars);
    }

    void renderNow(List<AndroidLibrary> libraries, List<File> localJars) {
        if (libraries.isEmpty() && (localJars == null || localJars.isEmpty())) {
            this.getTextOutput().withStyle(StyledTextOutput.Style.Info).text((Object)"No dependencies");
            this.getTextOutput().println();
            return;
        }
        this.renderChildren(libraries, localJars);
    }

    public void complete() {
        if (this.hasCyclicDependencies) {
            this.getTextOutput().withStyle(StyledTextOutput.Style.Info).println((Object)"\n(*) - dependencies omitted (listed previously)");
        }
        super.complete();
    }

    private void render(final AndroidLibrary lib, boolean lastChild) {
        this.renderer.visit((Action)new Action<StyledTextOutput>(){

            public void execute(StyledTextOutput styledTextOutput) {
                AndroidAsciiReportRenderer.this.getTextOutput().text((Object)lib.getName());
            }
        }, lastChild);
        this.renderChildren(lib.getLibraryDependencies(), lib.getLocalJars());
    }

    private void render(final File jarLibrary, boolean lastChild) {
        this.renderer.visit((Action)new Action<StyledTextOutput>(){

            public void execute(StyledTextOutput styledTextOutput) {
                AndroidAsciiReportRenderer.this.getTextOutput().text((Object)("LOCAL: " + jarLibrary.getName()));
            }
        }, lastChild);
    }

    private void renderChildren(List<? extends AndroidLibrary> libraries, Collection<File> localJars) {
        this.renderer.startChildren();
        if (localJars != null) {
            boolean emptyChildren = libraries.isEmpty();
            int count = localJars.size();
            int i = 0;
            for (File javaLibrary : localJars) {
                this.render(javaLibrary, emptyChildren && i == count - 1);
                ++i;
            }
        }
        int count = libraries.size();
        for (int i = 0; i < count; ++i) {
            AndroidLibrary lib = libraries.get(i);
            this.render(lib, i == count - 1);
        }
        this.renderer.completeChildren();
    }
}

