/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal;

import android.databinding.tool.DataBindingBuilder;
import com.android.build.api.transform.QualifiedContent;
import com.android.build.gradle.AndroidConfig;
import com.android.build.gradle.internal.DependencyManager;
import com.android.build.gradle.internal.SdkHandler;
import com.android.build.gradle.internal.TaskFactory;
import com.android.build.gradle.internal.TaskManager;
import com.android.build.gradle.internal.core.GradleVariantConfiguration;
import com.android.build.gradle.internal.dsl.CoreBuildType;
import com.android.build.gradle.internal.dsl.CoreJackOptions;
import com.android.build.gradle.internal.incremental.InstantRunPatchingPolicy;
import com.android.build.gradle.internal.incremental.InstantRunWrapperTask;
import com.android.build.gradle.internal.ndk.NdkHandler;
import com.android.build.gradle.internal.pipeline.StreamFilter;
import com.android.build.gradle.internal.pipeline.TransformManager;
import com.android.build.gradle.internal.pipeline.TransformStream;
import com.android.build.gradle.internal.pipeline.TransformTask;
import com.android.build.gradle.internal.scope.AndroidTask;
import com.android.build.gradle.internal.scope.DefaultGradlePackagingScope;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.transforms.InstantRunSplitApkBuilder;
import com.android.build.gradle.internal.variant.ApplicationVariantData;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.build.gradle.internal.variant.BaseVariantOutputData;
import com.android.build.gradle.internal.variant.SplitHandlingPolicy;
import com.android.build.gradle.tasks.AndroidJarTask;
import com.android.builder.core.AndroidBuilder;
import com.android.builder.profile.Recorder;
import com.android.builder.profile.ThreadRecorder;
import com.google.wireless.android.sdk.stats.AndroidStudioStats;
import java.util.List;
import java.util.Set;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.tasks.compile.JavaCompile;
import org.gradle.tooling.provider.model.ToolingModelBuilderRegistry;

public class ApplicationTaskManager
extends TaskManager {
    public ApplicationTaskManager(Project project, AndroidBuilder androidBuilder, DataBindingBuilder dataBindingBuilder, AndroidConfig extension, SdkHandler sdkHandler, NdkHandler ndkHandler, DependencyManager dependencyManager, ToolingModelBuilderRegistry toolingRegistry) {
        super(project, androidBuilder, dataBindingBuilder, extension, sdkHandler, ndkHandler, dependencyManager, toolingRegistry);
    }

    @Override
    public void createTasksForVariantData(final TaskFactory tasks, final BaseVariantData<? extends BaseVariantOutputData> variantData) {
        assert (variantData instanceof ApplicationVariantData);
        String projectPath = this.project.getPath();
        String variantName = variantData.getName();
        final VariantScope variantScope = variantData.getScope();
        this.createAnchorTasks(tasks, variantScope);
        this.createCheckManifestTask(tasks, variantScope);
        this.handleMicroApp(tasks, variantScope);
        this.createDependencyStreams(tasks, variantScope);
        ThreadRecorder.get().record(AndroidStudioStats.GradleBuildProfileSpan.ExecutionType.APP_TASK_MANAGER_CREATE_MERGE_MANIFEST_TASK, projectPath, variantName, (Recorder.Block)new Recorder.Block<Void>(){

            public Void call() {
                ApplicationTaskManager.this.createMergeAppManifestsTask(tasks, variantScope);
                return null;
            }
        });
        ThreadRecorder.get().record(AndroidStudioStats.GradleBuildProfileSpan.ExecutionType.APP_TASK_MANAGER_CREATE_GENERATE_RES_VALUES_TASK, projectPath, variantName, (Recorder.Block)new Recorder.Block<Void>(){

            public Void call() {
                ApplicationTaskManager.this.createGenerateResValuesTask(tasks, variantScope);
                return null;
            }
        });
        ThreadRecorder.get().record(AndroidStudioStats.GradleBuildProfileSpan.ExecutionType.APP_TASK_MANAGER_CREATE_CREATE_RENDERSCRIPT_TASK, projectPath, variantName, (Recorder.Block)new Recorder.Block<Void>(){

            public Void call() {
                ApplicationTaskManager.this.createRenderscriptTask(tasks, variantScope);
                return null;
            }
        });
        ThreadRecorder.get().record(AndroidStudioStats.GradleBuildProfileSpan.ExecutionType.APP_TASK_MANAGER_CREATE_MERGE_RESOURCES_TASK, projectPath, variantName, (Recorder.Block)new Recorder.Block<Void>(){

            public Void call() {
                ApplicationTaskManager.this.createMergeResourcesTask(tasks, variantScope);
                return null;
            }
        });
        ThreadRecorder.get().record(AndroidStudioStats.GradleBuildProfileSpan.ExecutionType.APP_TASK_MANAGER_CREATE_MERGE_ASSETS_TASK, projectPath, variantName, (Recorder.Block)new Recorder.Block<Void>(){

            public Void call() {
                ApplicationTaskManager.this.createMergeAssetsTask(tasks, variantScope);
                return null;
            }
        });
        ThreadRecorder.get().record(AndroidStudioStats.GradleBuildProfileSpan.ExecutionType.APP_TASK_MANAGER_CREATE_BUILD_CONFIG_TASK, projectPath, variantName, (Recorder.Block)new Recorder.Block<Void>(){

            public Void call() {
                ApplicationTaskManager.this.createBuildConfigTask(tasks, variantScope);
                return null;
            }
        });
        ThreadRecorder.get().record(AndroidStudioStats.GradleBuildProfileSpan.ExecutionType.APP_TASK_MANAGER_CREATE_PROCESS_RES_TASK, projectPath, variantName, (Recorder.Block)new Recorder.Block<Void>(){

            public Void call() {
                ApplicationTaskManager.this.createApkProcessResTask(tasks, variantScope);
                ApplicationTaskManager.this.createProcessJavaResTasks(tasks, variantScope);
                return null;
            }
        });
        ThreadRecorder.get().record(AndroidStudioStats.GradleBuildProfileSpan.ExecutionType.APP_TASK_MANAGER_CREATE_AIDL_TASK, projectPath, variantName, (Recorder.Block)new Recorder.Block<Void>(){

            public Void call() {
                ApplicationTaskManager.this.createAidlTask(tasks, variantScope);
                return null;
            }
        });
        ThreadRecorder.get().record(AndroidStudioStats.GradleBuildProfileSpan.ExecutionType.APP_TASK_MANAGER_CREATE_SHADER_TASK, projectPath, variantName, (Recorder.Block)new Recorder.Block<Void>(){

            public Void call() {
                ApplicationTaskManager.this.createShaderTask(tasks, variantScope);
                return null;
            }
        });
        if (!this.isComponentModelPlugin) {
            ThreadRecorder.get().record(AndroidStudioStats.GradleBuildProfileSpan.ExecutionType.APP_TASK_MANAGER_CREATE_NDK_TASK, projectPath, variantName, (Recorder.Block)new Recorder.Block<Void>(){

                public Void call() {
                    ApplicationTaskManager.this.createNdkTasks(variantScope);
                    return null;
                }
            });
        } else if (variantData.compileTask != null) {
            variantData.compileTask.dependsOn(new Object[]{this.getNdkBuildable(variantData)});
        } else {
            variantScope.getCompileTask().dependsOn(tasks, this.getNdkBuildable(variantData));
        }
        variantScope.setNdkBuildable(this.getNdkBuildable(variantData));
        ThreadRecorder.get().record(AndroidStudioStats.GradleBuildProfileSpan.ExecutionType.APP_TASK_MANAGER_CREATE_EXTERNAL_NATIVE_BUILD_TASK, projectPath, variantName, (Recorder.Block)new Recorder.Block<Void>(){

            public Void call() {
                ApplicationTaskManager.this.createExternalNativeBuildJsonGenerators(variantScope);
                ApplicationTaskManager.this.createExternalNativeBuildTasks(tasks, variantScope);
                return null;
            }
        });
        ThreadRecorder.get().record(AndroidStudioStats.GradleBuildProfileSpan.ExecutionType.APP_TASK_MANAGER_CREATE_MERGE_JNILIBS_FOLDERS_TASK, projectPath, variantName, (Recorder.Block)new Recorder.Block<Void>(){

            public Void call() {
                ApplicationTaskManager.this.createMergeJniLibFoldersTasks(tasks, variantScope);
                return null;
            }
        });
        ThreadRecorder.get().record(AndroidStudioStats.GradleBuildProfileSpan.ExecutionType.APP_TASK_MANAGER_CREATE_COMPILE_TASK, projectPath, variantName, (Recorder.Block)new Recorder.Block<Void>(){

            public Void call() {
                CoreJackOptions jackOptions = variantData.getVariantConfiguration().getJackOptions();
                AndroidTask<? extends JavaCompile> javacTask = ApplicationTaskManager.this.createJavacTask(tasks, variantScope);
                if (jackOptions.isEnabled().booleanValue()) {
                    AndroidTask<TransformTask> jackTask = ApplicationTaskManager.this.createJackTask(tasks, variantScope, true);
                    TaskManager.setJavaCompilerTask(jackTask, tasks, variantScope);
                } else {
                    if (variantScope.getGlobalScope().getExtension().getCompileOptions().getTargetCompatibility().isJava8Compatible()) {
                        if (ApplicationTaskManager.this.project.getPlugins().hasPlugin("me.tatarka.retrolambda") || ApplicationTaskManager.this.project.getPlugins().hasPlugin("dexguard")) {
                            ApplicationTaskManager.this.getLogger().warn("Jack is disabled, but one of the plugins you are using supports Java 8 language features.");
                        } else {
                            ApplicationTaskManager.this.androidBuilder.getErrorReporter().handleSyncError(variantScope.getVariantConfiguration().getFullName(), 18, "Jack is required to support java 8 language features. Either enable Jack or remove sourceCompatibility JavaVersion.VERSION_1_8.");
                        }
                    }
                    TaskManager.addJavacClassesStream(variantScope);
                    TaskManager.setJavaCompilerTask(javacTask, tasks, variantScope);
                    ApplicationTaskManager.this.getAndroidTasks().create(tasks, new AndroidJarTask.JarClassesConfigAction(variantScope));
                    ApplicationTaskManager.this.createPostCompilationTasks(tasks, variantScope);
                }
                return null;
            }
        });
        if (this.extension.getDataBinding().isEnabled()) {
            this.createDataBindingTasks(tasks, variantScope);
        }
        ApplicationTaskManager.createStripNativeLibraryTask(tasks, variantScope);
        if (variantData.getSplitHandlingPolicy().equals((Object)SplitHandlingPolicy.RELEASE_21_AND_AFTER_POLICY)) {
            if (this.getExtension().getBuildToolsRevision().getMajor() < 21) {
                throw new RuntimeException("Pure splits can only be used with buildtools 21 and later");
            }
            ThreadRecorder.get().record(AndroidStudioStats.GradleBuildProfileSpan.ExecutionType.APP_TASK_MANAGER_CREATE_SPLIT_TASK, projectPath, variantName, (Recorder.Block)new Recorder.Block<Void>(){

                public Void call() {
                    ApplicationTaskManager.this.createSplitTasks(tasks, variantScope);
                    return null;
                }
            });
        }
        ThreadRecorder.get().record(AndroidStudioStats.GradleBuildProfileSpan.ExecutionType.APP_TASK_MANAGER_CREATE_PACKAGING_TASK, projectPath, variantName, (Recorder.Block)new Recorder.Block<Void>(){

            public Void call() {
                AndroidTask<InstantRunWrapperTask> fullBuildInfoGeneratorTask = ApplicationTaskManager.this.createInstantRunPackagingTasks(tasks, variantScope);
                ApplicationTaskManager.this.createPackagingTask(tasks, variantScope, true, fullBuildInfoGeneratorTask);
                return null;
            }
        });
        ThreadRecorder.get().record(AndroidStudioStats.GradleBuildProfileSpan.ExecutionType.APP_TASK_MANAGER_CREATE_LINT_TASK, projectPath, variantName, (Recorder.Block)new Recorder.Block<Void>(){

            public Void call() {
                ApplicationTaskManager.this.createLintTasks(tasks, variantScope);
                return null;
            }
        });
    }

    protected AndroidTask<InstantRunWrapperTask> createInstantRunPackagingTasks(TaskFactory tasks, VariantScope variantScope) {
        if (this.getIncrementalMode(variantScope.getVariantConfiguration()) == TaskManager.IncrementalMode.NONE) {
            return null;
        }
        AndroidTask<InstantRunWrapperTask> buildInfoGeneratorTask = this.getAndroidTasks().create(tasks, new InstantRunWrapperTask.ConfigAction(variantScope, this.getLogger()));
        InstantRunPatchingPolicy patchingPolicy = variantScope.getInstantRunBuildContext().getPatchingPolicy();
        if (patchingPolicy == InstantRunPatchingPolicy.MULTI_APK) {
            BaseVariantOutputData outputData = variantScope.getVariantData().getOutputs().get(0);
            DefaultGradlePackagingScope packagingScope = new DefaultGradlePackagingScope(outputData.getScope());
            AndroidTask<InstantRunSplitApkBuilder> splitApk = this.getAndroidTasks().create(tasks, new InstantRunSplitApkBuilder.ConfigAction(packagingScope));
            TransformManager transformManager = variantScope.getTransformManager();
            for (TransformStream stream : transformManager.getStreams(StreamFilter.DEX)) {
                splitApk.dependsOn(tasks, stream.getDependencies());
            }
            variantScope.getAssembleTask().dependsOn(tasks, splitApk);
            buildInfoGeneratorTask.dependsOn(tasks, splitApk);
            variantScope.getAssembleTask().dependsOn(tasks, buildInfoGeneratorTask);
        }
        return buildInfoGeneratorTask;
    }

    @Override
    protected Set<QualifiedContent.Scope> getResMergingScopes(VariantScope variantScope) {
        return TransformManager.SCOPE_FULL_PROJECT;
    }

    private void handleMicroApp(TaskFactory tasks, VariantScope scope) {
        BaseVariantData<? extends BaseVariantOutputData> variantData = scope.getVariantData();
        GradleVariantConfiguration variantConfiguration = variantData.getVariantConfiguration();
        Boolean unbundledWearApp = variantConfiguration.getMergedFlavor().getWearAppUnbundled();
        if (Boolean.TRUE.equals(unbundledWearApp)) {
            if (this.hasWearAppDependency(variantData)) {
                this.androidBuilder.getErrorReporter().handleSyncError(scope.getFullVariantName(), 20, String.format("Wear app unbundling is turned on but a dependency on a wear App has been found for variant %s", scope.getFullVariantName()));
            } else {
                this.createGenerateMicroApkDataTask(tasks, scope, null);
            }
        } else if (((CoreBuildType)variantConfiguration.getBuildType()).isEmbedMicroApp()) {
            List<String> wearConfigNames = variantData.getWearConfigNames();
            for (String configName : wearConfigNames) {
                Configuration config = (Configuration)this.project.getConfigurations().findByName(configName);
                if (config == null) continue;
                Set file = config.getFiles();
                int count = file.size();
                if (count == 1) {
                    this.createGenerateMicroApkDataTask(tasks, scope, config);
                    return;
                }
                if (count <= 1) continue;
                this.androidBuilder.getErrorReporter().handleSyncError(configName, 19, String.format("Configuration '%s' resolves to more than one apk.", configName));
            }
        }
    }

    private boolean hasWearAppDependency(BaseVariantData<? extends BaseVariantOutputData> variantData) {
        List<String> wearConfigNames = variantData.getWearConfigNames();
        for (String configName : wearConfigNames) {
            Configuration config = (Configuration)this.project.getConfigurations().findByName(configName);
            if (config == null || config.getFiles().isEmpty()) continue;
            return true;
        }
        return false;
    }
}

