/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal;

import com.google.common.collect.Maps;
import com.google.common.io.Files;
import groovy.lang.Closure;
import java.io.File;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.FileCopyDetails;
import org.gradle.api.file.RelativePath;

public class LibraryCache {
    private static final LibraryCache sCache = new LibraryCache();
    private final Map<String, CountDownLatch> bundleLatches = Maps.newHashMap();

    public static LibraryCache getCache() {
        return sCache;
    }

    public synchronized void unload() {
        this.bundleLatches.clear();
    }

    public static void unzipAar(final File bundle, final File folderOut, final Project project) {
        for (File f : Files.fileTreeTraverser().postOrderTraversal((Object)folderOut)) {
            f.delete();
        }
        folderOut.mkdirs();
        project.copy(new Closure(LibraryCache.class){

            public Object doCall(CopySpec cs) {
                cs.from(new Object[]{project.zipTree((Object)bundle)});
                cs.into((Object)folderOut);
                cs.filesMatching("**/*.jar", (Action)new Action<FileCopyDetails>(){

                    public void execute(FileCopyDetails details) {
                        String path = details.getRelativePath().getPathString();
                        if (path.equals("classes.jar") || path.equals("lint.jar") || path.startsWith("libs/")) {
                            details.setRelativePath(new RelativePath(false, new String[]{"jars"}).plus(details.getRelativePath()));
                        } else if (!path.startsWith("res/raw/*") && !path.startsWith("assets/*")) {
                            project.getLogger().warn("Jar found at unexpected path (" + path + ") in " + bundle + " and will be ignored. Jars should be " + "placed inside 'jars' folder to be merged into dex. Jars " + "that are in assets/ or res/raw/ will be copied as-is.");
                        }
                    }
                });
                return cs;
            }
        });
    }
}

