/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.incremental;

import com.android.build.gradle.internal.incremental.InstantRunBuildContext;
import com.android.build.gradle.internal.incremental.InstantRunBuildMode;
import com.android.build.gradle.internal.incremental.InstantRunPatchingPolicy;
import com.android.build.gradle.internal.incremental.InstantRunVerifierStatus;
import com.google.common.annotations.VisibleForTesting;
import com.google.wireless.android.sdk.stats.AndroidStudioStats;
import org.jetbrains.annotations.Nullable;

public class InstantRunAnalyticsHelper {
    public static AndroidStudioStats.InstantRunStatus generateAnalyticsProto(InstantRunBuildContext instantRunBuildContext) {
        AndroidStudioStats.InstantRunStatus.Builder builder = AndroidStudioStats.InstantRunStatus.newBuilder();
        builder.setBuildMode(InstantRunAnalyticsHelper.convert(instantRunBuildContext.getBuildMode()));
        builder.setPatchingPolicy(InstantRunAnalyticsHelper.convert(instantRunBuildContext.getPatchingPolicy()));
        builder.setVerifierStatus(InstantRunAnalyticsHelper.convert(instantRunBuildContext.getVerifierResult().orElse(null)));
        InstantRunBuildContext.Build last = instantRunBuildContext.getLastBuild();
        if (last != null) {
            for (InstantRunBuildContext.Artifact artifact : last.getArtifacts()) {
                builder.addArtifact(AndroidStudioStats.InstantRunArtifact.newBuilder().setType(InstantRunAnalyticsHelper.convert(artifact.getType())));
            }
        }
        return builder.build();
    }

    @VisibleForTesting
    static AndroidStudioStats.InstantRunStatus.BuildMode convert(InstantRunBuildMode mode) {
        switch (mode) {
            case HOT_WARM: {
                return AndroidStudioStats.InstantRunStatus.BuildMode.HOT_WARM;
            }
            case COLD: {
                return AndroidStudioStats.InstantRunStatus.BuildMode.COLD;
            }
            case FULL: {
                return AndroidStudioStats.InstantRunStatus.BuildMode.FULL;
            }
        }
        return AndroidStudioStats.InstantRunStatus.BuildMode.UNKNOWN_BUILD_MODE;
    }

    @VisibleForTesting
    static AndroidStudioStats.InstantRunStatus.PatchingPolicy convert(@Nullable InstantRunPatchingPolicy policy) {
        if (policy == null) {
            return AndroidStudioStats.InstantRunStatus.PatchingPolicy.UNKNOWN_PATCHING_POLICY;
        }
        switch (policy) {
            case PRE_LOLLIPOP: {
                return AndroidStudioStats.InstantRunStatus.PatchingPolicy.PRE_LOLLIPOP;
            }
            case MULTI_DEX: {
                return AndroidStudioStats.InstantRunStatus.PatchingPolicy.MULTI_DEX;
            }
            case MULTI_APK: {
                return AndroidStudioStats.InstantRunStatus.PatchingPolicy.MULTI_APK;
            }
        }
        return AndroidStudioStats.InstantRunStatus.PatchingPolicy.UNKNOWN_PATCHING_POLICY;
    }

    @VisibleForTesting
    static AndroidStudioStats.InstantRunStatus.VerifierStatus convert(@Nullable InstantRunVerifierStatus status) {
        if (status == null) {
            return AndroidStudioStats.InstantRunStatus.VerifierStatus.UNKNOWN_VERIFIER_STATUS;
        }
        try {
            return AndroidStudioStats.InstantRunStatus.VerifierStatus.valueOf((String)status.toString());
        }
        catch (IllegalArgumentException ignored) {
            return AndroidStudioStats.InstantRunStatus.VerifierStatus.UNKNOWN_VERIFIER_STATUS;
        }
    }

    @VisibleForTesting
    static AndroidStudioStats.InstantRunArtifact.Type convert(InstantRunBuildContext.FileType type) {
        switch (type) {
            case MAIN: {
                return AndroidStudioStats.InstantRunArtifact.Type.MAIN;
            }
            case SPLIT_MAIN: {
                return AndroidStudioStats.InstantRunArtifact.Type.SPLIT_MAIN;
            }
            case RELOAD_DEX: {
                return AndroidStudioStats.InstantRunArtifact.Type.RELOAD_DEX;
            }
            case RESTART_DEX: {
                return AndroidStudioStats.InstantRunArtifact.Type.RESTART_DEX;
            }
            case DEX: {
                return AndroidStudioStats.InstantRunArtifact.Type.DEX;
            }
            case SPLIT: {
                return AndroidStudioStats.InstantRunArtifact.Type.SPLIT;
            }
            case RESOURCES: {
                return AndroidStudioStats.InstantRunArtifact.Type.RESOURCES;
            }
        }
        return null;
    }

    private InstantRunAnalyticsHelper() {
    }
}

