/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.model;

import com.android.builder.model.Library;
import com.android.builder.model.MavenCoordinates;
import com.google.common.base.Objects;
import java.io.Serializable;

class LibraryImpl
implements Library,
Serializable {
    private static final long serialVersionUID = 1L;
    private final String project;
    private final String name;
    private final MavenCoordinates requestedCoordinates;
    private final MavenCoordinates resolvedCoordinates;
    private final boolean isSkipped;
    private final boolean isProvided;

    LibraryImpl(String project, MavenCoordinates requestedCoordinates, MavenCoordinates resolvedCoordinates, boolean isSkipped, boolean isProvided) {
        this.name = resolvedCoordinates.toString();
        this.project = project;
        this.requestedCoordinates = requestedCoordinates;
        this.resolvedCoordinates = resolvedCoordinates;
        this.isSkipped = isSkipped;
        this.isProvided = isProvided;
    }

    protected LibraryImpl(Library clonedLibrary) {
        this.name = clonedLibrary.getName();
        this.project = clonedLibrary.getProject();
        this.requestedCoordinates = clonedLibrary.getRequestedCoordinates();
        this.resolvedCoordinates = clonedLibrary.getResolvedCoordinates();
        this.isSkipped = clonedLibrary.isSkipped();
        this.isProvided = clonedLibrary.isProvided();
    }

    public String getProject() {
        return this.project;
    }

    public String getName() {
        return this.name;
    }

    public MavenCoordinates getRequestedCoordinates() {
        return this.requestedCoordinates;
    }

    public MavenCoordinates getResolvedCoordinates() {
        return this.resolvedCoordinates;
    }

    public boolean isSkipped() {
        return this.isSkipped;
    }

    public boolean isProvided() {
        return this.isProvided;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LibraryImpl library = (LibraryImpl)o;
        return this.isSkipped == library.isSkipped && this.isProvided == library.isProvided && Objects.equal((Object)this.project, (Object)library.project) && Objects.equal((Object)this.name, (Object)library.name) && Objects.equal((Object)this.requestedCoordinates, (Object)library.requestedCoordinates) && Objects.equal((Object)this.resolvedCoordinates, (Object)library.resolvedCoordinates);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.project, this.name, this.requestedCoordinates, this.resolvedCoordinates, this.isSkipped, this.isProvided});
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("name", (Object)this.name).add("requestedCoordinates", (Object)this.requestedCoordinates).add("resolvedCoordinates", (Object)this.resolvedCoordinates).add("isSkipped", this.isSkipped).add("isProvided", this.isProvided).toString();
    }
}

