/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.pipeline;

import com.android.build.api.transform.QualifiedContent;
import com.google.common.collect.ImmutableSet;
import java.util.Set;

public enum ExtendedContentType implements QualifiedContent.ContentType
{
    DEX(4096),
    NATIVE_LIBS(8192),
    CLASSES_ENHANCED(16384),
    JACK(32768);

    private final int value;
    private static final Set<QualifiedContent.ContentType> allContentTypes;

    private ExtendedContentType(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static Set<QualifiedContent.ContentType> getAllContentTypes() {
        return allContentTypes;
    }

    static {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (QualifiedContent.DefaultContentType defaultContentType : QualifiedContent.DefaultContentType.values()) {
            builder.add((Object)defaultContentType);
        }
        for (ExtendedContentType extendedContentType : ExtendedContentType.values()) {
            builder.add((Object)extendedContentType);
        }
        allContentTypes = builder.build();
    }
}

