/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.pipeline;

import com.android.build.api.transform.QualifiedContent;
import com.android.build.api.transform.Transform;
import com.android.build.gradle.internal.TaskFactory;
import com.android.build.gradle.internal.pipeline.ExtendedContentType;
import com.android.build.gradle.internal.pipeline.FilterableStreamCollection;
import com.android.build.gradle.internal.pipeline.IntermediateStream;
import com.android.build.gradle.internal.pipeline.TransformStream;
import com.android.build.gradle.internal.pipeline.TransformTask;
import com.android.build.gradle.internal.scope.AndroidTask;
import com.android.build.gradle.internal.scope.AndroidTaskRegistry;
import com.android.build.gradle.internal.scope.TransformVariantScope;
import com.android.build.gradle.tasks.JackPreDexTransform;
import com.android.builder.core.ErrorReporter;
import com.android.utils.FileUtils;
import com.android.utils.StringHelper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;

public class TransformManager
extends FilterableStreamCollection {
    private static final boolean DEBUG = true;
    private static final String FD_TRANSFORMS = "transforms";
    public static final Set<QualifiedContent.Scope> EMPTY_SCOPES = ImmutableSet.of();
    public static final Set<QualifiedContent.ContentType> CONTENT_CLASS = ImmutableSet.of((Object)QualifiedContent.DefaultContentType.CLASSES);
    public static final Set<QualifiedContent.ContentType> CONTENT_JARS = ImmutableSet.of((Object)QualifiedContent.DefaultContentType.CLASSES, (Object)QualifiedContent.DefaultContentType.RESOURCES);
    public static final Set<QualifiedContent.ContentType> CONTENT_RESOURCES = ImmutableSet.of((Object)QualifiedContent.DefaultContentType.RESOURCES);
    public static final Set<QualifiedContent.ContentType> CONTENT_NATIVE_LIBS = ImmutableSet.of((Object)((Object)ExtendedContentType.NATIVE_LIBS));
    public static final Set<QualifiedContent.ContentType> CONTENT_DEX = ImmutableSet.of((Object)((Object)ExtendedContentType.DEX));
    public static final Set<QualifiedContent.ContentType> CONTENT_JACK = ImmutableSet.of((Object)((Object)ExtendedContentType.JACK));
    public static final Set<QualifiedContent.Scope> SCOPE_FULL_PROJECT = Sets.immutableEnumSet((Enum)QualifiedContent.Scope.PROJECT, (Enum[])new QualifiedContent.Scope[]{QualifiedContent.Scope.PROJECT_LOCAL_DEPS, QualifiedContent.Scope.SUB_PROJECTS, QualifiedContent.Scope.SUB_PROJECTS_LOCAL_DEPS, QualifiedContent.Scope.EXTERNAL_LIBRARIES});
    public static final Set<QualifiedContent.Scope> SCOPE_FULL_LIBRARY = Sets.immutableEnumSet((Enum)QualifiedContent.Scope.PROJECT, (Enum[])new QualifiedContent.Scope[]{QualifiedContent.Scope.PROJECT_LOCAL_DEPS});
    private final AndroidTaskRegistry taskRegistry;
    private final ErrorReporter errorReporter;
    private final Logger logger;
    private final List<TransformStream> streams = Lists.newArrayList();
    private final List<Transform> transforms = Lists.newArrayList();

    public TransformManager(AndroidTaskRegistry taskRegistry, ErrorReporter errorReporter) {
        this.taskRegistry = taskRegistry;
        this.errorReporter = errorReporter;
        this.logger = Logging.getLogger(TransformManager.class);
    }

    public AndroidTaskRegistry getTaskRegistry() {
        return this.taskRegistry;
    }

    public void addStream(TransformStream stream) {
        this.streams.add(stream);
    }

    public <T extends Transform> AndroidTask<TransformTask> addTransform(TaskFactory taskFactory, TransformVariantScope scope, T transform) {
        return this.addTransform(taskFactory, scope, transform, null);
    }

    public <T extends Transform> AndroidTask<TransformTask> addTransform(TaskFactory taskFactory, TransformVariantScope scope, T transform, TransformTask.ConfigActionCallback<T> callback) {
        if (!this.validateTransform(transform)) {
            return null;
        }
        ArrayList inputStreams = Lists.newArrayList();
        String taskName = scope.getTaskName(TransformManager.getTaskNamePrefix(transform));
        List<TransformStream> referencedStreams = this.grabReferencedStreams(transform);
        IntermediateStream outputStream = this.findTransformStreams(transform, scope, inputStreams, taskName, scope.getGlobalScope().getBuildDir());
        if (inputStreams.isEmpty() && referencedStreams.isEmpty()) {
            this.errorReporter.handleSyncError(null, 0, String.format("Unable to add Transform '%s' on variant '%s': requested streams not available: %s+%s / %s", transform.getName(), scope.getFullVariantName(), transform.getScopes(), transform.getReferencedScopes(), transform.getInputTypes()));
            return null;
        }
        if (this.logger.isEnabled(LogLevel.DEBUG)) {
            this.logger.debug("ADDED TRANSFORM(" + scope.getFullVariantName() + "):");
            this.logger.debug("\tName: " + transform.getName());
            this.logger.debug("\tTask: " + taskName);
            for (TransformStream sd : inputStreams) {
                this.logger.debug("\tInputStream: " + sd);
            }
            for (TransformStream sd : referencedStreams) {
                this.logger.debug("\tRef'edStream: " + sd);
            }
            if (outputStream != null) {
                this.logger.debug("\tOutputStream: " + outputStream);
            }
        }
        this.transforms.add(transform);
        AndroidTask<TransformTask> task = this.taskRegistry.create(taskFactory, new TransformTask.ConfigAction<T>(scope.getFullVariantName(), taskName, transform, inputStreams, referencedStreams, outputStream, callback));
        for (TransformStream s : inputStreams) {
            task.dependsOn(taskFactory, s.getDependencies());
        }
        for (TransformStream s : referencedStreams) {
            task.dependsOn(taskFactory, s.getDependencies());
        }
        return task;
    }

    public List<TransformStream> getStreams() {
        return this.streams;
    }

    private static String getTaskNamePrefix(Transform transform) {
        StringBuilder sb = new StringBuilder(100);
        sb.append("transform");
        Iterator iterator = transform.getInputTypes().iterator();
        sb.append(StringHelper.capitalize((String)((QualifiedContent.ContentType)iterator.next()).name().toLowerCase(Locale.getDefault())));
        while (iterator.hasNext()) {
            sb.append("And").append(StringHelper.capitalize((String)((QualifiedContent.ContentType)iterator.next()).name().toLowerCase(Locale.getDefault())));
        }
        sb.append("With").append(StringHelper.capitalize((String)transform.getName())).append("For");
        return sb.toString();
    }

    private IntermediateStream findTransformStreams(Transform transform, TransformVariantScope scope, List<TransformStream> inputStreams, String taskName, File buildDir) {
        Set requestedScopes = transform.getScopes();
        if (requestedScopes.isEmpty()) {
            return null;
        }
        Set requestedTypes = transform.getInputTypes();
        ArrayList oldStreams = Lists.newArrayListWithExpectedSize((int)this.streams.size());
        for (TransformStream stream : this.streams) {
            ImmutableSet availableTypes = stream.getContentTypes();
            ImmutableSet availableScopes = stream.getScopes();
            Sets.SetView commonTypes = Sets.intersection((Set)requestedTypes, availableTypes);
            Sets.SetView commonScopes = Sets.intersection((Set)requestedScopes, availableScopes);
            if (!commonTypes.isEmpty() && !commonScopes.isEmpty()) {
                if (!commonScopes.equals(availableScopes) || !commonTypes.equals(availableTypes)) {
                    inputStreams.add(stream.makeRestrictedCopy((Set<QualifiedContent.ContentType>)commonTypes, (Set<QualifiedContent.Scope>)commonScopes));
                    Sets.SetView remainingTypes = Sets.difference(availableTypes, (Set)commonTypes);
                    Sets.SetView remainingScopes = Sets.difference(availableScopes, (Set)commonScopes);
                    oldStreams.add(stream.makeRestrictedCopy((Set<QualifiedContent.ContentType>)(remainingTypes.isEmpty() ? availableTypes : remainingTypes.immutableCopy()), (Set<QualifiedContent.Scope>)(remainingScopes.isEmpty() ? availableScopes : remainingScopes.immutableCopy())));
                    continue;
                }
                inputStreams.add(stream);
                continue;
            }
            oldStreams.add(stream);
        }
        Set outputTypes = transform.getOutputTypes();
        File outRootFolder = FileUtils.join((File)buildDir, (Iterable)StringHelper.toStrings((Object[])new Object[]{"intermediates", FD_TRANSFORMS, transform.getName(), scope.getDirectorySegments()}));
        this.streams.clear();
        this.streams.addAll(oldStreams);
        IntermediateStream outputStream = IntermediateStream.builder().addContentTypes(outputTypes).addScopes(requestedScopes).setRootLocation(outRootFolder).setDependency(taskName).build();
        this.streams.add(outputStream);
        return outputStream;
    }

    private List<TransformStream> grabReferencedStreams(Transform transform) {
        Set requestedScopes = transform.getReferencedScopes();
        if (requestedScopes.isEmpty()) {
            return ImmutableList.of();
        }
        ArrayList streamMatches = Lists.newArrayListWithExpectedSize((int)this.streams.size());
        Set requestedTypes = transform.getInputTypes();
        for (TransformStream stream : this.streams) {
            Set<QualifiedContent.ContentType> availableTypes = stream.getContentTypes();
            Set<QualifiedContent.Scope> availableScopes = stream.getScopes();
            Sets.SetView commonTypes = Sets.intersection((Set)requestedTypes, availableTypes);
            Sets.SetView commonScopes = Sets.intersection((Set)requestedScopes, availableScopes);
            if (commonTypes.isEmpty() || commonScopes.isEmpty()) continue;
            streamMatches.add(stream);
        }
        return streamMatches;
    }

    private boolean validateTransform(Transform transform) {
        if (!this.checkContentTypes(transform.getInputTypes(), transform) || !this.checkContentTypes(transform.getOutputTypes(), transform)) {
            return false;
        }
        Set scopes = transform.getScopes();
        if (scopes.contains(QualifiedContent.Scope.PROVIDED_ONLY) && !TransformManager.isJackRuntimeLib(transform)) {
            this.errorReporter.handleSyncError(null, 0, String.format("PROVIDED_ONLY scope cannot be consumed by Transform '%1$s'", transform.getName()));
            return false;
        }
        if (scopes.contains(QualifiedContent.Scope.TESTED_CODE)) {
            this.errorReporter.handleSyncError(null, 0, String.format("TESTED_CODE scope cannot be consumed by Transform '%1$s'", transform.getName()));
            return false;
        }
        return true;
    }

    private boolean checkContentTypes(Set<QualifiedContent.ContentType> contentTypes, Transform transform) {
        for (QualifiedContent.ContentType contentType : contentTypes) {
            if (contentType instanceof QualifiedContent.DefaultContentType || contentType instanceof ExtendedContentType) continue;
            this.errorReporter.handleSyncError(null, 0, String.format("Custom content types (%1$s) are not supported in transforms (%2$s)", contentType.getClass().getName(), transform.getName()));
            return false;
        }
        return true;
    }

    private static boolean isJackRuntimeLib(Transform transform) {
        return transform instanceof JackPreDexTransform && ((JackPreDexTransform)transform).isForRuntimeLibs();
    }
}

