/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.profile;

import com.android.build.gradle.internal.LoggerWrapper;
import com.android.build.gradle.internal.profile.RecordingBuildListener;
import com.android.builder.profile.AsyncRecorder;
import com.android.builder.profile.ProcessRecorderFactory;
import com.android.utils.ILogger;
import java.io.File;
import org.gradle.BuildAdapter;
import org.gradle.BuildListener;
import org.gradle.BuildResult;
import org.gradle.api.Project;

public final class ProfilerInitializer {
    private static final Object sLOCK = new Object();
    private static RecordingBuildListener sRecordingBuildListener;

    private ProfilerInitializer() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init(final Project project) {
        ProcessRecorderFactory.initialize((File)project.getRootProject().getProjectDir(), (String)project.getGradle().getGradleVersion(), (ILogger)new LoggerWrapper(project.getLogger()), (File)project.getRootProject().file((Object)("profiler" + System.currentTimeMillis() + ".json")));
        Object object = sLOCK;
        synchronized (object) {
            if (sRecordingBuildListener == null) {
                sRecordingBuildListener = new RecordingBuildListener(AsyncRecorder.get());
                project.getGradle().addListener((Object)sRecordingBuildListener);
            }
        }
        project.getGradle().addBuildListener((BuildListener)new BuildAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void buildFinished(BuildResult buildResult) {
                try {
                    Object object = sLOCK;
                    synchronized (object) {
                        if (sRecordingBuildListener != null) {
                            project.getGradle().removeListener((Object)sRecordingBuildListener);
                            sRecordingBuildListener = null;
                        }
                    }
                    ProcessRecorderFactory.shutdown();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }
}

