/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.profile;

import com.android.build.gradle.internal.tasks.DefaultAndroidTask;
import com.android.builder.profile.Recorder;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.CaseFormat;
import com.google.wireless.android.sdk.stats.AndroidStudioStats;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.gradle.api.Task;
import org.gradle.api.execution.TaskExecutionListener;
import org.gradle.api.tasks.TaskState;

public class RecordingBuildListener
implements TaskExecutionListener {
    private final Recorder mRecorder;
    private final Map<String, AndroidStudioStats.GradleBuildProfileSpan.Builder> mTaskRecords = new ConcurrentHashMap<String, AndroidStudioStats.GradleBuildProfileSpan.Builder>();

    RecordingBuildListener(Recorder recorder) {
        this.mRecorder = recorder;
    }

    public void beforeExecute(Task task) {
        AndroidStudioStats.GradleBuildProfileSpan.Builder builder = AndroidStudioStats.GradleBuildProfileSpan.newBuilder();
        builder.setType(AndroidStudioStats.GradleBuildProfileSpan.ExecutionType.TASK_EXECUTION);
        builder.setId(this.mRecorder.allocationRecordId());
        builder.setStartTimeInMs(System.currentTimeMillis());
        this.mTaskRecords.put(task.getName(), builder);
    }

    public void afterExecute(Task task, TaskState taskState) {
        AndroidStudioStats.GradleBuildProfileSpan.Builder record = this.mTaskRecords.get(task.getName());
        record.setDurationInMs(System.currentTimeMillis() - record.getStartTimeInMs());
        record.setTask(AndroidStudioStats.GradleTaskExecution.newBuilder().setType(RecordingBuildListener.getExecutionType(task.getClass())).setDidWork(taskState.getDidWork()).setSkipped(taskState.getSkipped()).setUpToDate(taskState.getUpToDate()).setFailed(taskState.getFailure() != null));
        this.mRecorder.closeRecord(task.getProject().getPath(), RecordingBuildListener.getVariantName(task), record);
    }

    @VisibleForTesting
    static AndroidStudioStats.GradleTaskExecution.Type getExecutionType(Class<?> taskClass) {
        String taskImpl = taskClass.getSimpleName();
        if (taskImpl.endsWith("_Decorated")) {
            taskImpl = taskImpl.substring(0, taskImpl.length() - "_Decorated".length());
        }
        String potentialExecutionTypeName = CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, taskImpl);
        try {
            return AndroidStudioStats.GradleTaskExecution.Type.valueOf((String)potentialExecutionTypeName);
        }
        catch (IllegalArgumentException ignored) {
            return AndroidStudioStats.GradleTaskExecution.Type.UNKNOWN_TASK_TYPE;
        }
    }

    private static String getVariantName(Task task) {
        if (!(task instanceof DefaultAndroidTask)) {
            return null;
        }
        String variantName = ((DefaultAndroidTask)task).getVariantName();
        if (variantName == null) {
            throw new IllegalStateException("Task with type " + task.getClass().getName() + " does not include a variantName");
        }
        if (variantName.isEmpty()) {
            return null;
        }
        return variantName;
    }
}

