/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.gradle.internal.dependency.DependencyChecker;
import com.android.build.gradle.internal.dependency.VariantDependencies;
import com.android.build.gradle.internal.scope.TaskConfigAction;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.BaseTask;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.builder.model.ApiVersion;
import com.android.builder.model.SyncIssue;
import com.android.sdklib.SdkVersionInfo;
import com.android.utils.StringHelper;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import org.gradle.api.GradleException;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.tasks.ParallelizableTask;
import org.gradle.api.tasks.TaskAction;

@ParallelizableTask
public class PrepareDependenciesTask
extends BaseTask {
    private BaseVariantData variant;
    private final List<DependencyChecker> checkers = Lists.newArrayList();

    @TaskAction
    protected void prepare() {
        ApiVersion minSdkVersion = this.variant.getVariantConfiguration().getMinSdkVersion();
        int minSdk = 1;
        minSdk = minSdkVersion.getCodename() != null ? SdkVersionInfo.getApiByBuildCode((String)minSdkVersion.getCodename(), (boolean)true) : minSdkVersion.getApiLevel();
        boolean foundError = false;
        for (DependencyChecker checker : this.checkers) {
            for (Map.Entry<ModuleVersionIdentifier, Integer> entry : checker.getLegacyApiLevels().entrySet()) {
                ModuleVersionIdentifier mavenVersion = entry.getKey();
                int api = entry.getValue();
                if (api <= minSdk) continue;
                foundError = true;
                String variantName = checker.getVariantName();
                this.getLogger().error(String.format("Variant %s has a dependency on version %s of the legacy %s Maven artifact, which corresponds to API level %s. This is not compatible with min SDK of this module, which is %s. Please use the 'gradle dependencies' task to debug your dependencies graph.", StringHelper.capitalize((String)variantName), mavenVersion.getVersion(), mavenVersion.getGroup(), api, minSdk));
            }
            for (SyncIssue syncIssue : checker.getSyncIssues()) {
                if (syncIssue.getSeverity() != 2) continue;
                foundError = true;
                this.getLogger().error(syncIssue.getMessage());
            }
        }
        if (foundError) {
            throw new GradleException("Dependency Error. See console for details.");
        }
    }

    public void addChecker(DependencyChecker checker) {
        this.checkers.add(checker);
    }

    public BaseVariantData getVariant() {
        return this.variant;
    }

    public void setVariant(BaseVariantData variant) {
        this.variant = variant;
    }

    public static final class ConfigAction
    implements TaskConfigAction<PrepareDependenciesTask> {
        private final VariantScope scope;
        private final VariantDependencies configurationDependencies;

        public ConfigAction(VariantScope scope, VariantDependencies configurationDependencies) {
            this.scope = scope;
            this.configurationDependencies = configurationDependencies;
        }

        @Override
        public String getName() {
            return this.scope.getTaskName("prepare", "Dependencies");
        }

        @Override
        public Class<PrepareDependenciesTask> getType() {
            return PrepareDependenciesTask.class;
        }

        @Override
        public void execute(PrepareDependenciesTask prepareDependenciesTask) {
            this.scope.getVariantData().prepareDependenciesTask = prepareDependenciesTask;
            prepareDependenciesTask.dependsOn(new Object[]{this.scope.getPreBuildTask().getName()});
            prepareDependenciesTask.setAndroidBuilder(this.scope.getGlobalScope().getAndroidBuilder());
            prepareDependenciesTask.setVariantName(this.scope.getVariantConfiguration().getFullName());
            prepareDependenciesTask.setVariant(this.scope.getVariantData());
            prepareDependenciesTask.addChecker(this.configurationDependencies.getChecker());
        }
    }
}

