/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.gradle.internal.LibraryCache;
import com.android.build.gradle.internal.tasks.DefaultAndroidTask;
import com.google.common.io.Files;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.ParallelizableTask;
import org.gradle.api.tasks.TaskAction;

@ParallelizableTask
public class PrepareLibraryTask
extends DefaultAndroidTask {
    private File bundle;
    private File explodedDir;

    @TaskAction
    public void prepare() {
        LibraryCache.unzipAar(this.getBundle(), this.getExplodedDir(), this.getProject());
        File classesJar = new File(new File(this.getExplodedDir(), "jars"), "classes.jar");
        if (classesJar.exists()) {
            return;
        }
        try {
            Files.createParentDirs((File)classesJar);
            JarOutputStream jarOutputStream = new JarOutputStream((OutputStream)new BufferedOutputStream(new FileOutputStream(classesJar)), new Manifest());
            jarOutputStream.close();
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot create missing classes.jar", e);
        }
    }

    @InputFile
    public File getBundle() {
        return this.bundle;
    }

    @OutputDirectory
    public File getExplodedDir() {
        return this.explodedDir;
    }

    public void setBundle(File bundle) {
        this.bundle = bundle;
    }

    public void setExplodedDir(File explodedDir) {
        this.explodedDir = explodedDir;
    }
}

