/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.transforms;

import com.android.build.api.transform.DirectoryInput;
import com.android.build.api.transform.Format;
import com.android.build.api.transform.QualifiedContent;
import com.android.build.api.transform.SecondaryFile;
import com.android.build.api.transform.Transform;
import com.android.build.api.transform.TransformException;
import com.android.build.api.transform.TransformInput;
import com.android.build.api.transform.TransformInvocation;
import com.android.build.api.transform.TransformOutputProvider;
import com.android.build.gradle.internal.LoggerWrapper;
import com.android.build.gradle.internal.incremental.InstantRunBuildContext;
import com.android.build.gradle.internal.pipeline.TransformManager;
import com.android.builder.core.AndroidBuilder;
import com.android.builder.core.DexOptions;
import com.android.builder.internal.utils.FileCache;
import com.android.builder.sdk.TargetInfo;
import com.android.ide.common.blame.Message;
import com.android.ide.common.blame.MessageReceiver;
import com.android.ide.common.blame.ParsingProcessOutputHandler;
import com.android.ide.common.blame.parser.DexParser;
import com.android.ide.common.blame.parser.PatternAwareOutputParser;
import com.android.ide.common.blame.parser.ToolOutputParser;
import com.android.ide.common.internal.WaitableExecutor;
import com.android.ide.common.process.ProcessException;
import com.android.ide.common.process.ProcessOutputHandler;
import com.android.sdklib.BuildToolInfo;
import com.android.utils.FileUtils;
import com.android.utils.ILogger;
import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.gradle.api.logging.Logger;

public class DexTransform
extends Transform {
    private final DexOptions dexOptions;
    private final boolean debugMode;
    private final boolean multiDex;
    private final File mainDexListFile;
    private final File intermediateFolder;
    private final AndroidBuilder androidBuilder;
    private final ILogger logger;
    private final InstantRunBuildContext instantRunBuildContext;
    private final FileCache buildCache;

    public DexTransform(DexOptions dexOptions, boolean debugMode, boolean multiDex, File mainDexListFile, File intermediateFolder, AndroidBuilder androidBuilder, Logger logger, InstantRunBuildContext instantRunBuildContext, FileCache buildCache) {
        this.dexOptions = dexOptions;
        this.debugMode = debugMode;
        this.multiDex = multiDex;
        this.mainDexListFile = mainDexListFile;
        this.intermediateFolder = intermediateFolder;
        this.androidBuilder = androidBuilder;
        this.logger = new LoggerWrapper(logger);
        this.instantRunBuildContext = instantRunBuildContext;
        this.buildCache = buildCache;
    }

    public String getName() {
        return "dex";
    }

    public Set<QualifiedContent.ContentType> getInputTypes() {
        return TransformManager.CONTENT_CLASS;
    }

    public Set<QualifiedContent.ContentType> getOutputTypes() {
        return TransformManager.CONTENT_DEX;
    }

    public Set<QualifiedContent.Scope> getScopes() {
        return TransformManager.SCOPE_FULL_PROJECT;
    }

    public Collection<SecondaryFile> getSecondaryFiles() {
        if (this.mainDexListFile != null) {
            return ImmutableList.of((Object)SecondaryFile.nonIncremental((File)this.mainDexListFile));
        }
        return ImmutableList.of();
    }

    public Collection<File> getSecondaryDirectoryOutputs() {
        if (this.dexOptions.getPreDexLibraries() && (!this.multiDex || this.mainDexListFile != null)) {
            return ImmutableList.of((Object)this.intermediateFolder);
        }
        return ImmutableList.of();
    }

    public Map<String, Object> getParameterInputs() {
        try {
            HashMap params = Maps.newHashMapWithExpectedSize((int)4);
            params.put("optimize", this.getOptimize());
            params.put("predex", this.dexOptions.getPreDexLibraries());
            params.put("jumbo", this.dexOptions.getJumboMode());
            params.put("multidex", this.multiDex);
            params.put("multidex-legacy", this.multiDex && this.mainDexListFile != null);
            params.put("java-max-heap-size", this.dexOptions.getJavaMaxHeapSize());
            params.put("additional-parameters", Iterables.toString((Iterable)this.dexOptions.getAdditionalParameters()));
            TargetInfo targetInfo = this.androidBuilder.getTargetInfo();
            Preconditions.checkState((targetInfo != null ? 1 : 0) != 0, (String)"androidBuilder.targetInfo required for task '%s'.", (Object[])new Object[]{this.getName()});
            BuildToolInfo buildTools = targetInfo.getBuildTools();
            params.put("build-tools", buildTools.getRevision().toString());
            return params;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isIncremental() {
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public void transform(TransformInvocation transformInvocation) throws TransformException, IOException, InterruptedException {
        TransformOutputProvider outputProvider = transformInvocation.getOutputProvider();
        boolean isIncremental = transformInvocation.isIncremental();
        Preconditions.checkNotNull((Object)outputProvider, (Object)("Missing output object for transform " + this.getName()));
        ArrayList jarInputs = Lists.newArrayList();
        ArrayList directoryInputs = Lists.newArrayList();
        for (TransformInput input : transformInvocation.getInputs()) {
            jarInputs.addAll(input.getJarInputs());
            directoryInputs.addAll(input.getDirectoryInputs());
        }
        this.logger.info("Task is incremental : %b ", new Object[]{isIncremental});
        this.logger.info("JarInputs %s", new Object[]{Joiner.on((String)",").join((Iterable)jarInputs)});
        this.logger.info("DirInputs %s", new Object[]{Joiner.on((String)",").join((Iterable)directoryInputs)});
        if (!this.dexOptions.getKeepRuntimeAnnotatedClasses() && this.mainDexListFile != null) {
            this.logger.info("DexOptions.keepRuntimeAnnotatedClasses has no affect in native multidex.", new Object[0]);
        }
        ParsingProcessOutputHandler outputHandler = new ParsingProcessOutputHandler(new ToolOutputParser((PatternAwareOutputParser)new DexParser(), Message.Kind.ERROR, this.logger), new ToolOutputParser((PatternAwareOutputParser)new DexParser(), this.logger), new MessageReceiver[]{this.androidBuilder.getErrorReporter()});
        if (!isIncremental) {
            outputProvider.deleteAll();
        }
        try {
            if (jarInputs.size() + directoryInputs.size() == 1 || !this.dexOptions.getPreDexLibraries()) {
                File outputDir = outputProvider.getContentLocation("main", this.getOutputTypes(), this.getScopes(), Format.DIRECTORY);
                FileUtils.mkdirs((File)outputDir);
                FileUtils.cleanOutputDir((File)outputDir);
                List inputFiles = Stream.concat(jarInputs.stream().map(QualifiedContent::getFile), directoryInputs.stream().map(QualifiedContent::getFile)).collect(Collectors.toList());
                this.androidBuilder.convertByteCode(inputFiles, outputDir, this.multiDex, this.mainDexListFile, this.dexOptions, this.getOptimize(), (ProcessOutputHandler)outputHandler);
                for (File file2 : Files.fileTreeTraverser().breadthFirstTraversal((Object)outputDir)) {
                    if (!file2.isFile()) continue;
                    this.instantRunBuildContext.addChangedFile(InstantRunBuildContext.FileType.DEX, file2);
                }
            } else {
                boolean needMerge = !this.multiDex || this.mainDexListFile != null;
                File perStreamDexFolder = null;
                if (needMerge) {
                    perStreamDexFolder = this.intermediateFolder;
                    if (!isIncremental) {
                        FileUtils.deletePath((File)perStreamDexFolder);
                    }
                }
                HashSet hashs = Sets.newHashSet();
                HashMap inputFiles = Maps.newHashMap();
                HashSet externalLibs = Sets.newHashSet();
                ArrayList deletedFiles = Lists.newArrayList();
                for (DirectoryInput directoryInput : directoryInputs) {
                    File file2 = directoryInput.getFile();
                    if (!file2.exists()) {
                        File preDexedFile = this.getPreDexFile(outputProvider, needMerge, perStreamDexFolder, (QualifiedContent)directoryInput);
                        if (!preDexedFile.exists()) continue;
                        deletedFiles.add(preDexedFile);
                        continue;
                    }
                    if (isIncremental && directoryInput.getChangedFiles().isEmpty()) continue;
                    this.logger.info("Changed file for %s are %s", new Object[]{directoryInput.getFile().getAbsolutePath(), Joiner.on((String)",").join(directoryInput.getChangedFiles().entrySet())});
                    File preDexFile = this.getPreDexFile(outputProvider, needMerge, perStreamDexFolder, (QualifiedContent)directoryInput);
                    inputFiles.put(file2, preDexFile);
                    if (!DexTransform.isExternalLibrary((QualifiedContent)directoryInput)) continue;
                    externalLibs.add(file2);
                }
                for (Object jarInput : jarInputs) {
                    switch (jarInput.getStatus()) {
                        case NOTCHANGED: {
                            if (isIncremental) break;
                        }
                        case CHANGED: 
                        case ADDED: {
                            File file3 = this.getPreDexFile(outputProvider, needMerge, perStreamDexFolder, (QualifiedContent)jarInput);
                            inputFiles.put(jarInput.getFile(), file3);
                            if (!DexTransform.isExternalLibrary((QualifiedContent)jarInput)) break;
                            externalLibs.add(jarInput.getFile());
                            break;
                        }
                        case REMOVED: {
                            File file4 = this.getPreDexFile(outputProvider, needMerge, perStreamDexFolder, (QualifiedContent)jarInput);
                            if (!file4.exists()) break;
                            deletedFiles.add(file4);
                            break;
                        }
                    }
                }
                this.logger.info("inputFiles : %s", new Object[]{Joiner.on((String)",").join(inputFiles.entrySet())});
                this.logger.info("externalLibs %s: ", new Object[]{Joiner.on((String)",").join((Iterable)externalLibs)});
                WaitableExecutor executor = WaitableExecutor.useGlobalSharedThreadPool();
                for (Map.Entry entry : inputFiles.entrySet()) {
                    PreDexTask action = new PreDexTask((File)entry.getKey(), (File)entry.getValue(), hashs, (ProcessOutputHandler)outputHandler, externalLibs.contains(entry.getKey()) ? this.buildCache : FileCache.NO_CACHE);
                    this.logger.info("Adding PreDexTask for %s : %s", new Object[]{entry.getKey(), action});
                    executor.execute((Callable)action);
                }
                for (File file5 : deletedFiles) {
                    executor.execute(() -> {
                        FileUtils.deletePath((File)file3);
                        return null;
                    });
                }
                executor.waitForTasksWithQuickFail(false);
                this.logger.info("Done with all dexing", new Object[0]);
                if (needMerge) {
                    void var15_32;
                    File outputDir = outputProvider.getContentLocation("main", TransformManager.CONTENT_DEX, this.getScopes(), Format.DIRECTORY);
                    FileUtils.mkdirs((File)outputDir);
                    FileUtils.cleanOutputDir((File)outputDir);
                    FileUtils.mkdirs((File)outputDir);
                    Object var15_28 = null;
                    if (!this.multiDex) {
                        File[] files = this.intermediateFolder.listFiles((file, name) -> name.endsWith(".jar"));
                        if (files != null) {
                            List<File> list = Arrays.asList(files);
                        }
                    } else {
                        File[] directories = this.intermediateFolder.listFiles(File::isDirectory);
                        if (directories != null) {
                            List<File> list = Arrays.asList(directories);
                        }
                    }
                    if (var15_32 == null) {
                        throw new RuntimeException("No dex files to merge!");
                    }
                    this.androidBuilder.convertByteCode((Collection)var15_32, outputDir, this.multiDex, this.mainDexListFile, this.dexOptions, this.getOptimize(), (ProcessOutputHandler)outputHandler);
                }
            }
        }
        catch (Exception e) {
            throw new TransformException((Throwable)e);
        }
    }

    private static String getFileHash(File file) throws IOException {
        HashFunction hashFunction = Hashing.sha1();
        HashCode hashCode = file.isDirectory() ? hashFunction.hashString((CharSequence)file.getPath(), Charsets.UTF_16LE) : Files.hash((File)file, (HashFunction)hashFunction);
        return hashCode.toString();
    }

    private File getPreDexFile(TransformOutputProvider output, boolean needMerge, File outFolder, QualifiedContent qualifiedContent) {
        if (needMerge) {
            Preconditions.checkNotNull((Object)outFolder);
            return new File(outFolder, this.getFilename(qualifiedContent.getFile()));
        }
        return this.getOutputLocation(output, qualifiedContent, qualifiedContent.getFile());
    }

    private File getOutputLocation(TransformOutputProvider output, QualifiedContent qualifiedContent, File file) {
        String name = this.instantRunBuildContext.isInInstantRunMode() && (qualifiedContent.getScopes().contains(QualifiedContent.Scope.PROJECT) || qualifiedContent.getScopes().contains(QualifiedContent.Scope.SUB_PROJECTS)) ? this.getInstantRunFileName(file) : this.getFilename(file);
        File contentLocation = output.getContentLocation(name, TransformManager.CONTENT_DEX, qualifiedContent.getScopes(), this.multiDex ? Format.DIRECTORY : Format.JAR);
        if (this.multiDex) {
            FileUtils.mkdirs((File)contentLocation);
        } else {
            FileUtils.mkdirs((File)contentLocation.getParentFile());
        }
        return contentLocation;
    }

    private String getInstantRunFileName(File inputFile) {
        if (inputFile.isDirectory()) {
            return inputFile.getName();
        }
        return inputFile.getName().replace(".", "_");
    }

    private String getFilename(File inputFile) {
        String suffix = this.multiDex ? "" : ".jar";
        return FileUtils.getDirectoryNameForJar((File)inputFile) + suffix;
    }

    private boolean getOptimize() {
        return (Boolean)MoreObjects.firstNonNull((Object)this.dexOptions.getOptimize(), (Object)(!this.debugMode ? 1 : 0));
    }

    private static boolean isExternalLibrary(QualifiedContent content) {
        return content.getScopes().equals(Collections.singleton(QualifiedContent.Scope.EXTERNAL_LIBRARIES));
    }

    private final class PreDexTask
    implements Callable<Void> {
        private final File from;
        private final File to;
        private final Set<String> hashs;
        private final ProcessOutputHandler outputHandler;
        private final FileCache fileCache;

        private PreDexTask(File from, File to, Set<String> hashs, ProcessOutputHandler outputHandler, FileCache fileCache) {
            this.from = from;
            this.to = to;
            this.hashs = hashs;
            this.outputHandler = outputHandler;
            this.fileCache = fileCache;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void call() throws Exception {
            DexTransform.this.logger.info("predex called for %s", new Object[]{this.from});
            String hash = DexTransform.getFileHash(this.from);
            Set<String> set = this.hashs;
            synchronized (set) {
                if (this.hashs.contains(hash)) {
                    DexTransform.this.logger.info("Hash unknown", new Object[0]);
                    return null;
                }
                this.hashs.add(hash);
            }
            boolean optimize = DexTransform.this.getOptimize();
            FileCache.Inputs.Builder inputs = new FileCache.Inputs.Builder();
            String inputFilePath = this.from.getCanonicalPath();
            int explodedAarIndex = inputFilePath.lastIndexOf("exploded-aar");
            if (explodedAarIndex != -1) {
                inputs.put("exploded-aar-file", inputFilePath.substring(explodedAarIndex + "exploded-aar".length() + 1));
            } else {
                inputs.put("file", this.from);
            }
            inputs.put("buildToolsRevision", DexTransform.this.androidBuilder.getTargetInfo().getBuildTools().getRevision().toString());
            inputs.put("jumboMode", DexTransform.this.dexOptions.getJumboMode()).put("optimize", optimize).put("multiDex", DexTransform.this.multiDex);
            List additionalParams = DexTransform.this.dexOptions.getAdditionalParameters();
            for (int i = 0; i < additionalParams.size(); ++i) {
                inputs.put("additionalParameter" + (i + 1), (String)additionalParams.get(i));
            }
            this.fileCache.getOrCreateFile(this.to, inputs.build(), outputFile -> {
                if (DexTransform.this.multiDex) {
                    FileUtils.mkdirs((File)outputFile);
                }
                try {
                    DexTransform.this.androidBuilder.preDexLibrary(this.from, outputFile, DexTransform.this.multiDex, DexTransform.this.dexOptions, optimize, this.outputHandler);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                catch (ProcessException e) {
                    throw new RuntimeException(e);
                }
                return null;
            });
            for (File file : Files.fileTreeTraverser().breadthFirstTraversal((Object)this.to)) {
                if (!file.isFile()) continue;
                DexTransform.this.instantRunBuildContext.addChangedFile(InstantRunBuildContext.FileType.DEX, file);
            }
            return null;
        }
    }
}

