/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.transforms;

import com.android.build.api.transform.DirectoryInput;
import com.android.build.api.transform.Format;
import com.android.build.api.transform.JarInput;
import com.android.build.api.transform.QualifiedContent;
import com.android.build.api.transform.Transform;
import com.android.build.api.transform.TransformException;
import com.android.build.api.transform.TransformInput;
import com.android.build.api.transform.TransformInvocation;
import com.android.build.api.transform.TransformOutputProvider;
import com.android.builder.packaging.PackagingUtils;
import com.android.ide.common.internal.WaitableExecutor;
import com.google.common.base.Preconditions;
import com.google.common.io.ByteStreams;
import com.google.common.io.Closer;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.FileUtils;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;

public class ExtractJarsTransform
extends Transform {
    static Logger LOGGER = Logging.getLogger(ExtractJarsTransform.class);
    private final Set<QualifiedContent.ContentType> contentTypes;
    private final Set<QualifiedContent.Scope> scopes;

    public ExtractJarsTransform(Set<QualifiedContent.ContentType> contentTypes, Set<QualifiedContent.Scope> scopes) {
        this.contentTypes = contentTypes;
        this.scopes = scopes;
    }

    public String getName() {
        return "extractJars";
    }

    public Set<QualifiedContent.ContentType> getInputTypes() {
        return this.contentTypes;
    }

    public Set<QualifiedContent.Scope> getScopes() {
        return this.scopes;
    }

    public boolean isIncremental() {
        return true;
    }

    public void transform(TransformInvocation transformInvocation) throws IOException, TransformException, InterruptedException {
        TransformOutputProvider outputProvider = transformInvocation.getOutputProvider();
        boolean isIncremental = transformInvocation.isIncremental();
        Preconditions.checkNotNull((Object)outputProvider, (Object)("Missing output object for transform " + this.getName()));
        final boolean extractCode = this.contentTypes.contains(QualifiedContent.DefaultContentType.CLASSES);
        if (!isIncremental) {
            outputProvider.deleteAll();
        }
        try {
            WaitableExecutor executor = WaitableExecutor.useGlobalSharedThreadPool();
            for (TransformInput input : transformInvocation.getInputs()) {
                for (DirectoryInput dirInput : input.getDirectoryInputs()) {
                    File dirOutput = outputProvider.getContentLocation(dirInput.getName() + "-" + dirInput.getFile().getAbsolutePath().hashCode(), dirInput.getContentTypes(), dirInput.getScopes(), Format.DIRECTORY);
                    FileUtils.copyDirectory((File)dirInput.getFile(), (File)dirOutput);
                }
                for (JarInput jarInput : input.getJarInputs()) {
                    final File jarFile = jarInput.getFile();
                    final File outJarFolder = outputProvider.getContentLocation(jarFile.getName() + "-" + jarFile.getPath().hashCode(), jarInput.getContentTypes(), jarInput.getScopes(), Format.DIRECTORY);
                    com.android.utils.FileUtils.mkdirs((File)outJarFolder);
                    if (!isIncremental) {
                        executor.execute((Callable)new Callable<Void>(){

                            @Override
                            public Void call() throws Exception {
                                ExtractJarsTransform.extractJar(outJarFolder, jarFile, extractCode);
                                return null;
                            }
                        });
                        continue;
                    }
                    switch (jarInput.getStatus()) {
                        case CHANGED: {
                            executor.execute((Callable)new Callable<Void>(){

                                @Override
                                public Void call() throws Exception {
                                    com.android.utils.FileUtils.cleanOutputDir((File)outJarFolder);
                                    ExtractJarsTransform.extractJar(outJarFolder, jarFile, extractCode);
                                    return null;
                                }
                            });
                            break;
                        }
                        case ADDED: {
                            executor.execute((Callable)new Callable<Void>(){

                                @Override
                                public Void call() throws Exception {
                                    ExtractJarsTransform.extractJar(outJarFolder, jarFile, extractCode);
                                    return null;
                                }
                            });
                            break;
                        }
                        case REMOVED: {
                            executor.execute((Callable)new Callable<Void>(){

                                @Override
                                public Void call() throws Exception {
                                    com.android.utils.FileUtils.delete((File)outJarFolder);
                                    return null;
                                }
                            });
                        }
                    }
                }
            }
            executor.waitForTasksWithQuickFail(true);
        }
        catch (InterruptedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new TransformException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void extractJar(File outJarFolder, File jarFile, boolean extractCode) throws IOException {
        com.android.utils.FileUtils.mkdirs((File)outJarFolder);
        HashSet<String> lowerCaseNames = new HashSet<String>();
        boolean foundCaseInsensitiveIssue = false;
        try (Closer closer = Closer.create();){
            ZipEntry entry;
            FileInputStream fis = (FileInputStream)closer.register((Closeable)new FileInputStream(jarFile));
            ZipInputStream zis = (ZipInputStream)closer.register((Closeable)new ZipInputStream(fis));
            while ((entry = zis.getNextEntry()) != null) {
                try {
                    String name = entry.getName();
                    if (entry.isDirectory()) continue;
                    boolean bl = foundCaseInsensitiveIssue = foundCaseInsensitiveIssue || !lowerCaseNames.add(name.toLowerCase(Locale.US));
                    Action action = ExtractJarsTransform.getAction(name, extractCode);
                    if (action != Action.COPY) continue;
                    File outputFile = new File(outJarFolder, name.replace('/', File.separatorChar));
                    com.android.utils.FileUtils.mkdirs((File)outputFile.getParentFile());
                    Closer closer2 = Closer.create();
                    Throwable throwable = null;
                    try {
                        OutputStream outputStream = (OutputStream)closer2.register((Closeable)new BufferedOutputStream(new FileOutputStream(outputFile)));
                        ByteStreams.copy((InputStream)zis, (OutputStream)outputStream);
                        outputStream.flush();
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (closer2 == null) continue;
                        if (throwable != null) {
                            try {
                                closer2.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        closer2.close();
                    }
                }
                finally {
                    zis.closeEntry();
                }
            }
        }
        if (foundCaseInsensitiveIssue) {
            LOGGER.error("Jar '{}' contains multiple entries which will map to the same file on case insensitive file systems.\nThis can be caused by obfuscation with useMixedCaseClassNames.\nThis build will be incorrect on case insensitive file systems.", (Object)jarFile.getAbsolutePath());
        }
    }

    public static Action getAction(String archivePath, boolean extractCode) {
        if ("META-INF/MANIFEST.MF".equals(archivePath)) {
            return Action.IGNORE;
        }
        String[] segments = archivePath.split("/");
        if (segments.length == 0) {
            return Action.IGNORE;
        }
        return PackagingUtils.checkFileForApkPackaging((String)archivePath, (boolean)extractCode) ? Action.COPY : Action.IGNORE;
    }

    private static File getFolder(File outFolder, File jarFile) {
        return new File(outFolder, jarFile.getName() + "-" + jarFile.getPath().hashCode());
    }

    static enum Action {
        COPY,
        IGNORE;

    }
}

