/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.transforms;

import com.android.build.api.transform.QualifiedContent;
import com.android.build.api.transform.Transform;
import com.android.build.gradle.internal.pipeline.TransformManager;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.builder.core.VariantType;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;

public abstract class ProguardConfigurable
extends Transform {
    private final List<Supplier<Collection<File>>> configurationFiles = Lists.newArrayListWithExpectedSize((int)3);
    private final VariantType variantType;

    ProguardConfigurable(VariantScope scope) {
        this.variantType = scope.getVariantData().getType();
    }

    public void setConfigurationFiles(Supplier<Collection<File>> configFiles) {
        this.configurationFiles.add(configFiles);
    }

    List<File> getAllConfigurationFiles() {
        ArrayList files = Lists.newArrayList();
        for (Supplier<Collection<File>> supplier : this.configurationFiles) {
            files.addAll(supplier.get());
        }
        return files;
    }

    public Set<QualifiedContent.Scope> getScopes() {
        if (this.variantType == VariantType.LIBRARY) {
            return Sets.immutableEnumSet((Enum)QualifiedContent.Scope.PROJECT, (Enum[])new QualifiedContent.Scope[]{QualifiedContent.Scope.PROJECT_LOCAL_DEPS});
        }
        return TransformManager.SCOPE_FULL_PROJECT;
    }

    public Set<QualifiedContent.Scope> getReferencedScopes() {
        HashSet set = Sets.newHashSetWithExpectedSize((int)5);
        if (this.variantType == VariantType.LIBRARY) {
            set.add(QualifiedContent.Scope.SUB_PROJECTS);
            set.add(QualifiedContent.Scope.SUB_PROJECTS_LOCAL_DEPS);
            set.add(QualifiedContent.Scope.EXTERNAL_LIBRARIES);
        }
        if (this.variantType.isForTesting()) {
            set.add(QualifiedContent.Scope.TESTED_CODE);
        }
        set.add(QualifiedContent.Scope.PROVIDED_ONLY);
        return Sets.immutableEnumSet((Iterable)set);
    }

    public abstract void keep(String var1);

    public abstract void dontwarn(String var1);
}

