/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.build.api.transform.Format;
import com.android.build.api.transform.QualifiedContent;
import com.android.build.api.transform.Transform;
import com.android.build.api.transform.TransformException;
import com.android.build.api.transform.TransformInvocation;
import com.android.build.api.transform.TransformOutputProvider;
import com.android.build.gradle.internal.dsl.CoreJackOptions;
import com.android.build.gradle.internal.pipeline.TransformManager;
import com.android.build.gradle.internal.transforms.TransformInputUtil;
import com.android.builder.core.AndroidBuilder;
import com.android.builder.core.JackProcessOptions;
import com.android.builder.internal.compiler.JackConversionCache;
import com.android.ide.common.process.ProcessException;
import com.android.jack.api.ConfigNotSupportedException;
import com.android.jack.api.v01.CompilationException;
import com.android.jack.api.v01.ConfigurationException;
import com.android.jack.api.v01.UnrecoverableException;
import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;

public class JackPreDexTransform
extends Transform {
    private AndroidBuilder androidBuilder;
    private String javaMaxHeapSize;
    private boolean forPackagedLibs;
    private CoreJackOptions coreJackOptions;

    public JackPreDexTransform(AndroidBuilder androidBuilder, String javaMaxHeapSize, CoreJackOptions coreJackOptions, boolean forPackagedLibs) {
        this.androidBuilder = androidBuilder;
        this.javaMaxHeapSize = javaMaxHeapSize;
        this.coreJackOptions = coreJackOptions;
        this.forPackagedLibs = forPackagedLibs;
    }

    public String getName() {
        return this.forPackagedLibs ? "preJackPackagedLibraries" : "preJackRuntimeLibraries";
    }

    public Set<QualifiedContent.ContentType> getInputTypes() {
        return TransformManager.CONTENT_CLASS;
    }

    public Set<QualifiedContent.ContentType> getOutputTypes() {
        return TransformManager.CONTENT_JACK;
    }

    public Set<QualifiedContent.Scope> getScopes() {
        return this.forPackagedLibs ? TransformManager.SCOPE_FULL_PROJECT : Collections.singleton(QualifiedContent.Scope.PROVIDED_ONLY);
    }

    public boolean isIncremental() {
        return true;
    }

    public Map<String, Object> getParameterInputs() {
        return ImmutableMap.of((Object)"buildToolsRev", (Object)this.androidBuilder.getTargetInfo().getBuildTools().getRevision().toString());
    }

    public void transform(TransformInvocation transformInvocation) throws TransformException, InterruptedException, IOException {
        try {
            this.runJack(transformInvocation);
        }
        catch (ProcessException | ConfigNotSupportedException | CompilationException | ConfigurationException | UnrecoverableException | ClassNotFoundException e) {
            throw new TransformException(e);
        }
    }

    private void runJack(TransformInvocation transformInvocation) throws ConfigNotSupportedException, CompilationException, ProcessException, UnrecoverableException, ConfigurationException, ClassNotFoundException, IOException, InterruptedException {
        TransformOutputProvider outputProvider = transformInvocation.getOutputProvider();
        Preconditions.checkNotNull((Object)outputProvider);
        for (File file : TransformInputUtil.getDirectories(transformInvocation.getInputs())) {
            JackProcessOptions options = new JackProcessOptions();
            options.setImportFiles((Collection)ImmutableList.of((Object)file));
            File outDirectory = outputProvider.getContentLocation(file.getName(), this.getOutputTypes(), this.getScopes(), Format.DIRECTORY);
            options.setDexOutputDirectory(outDirectory);
            options.setJavaMaxHeapSize(this.javaMaxHeapSize);
            options.setAdditionalParameters(this.coreJackOptions.getAdditionalParameters());
            JackConversionCache.getCache().convertLibrary(this.androidBuilder, file, outDirectory, options, this.coreJackOptions.isJackInProcess().booleanValue());
        }
        Collection<File> jarInputs = this.forPackagedLibs ? TransformInputUtil.getJarFiles(transformInvocation.getInputs()) : Iterables.concat(TransformInputUtil.getJarFiles(transformInvocation.getInputs()), (Iterable)this.androidBuilder.getBootClasspath(true));
        for (File file : jarInputs) {
            JackProcessOptions options = new JackProcessOptions();
            options.setImportFiles((Collection)ImmutableList.of((Object)file));
            File outFile = outputProvider.getContentLocation(JackPreDexTransform.getJackFileName(file), this.getOutputTypes(), this.getScopes(), Format.JAR);
            options.setOutputFile(outFile);
            options.setJavaMaxHeapSize(this.javaMaxHeapSize);
            options.setAdditionalParameters(this.coreJackOptions.getAdditionalParameters());
            JackConversionCache.getCache().convertLibrary(this.androidBuilder, file, outFile, options, this.coreJackOptions.isJackInProcess().booleanValue());
        }
    }

    public static String getJackFileName(File inputFile) {
        String name = inputFile.getName();
        int pos = name.lastIndexOf(46);
        if (pos != -1) {
            name = name.substring(0, pos);
        }
        String input = inputFile.getAbsolutePath();
        HashFunction hashFunction = Hashing.sha1();
        HashCode hashCode = hashFunction.hashString((CharSequence)input, Charsets.UTF_16LE);
        return name + "-" + hashCode.toString();
    }

    public boolean isForRuntimeLibs() {
        return !this.forPackagedLibs;
    }
}

