/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.build.gradle.internal.core.GradleVariantConfiguration;
import com.android.build.gradle.internal.dsl.CoreBuildType;
import com.android.build.gradle.internal.dsl.CoreProductFlavor;
import com.android.build.gradle.internal.scope.ConventionMappingHelper;
import com.android.build.gradle.internal.scope.TaskConfigAction;
import com.android.build.gradle.internal.scope.VariantOutputScope;
import com.android.build.gradle.internal.variant.ApkVariantOutputData;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.build.gradle.internal.variant.BaseVariantOutputData;
import com.android.build.gradle.tasks.ManifestProcessorTask;
import com.android.builder.core.VariantConfiguration;
import com.android.builder.model.AndroidLibrary;
import com.android.builder.model.ApiVersion;
import com.android.builder.model.JavaLibrary;
import com.android.builder.model.MavenCoordinates;
import com.android.manifmerger.ManifestMerger2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import org.gradle.api.Task;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.ParallelizableTask;

@ParallelizableTask
public class MergeManifests
extends ManifestProcessorTask {
    private String minSdkVersion;
    private String targetSdkVersion;
    private Integer maxSdkVersion;
    private File reportFile;
    private VariantConfiguration<CoreBuildType, CoreProductFlavor, CoreProductFlavor> variantConfiguration;
    private ApkVariantOutputData variantOutputData;
    private List<AndroidLibrary> libraries;
    private List<ManifestMerger2.Invoker.Feature> optionalFeatures;

    @Override
    protected void doFullTaskAction() {
        this.getBuilder().mergeManifestsForApplication(this.getMainManifest(), this.getManifestOverlays(), this.getLibraries(), this.getPackageOverride(), this.getVersionCode(), this.getVersionName(), this.getMinSdkVersion(), this.getTargetSdkVersion(), this.getMaxSdkVersion(), this.getManifestOutputFile().getAbsolutePath(), null, this.getInstantRunManifestOutputFile().getAbsolutePath(), ManifestMerger2.MergeType.APPLICATION, this.variantConfiguration.getManifestPlaceholders(), this.getOptionalFeatures(), this.getReportFile());
    }

    @Optional
    @InputFile
    public File getMainManifest() {
        return this.variantConfiguration.getMainManifest();
    }

    @InputFiles
    public List<File> getManifestOverlays() {
        return this.variantConfiguration.getManifestOverlays();
    }

    @Input
    @Optional
    public String getPackageOverride() {
        return this.variantConfiguration.getIdOverride();
    }

    @Input
    public int getVersionCode() {
        if (this.variantOutputData != null) {
            return this.variantOutputData.getVersionCode();
        }
        return this.variantConfiguration.getVersionCode();
    }

    @Input
    @Optional
    public String getVersionName() {
        if (this.variantOutputData != null) {
            return this.variantOutputData.getVersionName();
        }
        return this.variantConfiguration.getVersionName();
    }

    @Input
    @Optional
    public String getManifestPlaceholders() {
        return MergeManifests.serializeMap(this.variantConfiguration.getManifestPlaceholders());
    }

    @InputFiles
    List<File> getLibraryManifests() {
        List<AndroidLibrary> libs = this.getLibraries();
        if (libs == null || libs.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList files = Lists.newArrayListWithCapacity((int)(libs.size() * 2));
        for (AndroidLibrary androidLibrary : libs) {
            MergeManifests.fillManifestList(androidLibrary, files);
        }
        return files;
    }

    @Input
    @Optional
    public String getMinSdkVersion() {
        return this.minSdkVersion;
    }

    public void setMinSdkVersion(String minSdkVersion) {
        this.minSdkVersion = minSdkVersion;
    }

    @Input
    @Optional
    public String getTargetSdkVersion() {
        return this.targetSdkVersion;
    }

    public void setTargetSdkVersion(String targetSdkVersion) {
        this.targetSdkVersion = targetSdkVersion;
    }

    @Input
    @Optional
    public Integer getMaxSdkVersion() {
        return this.maxSdkVersion;
    }

    public void setMaxSdkVersion(Integer maxSdkVersion) {
        this.maxSdkVersion = maxSdkVersion;
    }

    @OutputFile
    @Optional
    public File getReportFile() {
        return this.reportFile;
    }

    public void setReportFile(File reportFile) {
        this.reportFile = reportFile;
    }

    public List<ManifestMerger2.Invoker.Feature> getOptionalFeatures() {
        return this.optionalFeatures;
    }

    @Input
    public List<String> getOptionalFeaturesString() {
        return this.optionalFeatures.stream().map(Enum::toString).collect(Collectors.toList());
    }

    public VariantConfiguration getVariantConfiguration() {
        return this.variantConfiguration;
    }

    public void setVariantConfiguration(VariantConfiguration<CoreBuildType, CoreProductFlavor, CoreProductFlavor> variantConfiguration) {
        this.variantConfiguration = variantConfiguration;
    }

    public ApkVariantOutputData getVariantOutputData() {
        return this.variantOutputData;
    }

    public void setVariantOutputData(ApkVariantOutputData variantOutputData) {
        this.variantOutputData = variantOutputData;
    }

    public List<AndroidLibrary> getLibraries() {
        return this.libraries;
    }

    public void setLibraries(List<AndroidLibrary> libraries) {
        this.libraries = libraries;
    }

    public static class ConfigAction
    implements TaskConfigAction<MergeManifests> {
        private final VariantOutputScope scope;
        private final List<ManifestMerger2.Invoker.Feature> optionalFeatures;

        public ConfigAction(VariantOutputScope scope, List<ManifestMerger2.Invoker.Feature> optionalFeatures) {
            this.scope = scope;
            this.optionalFeatures = optionalFeatures;
        }

        @Override
        public String getName() {
            return this.scope.getTaskName("process", "Manifest");
        }

        @Override
        public Class<MergeManifests> getType() {
            return MergeManifests.class;
        }

        @Override
        public void execute(MergeManifests processManifestTask) {
            BaseVariantOutputData variantOutputData = this.scope.getVariantOutputData();
            final BaseVariantData<? extends BaseVariantOutputData> variantData = this.scope.getVariantScope().getVariantData();
            final GradleVariantConfiguration config = variantData.getVariantConfiguration();
            variantOutputData.manifestProcessorTask = processManifestTask;
            processManifestTask.setAndroidBuilder(this.scope.getGlobalScope().getAndroidBuilder());
            processManifestTask.setVariantName(config.getFullName());
            processManifestTask.setVariantConfiguration(config);
            if (variantOutputData instanceof ApkVariantOutputData) {
                processManifestTask.variantOutputData = (ApkVariantOutputData)variantOutputData;
            }
            ConventionMappingHelper.map((Task)processManifestTask, "libraries", new Callable<List<AndroidLibrary>>(){

                @Override
                public List<AndroidLibrary> call() throws Exception {
                    ArrayList manifests = Lists.newArrayList((Iterable)config.getCompileAndroidLibraries());
                    if (scope.getVariantScope().getMicroApkTask() != null && ((CoreBuildType)variantData.getVariantConfiguration().getBuildType()).isEmbedMicroApp()) {
                        manifests.add(new ManifestOnlyLibrary(scope.getVariantScope().getMicroApkManifestFile(), "Wear App sub-manifest"));
                    }
                    if (scope.getCompatibleScreensManifestTask() != null) {
                        manifests.add(new ManifestOnlyLibrary(scope.getCompatibleScreensManifestFile(), "Compatible-Screens sub-manifest"));
                    }
                    return manifests;
                }
            });
            ConventionMappingHelper.map((Task)processManifestTask, "minSdkVersion", new Callable<String>(){

                @Override
                public String call() throws Exception {
                    if (scope.getGlobalScope().getAndroidBuilder().isPreviewTarget()) {
                        return scope.getGlobalScope().getAndroidBuilder().getTargetCodename();
                    }
                    ApiVersion minSdk = config.getMergedFlavor().getMinSdkVersion();
                    return minSdk == null ? null : minSdk.getApiString();
                }
            });
            ConventionMappingHelper.map((Task)processManifestTask, "targetSdkVersion", new Callable<String>(){

                @Override
                public String call() throws Exception {
                    if (scope.getGlobalScope().getAndroidBuilder().isPreviewTarget()) {
                        return scope.getGlobalScope().getAndroidBuilder().getTargetCodename();
                    }
                    ApiVersion targetSdk = config.getMergedFlavor().getTargetSdkVersion();
                    return targetSdk == null ? null : targetSdk.getApiString();
                }
            });
            ConventionMappingHelper.map((Task)processManifestTask, "maxSdkVersion", new Callable<Integer>(){

                @Override
                public Integer call() throws Exception {
                    if (scope.getGlobalScope().getAndroidBuilder().isPreviewTarget()) {
                        return null;
                    }
                    return config.getMergedFlavor().getMaxSdkVersion();
                }
            });
            processManifestTask.setManifestOutputFile(this.scope.getManifestOutputFile());
            processManifestTask.setInstantRunManifestOutputFile(this.scope.getVariantScope().getInstantRunManifestOutputFile());
            processManifestTask.setReportFile(this.scope.getVariantScope().getManifestReportFile());
            processManifestTask.optionalFeatures = this.optionalFeatures;
        }

        private static class ManifestOnlyLibrary
        implements AndroidLibrary {
            private final File manifest;
            private final String name;

            public ManifestOnlyLibrary(File manifest, String name) {
                this.manifest = manifest;
                this.name = name;
            }

            public File getManifest() {
                return this.manifest;
            }

            public String getName() {
                return this.name;
            }

            public List<? extends AndroidLibrary> getLibraryDependencies() {
                return ImmutableList.of();
            }

            public boolean isOptional() {
                return false;
            }

            public boolean isProvided() {
                return false;
            }

            public boolean isSkipped() {
                return false;
            }

            public String getProject() {
                throw new UnsupportedOperationException("ManifestOnlyLibrary can only be queried for the Manifest file.");
            }

            public String getProjectVariant() {
                throw new UnsupportedOperationException("ManifestOnlyLibrary can only be queried for the Manifest file.");
            }

            public File getBundle() {
                throw new UnsupportedOperationException("ManifestOnlyLibrary can only be queried for the Manifest file.");
            }

            public File getFolder() {
                throw new UnsupportedOperationException("ManifestOnlyLibrary can only be queried for the Manifest file.");
            }

            public Collection<File> getLocalJars() {
                throw new UnsupportedOperationException("ManifestOnlyLibrary can only be queried for the Manifest file.");
            }

            public Collection<? extends JavaLibrary> getJavaDependencies() {
                throw new UnsupportedOperationException("ManifestOnlyLibrary can only be queried for the Manifest file.");
            }

            public File getJarFile() {
                throw new UnsupportedOperationException("ManifestOnlyLibrary can only be queried for the Manifest file.");
            }

            public File getResFolder() {
                throw new UnsupportedOperationException("ManifestOnlyLibrary can only be queried for the Manifest file.");
            }

            public File getAssetsFolder() {
                throw new UnsupportedOperationException("ManifestOnlyLibrary can only be queried for the Manifest file.");
            }

            public File getJniFolder() {
                throw new UnsupportedOperationException("ManifestOnlyLibrary can only be queried for the Manifest file.");
            }

            public File getAidlFolder() {
                throw new UnsupportedOperationException("ManifestOnlyLibrary can only be queried for the Manifest file.");
            }

            public File getRenderscriptFolder() {
                throw new UnsupportedOperationException("ManifestOnlyLibrary can only be queried for the Manifest file.");
            }

            public File getProguardRules() {
                throw new UnsupportedOperationException("ManifestOnlyLibrary can only be queried for the Manifest file.");
            }

            public File getLintJar() {
                throw new UnsupportedOperationException("ManifestOnlyLibrary can only be queried for the Manifest file.");
            }

            public File getExternalAnnotations() {
                throw new UnsupportedOperationException("ManifestOnlyLibrary can only be queried for the Manifest file.");
            }

            public File getPublicResources() {
                throw new UnsupportedOperationException("ManifestOnlyLibrary can only be queried for the Manifest file.");
            }

            public File getSymbolFile() {
                throw new UnsupportedOperationException("ManifestOnlyLibrary can only be queried for the Manifest file.");
            }

            public MavenCoordinates getRequestedCoordinates() {
                throw new UnsupportedOperationException("ManifestOnlyLibrary can only be queried for the Manifest file.");
            }

            public MavenCoordinates getResolvedCoordinates() {
                throw new UnsupportedOperationException("ManifestOnlyLibrary can only be queried for the Manifest file.");
            }
        }
    }
}

