/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.build.gradle.internal.core.GradleVariantConfiguration;
import com.android.build.gradle.internal.scope.ConventionMappingHelper;
import com.android.build.gradle.internal.scope.TaskConfigAction;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.variant.BaseVariantOutputData;
import com.android.build.gradle.tasks.ManifestProcessorTask;
import com.android.builder.core.VariantConfiguration;
import com.android.builder.model.AndroidLibrary;
import com.android.io.FileWrapper;
import com.android.io.IAbstractFile;
import com.android.xml.AndroidManifest;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.ParallelizableTask;

@ParallelizableTask
public class ProcessTestManifest
extends ManifestProcessorTask {
    private File testManifestFile;
    private File tmpDir;
    private String testApplicationId;
    private String minSdkVersion;
    private String targetSdkVersion;
    private String testedApplicationId;
    private String instrumentationRunner;
    private Boolean handleProfiling;
    private Boolean functionalTest;
    private Map<String, Object> placeholdersValues;
    private List<AndroidLibrary> libraries;
    private String testLabel;

    @Override
    protected void doFullTaskAction() throws IOException {
        this.getBuilder().mergeManifestsForTestVariant(this.getTestApplicationId(), this.getMinSdkVersion(), this.getTargetSdkVersion(), this.getTestedApplicationId(), this.getInstrumentationRunner(), this.getHandleProfiling(), this.getFunctionalTest(), this.getTestLabel(), this.getTestManifestFile(), this.getLibraries(), this.getPlaceholdersValues(), this.getManifestOutputFile(), this.getTmpDir());
    }

    @InputFile
    @Optional
    public File getTestManifestFile() {
        return this.testManifestFile;
    }

    public void setTestManifestFile(File testManifestFile) {
        this.testManifestFile = testManifestFile;
    }

    public File getTmpDir() {
        return this.tmpDir;
    }

    public void setTmpDir(File tmpDir) {
        this.tmpDir = tmpDir;
    }

    @Input
    public String getTestApplicationId() {
        return this.testApplicationId;
    }

    public void setTestApplicationId(String testApplicationId) {
        this.testApplicationId = testApplicationId;
    }

    @Input
    public String getMinSdkVersion() {
        return this.minSdkVersion;
    }

    public void setMinSdkVersion(String minSdkVersion) {
        this.minSdkVersion = minSdkVersion;
    }

    @Input
    public String getTargetSdkVersion() {
        return this.targetSdkVersion;
    }

    public void setTargetSdkVersion(String targetSdkVersion) {
        this.targetSdkVersion = targetSdkVersion;
    }

    @Input
    public String getTestedApplicationId() {
        return this.testedApplicationId;
    }

    public void setTestedApplicationId(String testedApplicationId) {
        this.testedApplicationId = testedApplicationId;
    }

    @Input
    public String getInstrumentationRunner() {
        return this.instrumentationRunner;
    }

    public void setInstrumentationRunner(String instrumentationRunner) {
        this.instrumentationRunner = instrumentationRunner;
    }

    @Input
    public Boolean getHandleProfiling() {
        return this.handleProfiling;
    }

    public void setHandleProfiling(Boolean handleProfiling) {
        this.handleProfiling = handleProfiling;
    }

    @Input
    public Boolean getFunctionalTest() {
        return this.functionalTest;
    }

    public void setFunctionalTest(Boolean functionalTest) {
        this.functionalTest = functionalTest;
    }

    @Input
    @Optional
    public String getTestLabel() {
        return this.testLabel;
    }

    public void setTestLabel(String testLabel) {
        this.testLabel = testLabel;
    }

    @Input
    public Map<String, Object> getPlaceholdersValues() {
        return this.placeholdersValues;
    }

    public void setPlaceholdersValues(Map<String, Object> placeholdersValues) {
        this.placeholdersValues = placeholdersValues;
    }

    public List<AndroidLibrary> getLibraries() {
        return this.libraries;
    }

    public void setLibraries(List<AndroidLibrary> libraries) {
        this.libraries = libraries;
    }

    @InputFiles
    List<File> getLibraryManifests() {
        List<AndroidLibrary> libs = this.getLibraries();
        if (libs == null || libs.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList files = Lists.newArrayListWithCapacity((int)(libs.size() * 2));
        for (AndroidLibrary androidLibrary : libs) {
            ProcessTestManifest.fillManifestList(androidLibrary, files);
        }
        return files;
    }

    public static class ConfigAction
    implements TaskConfigAction<ProcessTestManifest> {
        private final VariantScope scope;
        private final Configuration targetManifestConfiguration;

        public ConfigAction(VariantScope scope) {
            this(scope, null);
        }

        public ConfigAction(VariantScope scope, Configuration targetManifestConfiguration) {
            this.scope = scope;
            this.targetManifestConfiguration = targetManifestConfiguration;
        }

        @Override
        public String getName() {
            return this.scope.getTaskName("process", "Manifest");
        }

        @Override
        public Class<ProcessTestManifest> getType() {
            return ProcessTestManifest.class;
        }

        @Override
        public void execute(ProcessTestManifest processTestManifestTask) {
            GradleVariantConfiguration config = this.scope.getVariantConfiguration();
            processTestManifestTask.setTestManifestFile(config.getMainManifest());
            processTestManifestTask.setTmpDir(new File(this.scope.getGlobalScope().getIntermediatesDir(), "manifest/tmp"));
            BaseVariantOutputData variantOutputData = this.scope.getVariantData().getOutputs().get(0);
            variantOutputData.manifestProcessorTask = processTestManifestTask;
            processTestManifestTask.setAndroidBuilder(this.scope.getGlobalScope().getAndroidBuilder());
            processTestManifestTask.setVariantName(config.getFullName());
            processTestManifestTask.setTestApplicationId(config.getTestApplicationId());
            ConventionMappingHelper.map((Task)processTestManifestTask, "minSdkVersion", () -> {
                if (this.scope.getGlobalScope().getAndroidBuilder().isPreviewTarget()) {
                    return this.scope.getGlobalScope().getAndroidBuilder().getTargetCodename();
                }
                return config.getMinSdkVersion().getApiString();
            });
            ConventionMappingHelper.map((Task)processTestManifestTask, "targetSdkVersion", () -> {
                if (this.scope.getGlobalScope().getAndroidBuilder().isPreviewTarget()) {
                    return this.scope.getGlobalScope().getAndroidBuilder().getTargetCodename();
                }
                return config.getTargetSdkVersion().getApiString();
            });
            if (this.targetManifestConfiguration != null) {
                ConventionMappingHelper.map((Task)processTestManifestTask, "testedApplicationId", () -> AndroidManifest.getPackage((IAbstractFile)new FileWrapper(this.targetManifestConfiguration.getSingleFile().getAbsolutePath())));
            } else {
                ConventionMappingHelper.map((Task)processTestManifestTask, "testedApplicationId", () -> {
                    String testedApp = config.getTestedApplicationId();
                    assert (testedApp != null);
                    return testedApp;
                });
            }
            ConventionMappingHelper.map((Task)processTestManifestTask, "instrumentationRunner", () -> ((VariantConfiguration)config).getInstrumentationRunner());
            ConventionMappingHelper.map((Task)processTestManifestTask, "handleProfiling", () -> ((VariantConfiguration)config).getHandleProfiling());
            ConventionMappingHelper.map((Task)processTestManifestTask, "functionalTest", () -> ((VariantConfiguration)config).getFunctionalTest());
            ConventionMappingHelper.map((Task)processTestManifestTask, "testLabel", () -> ((VariantConfiguration)config).getTestLabel());
            ConventionMappingHelper.map((Task)processTestManifestTask, "libraries", () -> ((VariantConfiguration)config).getCompileAndroidLibraries());
            processTestManifestTask.setManifestOutputFile(variantOutputData.getScope().getManifestOutputFile());
            ConventionMappingHelper.map((Task)processTestManifestTask, "placeholdersValues", () -> ((VariantConfiguration)config).getManifestPlaceholders());
        }
    }
}

